/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.SimpleBlockPredicate;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.DiligentMatcher;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.FlippingFloorSquareForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.BlockTraverse;
import qouteall.imm_ptl.core.portal.nether_portal.GeneralBreakablePortal;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class ConvertConventionalPortalForm
extends PortalGenForm {
    public static final Codec<ConvertConventionalPortalForm> codec = RecordCodecBuilder.create(instance -> instance.group((App)SimpleBlockPredicate.codec.fieldOf("portal_block").forGetter(o -> o.portalBlock)).apply((Applicative)instance, instance.stable(ConvertConventionalPortalForm::new)));
    public final SimpleBlockPredicate portalBlock;

    public ConvertConventionalPortalForm(SimpleBlockPredicate portalBlock) {
        this.portalBlock = portalBlock;
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        return codec;
    }

    @Override
    public PortalGenForm getReverse() {
        return this;
    }

    @Override
    public boolean perform(CustomPortalGeneration cpg, ServerLevel fromWorld, BlockPos startingPos, ServerLevel toWorld, @Nullable Entity triggeringEntity) {
        if (triggeringEntity == null) {
            Helper.err((Object)"Null triggering entity for portal conversion");
            return false;
        }
        if (!(triggeringEntity instanceof ServerPlayer)) {
            Helper.err((Object)"Non player entity triggers portal conversion");
            return false;
        }
        ServerPlayer player = (ServerPlayer)triggeringEntity;
        if (player.m_9236_() != toWorld) {
            Helper.err((Object)("The player is not in the correct world " + player.m_9236_().m_46472_().m_135782_()));
            return false;
        }
        BlockPos playerCurrentPos = player.m_20183_().m_7949_();
        BlockPos startFramePos = ConvertConventionalPortalForm.findBlockAround((Level)fromWorld, startingPos, this.portalBlock);
        if (startFramePos == null) {
            return false;
        }
        BlockPos toFramePos = ConvertConventionalPortalForm.findBlockAround((Level)toWorld, playerCurrentPos, this.portalBlock);
        if (toFramePos == null) {
            return false;
        }
        Helper.log((Object)String.format("Trying to convert conventional portal %s -> %s by %s (%d %d %d)", fromWorld.m_46472_().m_135782_(), toWorld.m_46472_().m_135782_(), player.m_7755_().m_214077_(), (int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_()));
        BlockPortalShape fromShape = NetherPortalGeneration.findFrameShape(fromWorld, startFramePos, this.portalBlock, s -> !s.m_60795_());
        if (fromShape == null) {
            Helper.err((Object)"Cannot find from side shape");
            return false;
        }
        BlockPortalShape toShape = NetherPortalGeneration.findFrameShape(toWorld, toFramePos, this.portalBlock, s -> !s.m_60795_());
        if (toShape == null) {
            Helper.err((Object)"Cannot fine to side shape");
            return false;
        }
        Helper.log((Object)(fromShape.innerAreaBox + " " + toShape.innerAreaBox));
        PortalGenInfo portalGenInfo = ConvertConventionalPortalForm.tryToMatch((ResourceKey<Level>)fromWorld.m_46472_(), (ResourceKey<Level>)toWorld.m_46472_(), fromShape, toShape);
        if (portalGenInfo == null) {
            Helper.err((Object)"Shapes are incompatible");
            player.m_5661_((Component)Component.m_237115_((String)"imm_ptl.incompatible_shape"), false);
            return false;
        }
        portalGenInfo.generatePlaceholderBlocks();
        if (fromShape.axis == Direction.Axis.Y && toShape.axis == Direction.Axis.Y && portalGenInfo.scale == 1.0 && portalGenInfo.rotation == null) {
            Portal[] portals = FlippingFloorSquareForm.createPortals(fromWorld, toWorld, portalGenInfo.fromShape, portalGenInfo.toShape);
            cpg.onPortalsGenerated(portals);
            Helper.log((Object)"Created flipping floor portal");
        } else {
            Portal[] portals = portalGenInfo.generateBiWayBiFacedPortal(GeneralBreakablePortal.entityType);
            cpg.onPortalsGenerated(portals);
            Helper.log((Object)"Created normal bi-way bi-faced portal");
        }
        return true;
    }

    @Deprecated
    @Nullable
    public static IntBox findBlockBoxArea(Level world, BlockPos pos, Predicate<BlockState> predicate) {
        BlockPos startingPos = ConvertConventionalPortalForm.findBlockAround(world, pos, predicate);
        if (startingPos == null) {
            return null;
        }
        IntBox result = Helper.expandBoxArea((BlockPos)startingPos, p -> predicate.test(world.m_8055_(p)));
        if (result.getSize().equals((Object)new BlockPos(1, 1, 1))) {
            return null;
        }
        return result;
    }

    @Nullable
    public static BlockPos findBlockAround(Level world, BlockPos pos, Predicate<BlockState> predicate) {
        BlockState blockState = world.m_8055_(pos);
        if (predicate.test(blockState)) {
            return pos;
        }
        return BlockTraverse.searchInBox(new IntBox(pos.m_7918_(-2, -2, -2), pos.m_7918_(2, 2, 2)), p -> {
            if (predicate.test(world.m_8055_(p))) {
                return p;
            }
            return null;
        });
    }

    @Deprecated
    @Nullable
    public static BlockPortalShape convertToPortalShape(IntBox box) {
        BlockPos size = box.getSize();
        Direction.Axis axis = null;
        if (size.m_123341_() == 1) {
            axis = Direction.Axis.X;
        } else if (size.m_123342_() == 1) {
            axis = Direction.Axis.Y;
        } else if (size.m_123343_() == 1) {
            axis = Direction.Axis.Z;
        } else {
            Helper.err((Object)("The box is not flat " + box));
            return null;
        }
        return new BlockPortalShape(box.stream().collect(Collectors.toSet()), axis);
    }

    @Nullable
    public static PortalGenInfo tryToMatch(ResourceKey<Level> fromDim, ResourceKey<Level> toDim, BlockPortalShape a, BlockPortalShape b) {
        List<DiligentMatcher.TransformedShape> matchableShapeVariants = DiligentMatcher.getMatchableShapeVariants(a, BlockPortalShape.defaultLengthLimit);
        for (DiligentMatcher.TransformedShape variant : matchableShapeVariants) {
            BlockPortalShape variantMoved = variant.transformedShape.getShapeWithMovedAnchor(b.anchor);
            if (!variantMoved.equals(b)) continue;
            return new PortalGenInfo(fromDim, toDim, a, b, variant.rotation.toQuaternion(), variant.scale);
        }
        return null;
    }
}

