/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import qouteall.q_misc_util.MiscHelper;

public class SimpleBlockPredicate
implements Predicate<BlockState> {
    public static final SimpleBlockPredicate pass = new SimpleBlockPredicate();
    public final String name;
    private final TagKey<Block> tag;
    private final Block block;
    public static final Codec<SimpleBlockPredicate> codec = Codec.STRING.comapFlatMap(SimpleBlockPredicate::deserialize, SimpleBlockPredicate::serialize);

    public SimpleBlockPredicate(String name, TagKey<Block> tag) {
        this.name = name;
        this.tag = tag;
        this.block = null;
    }

    public SimpleBlockPredicate(String name, Block block) {
        this.name = name;
        this.block = block;
        this.tag = null;
    }

    private SimpleBlockPredicate() {
        this.tag = null;
        this.block = null;
        this.name = "imm_ptl:pass";
    }

    @Override
    public boolean test(BlockState blockState) {
        if (this.tag != null) {
            return blockState.m_204336_(this.tag);
        }
        if (this.block != null) {
            return blockState.m_60734_() == this.block;
        }
        return true;
    }

    private static DataResult<SimpleBlockPredicate> deserialize(String string) {
        MinecraftServer server = MiscHelper.getServer();
        if (server == null) {
            return DataResult.error(() -> "[Immersive Portals] Simple block predicate should not be deserialized in client");
        }
        if (string.equals("minecraft:air")) {
            return DataResult.success((Object)new AirPredicate());
        }
        ResourceLocation id = new ResourceLocation(string);
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)id);
        Registry blockRegistry = (Registry)server.m_206579_().m_6632_(Registries.f_256747_).get();
        Optional tag1 = blockRegistry.m_203431_(tagKey);
        boolean knownTagName = tag1.isPresent();
        if (knownTagName) {
            return DataResult.success((Object)new SimpleBlockPredicate(string, (TagKey<Block>)tagKey));
        }
        if (blockRegistry.m_6566_().contains(id)) {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(id);
            return DataResult.success((Object)new SimpleBlockPredicate(string, block), (Lifecycle)Lifecycle.stable());
        }
        return DataResult.error(() -> "Unknown block or block tag:" + string);
    }

    private static String serialize(SimpleBlockPredicate predicate) {
        MinecraftServer server = MiscHelper.getServer();
        if (server == null) {
            throw new RuntimeException("Simple block predicate should not be serialized in client");
        }
        return predicate.name;
    }

    public static class AirPredicate
    extends SimpleBlockPredicate {
        @Override
        public boolean test(BlockState blockState) {
            return blockState.m_60795_();
        }
    }
}

