/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.mixin.common.registry.IERegistryDataLoader;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenTrigger;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.WithDim;

public class CustomPortalGenManagement {
    private static final Multimap<Item, CustomPortalGeneration> useItemGen = HashMultimap.create();
    private static final Multimap<Item, CustomPortalGeneration> throwItemGen = HashMultimap.create();
    private static final ArrayList<CustomPortalGeneration> convGen = new ArrayList();
    private static final Map<UUID, WithDim<Vec3>> playerPosBeforeTravel = new HashMap<UUID, WithDim<Vec3>>();

    public static void onDatapackReload() {
        useItemGen.clear();
        throwItemGen.clear();
        convGen.clear();
        playerPosBeforeTravel.clear();
        if (!IPGlobal.enableDatapackPortalGen) {
            return;
        }
        Helper.log((Object)"Loading custom portal generation");
        Registry<CustomPortalGeneration> result = CustomPortalGenManagement.loadCustomPortalGenerations();
        if (result == null) {
            return;
        }
        result.m_6579_().forEach(entry -> {
            CustomPortalGeneration gen = (CustomPortalGeneration)entry.getValue();
            gen.identifier = ((ResourceKey)entry.getKey()).m_135782_();
            if (!gen.initAndCheck()) {
                Helper.log((Object)("Custom Portal Gen Is Not Activated " + gen.toString()));
                return;
            }
            Helper.log((Object)("Loaded Custom Portal Gen " + ((ResourceKey)entry.getKey()).m_135782_()));
            CustomPortalGenManagement.load(gen);
            if (gen.reversible) {
                CustomPortalGeneration reverse = gen.getReverse();
                if (reverse != null) {
                    reverse.identifier = ((ResourceKey)entry.getKey()).m_135782_();
                    if (gen.initAndCheck()) {
                        CustomPortalGenManagement.load(reverse);
                    }
                } else {
                    McHelper.sendMessageToFirstLoggedPlayer((Component)Component.m_237113_((String)("Cannot create reverse generation of " + gen)));
                }
            }
        });
    }

    private static Registry<CustomPortalGeneration> loadCustomPortalGenerations() {
        MinecraftServer server = MiscHelper.getServer();
        RegistryAccess.Frozen registryTracker = server.m_206579_();
        ResourceManager resourceManager = server.m_177941_();
        RegistryOps registryOps = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryTracker);
        MappedRegistry registry = new MappedRegistry(CustomPortalGeneration.registryRegistryKey, Lifecycle.stable());
        RegistryOps.RegistryInfoLookup context = IERegistryDataLoader.ip_createContext((RegistryAccess)registryTracker, List.of());
        HashMap errorMap = new HashMap();
        IERegistryDataLoader.ip_loadRegistryContents(context, resourceManager, CustomPortalGeneration.registryRegistryKey, registry, CustomPortalGeneration.codec.codec(), errorMap);
        errorMap.forEach((key, exception) -> {
            exception.printStackTrace();
            McHelper.sendMessageToFirstLoggedPlayer((Component)Component.m_237113_((String)"Error loading custom portal generation %s".formatted(key.m_135782_())));
        });
        return registry;
    }

    private static void load(CustomPortalGeneration gen) {
        PortalGenTrigger trigger = gen.trigger;
        if (trigger instanceof PortalGenTrigger.UseItemTrigger) {
            useItemGen.put((Object)((PortalGenTrigger.UseItemTrigger)trigger).item, (Object)gen);
        } else if (trigger instanceof PortalGenTrigger.ThrowItemTrigger) {
            throwItemGen.put((Object)((PortalGenTrigger.ThrowItemTrigger)trigger).item, (Object)gen);
        } else if (trigger instanceof PortalGenTrigger.ConventionalDimensionChangeTrigger) {
            convGen.add(gen);
        }
    }

    public static void onItemUse(UseOnContext context, InteractionResult actionResult) {
        if (context.m_43725_().m_5776_()) {
            return;
        }
        Item item = context.m_43722_().m_41720_();
        if (useItemGen.containsKey((Object)item)) {
            IPGlobal.serverTaskList.addTask(() -> {
                for (CustomPortalGeneration gen : useItemGen.get((Object)item)) {
                    PortalGenTrigger.UseItemTrigger trigger;
                    boolean result = gen.perform((ServerLevel)context.m_43725_(), context.m_8083_().m_121945_(context.m_43719_()), (Entity)context.m_43723_());
                    if (!result) continue;
                    if (!(gen.trigger instanceof PortalGenTrigger.UseItemTrigger) || !(trigger = (PortalGenTrigger.UseItemTrigger)gen.trigger).shouldConsume(context)) break;
                    context.m_43722_().m_41774_(1);
                    break;
                }
                return true;
            });
        }
    }

    public static void onItemTick(ItemEntity entity) {
        Item item;
        Validate.isTrue((!entity.m_9236_().m_5776_() ? 1 : 0) != 0);
        if (entity.m_32063_() && throwItemGen.containsKey((Object)(item = entity.m_32055_().m_41720_()))) {
            IPGlobal.serverTaskList.addTask(() -> {
                for (CustomPortalGeneration gen : throwItemGen.get((Object)item)) {
                    boolean result = gen.perform((ServerLevel)entity.m_9236_(), entity.m_20183_(), (Entity)entity);
                    if (!result) continue;
                    entity.m_32055_().m_41774_(1);
                    break;
                }
                return true;
            });
        }
    }

    public static void onBeforeConventionalDimensionChange(ServerPlayer player) {
        playerPosBeforeTravel.put(player.m_20148_(), (WithDim<Vec3>)new WithDim(player.m_9236_().m_46472_(), (Object)player.m_20182_()));
    }

    public static void onAfterConventionalDimensionChange(ServerPlayer player) {
        UUID uuid = player.m_20148_();
        if (playerPosBeforeTravel.containsKey(uuid)) {
            WithDim<Vec3> startCoord = playerPosBeforeTravel.get(uuid);
            ServerLevel startWorld = McHelper.getServerWorld((ResourceKey<Level>)startCoord.dimension());
            BlockPos startPos = BlockPos.m_274446_((Position)((Position)startCoord.value()));
            for (CustomPortalGeneration gen : convGen) {
                boolean succeeded = gen.perform(startWorld, startPos, (Entity)player);
                if (!succeeded) continue;
                playerPosBeforeTravel.remove(uuid);
                return;
            }
        }
        playerPosBeforeTravel.remove(uuid);
    }
}

