/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Vec2d;
import qouteall.q_misc_util.my_util.animation.Animated;

public record UnilateralPortalState(ResourceKey<Level> dimension, Vec3 position, DQuaternion orientation, double width, double height) {
    public static final Animated.TypeInfo<UnilateralPortalState> ANIMATION_TYPE_INFO = new Animated.TypeInfo<UnilateralPortalState>(){

        public UnilateralPortalState interpolate(UnilateralPortalState start, UnilateralPortalState end, double progress) {
            if (start.dimension() != end.dimension()) {
                return end;
            }
            Pair<RectInvariant, UnilateralPortalState> p = start.turnToClosestTo(end.orientation());
            start = (UnilateralPortalState)p.getSecond();
            return new UnilateralPortalState(start.dimension(), start.position().m_165921_(end.position(), progress), DQuaternion.interpolate((DQuaternion)start.orientation(), (DQuaternion)end.orientation(), (double)progress), Mth.m_14139_((double)progress, (double)start.width(), (double)end.width()), Mth.m_14139_((double)progress, (double)start.height(), (double)end.height()));
        }

        public boolean isClose(UnilateralPortalState a, UnilateralPortalState b) {
            return a.dimension() == b.dimension() && a.position().m_82557_(b.position()) < 0.01 && DQuaternion.isClose((DQuaternion)a.orientation(), (DQuaternion)b.orientation(), (double)0.01) && Math.abs(a.width() - b.width()) < 0.01 && Math.abs(a.height() - b.height()) < 0.01;
        }
    };

    public static UnilateralPortalState extractThisSide(PortalState portalState) {
        return new UnilateralPortalState(portalState.fromWorld, portalState.fromPos, portalState.orientation, portalState.width, portalState.height);
    }

    public static UnilateralPortalState extractOtherSide(PortalState portalState) {
        DQuaternion otherSideOrientation = portalState.rotation.hamiltonProduct(portalState.orientation).hamiltonProduct(PortalManipulation.flipAxisW);
        return new UnilateralPortalState(portalState.toWorld, portalState.toPos, otherSideOrientation, portalState.width * portalState.scaling, portalState.height * portalState.scaling);
    }

    public static PortalState combine(UnilateralPortalState thisSide, UnilateralPortalState otherSide) {
        DQuaternion otherSideOrientation = otherSide.orientation;
        DQuaternion thisSideOrientation = thisSide.orientation;
        DQuaternion rotation = PortalManipulation.computeDeltaTransformation(thisSideOrientation, otherSideOrientation);
        double scale = otherSide.width / thisSide.width;
        PortalState result = new PortalState(thisSide.dimension, thisSide.position, otherSide.dimension, otherSide.position, scale, rotation, thisSide.orientation, thisSide.width, thisSide.height);
        return result;
    }

    public static UnilateralPortalState interpolate(UnilateralPortalState from, UnilateralPortalState to, double progress) {
        return new UnilateralPortalState(from.dimension, Helper.interpolatePos((Vec3)from.position, (Vec3)to.position, (double)progress), DQuaternion.interpolate((DQuaternion)from.orientation, (DQuaternion)to.orientation, (double)progress), Mth.m_14139_((double)progress, (double)from.width, (double)to.width), Mth.m_14139_((double)progress, (double)from.height, (double)to.height));
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("dimension", this.dimension.m_135782_().toString());
        Helper.putVec3d((CompoundTag)tag, (String)"position", (Vec3)this.position);
        tag.m_128365_("orientation", this.orientation.toTag());
        tag.m_128347_("width", this.width);
        tag.m_128347_("height", this.height);
        return tag;
    }

    public static UnilateralPortalState fromTag(CompoundTag tag) {
        ResourceKey dimension = DimId.idToKey((String)tag.m_128461_("dimension"));
        Vec3 point = Helper.getVec3d((CompoundTag)tag, (String)"position");
        DQuaternion orientation = DQuaternion.fromTag((Tag)tag.m_128469_("orientation"));
        double width = tag.m_128459_("width");
        double height = tag.m_128459_("height");
        return new UnilateralPortalState((ResourceKey<Level>)dimension, point, orientation, width, height);
    }

    public DeltaUnilateralPortalState subtract(UnilateralPortalState other) {
        Vec3 offset = this.position.m_82546_(other.position);
        DQuaternion rotation = this.orientation.hamiltonProduct(other.orientation.getConjugated());
        double widthScale = this.width / other.width;
        double heightScale = this.height / other.height;
        return new DeltaUnilateralPortalState(offset, rotation, new Vec2d(widthScale, heightScale)).purgeFPError();
    }

    public UnilateralPortalState apply(DeltaUnilateralPortalState thisSideDelta) {
        return new Builder().from(this).apply(thisSideDelta).build();
    }

    public Vec3 getAxisW() {
        return this.orientation.getAxisW();
    }

    public Vec3 getAxisH() {
        return this.orientation.getAxisH();
    }

    public Vec3 getNormal() {
        return this.orientation.getNormal();
    }

    public Pair<RectInvariant, UnilateralPortalState> turnToClosestTo(DQuaternion targetOrientation) {
        return Arrays.stream(RectInvariant.values()).map(inv -> Pair.of((Object)inv, (Object)inv.getVariantOf(this))).min(Comparator.comparingDouble(p -> DQuaternion.distance((DQuaternion)((UnilateralPortalState)p.getSecond()).orientation(), (DQuaternion)targetOrientation))).orElseThrow();
    }

    public static class Builder {
        public ResourceKey<Level> dimension;
        public Vec3 position;
        public DQuaternion orientation;
        public double width;
        public double height;

        public UnilateralPortalState build() {
            return new UnilateralPortalState(this.dimension, this.position, this.orientation, this.width, this.height);
        }

        public Builder dimension(ResourceKey<Level> dimension) {
            this.dimension = dimension;
            return this;
        }

        public Builder position(Vec3 point) {
            this.position = point;
            return this;
        }

        public Builder orientation(DQuaternion orientation) {
            this.orientation = orientation;
            return this;
        }

        public Builder width(double width) {
            this.width = width;
            return this;
        }

        public Builder height(double height) {
            this.height = height;
            return this;
        }

        @NotNull
        public Builder from(UnilateralPortalState other) {
            this.dimension = other.dimension;
            this.position = other.position;
            this.orientation = other.orientation;
            this.width = other.width;
            this.height = other.height;
            return this;
        }

        public Builder offset(Vec3 offset) {
            this.position = this.position.m_82549_(offset);
            return this;
        }

        public Builder rotate(DQuaternion rotation) {
            this.orientation = rotation.hamiltonProduct(this.orientation);
            return this;
        }

        public Builder scaleWidth(double scale) {
            this.width *= scale;
            return this;
        }

        public Builder scaleHeight(double scale) {
            this.height *= scale;
            return this;
        }

        public Builder apply(DeltaUnilateralPortalState delta) {
            if (delta.offset() != null) {
                this.position = this.position.m_82549_(delta.offset());
            }
            if (delta.rotation() != null) {
                this.orientation = delta.rotation().hamiltonProduct(this.orientation);
            }
            if (delta.sizeScaling() != null) {
                this.width *= delta.sizeScaling().x();
                this.height *= delta.sizeScaling().y();
            }
            return this;
        }

        @Deprecated
        @NotNull
        public Builder correctFrom(UnilateralPortalState other) {
            this.dimension = other.dimension;
            if (this.position.m_82557_(other.position) > 1.0E-4) {
                this.position = other.position;
            }
            if (!DQuaternion.isClose((DQuaternion)this.orientation, (DQuaternion)other.orientation, (double)0.001)) {
                this.orientation = other.orientation;
            }
            if (Math.abs(this.width - other.width) > 1.0E-4) {
                this.width = other.width;
            }
            if (Math.abs(this.height - other.height) > 1.0E-4) {
                this.height = other.height;
            }
            return this;
        }
    }

    public static enum RectInvariant {
        IDENTITY,
        ROTATE_90,
        ROTATE_180,
        ROTATE_270,
        FLIP_X,
        FLIP_X_ROTATE_90,
        FLIP_X_ROTATE_180,
        FLIP_X_ROTATE_270;


        public UnilateralPortalState getVariantOf(UnilateralPortalState state) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY -> state;
                case ROTATE_90 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((Vec3)new Vec3(0.0, 0.0, 1.0), (double)90.0)), state.height, state.width);
                case ROTATE_180 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((Vec3)new Vec3(0.0, 0.0, 1.0), (double)180.0)), state.width, state.height);
                case ROTATE_270 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((Vec3)new Vec3(0.0, 0.0, 1.0), (double)270.0)), state.height, state.width);
                case FLIP_X -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((Vec3)new Vec3(1.0, 0.0, 0.0), (double)180.0)), state.width, state.height);
                case FLIP_X_ROTATE_90 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((Vec3)new Vec3(0.0, 0.0, 1.0), (double)90.0)).hamiltonProduct(DQuaternion.rotationByDegrees((Vec3)new Vec3(1.0, 0.0, 0.0), (double)180.0)), state.height, state.width);
                case FLIP_X_ROTATE_180 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((Vec3)new Vec3(0.0, 0.0, 1.0), (double)180.0)).hamiltonProduct(DQuaternion.rotationByDegrees((Vec3)new Vec3(1.0, 0.0, 0.0), (double)180.0)), state.width, state.height);
                case FLIP_X_ROTATE_270 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((Vec3)new Vec3(0.0, 0.0, 1.0), (double)270.0)).hamiltonProduct(DQuaternion.rotationByDegrees((Vec3)new Vec3(1.0, 0.0, 0.0), (double)180.0)), state.height, state.width);
            };
        }

        public boolean switchesWidthAndHeight() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY, ROTATE_180, FLIP_X, FLIP_X_ROTATE_180 -> false;
                case ROTATE_90, ROTATE_270, FLIP_X_ROTATE_90, FLIP_X_ROTATE_270 -> true;
            };
        }
    }
}

