/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.AnimationContext;
import qouteall.imm_ptl.core.portal.animation.AnimationResult;
import qouteall.imm_ptl.core.portal.animation.DefaultPortalAnimation;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.Helper;

public class PortalAnimation {
    @NotNull
    public DefaultPortalAnimation defaultAnimation = DefaultPortalAnimation.createDefault();
    @NotNull
    public List<PortalAnimationDriver> thisSideAnimations = new ArrayList<PortalAnimationDriver>();
    @NotNull
    public List<PortalAnimationDriver> otherSideAnimations = new ArrayList<PortalAnimationDriver>();
    public long pauseTime = 0L;
    public long timeOffset = 0L;
    @Nullable
    public UnilateralPortalState thisSideReferenceState;
    @Nullable
    public UnilateralPortalState otherSideReferenceState;
    @Nullable
    private UnilateralPortalState pausedThisSideState;
    @Nullable
    private UnilateralPortalState pausedOtherSideState;
    @Nullable
    public PortalState lastTickAnimatedState;
    @Nullable
    public PortalState thisTickAnimatedState;
    public long updateCounter;
    @Nullable
    public PortalState clientLastFramePortalState;
    public long clientLastFramePortalStateCounter = -1L;
    @Nullable
    public PortalState clientCurrentFramePortalState;
    public long clientCurrentFramePortalStateCounter = -1L;

    public void readFromTag(CompoundTag tag) {
        ListTag listTag;
        this.defaultAnimation = tag.m_128441_("animation") ? DefaultPortalAnimation.fromNbt(tag.m_128469_("animation")) : (tag.m_128441_("defaultAnimation") ? DefaultPortalAnimation.fromNbt(tag.m_128469_("defaultAnimation")) : DefaultPortalAnimation.createDefault());
        if (tag.m_128441_("thisSideAnimations")) {
            listTag = tag.m_128437_("thisSideAnimations", 10);
            this.thisSideAnimations = Helper.listTagToList((ListTag)listTag, PortalAnimationDriver::fromTag);
        } else {
            this.thisSideAnimations.clear();
        }
        if (tag.m_128441_("otherSideAnimations")) {
            listTag = tag.m_128437_("otherSideAnimations", 10);
            this.otherSideAnimations = Helper.listTagToList((ListTag)listTag, PortalAnimationDriver::fromTag);
        } else {
            this.otherSideAnimations.clear();
        }
        this.pauseTime = tag.m_128441_("pauseTime") ? tag.m_128454_("pauseTime") : 0L;
        this.timeOffset = tag.m_128441_("timeOffset") ? tag.m_128454_("timeOffset") : 0L;
        this.thisSideReferenceState = tag.m_128441_("thisSideReferenceState") ? UnilateralPortalState.fromTag(tag.m_128469_("thisSideReferenceState")) : null;
        this.otherSideReferenceState = tag.m_128441_("otherSideReferenceState") ? UnilateralPortalState.fromTag(tag.m_128469_("otherSideReferenceState")) : null;
        this.pausedThisSideState = tag.m_128441_("pausedThisSideState") ? UnilateralPortalState.fromTag(tag.m_128469_("pausedThisSideState")) : null;
        this.pausedOtherSideState = tag.m_128441_("pausedOtherSideState") ? UnilateralPortalState.fromTag(tag.m_128469_("pausedOtherSideState")) : null;
    }

    public void writeToTag(CompoundTag tag) {
        tag.m_128365_("defaultAnimation", (Tag)this.defaultAnimation.toNbt());
        if (!this.thisSideAnimations.isEmpty()) {
            tag.m_128365_("thisSideAnimations", (Tag)Helper.listToListTag(this.thisSideAnimations, PortalAnimationDriver::toTag));
        }
        if (!this.otherSideAnimations.isEmpty()) {
            tag.m_128365_("otherSideAnimations", (Tag)Helper.listToListTag(this.otherSideAnimations, PortalAnimationDriver::toTag));
        }
        if (this.pauseTime != 0L) {
            tag.m_128356_("pauseTime", this.pauseTime);
        }
        if (this.timeOffset != 0L) {
            tag.m_128356_("timeOffset", this.timeOffset);
        }
        if (this.thisSideReferenceState != null) {
            tag.m_128365_("thisSideReferenceState", (Tag)this.thisSideReferenceState.toTag());
        }
        if (this.otherSideReferenceState != null) {
            tag.m_128365_("otherSideReferenceState", (Tag)this.otherSideReferenceState.toTag());
        }
        if (this.pausedThisSideState != null) {
            tag.m_128365_("pausedThisSideState", (Tag)this.pausedThisSideState.toTag());
        }
        if (this.pausedOtherSideState != null) {
            tag.m_128365_("pausedOtherSideState", (Tag)this.pausedOtherSideState.toTag());
        }
    }

    public boolean isRoughlyRunningAnimation() {
        return this.lastTickAnimatedState != null || this.thisTickAnimatedState != null || this.hasRunningAnimationDriver();
    }

    public boolean hasRunningAnimationDriver() {
        return !this.isPaused() && this.hasAnimationDriver();
    }

    public boolean hasAnimationDriver() {
        return !this.thisSideAnimations.isEmpty() || !this.otherSideAnimations.isEmpty();
    }

    public boolean isPaused() {
        return this.pauseTime != 0L;
    }

    public void setPaused(Portal portal, boolean paused) {
        if (paused == this.isPaused()) {
            return;
        }
        if (paused) {
            this.pauseTime = portal.m_9236_().m_46467_();
            PortalState portalState = portal.getPortalState();
            assert (portalState != null);
            this.pausedThisSideState = portalState.getThisSideState();
            this.pausedOtherSideState = portalState.getOtherSideState();
        } else {
            this.timeOffset -= portal.m_9236_().m_46467_() - this.pauseTime;
            this.pauseTime = 0L;
            if (this.pausedThisSideState != null && this.pausedOtherSideState != null) {
                PortalState currentState = portal.getPortalState();
                assert (currentState != null);
                UnilateralPortalState currentThisSideState = currentState.getThisSideState();
                UnilateralPortalState currentOtherSideState = currentState.getOtherSideState();
                DeltaUnilateralPortalState thisSideDelta = currentThisSideState.subtract(this.pausedThisSideState);
                DeltaUnilateralPortalState otherSideDelta = currentOtherSideState.subtract(this.pausedOtherSideState);
                if (this.thisSideReferenceState != null) {
                    this.thisSideReferenceState = this.thisSideReferenceState.apply(thisSideDelta);
                }
                if (this.otherSideReferenceState != null) {
                    this.otherSideReferenceState = this.otherSideReferenceState.apply(otherSideDelta);
                }
                this.pausedThisSideState = null;
                this.pausedOtherSideState = null;
            }
        }
        PortalExtension.forClusterPortals(portal, Portal::reloadAndSyncToClientNextTick);
    }

    public void setBackToPausingState(Portal portal) {
        if (this.pausedThisSideState != null && this.pausedOtherSideState != null) {
            portal.setPortalState(UnilateralPortalState.combine(this.pausedThisSideState, this.pausedOtherSideState));
        }
    }

    public long getEffectiveTime(long gameTime) {
        return (this.isPaused() ? this.pauseTime : gameTime) + this.timeOffset;
    }

    public void tick(Portal portal) {
        this.swapTickRelativeStateIfNeeded(portal);
        if (!portal.m_9236_().m_5776_()) {
            this.updateAnimationDriver(portal, portal.animation, portal.m_9236_().m_46467_(), 1.0f, true, true);
            if (this.thisSideAnimations.isEmpty()) {
                this.thisSideReferenceState = null;
            }
            if (this.otherSideAnimations.isEmpty()) {
                this.otherSideReferenceState = null;
            }
            if (!this.hasAnimationDriver()) {
                this.setPaused(portal, false);
            }
        } else if (this.hasAnimationDriver() && !this.isPaused()) {
            PortalAnimation.markRequiresClientAnimationUpdate((Portal)portal);
        }
    }

    public void swapTickRelativeStateIfNeeded(Portal portal) {
        int counter = portal.f_19797_;
        if ((long)counter != this.updateCounter) {
            this.lastTickAnimatedState = this.thisTickAnimatedState;
            this.thisTickAnimatedState = null;
            this.updateCounter = counter;
        }
    }

    private void provideThisTickState(Portal portal, PortalState portalState) {
        this.swapTickRelativeStateIfNeeded(portal);
        if (this.thisTickAnimatedState != null && !portal.m_9236_().m_5776_()) {
            Helper.log((Object)("Conflicting animation in " + portal));
            portal.clearAnimationDrivers(true, true);
            this.thisTickAnimatedState = null;
            return;
        }
        this.thisTickAnimatedState = portalState;
    }

    public void updateAnimationDriver(Portal portal, PortalAnimation animation, long gameTime, float partialTicks, boolean isTicking, boolean canRemoveAnimation) {
        if (!this.hasAnimationDriver()) {
            return;
        }
        if (this.isPaused()) {
            return;
        }
        PortalState portalState = portal.getPortalState();
        if (portalState == null) {
            return;
        }
        this.initializeReferenceStates(portalState);
        assert (this.thisSideReferenceState != null);
        assert (this.otherSideReferenceState != null);
        long effectiveGameTime = animation.getEffectiveTime(gameTime);
        float effectivePartialTicks = animation.isPaused() ? 0.0f : partialTicks;
        UnilateralPortalState.Builder thisSideState = new UnilateralPortalState.Builder().from(this.thisSideReferenceState);
        UnilateralPortalState.Builder otherSideState = new UnilateralPortalState.Builder().from(this.otherSideReferenceState);
        int originalThisSideAnimationCount = this.thisSideAnimations.size();
        int originalOtherSideAnimationCount = this.otherSideAnimations.size();
        AnimationContext context = new AnimationContext(portal.m_9236_().m_5776_(), isTicking);
        this.thisSideAnimations.removeIf(animationDriver -> {
            boolean animationRemoved;
            AnimationResult animationResult = animationDriver.getAnimationResult(effectiveGameTime, effectivePartialTicks, context);
            if (animationResult.delta() != null) {
                thisSideState.apply(animationResult.delta());
            }
            boolean bl = animationRemoved = canRemoveAnimation && animationResult.isFinished();
            if (animationRemoved && animationResult.delta() != null) {
                assert (this.thisSideReferenceState != null);
                this.thisSideReferenceState = new UnilateralPortalState.Builder().from(this.thisSideReferenceState).apply(animationResult.delta()).build();
            }
            return animationRemoved;
        });
        this.otherSideAnimations.removeIf(animationDriver -> {
            boolean animationRemoved;
            AnimationResult animationResult = animationDriver.getAnimationResult(effectiveGameTime, effectivePartialTicks, context);
            if (animationResult.delta() != null) {
                otherSideState.apply(animationResult.delta());
            }
            boolean bl = animationRemoved = canRemoveAnimation && animationResult.isFinished();
            if (animationRemoved && animationResult.delta() != null) {
                assert (this.otherSideReferenceState != null);
                this.otherSideReferenceState = new UnilateralPortalState.Builder().from(this.otherSideReferenceState).apply(animationResult.delta()).build();
            }
            return animationRemoved;
        });
        if (thisSideState.dimension != portalState.fromWorld || otherSideState.dimension != portalState.toWorld) {
            Helper.err((Object)"Portal animation driver cannot change dimension");
            if (!portal.m_9236_().m_5776_()) {
                portal.clearAnimationDrivers(true, true);
            }
            return;
        }
        UnilateralPortalState newThisSideState = thisSideState.build();
        UnilateralPortalState newOtherSideState = otherSideState.build();
        PortalState newPortalState = UnilateralPortalState.combine(newThisSideState, newOtherSideState);
        portal.setPortalState(newPortalState);
        if (isTicking) {
            this.provideThisTickState(portal, newPortalState);
        }
        portal.rectifyClusterPortals(false);
        if (isTicking) {
            PortalExtension.forConnectedPortals(portal, p -> p.animation.provideThisTickState((Portal)p, p.getPortalState()));
        }
        if (!(portal.m_9236_().m_5776_() || this.thisSideAnimations.size() == originalThisSideAnimationCount && this.otherSideAnimations.size() == originalOtherSideAnimationCount)) {
            PortalExtension.forClusterPortals(portal, p -> p.reloadAndSyncToClientWithTickDelay(1));
        }
    }

    public void initializeReferenceStates(PortalState portalState) {
        if (this.thisSideReferenceState == null) {
            this.thisSideReferenceState = UnilateralPortalState.extractThisSide(portalState);
        }
        if (this.otherSideReferenceState == null) {
            this.otherSideReferenceState = UnilateralPortalState.extractOtherSide(portalState);
        }
    }

    public void resetReferenceState(Portal portal, boolean thisSide, boolean otherSide) {
        PortalState portalState = portal.getPortalState();
        assert (portalState != null);
        if (thisSide && this.thisSideReferenceState != null) {
            this.thisSideReferenceState = UnilateralPortalState.extractThisSide(portalState);
        }
        if (otherSide && this.otherSideReferenceState != null) {
            this.otherSideReferenceState = UnilateralPortalState.extractOtherSide(portalState);
        }
    }

    public void clearAnimationDrivers(Portal portal, boolean clearThisSide, boolean clearOtherSide) {
        Validate.isTrue((!portal.m_9236_().m_5776_() ? 1 : 0) != 0);
        this.setPaused(portal, false);
        if (this.thisSideAnimations.isEmpty() && this.otherSideAnimations.isEmpty()) {
            return;
        }
        AnimationContext context = new AnimationContext(portal.m_9236_().m_5776_(), true);
        PortalState portalState = portal.getPortalState();
        assert (portalState != null);
        UnilateralPortalState.Builder from = new UnilateralPortalState.Builder().from(UnilateralPortalState.extractThisSide(portalState));
        UnilateralPortalState.Builder to = new UnilateralPortalState.Builder().from(UnilateralPortalState.extractOtherSide(portalState));
        this.applyEndingState(portal, clearThisSide, clearOtherSide, context, from, to);
        if (clearThisSide) {
            this.thisSideReferenceState = null;
            this.thisSideAnimations.clear();
        }
        if (clearOtherSide) {
            this.otherSideReferenceState = null;
            this.otherSideAnimations.clear();
        }
        PortalState newState = UnilateralPortalState.combine(from.build(), to.build());
        portal.setPortalState(newState);
        PortalExtension.get(portal).rectifyClusterPortals(portal, true);
    }

    private void applyEndingState(Portal portal, boolean includeThisSide, boolean includeOtherSide, AnimationContext context, UnilateralPortalState.Builder from, UnilateralPortalState.Builder to) {
        DeltaUnilateralPortalState endingResult;
        long effectiveGameTime = portal.m_9236_().m_46467_() + this.timeOffset;
        if (includeThisSide) {
            for (PortalAnimationDriver animationDriver : this.thisSideAnimations) {
                endingResult = animationDriver.getEndingResult(effectiveGameTime, context);
                if (endingResult == null) continue;
                from.apply(endingResult);
            }
        }
        if (includeOtherSide) {
            for (PortalAnimationDriver animationDriver : this.otherSideAnimations) {
                endingResult = animationDriver.getEndingResult(effectiveGameTime, context);
                if (endingResult == null) continue;
                to.apply(endingResult);
            }
        }
    }

    public PortalState getAnimationEndingState(Portal portal) {
        PortalState portalState = portal.getPortalState();
        assert (portalState != null);
        this.initializeReferenceStates(portalState);
        assert (this.thisSideReferenceState != null);
        assert (this.otherSideReferenceState != null);
        UnilateralPortalState.Builder from = new UnilateralPortalState.Builder().from(this.thisSideReferenceState);
        UnilateralPortalState.Builder to = new UnilateralPortalState.Builder().from(this.otherSideReferenceState);
        this.applyEndingState(portal, true, true, new AnimationContext(portal.m_9236_().m_5776_(), true), from, to);
        return UnilateralPortalState.combine(from.build(), to.build());
    }

    public Component getInfo(Portal portal, boolean reverse) {
        PortalAnimationDriver animation;
        int i;
        MutableComponent component = Component.m_237113_((String)"");
        List<PortalAnimationDriver> l1 = reverse ? this.otherSideAnimations : this.thisSideAnimations;
        List<PortalAnimationDriver> l2 = reverse ? this.thisSideAnimations : this.otherSideAnimations;
        component.m_7220_((Component)Component.m_237113_((String)"This Side:\n"));
        for (i = 0; i < l1.size(); ++i) {
            animation = l1.get(i);
            component.m_7220_((Component)Component.m_237113_((String)"[%d]: ".formatted(i)).m_130940_(ChatFormatting.GOLD).m_7220_(animation.getInfo()).m_130946_("\n"));
        }
        component.m_7220_((Component)Component.m_237113_((String)"Other Side:\n"));
        for (i = 0; i < l2.size(); ++i) {
            animation = l2.get(i);
            component.m_7220_((Component)Component.m_237113_((String)"[%d]: ".formatted(i)).m_130940_(ChatFormatting.GOLD).m_7220_(animation.getInfo()).m_130946_("\n"));
        }
        return component;
    }
}

