/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import net.minecraft.nbt.CompoundTag;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;

public class DefaultPortalAnimation {
    public TimingFunction timingFunction;
    public int durationTicks;
    public boolean inverseScale;
    public long disableUntil = 0L;

    public DefaultPortalAnimation(TimingFunction timingFunction, int durationTicks, boolean inverseScale, long disableUntil) {
        this.timingFunction = timingFunction;
        this.durationTicks = durationTicks;
        this.inverseScale = inverseScale;
        this.disableUntil = disableUntil;
    }

    public DefaultPortalAnimation(TimingFunction timingFunction, int durationTicks, boolean inverseScale) {
        this(timingFunction, durationTicks, inverseScale, 0L);
    }

    public static DefaultPortalAnimation createDefault() {
        return new DefaultPortalAnimation(TimingFunction.sine, 10, false);
    }

    public static DefaultPortalAnimation fromNbt(CompoundTag nbt) {
        String c = nbt.m_128461_("curve");
        TimingFunction timingFunction = TimingFunction.fromString(c);
        int durationTicks = nbt.m_128451_("durationTicks");
        boolean inverseScale = nbt.m_128471_("inverseScale");
        long disableUntil = nbt.m_128454_("disableUntil");
        return new DefaultPortalAnimation(timingFunction, durationTicks, inverseScale, disableUntil);
    }

    public void setDisableUntil(long disableUntil) {
        this.disableUntil = disableUntil;
    }

    public CompoundTag toNbt() {
        CompoundTag nbtCompound = new CompoundTag();
        nbtCompound.m_128359_("curve", this.timingFunction.toString());
        nbtCompound.m_128405_("durationTicks", this.durationTicks);
        nbtCompound.m_128379_("inverseScale", this.inverseScale);
        nbtCompound.m_128356_("disableUntil", this.disableUntil);
        return nbtCompound;
    }

    public DefaultPortalAnimation copy() {
        return new DefaultPortalAnimation(this.timingFunction, this.durationTicks, this.inverseScale);
    }
}

