/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.my_util.DQuaternion;

public class PortalState {
    public final ResourceKey<Level> fromWorld;
    public final Vec3 fromPos;
    public final ResourceKey<Level> toWorld;
    public final Vec3 toPos;
    public final double scaling;
    public final DQuaternion rotation;
    public final DQuaternion orientation;
    public final double width;
    public final double height;

    public PortalState(ResourceKey<Level> fromWorld, Vec3 fromPos, ResourceKey<Level> toWorld, Vec3 toPos, double scaling, DQuaternion rotation, DQuaternion orientation, double width, double height) {
        this.fromWorld = fromWorld;
        this.fromPos = fromPos;
        this.toWorld = toWorld;
        this.toPos = toPos;
        this.scaling = scaling;
        this.rotation = rotation;
        this.orientation = orientation;
        this.width = width;
        this.height = height;
    }

    public PortalState withThisSideUpdated(UnilateralPortalState thisSide, boolean lockScale) {
        UnilateralPortalState otherSide = UnilateralPortalState.extractOtherSide(this);
        if (lockScale) {
            otherSide = new UnilateralPortalState.Builder().from(otherSide).width(thisSide.width() * this.scaling).height(thisSide.height() * this.scaling).build();
        }
        PortalState newPortalState = UnilateralPortalState.combine(thisSide, otherSide);
        return newPortalState;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("fromWorld", this.fromWorld.m_135782_().toString());
        tag.m_128359_("toWorld", this.toWorld.m_135782_().toString());
        Helper.putVec3d((CompoundTag)tag, (String)"fromPos", (Vec3)this.fromPos);
        Helper.putVec3d((CompoundTag)tag, (String)"toPos", (Vec3)this.toPos);
        tag.m_128347_("scaling", this.scaling);
        tag.m_128347_("width", this.width);
        tag.m_128347_("height", this.height);
        tag.m_128365_("rotation", this.rotation.toTag());
        tag.m_128365_("orientation", this.orientation.toTag());
        return tag;
    }

    public static PortalState fromTag(CompoundTag tag) {
        ResourceKey fromWorld = DimId.idToKey((String)tag.m_128461_("fromWorld"));
        ResourceKey toWorld = DimId.idToKey((String)tag.m_128461_("toWorld"));
        Vec3 fromPos = Helper.getVec3d((CompoundTag)tag, (String)"fromPos");
        Vec3 toPos = Helper.getVec3d((CompoundTag)tag, (String)"toPos");
        double scaling = tag.m_128459_("scaling");
        double width = tag.m_128459_("width");
        double height = tag.m_128459_("height");
        DQuaternion rotation = DQuaternion.fromTag((Tag)tag.m_128469_("rotation"));
        DQuaternion orientation = DQuaternion.fromTag((Tag)tag.m_128469_("orientation"));
        return new PortalState((ResourceKey<Level>)fromWorld, fromPos, (ResourceKey<Level>)toWorld, toPos, scaling, rotation, orientation, width, height);
    }

    public static PortalState interpolate(PortalState a, PortalState b, double progress, boolean inverseScale) {
        Validate.isTrue((a.fromWorld == b.fromWorld ? 1 : 0) != 0);
        Validate.isTrue((a.toWorld == b.toWorld ? 1 : 0) != 0);
        return new PortalState(a.fromWorld, Helper.interpolatePos((Vec3)a.fromPos, (Vec3)b.fromPos, (double)progress), a.toWorld, Helper.interpolatePos((Vec3)a.toPos, (Vec3)b.toPos, (double)progress), PortalState.interpolateScale(a, b, progress, inverseScale), DQuaternion.interpolate((DQuaternion)a.rotation, (DQuaternion)b.rotation, (double)progress), DQuaternion.interpolate((DQuaternion)a.orientation, (DQuaternion)b.orientation, (double)progress), Mth.m_14139_((double)progress, (double)a.width, (double)b.width), Mth.m_14139_((double)progress, (double)a.height, (double)b.height));
    }

    private static double interpolateScale(PortalState a, PortalState b, double progress, boolean inverseScale) {
        if (inverseScale) {
            return 1.0 / Mth.m_14139_((double)progress, (double)(1.0 / a.scaling), (double)(1.0 / b.scaling));
        }
        return Mth.m_14139_((double)progress, (double)a.scaling, (double)b.scaling);
    }

    public Vec3 getPointOnSurface(double localX, double localY) {
        Vec3 axisW = McHelper.getAxisWFromOrientation(this.orientation);
        Vec3 axisH = McHelper.getAxisHFromOrientation(this.orientation);
        return axisW.m_82490_(localX).m_82549_(axisH.m_82490_(localY)).m_82549_(this.fromPos);
    }

    public Vec3 transformPoint(Vec3 pos) {
        Vec3 offset = pos.m_82546_(this.fromPos);
        Vec3 rotated = this.rotation.rotate(offset);
        Vec3 scaled = rotated.m_82490_(this.scaling);
        return scaled.m_82549_(this.toPos);
    }

    public Vec3 transformVec(Vec3 vec) {
        Vec3 rotated = this.rotation.rotate(vec);
        Vec3 scaled = rotated.m_82490_(this.scaling);
        return scaled;
    }

    public Vec3 worldPosToPortalLocalPos(Vec3 worldPos) {
        Vec3 axisW = McHelper.getAxisWFromOrientation(this.orientation);
        Vec3 axisH = McHelper.getAxisHFromOrientation(this.orientation);
        Vec3 origin = this.fromPos;
        Vec3 offset = worldPos.m_82546_(origin);
        return new Vec3(offset.m_82526_(axisW), offset.m_82526_(axisH), offset.m_82526_(axisW.m_82537_(axisH)));
    }

    public Vec3 portalLocalPosToWorldPos(Vec3 portalLocalPos) {
        Vec3 axisW = McHelper.getAxisWFromOrientation(this.orientation);
        Vec3 axisH = McHelper.getAxisHFromOrientation(this.orientation);
        Vec3 origin = this.fromPos;
        return origin.m_82549_(axisW.m_82490_(portalLocalPos.f_82479_)).m_82549_(axisH.m_82490_(portalLocalPos.f_82480_)).m_82549_(axisW.m_82537_(axisH).m_82490_(portalLocalPos.f_82481_));
    }

    public Vec3 getLocalPosTransformed(double collisionLocalX, double collisionLocalY) {
        return this.transformPoint(this.portalLocalPosToWorldPos(new Vec3(collisionLocalX, collisionLocalY, 0.0)));
    }

    public Vec3 getNormal() {
        return McHelper.getNormalFromOrientation(this.orientation);
    }

    public Vec3 getContentDirection() {
        return this.rotation.rotate(this.getNormal().m_82490_(-1.0));
    }

    public UnilateralPortalState getThisSideState() {
        return UnilateralPortalState.extractThisSide(this);
    }

    public UnilateralPortalState getOtherSideState() {
        return UnilateralPortalState.extractOtherSide(this);
    }
}

