/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.mixin.common.miscellaneous.IEEndDragonFight;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

public class EndPortalEntity
extends Portal {
    private static final Logger LOGGER = LogManager.getLogger(EndPortalEntity.class);
    public static final EntityType<EndPortalEntity> entityType = Portal.createPortalEntityType(EndPortalEntity::new);
    public static final String PORTAL_TAG_VIEW_BOX = "view_box";
    private EndPortalEntity clientFakedReversePortal;

    public EndPortalEntity(EntityType<?> entityType, Level world) {
        super(entityType, world);
        this.renderingMergable = true;
        this.hasCrossPortalCollision = false;
    }

    public static void onEndPortalComplete(ServerLevel world, Vec3 portalCenter) {
        ServerLevel endDim = MiscHelper.getServer().m_129880_(Level.f_46430_);
        if (endDim == null) {
            return;
        }
        if (IPGlobal.endPortalMode == IPGlobal.EndPortalMode.normal) {
            EndPortalEntity.generateClassicalEndPortal(world, new Vec3(0.0, 120.0, 0.0), portalCenter);
        } else if (IPGlobal.endPortalMode == IPGlobal.EndPortalMode.toObsidianPlatform) {
            BlockPos endSpawnPos = ServerLevel.f_8562_;
            EndPortalEntity.generateClassicalEndPortal(world, Vec3.m_82512_((Vec3i)endSpawnPos).m_82520_(0.0, 1.0, 0.0), portalCenter);
        } else if (IPGlobal.endPortalMode == IPGlobal.EndPortalMode.scaledView) {
            EndPortalEntity.generateScaledViewEndPortal(world, portalCenter);
        } else {
            Helper.err((Object)"End portal mode abnormal");
        }
        ServerLevel.m_8617_((ServerLevel)world);
        EndDragonFight dragonFight = world.m_8586_();
        if (dragonFight == null) {
            return;
        }
        if (((IEEndDragonFight)dragonFight).ip_getNeedsStateScanning()) {
            ((IEEndDragonFight)dragonFight).ip_scanState();
        }
    }

    private static void generateClassicalEndPortal(ServerLevel world, Vec3 destination, Vec3 portalCenter) {
        EndPortalEntity portal = new EndPortalEntity(entityType, (Level)world);
        portal.m_6034_(portalCenter.f_82479_, portalCenter.f_82480_, portalCenter.f_82481_);
        portal.setDestination(destination);
        portal.dimensionTo = Level.f_46430_;
        portal.axisW = new Vec3(0.0, 0.0, 1.0);
        portal.axisH = new Vec3(1.0, 0.0, 0.0);
        portal.width = 3.0;
        portal.height = 3.0;
        world.m_7967_((Entity)portal);
    }

    private static void generateScaledViewEndPortal(ServerLevel world, Vec3 portalCenter) {
        ServerLevel endWorld = McHelper.getServerWorld((ResourceKey<Level>)Level.f_46430_);
        double d = 3.0;
        Vec3 viewBoxSize = new Vec3(d, 1.2, d);
        double scale = 280.0 / d;
        AABB thisSideBox = Helper.getBoxByBottomPosAndSize((Vec3)portalCenter.m_82520_(0.0, 0.0, 0.0), (Vec3)viewBoxSize);
        AABB otherSideBox = Helper.getBoxByBottomPosAndSize((Vec3)new Vec3(0.0, 0.0, 0.0), (Vec3)viewBoxSize.m_82490_(scale));
        for (Direction direction : Direction.values()) {
            EndPortalEntity portal = PortalManipulation.createOrthodoxPortal(entityType, world, endWorld, direction, Helper.getBoxSurface((AABB)thisSideBox, (Direction)direction), Helper.getBoxSurface((AABB)otherSideBox, (Direction)direction).m_82399_());
            portal.scaling = scale;
            portal.teleportChangesScale = false;
            portal.portalTag = PORTAL_TAG_VIEW_BOX;
            portal.setInteractable(false);
            McHelper.spawnServerEntity(portal);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.tickClient();
        }
    }

    @Override
    public void onEntityTeleportedOnServer(Entity entity) {
        super.onEntityTeleportedOnServer(entity);
        if (this.shouldAddSlowFalling(entity)) {
            int duration = 200;
            if (this.isViewBoxPortal()) {
                duration = 300;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, duration, 1));
        }
        ServerLevel endWorld = MiscHelper.getServer().m_129880_(Level.f_46430_);
        ServerLevel.m_8617_((ServerLevel)endWorld);
    }

    private boolean isViewBoxPortal() {
        return Objects.equals(this.portalTag, PORTAL_TAG_VIEW_BOX);
    }

    @Override
    public Vec3 transformVelocityRelativeToPortal(Vec3 originalVelocityRelativeToPortal, Entity entity) {
        if (this.isViewBoxPortal()) {
            return Vec3.f_82478_;
        }
        return super.transformVelocityRelativeToPortal(originalVelocityRelativeToPortal, entity);
    }

    @Override
    public boolean canTeleportEntity(Entity entity) {
        if (entity instanceof Arrow) {
            return false;
        }
        return super.canTeleportEntity(entity);
    }

    private boolean shouldAddSlowFalling(Entity entity) {
        if (entity instanceof LivingEntity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (player.f_8941_.m_9290_() == GameType.CREATIVE) {
                    return false;
                }
                if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() == Items.f_42741_) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldLimitBoundingBox() {
        return false;
    }

    @Override
    public void onCollidingWithEntity(Entity entity) {
        if (!this.m_9236_().m_5776_() && entity instanceof ServerPlayer && IPGlobal.endPortalMode == IPGlobal.EndPortalMode.toObsidianPlatform) {
            ServerLevel endWorld = MiscHelper.getServer().m_129880_(Level.f_46430_);
            ServerLevel.m_8617_((ServerLevel)endWorld);
        }
    }
}

