/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import io.netty.buffer.Unpooled;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.network.IPNetworkingClient;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimId;

public class IPNetworking {
    public static final ResourceLocation id_ctsTeleport = new ResourceLocation("imm_ptl", "teleport");
    public static final ResourceLocation id_stcSpawnEntity = new ResourceLocation("imm_ptl", "spawn_entity");
    public static final ResourceLocation id_stcDimensionConfirm = new ResourceLocation("imm_ptl", "dim_confirm");
    public static final ResourceLocation id_stcUpdateGlobalPortal = new ResourceLocation("imm_ptl", "upd_glb_ptl");

    public static void init() {
    }

    public static boolean handleImmPtlCorePacketServerSide(ResourceLocation packedId, ServerPlayer player, FriendlyByteBuf buf) {
        if (id_ctsTeleport.equals((Object)packedId)) {
            IPNetworking.processCtsTeleport(player, buf);
            return true;
        }
        return false;
    }

    public static boolean handleImmPtlCorePacketClientSide(ResourceLocation packedId, Supplier<FriendlyByteBuf> buf) {
        return IPNetworkingClient.handleImmPtlCorePacketClientSide(packedId, buf);
    }

    public static Packet createStcDimensionConfirm(ResourceKey<Level> dimensionType, Vec3 pos) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        DimId.writeWorldId((FriendlyByteBuf)buf, dimensionType, (boolean)false);
        buf.writeDouble(pos.f_82479_);
        buf.writeDouble(pos.f_82480_);
        buf.writeDouble(pos.f_82481_);
        return new ClientboundCustomPayloadPacket(id_stcDimensionConfirm, buf);
    }

    public static Packet createStcSpawnEntity(Entity entity) {
        EntityType entityType = entity.m_6095_();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(EntityType.m_20613_((EntityType)entityType).toString());
        buf.writeInt(entity.m_19879_());
        DimId.writeWorldId((FriendlyByteBuf)buf, (ResourceKey)entity.m_9236_().m_46472_(), (boolean)entity.m_9236_().f_46443_);
        CompoundTag tag = new CompoundTag();
        entity.m_20240_(tag);
        buf.m_130079_(tag);
        return new ClientboundCustomPayloadPacket(id_stcSpawnEntity, buf);
    }

    public static Packet createGlobalPortalUpdate(GlobalPortalStorage storage) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        DimId.writeWorldId((FriendlyByteBuf)buf, (ResourceKey)((ServerLevel)storage.world.get()).m_46472_(), (boolean)false);
        buf.m_130079_(storage.m_7176_(new CompoundTag()));
        return new ClientboundCustomPayloadPacket(id_stcUpdateGlobalPortal, buf);
    }

    private static void processCtsTeleport(ServerPlayer player, FriendlyByteBuf buf) {
        ResourceKey dim = DimId.readWorldId((FriendlyByteBuf)buf, (boolean)false);
        Vec3 posBefore = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        UUID portalEntityId = buf.m_130259_();
        MiscHelper.executeOnServerThread(() -> IPGlobal.serverTeleportationManager.onPlayerTeleportedInClient(player, (ResourceKey<Level>)dim, posBefore, portalEntityId));
    }

    public static class RemoteCallables {
    }
}

