/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.position_sync;

import java.util.Set;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEPlayerMoveC2SPacket;
import qouteall.imm_ptl.core.ducks.IEPlayerPositionLookS2CPacket;
import qouteall.imm_ptl.core.ducks.IEServerPlayNetworkHandler;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.LimitedLogger;

@Mixin(value={ServerGamePacketListenerImpl.class}, priority=900)
public abstract class MixinServerGamePacketListenerImpl
implements IEServerPlayNetworkHandler {
    @Shadow
    public ServerPlayer f_9743_;
    @Shadow
    private Vec3 f_9766_;
    @Shadow
    private int f_9767_;
    @Shadow
    private int f_9735_;
    @Shadow
    private int f_9746_;
    @Shadow
    private double f_9763_;
    @Shadow
    private double f_9764_;
    @Shadow
    private double f_9765_;
    @Shadow
    private double f_9760_;
    @Shadow
    private double f_9761_;
    @Shadow
    private double f_9762_;
    @Shadow
    @Final
    public Connection f_9742_;
    @Shadow
    @Final
    private MinecraftServer f_9745_;
    @Shadow
    private Entity f_9759_;
    @Shadow
    private boolean f_9738_;
    @Shadow
    @Final
    private static Logger f_9744_;
    private static LimitedLogger ip_limitedLogger;
    private int ip_dubiousMoveCount = 0;

    @Shadow
    protected abstract boolean m_9956_();

    @Shadow
    public abstract void m_9942_(Component var1);

    @Inject(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/server/level/ServerLevel;)V")}, cancellable=true)
    private void onProcessMovePacket(ServerboundMovePlayerPacket packet, CallbackInfo ci) {
        ResourceKey<Level> packetDimension = ((IEPlayerMoveC2SPacket)packet).getPlayerDimension();
        if (packetDimension == null) {
            Helper.err((Object)"Player move packet is missing dimension info. Maybe the player client doesn't have ImmPtl");
            IPGlobal.serverTaskList.addTask(() -> {
                this.f_9743_.f_8906_.m_9942_((Component)Component.m_237113_((String)"The client does not have Immersive Portals mod"));
                return true;
            });
            return;
        }
        if (IPGlobal.serverTeleportationManager.isJustTeleported((Entity)this.f_9743_, 100L)) {
            this.cancelTeleportRequest();
        }
        if (this.f_9743_.m_9236_().m_46472_() != packetDimension) {
            ip_limitedLogger.lInfo(f_9744_, "[ImmPtl] Ignoring player move packet %s %s".formatted(this.f_9743_, packetDimension.m_135782_()), new Object[0]);
            ++this.ip_dubiousMoveCount;
            if (this.ip_dubiousMoveCount > 200) {
                f_9744_.info("[ImmPtl] Force move player {} {} {}", new Object[]{this.f_9743_, this.f_9743_.m_9236_().m_46472_().m_135782_(), this.f_9743_.m_20182_()});
                IPGlobal.serverTeleportationManager.forceTeleportPlayer(this.f_9743_, (ResourceKey<Level>)this.f_9743_.m_9236_().m_46472_(), this.f_9743_.m_20182_());
                this.ip_dubiousMoveCount = 0;
            }
            ci.cancel();
        } else {
            this.ip_dubiousMoveCount = 0;
        }
    }

    @Redirect(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;isSingleplayerOwner()Z"))
    private boolean redirectIsServerOwnerOnPlayerMove(ServerGamePacketListenerImpl serverPlayNetworkHandler) {
        if (MixinServerGamePacketListenerImpl.shouldAcceptDubiousMovement(this.f_9743_)) {
            return true;
        }
        return this.m_9956_();
    }

    @Redirect(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isChangingDimension()Z"), require=0)
    private boolean redirectIsInTeleportationState(ServerPlayer player) {
        if (MixinServerGamePacketListenerImpl.shouldAcceptDubiousMovement(player)) {
            return true;
        }
        return player.m_8958_();
    }

    @Overwrite
    @IPVanillaCopy
    public void m_9780_(double x, double y, double z, float yaw, float pitch, Set<RelativeMovement> nonRelative) {
        if (this.f_9743_.m_146911_() != null) {
            Helper.err((Object)"Tries to send player pos packet to a removed player");
            new Throwable().printStackTrace();
            return;
        }
        double xDiff = nonRelative.contains(RelativeMovement.X) ? this.f_9743_.m_20185_() : 0.0;
        double yDiff = nonRelative.contains(RelativeMovement.Y) ? this.f_9743_.m_20186_() : 0.0;
        double zDiff = nonRelative.contains(RelativeMovement.Z) ? this.f_9743_.m_20189_() : 0.0;
        float yawDiff = nonRelative.contains(RelativeMovement.Y_ROT) ? this.f_9743_.m_146908_() : 0.0f;
        float pitchDiff = nonRelative.contains(RelativeMovement.X_ROT) ? this.f_9743_.m_146909_() : 0.0f;
        this.f_9766_ = new Vec3(x, y, z);
        if (++this.f_9767_ == Integer.MAX_VALUE) {
            this.f_9767_ = 0;
        }
        this.f_9735_ = this.f_9746_;
        this.f_9743_.m_19890_(x, y, z, yaw, pitch);
        ClientboundPlayerPositionPacket lookPacket = new ClientboundPlayerPositionPacket(x - xDiff, y - yDiff, z - zDiff, yaw - yawDiff, pitch - pitchDiff, nonRelative, this.f_9767_);
        ((IEPlayerPositionLookS2CPacket)lookPacket).setPlayerDimension((ResourceKey<Level>)this.f_9743_.m_9236_().m_46472_());
        this.f_9743_.f_8906_.m_9829_((Packet)lookPacket);
    }

    @Inject(method={"isPlayerCollidingWithAnythingNew"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsPlayerCollidingWithAnythingNew(LevelReader levelReader, AABB aABB, double d, double e, double f, CallbackInfoReturnable<Boolean> cir) {
        if (MixinServerGamePacketListenerImpl.shouldAcceptDubiousMovement(this.f_9743_)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleAcceptTeleportPacket(Lnet/minecraft/network/protocol/game/ServerboundAcceptTeleportationPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onOnTeleportConfirm(ServerboundAcceptTeleportationPacket packet, CallbackInfo ci) {
        if (this.f_9766_ == null) {
            ci.cancel();
        }
    }

    private static boolean shouldAcceptDubiousMovement(ServerPlayer player) {
        if (IPGlobal.serverTeleportationManager.isJustTeleported((Entity)player, 100L)) {
            return true;
        }
        if (IPGlobal.looseMovementCheck) {
            return true;
        }
        if (((IEEntity)player).ip_isRecentlyCollidingWithPortal()) {
            return true;
        }
        boolean portalsNearby = IPMcHelper.getNearbyPortals((Entity)player, 16.0).findFirst().isPresent();
        return portalsNearby;
    }

    @Override
    public void cancelTeleportRequest() {
        this.f_9766_ = null;
    }

    static {
        ip_limitedLogger = new LimitedLogger(20);
    }
}

