/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.other_sync;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.chunk_loading.NewChunkTrackingGraph;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;

@Mixin(value={PlayerList.class}, priority=800)
public class MixinPlayerList {
    @Shadow
    @Final
    private List<ServerPlayer> f_11196_;
    @Shadow
    @Final
    private MinecraftServer f_11195_;

    @Inject(method={"Lnet/minecraft/server/players/PlayerList;sendLevelInfo(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="RETURN")})
    private void onSendWorldInfo(ServerPlayer player, ServerLevel world, CallbackInfo ci) {
        if (!IPGlobal.serverTeleportationManager.isFiringMyChangeDimensionEvent) {
            GlobalPortalStorage.onPlayerLoggedIn(player);
        }
    }

    @Inject(method={"Lnet/minecraft/server/players/PlayerList;placeNewPlayer(Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="TAIL")})
    private void onOnPlayerConnect(Connection connection, ServerPlayer player, CallbackInfo ci) {
        NewChunkTrackingGraph.updateForPlayer(player);
    }

    @Inject(method={"Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/resources/ResourceKey;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void sendToDimension(Packet<?> packet, ResourceKey<Level> dimension, CallbackInfo ci) {
        for (ServerPlayer player : this.f_11196_) {
            if (player.m_9236_().m_46472_() != dimension) continue;
            PacketRedirection.sendRedirectedMessage(player, dimension, packet);
        }
        ci.cancel();
    }

    @Redirect(method={"respawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"))
    private void onRestoreFrom(ServerPlayer newPlayer, ServerPlayer that, boolean keepEverything) {
        newPlayer.m_9015_(that, keepEverything);
        newPlayer.f_8906_.f_9743_ = newPlayer;
    }

    @Overwrite
    public void m_11241_(@Nullable Player excludingPlayer, double x, double y, double z, double distance, ResourceKey<Level> dimension, Packet<?> packet) {
        ChunkPos chunkPos = new ChunkPos(BlockPos.m_274446_((Position)new Vec3(x, y, z)));
        Object2ObjectOpenHashMap<ServerPlayer, NewChunkTrackingGraph.PlayerWatchRecord> recs = NewChunkTrackingGraph.getPlayerWatchListRecord(dimension, chunkPos.f_45578_, chunkPos.f_45579_);
        if (recs == null) {
            return;
        }
        for (NewChunkTrackingGraph.PlayerWatchRecord rec : recs.values()) {
            if (!rec.isLoadedToPlayer || rec.player == excludingPlayer || !NewChunkTrackingGraph.isPlayerWatchingChunkWithinRadius(rec.player, dimension, chunkPos.f_45578_, chunkPos.f_45579_, (int)distance + 16)) continue;
            rec.player.f_8906_.m_9829_(PacketRedirection.createRedirectedMessage(dimension, packet));
        }
    }
}

