/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.networking;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.ducks.IECustomPayloadPacket;
import qouteall.imm_ptl.core.network.IPNetworking;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.q_misc_util.dimension.DimId;

@Mixin(value={ClientboundCustomPayloadPacket.class})
public class MixinClientboundCustomPayloadPacket
implements IECustomPayloadPacket {
    @Shadow
    @Final
    private ResourceLocation f_132029_;
    @Shadow
    @Final
    private FriendlyByteBuf f_132030_;
    private ResourceKey<Level> ip_redirectedDimension;
    private Packet<ClientGamePacketListener> ip_redirectedPacket;

    @ModifyConstant(method={"<init>(Lnet/minecraft/network/FriendlyByteBuf;)V"}, constant={@Constant(intValue=0x100000)}, require=0)
    private int modifySizeLimitWhenReadingPacket(int oldValue) {
        return 233333333;
    }

    @Inject(method={"<init>(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="RETURN")})
    private void readTheActualRedirectedPacket(FriendlyByteBuf _buf, CallbackInfo ci) {
        if (PacketRedirection.isPacketIdOfRedirection(this.f_132029_)) {
            FriendlyByteBuf buf = this.f_132030_;
            ResourceKey dimension = DimId.readWorldId((FriendlyByteBuf)buf, (boolean)true);
            int packetId = buf.readInt();
            Packet packet = PacketRedirection.createPacketById(packetId, buf);
            if (packet == null) {
                throw new RuntimeException("Unknown packet id %d in %s".formatted(packetId, dimension.m_135782_()));
            }
            this.ip_redirectedDimension = dimension;
            this.ip_redirectedPacket = packet;
        }
    }

    @Inject(method={"write"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/FriendlyByteBuf;writeBytes(Lio/netty/buffer/ByteBuf;)Lio/netty/buffer/ByteBuf;")}, cancellable=true)
    private void writeTheActualRedirectedPacket(FriendlyByteBuf buffer, CallbackInfo ci) {
        if (PacketRedirection.isPacketIdOfRedirection(this.f_132029_)) {
            Validate.isTrue((this.ip_redirectedDimension != null ? 1 : 0) != 0, (String)"ip_redirectedDimension is null", (Object[])new Object[0]);
            Validate.isTrue((this.ip_redirectedPacket != null ? 1 : 0) != 0, (String)"ip_redirectedPacket is null", (Object[])new Object[0]);
            DimId.writeWorldId((FriendlyByteBuf)buffer, this.ip_redirectedDimension, (boolean)false);
            int packetId = PacketRedirection.getPacketId(this.ip_redirectedPacket);
            buffer.writeInt(packetId);
            this.ip_redirectedPacket.m_5779_(buffer);
            ci.cancel();
        }
    }

    @Inject(method={"handle(Lnet/minecraft/network/protocol/game/ClientGamePacketListener;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandle(ClientGamePacketListener handler, CallbackInfo ci) {
        if (PacketRedirection.isPacketIdOfRedirection(this.f_132029_)) {
            PacketRedirection.do_handleRedirectedPacket(this.ip_redirectedDimension, this.ip_redirectedPacket, handler);
            ci.cancel();
        } else {
            boolean handled = IPNetworking.handleImmPtlCorePacketClientSide(this.f_132029_, () -> new FriendlyByteBuf(this.f_132030_.slice()));
            if (handled) {
                ci.cancel();
            }
        }
    }

    @Override
    public void ip_setRedirectedDimension(ResourceKey<Level> dimension) {
        this.ip_redirectedDimension = dimension;
    }

    @Override
    public void ip_setRedirectedPacket(Packet<ClientGamePacketListener> packet) {
        Validate.isTrue((!(packet instanceof BundlePacket) ? 1 : 0) != 0);
        this.ip_redirectedPacket = packet;
    }

    @Override
    public ResourceKey<Level> ip_getRedirectedDimension() {
        return this.ip_redirectedDimension;
    }

    @Override
    public Packet<ClientGamePacketListener> ip_getRedirectedPacket() {
        return this.ip_redirectedPacket;
    }
}

