/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.entity_sync;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEEntityTrackerEntry;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.imm_ptl.core.portal.Portal;

@Mixin(value={ServerEntity.class}, priority=1200)
public abstract class MixinServerEntity
implements IEEntityTrackerEntry {
    @Shadow
    @Final
    private Entity f_8510_;
    @Shadow
    @Final
    private VecDeltaCodec f_214995_;
    @Shadow
    @Final
    private static Logger f_8508_;

    @Inject(method={"Lnet/minecraft/server/level/ServerEntity;sendChanges()V"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        PacketRedirection.validateForceRedirecting();
    }

    @Redirect(method={"removePairing"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private void onSendRemoveEntityPacket(ServerGamePacketListenerImpl networkHandler, Packet packet) {
        if (IPGlobal.entityUnloadDebug) {
            f_8508_.info("[Debug] Entity remove packet sent {}", (Object)this.f_8510_);
        }
        PacketRedirection.sendRedirectedPacket(networkHandler, (Packet<ClientGamePacketListener>)packet, (ResourceKey<Level>)this.f_8510_.m_9236_().m_46472_());
    }

    @Redirect(method={"addPairing"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private void onSendAddEntityPacket(ServerGamePacketListenerImpl networkHandler, Packet packet) {
        PacketRedirection.sendRedirectedPacket(networkHandler, (Packet<ClientGamePacketListener>)packet, (ResourceKey<Level>)this.f_8510_.m_9236_().m_46472_());
    }

    @Redirect(method={"Lnet/minecraft/server/level/ServerEntity;broadcastAndSend(Lnet/minecraft/network/protocol/Packet;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private void onSendToWatcherAndSelf(ServerGamePacketListenerImpl serverPlayNetworkHandler, Packet packet) {
        PacketRedirection.sendRedirectedPacket(serverPlayNetworkHandler, (Packet<ClientGamePacketListener>)packet, (ResourceKey<Level>)this.f_8510_.m_9236_().m_46472_());
    }

    @Inject(method={"sendChanges"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSendChanges(CallbackInfo ci) {
        if (this.f_8510_ instanceof Portal) {
            ci.cancel();
        }
    }

    @Override
    public void ip_updateTrackedEntityPosition() {
        this.f_214995_.m_238033_(this.f_8510_.m_213870_());
    }
}

