/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.sync;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ClientRegistryLayer;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.telemetry.WorldSessionTelemetryManager;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEClientPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEPlayerPositionLookS2CPacket;
import qouteall.imm_ptl.core.network.IPNetworkAdapt;
import qouteall.imm_ptl.core.teleportation.ClientTeleportationManager;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.dimension.DimensionTypeSync;
import qouteall.q_misc_util.my_util.LimitedLogger;

@Mixin(value={ClientPacketListener.class})
public abstract class MixinClientPacketListener
implements IEClientPlayNetworkHandler {
    private static final LimitedLogger immptl_limitedLogger = new LimitedLogger(20);
    @Shadow
    private ClientLevel f_104889_;
    @Shadow
    @Final
    private Minecraft f_104888_;
    @Mutable
    @Shadow
    @Final
    private Map<UUID, PlayerInfo> f_104892_;
    @Shadow
    private LayeredRegistryAccess<ClientRegistryLayer> f_104903_;
    @Shadow
    @Final
    private static Logger f_104883_;
    private boolean isReProcessingPassengerPacket;

    @Shadow
    public abstract void m_6403_(ClientboundSetPassengersPacket var1);

    @Shadow
    protected abstract void m_194248_(int var1, int var2, ClientboundLightUpdatePacketData var3);

    @Shadow
    public abstract RegistryAccess m_105152_();

    @Override
    public void ip_setWorld(ClientLevel world) {
        this.f_104889_ = world;
    }

    @Override
    public Map getPlayerListEntries() {
        return this.f_104892_;
    }

    @Override
    public void setPlayerListEntries(Map value) {
        this.f_104892_ = value;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(Minecraft minecraft, Screen screen, Connection connection, ServerData serverData, GameProfile gameProfile, WorldSessionTelemetryManager worldSessionTelemetryManager, CallbackInfo ci) {
        this.isReProcessingPassengerPacket = false;
    }

    @Inject(method={"Lnet/minecraft/client/multiplayer/ClientPacketListener;handleLogin(Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;)V"}, at={@At(value="RETURN")})
    private void onOnGameJoin(ClientboundLoginPacket packet, CallbackInfo ci) {
        ClientWorldLoader.isFlatWorld = packet.f_132374_();
        DimensionTypeSync.onGameJoinPacketReceived((RegistryAccess)packet.f_132366_());
    }

    @Inject(method={"Lnet/minecraft/client/multiplayer/ClientPacketListener;handleMovePlayer(Lnet/minecraft/network/protocol/game/ClientboundPlayerPositionPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)})
    private void onProcessingPositionPacket(ClientboundPlayerPositionPacket packet, CallbackInfo ci) {
        if (!IPNetworkAdapt.doesServerHasIP()) {
            return;
        }
        ResourceKey<Level> packetDim = ((IEPlayerPositionLookS2CPacket)packet).getPlayerDimension();
        LocalPlayer player = this.f_104888_.f_91074_;
        assert (player != null);
        Level playerWorld = player.m_9236_();
        if (packetDim != playerWorld.m_46472_()) {
            f_104883_.info("[ImmPtl] Client accepted position packet in another dimension. Packet: {} {} {} {}. Player: {} {} {} {}", new Object[]{packetDim.m_135782_(), packet.m_132818_(), packet.m_132821_(), packet.m_132822_(), playerWorld.m_46472_().m_135782_(), player.m_20185_(), player.m_20186_(), player.m_20189_()});
            ClientTeleportationManager.forceTeleportPlayer(packetDim, new Vec3(packet.m_132818_(), packet.m_132821_(), packet.m_132822_()));
        }
        f_104883_.info("[ImmPtl] Client accepted position packet {} {} {} {}", new Object[]{packetDim.m_135782_(), packet.m_132818_(), packet.m_132821_(), packet.m_132822_()});
    }

    @Inject(method={"Lnet/minecraft/client/multiplayer/ClientPacketListener;handleSetEntityPassengersPacket(Lnet/minecraft/network/protocol/game/ClientboundSetPassengersPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void onOnEntityPassengersSet(ClientboundSetPassengersPacket entityPassengersSetS2CPacket_1, CallbackInfo ci) {
        Entity entity_1 = this.f_104889_.m_6815_(entityPassengersSetS2CPacket_1.m_133286_());
        if (entity_1 == null && !this.isReProcessingPassengerPacket) {
            Helper.log((Object)"Re-processed riding packet");
            IPGlobal.clientTaskList.addTask(() -> {
                this.isReProcessingPassengerPacket = true;
                this.m_6403_(entityPassengersSetS2CPacket_1);
                this.isReProcessingPassengerPacket = false;
                return true;
            });
            ci.cancel();
        }
    }

    @Redirect(method={"Lnet/minecraft/client/multiplayer/ClientPacketListener;handleSetEntityData(Lnet/minecraft/network/protocol/game/ClientboundSetEntityDataPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getEntity(I)Lnet/minecraft/world/entity/Entity;"))
    private Entity redirectGetEntityById(ClientLevel clientWorld, int id) {
        Entity entity = clientWorld.m_6815_(id);
        if (entity == null) {
            immptl_limitedLogger.err("missing entity for data tracking " + clientWorld + " " + id);
        }
        return entity;
    }

    @Inject(method={"handleSetTime"}, at={@At(value="RETURN")})
    private void onSetTime(ClientboundSetTimePacket packet, CallbackInfo ci) {
        if (ClientWorldLoader.getIsInitialized()) {
            ClientLevel currentWorld = this.f_104888_.f_91073_;
            for (ClientLevel clientWorld : ClientWorldLoader.getClientWorlds()) {
                if (clientWorld == currentWorld) continue;
                clientWorld.m_104637_(packet.m_133358_());
            }
        }
    }

    @Redirect(method={"handleBlockChangedAck"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;handleBlockChangedAck(I)V"))
    private void redirectHandleBlockChangedAck(ClientLevel instance, int seqNumber) {
        for (ClientLevel clientWorld : ClientWorldLoader.getClientWorlds()) {
            clientWorld.m_233651_(seqNumber);
        }
    }

    @Inject(method={"handleAddEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void onHandleAddEntity(ClientboundAddEntityPacket packet, CallbackInfo ci) {
        int entityId = packet.m_131496_();
        Entity existingEntity = this.f_104889_.m_6815_(entityId);
        if (existingEntity != null && !existingEntity.m_20197_().isEmpty()) {
            f_104883_.warn("[ImmPtl] Entity already exists and has passengers when accepting add-entity packet. Ignoring. {} {}", (Object)existingEntity, (Object)packet);
            ci.cancel();
        }
    }

    @Inject(method={"handleLevelChunkWithLight"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)})
    private void onHandleLevelChunkWithLight(ClientboundLevelChunkWithLightPacket packet, CallbackInfo ci) {
        if (IPGlobal.chunkPacketDebug) {
            f_104883_.info("Chunk Load Packet {} {} {}", new Object[]{this.f_104889_.m_46472_().m_135782_(), packet.m_195717_(), packet.m_195718_()});
        }
    }

    @Inject(method={"handleForgetLevelChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)})
    private void onHandleForgetLevelChunk(ClientboundForgetLevelChunkPacket packet, CallbackInfo ci) {
        if (IPGlobal.chunkPacketDebug) {
            f_104883_.info("Chunk Unload Packet {} {} {}", new Object[]{this.f_104889_.m_46472_().m_135782_(), packet.m_132149_(), packet.m_132152_()});
        }
    }
}

