/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.render.optimization;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.render.context_management.CloudContext;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

@Mixin(value={LevelRenderer.class})
public abstract class MixinLevelRenderer_Clouds {
    @Shadow
    private int f_109430_;
    @Shadow
    private int f_109431_;
    @Shadow
    private int f_109432_;
    @Shadow
    @Nullable
    private VertexBuffer f_109475_;
    @Shadow
    private ClientLevel f_109465_;
    @Shadow
    private boolean f_109474_;
    @Shadow
    private int f_109477_;

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")})
    private void onBeginRenderClouds(PoseStack matrices, Matrix4f matrix4f, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        if (RenderStates.getRenderedPortalNum() == 0) {
            return;
        }
        if (IPGlobal.cloudOptimization) {
            this.portal_onBeginCloudRendering(tickDelta, cameraX, cameraY, cameraZ);
        }
    }

    @Inject(method={"renderClouds"}, at={@At(value="RETURN")})
    private void onEndRenderClouds(PoseStack matrices, Matrix4f matrix4f, float f, double d, double e, double g, CallbackInfo ci) {
        if (RenderStates.getRenderedPortalNum() == 0) {
            return;
        }
        if (IPGlobal.cloudOptimization) {
            this.portal_onEndCloudRendering();
        }
    }

    private void portal_yieldCloudContext(CloudContext context) {
        Vec3 cloudsColor = this.f_109465_.m_104808_(RenderStates.getPartialTick());
        context.lastCloudsBlockX = this.f_109430_;
        context.lastCloudsBlockY = this.f_109431_;
        context.lastCloudsBlockZ = this.f_109432_;
        context.cloudsBuffer = this.f_109475_;
        context.dimension = this.f_109465_.m_46472_();
        context.cloudColor = cloudsColor;
        this.f_109475_ = null;
        this.f_109474_ = true;
    }

    private void portal_loadCloudContext(CloudContext context) {
        Validate.isTrue((context.dimension == this.f_109465_.m_46472_() ? 1 : 0) != 0);
        this.f_109430_ = context.lastCloudsBlockX;
        this.f_109431_ = context.lastCloudsBlockY;
        this.f_109432_ = context.lastCloudsBlockZ;
        this.f_109475_ = context.cloudsBuffer;
        this.f_109474_ = false;
    }

    private void portal_onBeginCloudRendering(float tickDelta, double cameraX, double cameraY, double cameraZ) {
        int kz;
        int ky;
        float f = this.f_109465_.m_104583_().m_108871_();
        float g = 12.0f;
        float h = 4.0f;
        double d = 2.0E-4;
        double e = ((float)this.f_109477_ + tickDelta) * 0.03f;
        double i = (cameraX + e) / 12.0;
        double j = f - (float)cameraY + 0.33f;
        double k = cameraZ / 12.0 + (double)0.33f;
        i -= (double)(Mth.m_14107_((double)(i / 2048.0)) * 2048);
        k -= (double)(Mth.m_14107_((double)(k / 2048.0)) * 2048);
        float l = (float)(i - (double)Mth.m_14107_((double)i));
        float m = (float)(j / 4.0 - (double)Mth.m_14107_((double)(j / 4.0))) * 4.0f;
        float n = (float)(k - (double)Mth.m_14107_((double)k));
        Vec3 cloudsColor = this.f_109465_.m_104808_(tickDelta);
        int kx = (int)Math.floor(i);
        @Nullable CloudContext context = CloudContext.findAndTakeContext(kx, ky = (int)Math.floor(j / 4.0), kz = (int)Math.floor(k), (ResourceKey<Level>)this.f_109465_.m_46472_(), cloudsColor);
        if (context != null) {
            this.portal_loadCloudContext(context);
        }
    }

    private void portal_onEndCloudRendering() {
        if (!this.f_109474_) {
            CloudContext newContext = new CloudContext();
            this.portal_yieldCloudContext(newContext);
            CloudContext.appendContext(newContext);
        }
    }
}

