/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.interaction;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer;
import qouteall.imm_ptl.core.ducks.IEClientPlayerInteractionManager;
import qouteall.q_misc_util.api.McRemoteProcedureCall;

@Mixin(value={MultiPlayerGameMode.class})
public abstract class MixinMultiPlayerGameMode
implements IEClientPlayerInteractionManager {
    @Shadow
    @Final
    private ClientPacketListener f_105190_;
    @Shadow
    @Final
    private Minecraft f_105189_;

    @Redirect(method={"lambda$startDestroyBlock$1(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraftforge/event/entity/player/PlayerInteractEvent$LeftClickBlock;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;I)Lnet/minecraft/network/protocol/Packet;"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;level()Lnet/minecraft/world/level/Level;"))
    private Level redirectPlayerLevel1(LocalPlayer instance) {
        return Minecraft.m_91087_().f_91073_;
    }

    @Redirect(method={"continueDestroyBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;level()Lnet/minecraft/world/level/Level;"))
    private Level redirectPlayerLevel2(LocalPlayer instance) {
        return Minecraft.m_91087_().f_91073_;
    }

    @Redirect(method={"performUseItemOn"}, at=@At(value="NEW", target="(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/item/context/UseOnContext;"))
    private UseOnContext redirectNewUseOnContext(Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return new UseOnContext((Level)Minecraft.m_91087_().f_91073_, player, interactionHand, player.m_21120_(interactionHand), blockHitResult);
    }

    @ModifyArg(method={"startPrediction"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private Packet<?> modifyPacketInStartPrediction(Packet<?> packet) {
        return MixinMultiPlayerGameMode.ip_redirectPacket(packet);
    }

    @ModifyArg(method={"startDestroyBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private Packet redirectSendInStartDestroyBlock(Packet packet) {
        return MixinMultiPlayerGameMode.ip_redirectPacket(packet);
    }

    @ModifyArg(method={"stopDestroyBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private Packet redirectSendInStopDestroyBlock(Packet packet) {
        return MixinMultiPlayerGameMode.ip_redirectPacket(packet);
    }

    private static Packet<?> ip_redirectPacket(Packet<?> packet) {
        if (ClientWorldLoader.getIsWorldSwitched()) {
            ResourceKey dimension = Minecraft.m_91087_().f_91073_.m_46472_();
            if (packet instanceof ServerboundPlayerActionPacket) {
                ServerboundPlayerActionPacket playerActionPacket = (ServerboundPlayerActionPacket)packet;
                if (BlockManipulationServer.isAttackingAction(playerActionPacket.m_134285_())) {
                    return McRemoteProcedureCall.createPacketToSendToServer((String)"qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer.RemoteCallables.processPlayerActionPacket", (Object[])new Object[]{dimension, IPMcHelper.packetToBytes(playerActionPacket)});
                }
            } else if (packet instanceof ServerboundUseItemOnPacket) {
                ServerboundUseItemOnPacket useItemOnPacket = (ServerboundUseItemOnPacket)packet;
                return McRemoteProcedureCall.createPacketToSendToServer((String)"qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer.RemoteCallables.processUseItemOnPacket", (Object[])new Object[]{dimension, IPMcHelper.packetToBytes(useItemOnPacket)});
            }
        }
        return packet;
    }
}

