/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mc_utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import java.util.function.IntSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Sphere;

@Environment(value=EnvType.CLIENT)
public class WireRenderingHelper {
    public static void renderSmallCubeFrame(VertexConsumer vertexConsumer, Vec3 cameraPos, Vec3 boxCenter, int color, double scale, PoseStack matrixStack) {
        Random random = new Random(color);
        double boxSize = Math.pow(boxCenter.m_82554_(cameraPos), 0.3) * 0.09;
        matrixStack.m_85836_();
        matrixStack.m_85837_(boxCenter.f_82479_ - cameraPos.f_82479_, boxCenter.f_82480_ - cameraPos.f_82480_, boxCenter.f_82481_ - cameraPos.f_82481_);
        matrixStack.m_85841_((float)scale, (float)scale, (float)scale);
        DQuaternion rotation = WireRenderingHelper.getRandomSmoothRotation(random);
        double periodLen = 100.0;
        matrixStack.m_252781_(rotation.toMcQuaternion());
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        LevelRenderer.m_109608_((PoseStack)matrixStack, (VertexConsumer)vertexConsumer, (double)(-boxSize / 2.0), (double)(-boxSize / 2.0), (double)(-boxSize / 2.0), (double)(boxSize / 2.0), (double)(boxSize / 2.0), (double)(boxSize / 2.0), (float)red, (float)green, (float)blue, (float)alpha);
        matrixStack.m_85849_();
    }

    public static DQuaternion getRandomSmoothRotation(Random random) {
        double time = (double)StableClientTimer.getStableTickTime() + (double)StableClientTimer.getStablePartialTicks();
        DQuaternion rotation = DQuaternion.identity;
        for (int i = 0; i < 6; ++i) {
            rotation = rotation.hamiltonProduct(DQuaternion.rotationByDegrees((Vec3)WireRenderingHelper.randomVec(random), (double)(CHelper.getSmoothCycles(random.nextInt(30, 60)) * 360.0)));
        }
        return rotation;
    }

    public static double getRandomSmoothCycle(Random random) {
        double totalFactor = 0.1;
        double total = 0.0;
        for (int i = 0; i < 5; ++i) {
            double smoothCycle = CHelper.getSmoothCycles(random.nextInt(30, 300));
            double sin = Math.sin(Math.PI * 2 * smoothCycle);
            double factor = random.nextDouble(0.1, 1.0);
            totalFactor += factor;
            total += sin * factor;
        }
        return total / totalFactor;
    }

    @NotNull
    public static Vec3 randomVec(Random random) {
        return new Vec3(random.nextDouble() - 0.5, random.nextDouble() - 0.5, random.nextDouble() - 0.5);
    }

    public static void renderPlane(VertexConsumer vertexConsumer, Vec3 cameraPos, Plane plane, double renderedPlaneScale, int color, PoseStack matrixStack) {
        Vec3 lineEnd;
        Vec3 lineStart;
        Vec3 anyVecNonNormal;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Vec3 planeCenter = plane.pos();
        Vec3 normal = plane.normal();
        if (Math.abs(normal.m_82526_(anyVecNonNormal = new Vec3(13.0, 29.0, 71.0).m_82541_())) > 0.99) {
            anyVecNonNormal = new Vec3(1.0, 0.0, 0.0);
        }
        Vec3 planeX = normal.m_82537_(anyVecNonNormal).m_82541_();
        Vec3 planeY = normal.m_82537_(planeX).m_82541_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(planeCenter.f_82479_ - cameraPos.f_82479_, planeCenter.f_82480_ - cameraPos.f_82480_, planeCenter.f_82481_ - cameraPos.f_82481_);
        matrixStack.m_252781_(DQuaternion.rotationByDegrees((Vec3)normal, (double)(CHelper.getSmoothCycles(211L) * 360.0)).toMcQuaternion());
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        double cameraDistanceToCenter = player.m_20299_(RenderStates.getPartialTick()).m_82554_(planeCenter);
        int lineNumPerSide = 10;
        double lineInterval = cameraDistanceToCenter * 0.2 * renderedPlaneScale;
        double lineLenPerSide = (double)lineNumPerSide * lineInterval;
        for (int ix = -lineNumPerSide; ix <= lineNumPerSide; ++ix) {
            lineStart = planeX.m_82490_((double)ix * lineInterval).m_82549_(planeY.m_82490_(-lineLenPerSide));
            lineEnd = planeX.m_82490_((double)ix * lineInterval).m_82549_(planeY.m_82490_(lineLenPerSide));
            WireRenderingHelper.putLineToLineStrip(vertexConsumer, color, planeY, matrix, lineStart, lineEnd);
        }
        for (int iy = -lineNumPerSide; iy <= lineNumPerSide; ++iy) {
            lineStart = planeY.m_82490_((double)iy * lineInterval).m_82549_(planeX.m_82490_(-lineLenPerSide));
            lineEnd = planeY.m_82490_((double)iy * lineInterval).m_82549_(planeX.m_82490_(lineLenPerSide));
            WireRenderingHelper.putLineToLineStrip(vertexConsumer, color, planeX, matrix, lineStart, lineEnd);
        }
        matrixStack.m_85849_();
    }

    public static void renderCircle(VertexConsumer vertexConsumer, Vec3 cameraPos, Circle circle, int color, PoseStack matrixStack) {
        Vec3 anyVecNonNormal;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Vec3 planeCenter = circle.plane().pos();
        Vec3 normal = circle.plane().normal();
        if (Math.abs(normal.m_82526_(anyVecNonNormal = new Vec3(0.0, 1.0, 0.0))) > 0.9) {
            anyVecNonNormal = new Vec3(1.0, 0.0, 0.0);
        }
        Vec3 planeX = normal.m_82537_(anyVecNonNormal).m_82541_();
        Vec3 planeY = normal.m_82537_(planeX).m_82541_();
        Vec3 circleCenter = circle.circleCenter();
        double circleRadius = circle.radius();
        matrixStack.m_85836_();
        matrixStack.m_85837_(circleCenter.f_82479_ - cameraPos.f_82479_, circleCenter.f_82480_ - cameraPos.f_82480_, circleCenter.f_82481_ - cameraPos.f_82481_);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        int vertexNum = Mth.m_14045_((int)((int)Math.round(circleRadius * 40.0)), (int)20, (int)400);
        for (int i = 0; i < vertexNum; ++i) {
            double angle = (double)(i * 2) * Math.PI / (double)vertexNum;
            double nextAngle = (double)((i + 1) * 2) * Math.PI / (double)vertexNum;
            boolean isBegin = i == 0;
            boolean isEnd = i == vertexNum - 1;
            Vec3 lineStart = planeX.m_82490_(Math.cos(angle) * circleRadius).m_82549_(planeY.m_82490_(Math.sin(angle) * circleRadius));
            Vec3 lineEnd = planeX.m_82490_(Math.cos(nextAngle) * circleRadius).m_82549_(planeY.m_82490_(Math.sin(nextAngle) * circleRadius));
            if (isBegin) {
                vertexConsumer.m_252986_(matrix, (float)lineStart.f_82479_, (float)lineStart.f_82480_, (float)lineStart.f_82481_).m_193479_(0).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
                vertexConsumer.m_252986_(matrix, (float)lineStart.f_82479_, (float)lineStart.f_82480_, (float)lineStart.f_82481_).m_193479_(color).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
            }
            vertexConsumer.m_252986_(matrix, (float)lineEnd.f_82479_, (float)lineEnd.f_82480_, (float)lineEnd.f_82481_).m_193479_(color).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
            if (!isEnd) continue;
            vertexConsumer.m_252986_(matrix, (float)lineEnd.f_82479_, (float)lineEnd.f_82480_, (float)lineEnd.f_82481_).m_193479_(0).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        }
        matrixStack.m_85849_();
    }

    public static void renderLockShape(VertexConsumer vertexConsumer, Vec3 cameraPos, Vec3 center, double scale, int color, PoseStack matrixStack) {
        double w = 380.0;
        double h = 270.0;
        double ringWidth = 60.0;
        double ringAreaWidth = 152.0;
        double rightAreaHeight = 136.0;
        Vec3[] lineVertices = new Vec3[]{new Vec3(w / 2.0, h / 2.0, 0.0), new Vec3(-w / 2.0, h / 2.0, 0.0), new Vec3(-w / 2.0, h / 2.0, 0.0), new Vec3(-w / 2.0, -h / 2.0, 0.0), new Vec3(-w / 2.0, -h / 2.0, 0.0), new Vec3(w / 2.0, -h / 2.0, 0.0), new Vec3(w / 2.0, -h / 2.0, 0.0), new Vec3(w / 2.0, h / 2.0, 0.0), new Vec3(ringAreaWidth / 2.0, h / 2.0, 0.0), new Vec3(ringAreaWidth / 2.0, h / 2.0 + rightAreaHeight, 0.0), new Vec3(ringAreaWidth / 2.0, h / 2.0 + rightAreaHeight, 0.0), new Vec3(-ringAreaWidth / 2.0, h / 2.0 + rightAreaHeight, 0.0), new Vec3(-ringAreaWidth / 2.0, h / 2.0 + rightAreaHeight, 0.0), new Vec3(-ringAreaWidth / 2.0, h / 2.0, 0.0), new Vec3(ringAreaWidth / 2.0 + ringWidth, h / 2.0, 0.0), new Vec3(ringAreaWidth / 2.0 + ringWidth, h / 2.0 + rightAreaHeight + ringWidth, 0.0), new Vec3(ringAreaWidth / 2.0 + ringWidth, h / 2.0 + rightAreaHeight + ringWidth, 0.0), new Vec3(-ringAreaWidth / 2.0 - ringWidth, h / 2.0 + rightAreaHeight + ringWidth, 0.0), new Vec3(-ringAreaWidth / 2.0 - ringWidth, h / 2.0 + rightAreaHeight + ringWidth, 0.0), new Vec3(-ringAreaWidth / 2.0 - ringWidth, h / 2.0, 0.0)};
        float renderScale = (float)(scale * 0.001);
        DQuaternion rotation = DQuaternion.rotationByDegrees((Vec3)new Vec3(0.0, 1.0, 0.0), (double)(CHelper.getSmoothCycles(60L) * 360.0));
        WireRenderingHelper.renderLines(vertexConsumer, cameraPos, center, lineVertices, renderScale, rotation, color, matrixStack);
    }

    public static void renderLines(VertexConsumer vertexConsumer, Vec3 cameraPos, Vec3 center, Vec3[] lineVertices, double scale, DQuaternion rotation, int color, PoseStack matrixStack) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(center.f_82479_ - cameraPos.f_82479_, center.f_82480_ - cameraPos.f_82480_, center.f_82481_ - cameraPos.f_82481_);
        matrixStack.m_252781_(rotation.toMcQuaternion());
        matrixStack.m_85841_((float)scale, (float)scale, (float)scale);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = matrixStack.m_85850_().m_252943_();
        for (int i = 0; i < lineVertices.length / 2; ++i) {
            WireRenderingHelper.putLine(vertexConsumer, color, matrix, normalMatrix, lineVertices[i * 2], lineVertices[i * 2 + 1]);
        }
        matrixStack.m_85849_();
    }

    public static void putLine(VertexConsumer vertexConsumer, int color, Matrix4f matrix, Matrix3f normalMatrix, Vec3 lineStart, Vec3 lineEnd) {
        WireRenderingHelper.putLine(vertexConsumer, color, lineEnd.m_82546_(lineStart), matrix, normalMatrix, lineStart, lineEnd);
    }

    public static void putLine(VertexConsumer vertexConsumer, int color, Vec3 normal, Matrix4f matrix, Matrix3f normalMatrix, Vec3 lineStart, Vec3 lineEnd) {
        vertexConsumer.m_252986_(matrix, (float)lineStart.f_82479_, (float)lineStart.f_82480_, (float)lineStart.f_82481_).m_193479_(color).m_252939_(normalMatrix, (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)lineEnd.f_82479_, (float)lineEnd.f_82480_, (float)lineEnd.f_82481_).m_193479_(color).m_252939_(normalMatrix, (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    private static void putLineToLineStrip(VertexConsumer vertexConsumer, int color, Vec3 normal, Matrix4f matrix, Vec3 lineStart, Vec3 lineEnd) {
        vertexConsumer.m_252986_(matrix, (float)lineStart.f_82479_, (float)lineStart.f_82480_, (float)lineStart.f_82481_).m_193479_(0).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)lineStart.f_82479_, (float)lineStart.f_82480_, (float)lineStart.f_82481_).m_193479_(color).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)lineEnd.f_82479_, (float)lineEnd.f_82480_, (float)lineEnd.f_82481_).m_193479_(color).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)lineEnd.f_82479_, (float)lineEnd.f_82480_, (float)lineEnd.f_82481_).m_193479_(0).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    public static void renderRectLine(VertexConsumer vertexConsumer, Vec3 cameraPos, UnilateralPortalState rect, int flowCount, int color, double shrinkFactor, int flowDirection, PoseStack matrixStack) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(rect.position().f_82479_ - cameraPos.f_82479_, rect.position().f_82480_ - cameraPos.f_82480_, rect.position().f_82481_ - cameraPos.f_82481_);
        Vec3[] vertices = WireRenderingHelper.getRectVertices(rect, shrinkFactor);
        Random random = new Random(color);
        WireRenderingHelper.renderFlowLines(vertexConsumer, vertices, flowCount, color, flowDirection, matrixStack, () -> random.nextInt(30, 300));
        matrixStack.m_85849_();
    }

    public static void renderFlowLines(VertexConsumer vertexConsumer, Vec3[] vertices, int flowCount, int color, int flowDirection, PoseStack matrixStack, IntSupplier randCycleSupplier) {
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = matrixStack.m_85850_().m_252943_();
        for (int i = 0; i < flowCount; ++i) {
            double offset = (double)flowDirection * CHelper.getSmoothCycles(randCycleSupplier.getAsInt());
            double totalStartRatio = (double)i * 2.0 / (double)(flowCount * 2) + offset;
            double totalEndRatio = ((double)i * 2.0 + 1.0) / (double)(flowCount * 2) + offset;
            WireRenderingHelper.renderSubLineInLineLoop(vertexConsumer, matrix, normalMatrix, vertices, color, totalStartRatio, totalEndRatio);
        }
    }

    private static Vec3[] getRectVertices(UnilateralPortalState rect, double shrinkFactor) {
        Vec3 normal = rect.orientation().getNormal();
        Vec3 axisW = rect.orientation().getAxisW();
        Vec3 axisH = rect.orientation().getAxisH();
        Vec3 facingOffset = normal.m_82490_(0.01);
        Vec3[] vertices = new Vec3[]{axisW.m_82490_(shrinkFactor * rect.width() / 2.0).m_82549_(axisH.m_82490_(shrinkFactor * rect.height() / 2.0)).m_82549_(facingOffset), axisW.m_82490_(shrinkFactor * rect.width() / 2.0).m_82549_(axisH.m_82490_(-1.0 * shrinkFactor * rect.height() / 2.0)).m_82549_(facingOffset), axisW.m_82490_(-1.0 * shrinkFactor * rect.width() / 2.0).m_82549_(axisH.m_82490_(-1.0 * shrinkFactor * rect.height() / 2.0)).m_82549_(facingOffset), axisW.m_82490_(-1.0 * shrinkFactor * rect.width() / 2.0).m_82549_(axisH.m_82490_(shrinkFactor * rect.height() / 2.0)).m_82549_(facingOffset), axisW.m_82490_(shrinkFactor * rect.width() / 2.0).m_82549_(axisH.m_82490_(shrinkFactor * rect.height() / 2.0)).m_82549_(facingOffset)};
        return vertices;
    }

    public static void renderSubLineInLineLoop(VertexConsumer vertexConsumer, Matrix4f matrix, Matrix3f normalMatrix, Vec3[] lineVertices, int color, double totalStartRatio, double totalEndRatio) {
        int lineNum = lineVertices.length - 1;
        double startRatioByLine = totalStartRatio * (double)lineNum;
        double endRatioByLine = totalEndRatio * (double)lineNum;
        int startRatioLineIndex = (int)Math.floor(startRatioByLine);
        int endRatioLineIndex = (int)Math.floor(endRatioByLine);
        for (int lineIndex = startRatioLineIndex; lineIndex <= endRatioLineIndex; ++lineIndex) {
            double startLimit = lineIndex;
            double endLimit = lineIndex + 1;
            double startRatio = Math.max(startLimit, startRatioByLine);
            double endRatio = Math.min(endLimit, endRatioByLine);
            WireRenderingHelper.putLinePart(vertexConsumer, color, matrix, normalMatrix, lineVertices[Math.floorMod(lineIndex, lineNum)], lineVertices[Math.floorMod(lineIndex, lineNum) + 1], startRatio - (double)lineIndex, endRatio - (double)lineIndex);
        }
    }

    private static void putLinePart(VertexConsumer vertexConsumer, int color, Matrix4f matrix, Matrix3f normalMatrix, Vec3 lineStart, Vec3 lineEnd, double startRatio, double endRatio) {
        Vec3 vec = lineEnd.m_82546_(lineStart);
        Vec3 partStartPos = lineStart.m_82549_(vec.m_82490_(startRatio));
        Vec3 partEndPos = lineStart.m_82549_(vec.m_82490_(endRatio));
        WireRenderingHelper.putLine(vertexConsumer, color, matrix, normalMatrix, partStartPos, partEndPos);
    }

    public static void renderSphere(VertexConsumer vertexConsumer, int color, PoseStack matrixStack, Vec3 cameraPos, Sphere sphere, DQuaternion sphereOrientation, double animationProgress, double rotationProgress) {
        int i;
        matrixStack.m_85836_();
        matrixStack.m_85837_(sphere.center().f_82479_ - cameraPos.f_82479_, sphere.center().f_82480_ - cameraPos.f_82480_, sphere.center().f_82481_ - cameraPos.f_82481_);
        matrixStack.m_252781_(sphereOrientation.toMcQuaternion());
        matrixStack.m_85841_((float)sphere.radius(), (float)sphere.radius(), (float)sphere.radius());
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        int meridianCount = 30;
        int parallelCount = 15;
        int vertexNum = Mth.m_14045_((int)((int)Math.round(sphere.radius() * 40.0)), (int)20, (int)400);
        int transparentColor = color & 0xFFFFFF;
        for (i = 0; i < meridianCount; ++i) {
            double longitude = ((double)i / (double)meridianCount + rotationProgress) * Math.PI * 2.0;
            for (int j = 0; j < vertexNum; ++j) {
                boolean isLast;
                boolean isFirst;
                double latitudeRatio = (double)j / (double)vertexNum;
                latitudeRatio = Math.min(latitudeRatio, animationProgress);
                double latitude = latitudeRatio * Math.PI - 1.5707963267948966;
                double x = Math.cos(latitude) * Math.cos(longitude);
                double y = Math.sin(latitude);
                double z = Math.cos(latitude) * Math.sin(longitude);
                boolean bl = isFirst = j == 0;
                if (isFirst) {
                    vertexConsumer.m_252986_(matrix, (float)x, (float)y, (float)z).m_193479_(transparentColor).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                }
                vertexConsumer.m_252986_(matrix, (float)x, (float)y, (float)z).m_193479_(color).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                boolean bl2 = isLast = j == vertexNum - 1;
                if (!isLast) continue;
                vertexConsumer.m_252986_(matrix, (float)x, (float)y, (float)z).m_193479_(transparentColor).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
        }
        for (i = 0; i < parallelCount; ++i) {
            double latitudeRatio = (double)i / (double)parallelCount + rotationProgress;
            latitudeRatio -= Math.floor(latitudeRatio);
            double latitude = latitudeRatio * Math.PI - 1.5707963267948966;
            for (int j = 0; j <= vertexNum; ++j) {
                boolean isLast;
                boolean isFirst;
                double longitudeRatio = (double)j / (double)vertexNum;
                longitudeRatio = Math.min(longitudeRatio, animationProgress);
                double longitude = longitudeRatio * Math.PI * 2.0;
                double x = Math.cos(latitude) * Math.cos(longitude);
                double y = Math.sin(latitude);
                double z = Math.cos(latitude) * Math.sin(longitude);
                boolean bl = isFirst = j == 0;
                if (isFirst) {
                    vertexConsumer.m_252986_(matrix, (float)x, (float)y, (float)z).m_193479_(transparentColor).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                }
                vertexConsumer.m_252986_(matrix, (float)x, (float)y, (float)z).m_193479_(color).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                boolean bl3 = isLast = j == vertexNum;
                if (!isLast) continue;
                vertexConsumer.m_252986_(matrix, (float)x, (float)y, (float)z).m_193479_(transparentColor).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
        }
        matrixStack.m_85849_();
    }

    public static void renderRectFrameFlow(PoseStack matrixStack, Vec3 cameraPos, VertexConsumer vertexConsumer, UnilateralPortalState rect, int innerColor, int outerColor) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        WireRenderingHelper.renderRectLine(vertexConsumer, cameraPos, rect, 10, innerColor, 0.99, 1, matrixStack);
        WireRenderingHelper.renderRectLine(vertexConsumer, cameraPos, rect, 10, outerColor, 1.01, -1, matrixStack);
        matrixStack.m_85849_();
    }

    public static void renderPortalShapeMeshDebug(PoseStack matrixStack, VertexConsumer vertexConsumer, Portal portal) {
        double cycle = (Math.sin(CHelper.getSmoothCycles(50L) * 2.0 * Math.PI) + 1.0) / 2.0;
        double shrink = 0.03 * cycle;
        GeometryPortalShape shape = portal.specialShape;
        if (shape != null) {
            int triangleNum = shape.triangles.size();
            int vertexNum = triangleNum * 3;
            Vec3[] vertexes = new Vec3[vertexNum];
            double halfWidth = portal.width / 2.0;
            double halfHeight = portal.height / 2.0;
            Vec3 X = portal.axisW.m_82490_(halfWidth);
            Vec3 Y = portal.axisH.m_82490_(halfHeight);
            matrixStack.m_85836_();
            Matrix4f matrix = matrixStack.m_85850_().m_252922_();
            Matrix3f normalMatrix = matrixStack.m_85850_().m_252943_();
            for (int i = 0; i < shape.triangles.size(); ++i) {
                GeometryPortalShape.TriangleInPlane triangleInPlane = shape.triangles.get(i);
                double centerX = (triangleInPlane.x1 + triangleInPlane.x2 + triangleInPlane.x3) / 3.0;
                double centerY = (triangleInPlane.y1 + triangleInPlane.y2 + triangleInPlane.y3) / 3.0;
                double x1 = triangleInPlane.x1 * (1.0 - shrink) + centerX * shrink;
                double y1 = triangleInPlane.y1 * (1.0 - shrink) + centerY * shrink;
                double x2 = triangleInPlane.x2 * (1.0 - shrink) + centerX * shrink;
                double y2 = triangleInPlane.y2 * (1.0 - shrink) + centerY * shrink;
                double x3 = triangleInPlane.x3 * (1.0 - shrink) + centerX * shrink;
                double y3 = triangleInPlane.y3 * (1.0 - shrink) + centerY * shrink;
                WireRenderingHelper.putLine(vertexConsumer, -2130771968, matrix, normalMatrix, X.m_82490_(x1).m_82549_(Y.m_82490_(y1)), X.m_82490_(x2).m_82549_(Y.m_82490_(y2)));
                WireRenderingHelper.putLine(vertexConsumer, -2130771968, matrix, normalMatrix, X.m_82490_(x2).m_82549_(Y.m_82490_(y2)), X.m_82490_(x3).m_82549_(Y.m_82490_(y3)));
                WireRenderingHelper.putLine(vertexConsumer, -2130771968, matrix, normalMatrix, X.m_82490_(x3).m_82549_(Y.m_82490_(y3)), X.m_82490_(x1).m_82549_(Y.m_82490_(y1)));
            }
            matrixStack.m_85849_();
        }
    }
}

