/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat.sodium_compatibility;

import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSectionManager;
import me.jellysquid.mods.sodium.client.render.chunk.map.ChunkTrackerHolder;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.world.WorldRendererExtended;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.compat.mixin.sodium.IESodiumWorldRenderer;
import qouteall.imm_ptl.core.compat.sodium_compatibility.IESodiumRenderSectionManager;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumRenderingContext;
import qouteall.imm_ptl.core.render.FrustumCuller;

@Environment(value=EnvType.CLIENT)
public class SodiumInterface {
    @Nullable
    public static FrustumCuller frustumCuller = null;
    public static Invoker invoker = new Invoker();

    public static class Invoker {
        public boolean isSodiumPresent() {
            return false;
        }

        public Object createNewContext(int renderDistance) {
            return null;
        }

        public void switchContextWithCurrentWorldRenderer(Object context) {
        }

        public void markSpriteActive(TextureAtlasSprite sprite) {
        }

        public void onClientChunkLoaded(ClientLevel world, int chunkX, int chunkZ) {
        }

        public void onClientChunkUnloaded(ClientLevel world, int chunkX, int chunkZ) {
        }
    }

    public static class OnSodiumPresent
    extends Invoker {
        @Override
        public boolean isSodiumPresent() {
            return true;
        }

        @Override
        public Object createNewContext(int renderDistance) {
            return new SodiumRenderingContext(renderDistance);
        }

        @Override
        public void switchContextWithCurrentWorldRenderer(Object context) {
            SodiumWorldRenderer swr = ((WorldRendererExtended)Minecraft.m_91087_().f_91060_).sodium$getWorldRenderer();
            swr.scheduleTerrainUpdate();
            RenderSectionManager renderSectionManager = ((IESodiumWorldRenderer)swr).ip_getRenderSectionManager();
            ((IESodiumRenderSectionManager)renderSectionManager).ip_swapContext((SodiumRenderingContext)context);
            swr.scheduleTerrainUpdate();
        }

        @Override
        public void markSpriteActive(TextureAtlasSprite sprite) {
            SpriteUtil.markSpriteActive((TextureAtlasSprite)sprite);
        }

        @Override
        public void onClientChunkLoaded(ClientLevel world, int chunkX, int chunkZ) {
            ChunkTrackerHolder.get((ClientLevel)world).onChunkStatusAdded(chunkX, chunkZ, 1);
        }

        @Override
        public void onClientChunkUnloaded(ClientLevel world, int chunkX, int chunkZ) {
            ChunkTrackerHolder.get((ClientLevel)world).onChunkStatusRemoved(chunkX, chunkZ, 1);
        }
    }
}

