/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat;

import com.mojang.logging.LogUtils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.q_misc_util.Helper;

public class IPModInfoChecking {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static List<String> incompatibleShaderpacks;
    @Nullable
    private static String lastShaderpackName;

    @Nullable
    public static ImmPtlInfo fetchImmPtlInfoFromInternet() {
        String url = O_O.getImmPtlModInfoUrl();
        if (url == null) {
            Helper.log((Object)"Not fetching immptl mod info");
            return null;
        }
        try {
            HttpResponse<String> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "Immersive Portals mod").build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                Helper.err((Object)("Failed to fetch immptl mod info " + response.statusCode()));
                return null;
            }
            String jsonStr = response.body();
            ImmPtlInfo immPtlInfo = (ImmPtlInfo)Helper.gson.fromJson(jsonStr, ImmPtlInfo.class);
            LOGGER.info("ImmPtl mod info fetched");
            return immPtlInfo;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void initDedicatedServer() {
        Util.m_183991_().execute(() -> {
            if (!IPGlobal.checkModInfoFromInternet) {
                return;
            }
            ImmPtlInfo immPtlInfo = IPModInfoChecking.fetchImmPtlInfoFromInternet();
            if (immPtlInfo == null) {
                return;
            }
            IPGlobal.serverTaskList.addOneShotTask(() -> {
                MutableComponent text1;
                if (IPGlobal.enableUpdateNotification && O_O.shouldUpdateImmPtl(immPtlInfo.latestReleaseVersion)) {
                    LOGGER.info("[Immersive Portals] A new version is available. It is recommended to update to " + immPtlInfo.latestReleaseVersion);
                }
                for (ModIncompatInfo mod : immPtlInfo.severelyIncompatible) {
                    if (mod == null || !mod.isModLoadedWithinVersion()) continue;
                    if (mod.startVersion != null || mod.endVersion != null) {
                        text1 = Component.m_237110_((String)"imm_ptl.severely_incompatible_within_version", (Object[])new Object[]{mod.modName, mod.modId, mod.getVersionRangeStr()}).m_130940_(ChatFormatting.RED);
                        LOGGER.error("[Immersive Portals] Detected an incompatible mod: {} {} version range: {} description: {} link: {}", new Object[]{mod.modName, mod.modId, mod.getVersionRangeStr(), mod.desc, mod.link});
                    } else {
                        text1 = Component.m_237110_((String)"imm_ptl.severely_incompatible", (Object[])new Object[]{mod.modName, mod.modId}).m_130940_(ChatFormatting.RED);
                        LOGGER.error("[Immersive Portals] Detected an incompatible mod: {} {} description: {} link: {}", new Object[]{mod.modName, mod.modId, mod.desc, mod.link});
                    }
                    if (mod.desc != null) {
                        text1.m_7220_((Component)Component.m_237113_((String)(" " + mod.desc + " ")));
                    }
                    if (mod.link != null) {
                        text1.m_7220_((Component)Component.m_237113_((String)" "));
                        text1.m_7220_((Component)McHelper.getLinkText(mod.link));
                    }
                    McHelper.sendMessageToFirstLoggedPlayer((Component)Component.m_237115_((String)"imm_ptl.message_from_server").m_7220_((Component)text1));
                }
                for (ModIncompatInfo mod : immPtlInfo.incompatible) {
                    if (mod == null || !mod.isModLoadedWithinVersion() || !IPConfig.getConfig().shouldDisplayWarning(mod.modId)) continue;
                    text1 = Component.m_237110_((String)"imm_ptl.incompatible", (Object[])new Object[]{mod.modName, mod.modId}).m_130940_(ChatFormatting.RED);
                    if (mod.desc != null) {
                        text1.m_7220_((Component)Component.m_237113_((String)(" " + mod.desc + " ")));
                    }
                    if (mod.link != null) {
                        text1.m_7220_((Component)McHelper.getLinkText(" " + mod.link));
                    }
                    LOGGER.error("[Immersive Portals] Detected a mildly incompatible mod: {} {} description: {} link: {}", new Object[]{mod.modName, mod.modId, mod.desc, mod.link});
                    McHelper.sendMessageToFirstLoggedPlayer((Component)Component.m_237115_((String)"imm_ptl.message_from_server").m_7220_((Component)text1));
                }
            });
        });
    }

    public static void checkShaderpack() {
        if (!IPConfig.getConfig().shaderpackWarning) {
            return;
        }
        String shaderpackName = IrisInterface.invoker.getShaderpackName();
        if (!Objects.equals(lastShaderpackName, shaderpackName)) {
            boolean incompatible;
            lastShaderpackName = shaderpackName;
            if (shaderpackName != null && incompatibleShaderpacks != null && (incompatible = incompatibleShaderpacks.stream().anyMatch(n -> shaderpackName.toLowerCase().contains(n.toLowerCase())))) {
                CHelper.printChat((Component)Component.m_237115_((String)"imm_ptl.incompatible_shaderpack").m_130940_(ChatFormatting.RED));
            }
        }
    }

    public static final class ImmPtlInfo {
        public String latestReleaseVersion;
        public List<String> previewVersions;
        public List<ModIncompatInfo> severelyIncompatible;
        public List<ModIncompatInfo> incompatible;
        public List<String> incompatibleShaderpacks;

        public ImmPtlInfo(String latestReleaseVersion, List<ModIncompatInfo> severelyIncompatible, List<ModIncompatInfo> incompatible) {
            this.latestReleaseVersion = latestReleaseVersion;
            this.severelyIncompatible = severelyIncompatible;
            this.incompatible = incompatible;
        }

        public String toString() {
            return "ImmPtlInfo{latestReleaseVersion='" + this.latestReleaseVersion + "', severelyIncompatible=" + this.severelyIncompatible + ", incompatible=" + this.incompatible + "}";
        }
    }

    public record ModIncompatInfo(String modId, String modName, @Nullable String startVersion, @Nullable String endVersion, @Nullable String desc, @Nullable String link) {
        boolean isModLoadedWithinVersion() {
            return O_O.isModLoadedWithinVersion(this.modId, this.startVersion, this.endVersion);
        }

        String getVersionRangeStr() {
            if (this.startVersion != null) {
                if (this.endVersion != null) {
                    return this.startVersion + "-" + this.endVersion;
                }
                return this.startVersion + "+";
            }
            Validate.notNull((Object)this.endVersion);
            return "-" + this.endVersion;
        }
    }
}

