/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat;

import gravity_changer.api.GravityChangerAPI;
import gravity_changer.util.RotationUtil;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import qouteall.q_misc_util.my_util.DQuaternion;

public class GravityChangerInterface {
    public static Invoker invoker = new Invoker();
    private static boolean warned = false;

    public static class Invoker {
        public boolean isGravityChangerPresent() {
            return false;
        }

        public Vec3 getEyeOffset(Entity entity) {
            return new Vec3(0.0, (double)entity.m_20192_(), 0.0);
        }

        public Direction getGravityDirection(Entity entity) {
            return Direction.DOWN;
        }

        public Direction getBaseGravityDirection(Entity entity) {
            return Direction.DOWN;
        }

        public void setClientPlayerGravityDirection(Player player, Direction direction) {
            GravityChangerInterface.warnGravityChangerNotPresent();
        }

        public void setBaseGravityDirectionServer(Entity entity, Direction direction) {
        }

        @Nullable
        public DQuaternion getExtraCameraRotation(Direction gravityDirection) {
            return null;
        }

        public Vec3 getWorldVelocity(Entity entity) {
            return entity.m_20184_();
        }

        public void setWorldVelocity(Entity entity, Vec3 newVelocity) {
            entity.m_20256_(newVelocity);
        }

        public Vec3 transformPlayerToWorld(Direction gravity, Vec3 vec3d) {
            return vec3d;
        }

        public Vec3 transformWorldToPlayer(Direction gravity, Vec3 vec3d) {
            return vec3d;
        }

        public Direction transformDirPlayerToWorld(Direction gravity, Direction direction) {
            return direction;
        }

        public Direction transformDirWorldToPlayer(Direction gravity, Direction direction) {
            return direction;
        }
    }

    public static class OnGravityChangerPresent
    extends Invoker {
        @Override
        public boolean isGravityChangerPresent() {
            return true;
        }

        @Override
        public Vec3 getEyeOffset(Entity entity) {
            return GravityChangerAPI.getEyeOffset((Entity)entity);
        }

        @Override
        public Direction getGravityDirection(Entity entity) {
            return GravityChangerAPI.getGravityDirection((Entity)entity);
        }

        @Override
        public Direction getBaseGravityDirection(Entity entity) {
            return GravityChangerAPI.getBaseGravityDirection((Entity)entity);
        }

        @Override
        public void setBaseGravityDirectionServer(Entity entity, Direction direction) {
            GravityChangerAPI.setBaseGravityDirection((Entity)entity, (Direction)direction);
        }

        @Override
        public void setClientPlayerGravityDirection(Player player, Direction direction) {
            this.setClientPlayerGravityDirectionClientOnly(player, direction);
        }

        @Override
        @Nullable
        public DQuaternion getExtraCameraRotation(Direction gravityDirection) {
            if (gravityDirection == Direction.DOWN) {
                return null;
            }
            return DQuaternion.fromMcQuaternion((Quaternionf)RotationUtil.getWorldRotationQuaternion((Direction)gravityDirection));
        }

        @Override
        public Vec3 getWorldVelocity(Entity entity) {
            return GravityChangerAPI.getWorldVelocity((Entity)entity);
        }

        @Override
        public void setWorldVelocity(Entity entity, Vec3 newVelocity) {
            GravityChangerAPI.setWorldVelocity((Entity)entity, (Vec3)newVelocity);
        }

        @Override
        public Vec3 transformPlayerToWorld(Direction gravity, Vec3 vec3d) {
            return RotationUtil.vecPlayerToWorld((Vec3)vec3d, (Direction)gravity);
        }

        @Override
        public Vec3 transformWorldToPlayer(Direction gravity, Vec3 vec3d) {
            return RotationUtil.vecWorldToPlayer((Vec3)vec3d, (Direction)gravity);
        }

        @Override
        public Direction transformDirPlayerToWorld(Direction gravity, Direction direction) {
            return RotationUtil.dirPlayerToWorld((Direction)direction, (Direction)gravity);
        }

        @Override
        public Direction transformDirWorldToPlayer(Direction gravity, Direction direction) {
            return RotationUtil.dirWorldToPlayer((Direction)direction, (Direction)gravity);
        }
    }
}

