/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.commands.AxisArgumentType;
import qouteall.imm_ptl.core.commands.PortalAnimationCommand;
import qouteall.imm_ptl.core.commands.PortalDebugCommands;
import qouteall.imm_ptl.core.commands.SubCommandArgumentType;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.global_portals.BorderBarrierFiller;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.core.portal.global_portals.WorldWrappingPortal;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalMatcher;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.GeometryUtil;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.Mesh2D;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.SignalBiArged;
import qouteall.q_misc_util.my_util.Vec2d;
import qouteall.q_misc_util.my_util.WithDim;

public class PortalCommand {
    public static final SignalBiArged<ServerPlayer, String> createCommandStickCommandSignal = new SignalBiArged();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"portal").requires(PortalCommand::canUsePortalCommand);
        PortalCommand.registerPortalTargetedCommands((LiteralArgumentBuilder<CommandSourceStack>)builder);
        LiteralArgumentBuilder animation = Commands.m_82127_((String)"animation");
        PortalAnimationCommand.registerPortalAnimationCommands((LiteralArgumentBuilder<CommandSourceStack>)animation);
        builder.then((ArgumentBuilder)animation);
        PortalCommand.registerCBPortalCommands((LiteralArgumentBuilder<CommandSourceStack>)builder);
        PortalCommand.registerUtilityCommands((LiteralArgumentBuilder<CommandSourceStack>)builder);
        LiteralArgumentBuilder global = (LiteralArgumentBuilder)Commands.m_82127_((String)"global").requires(commandSource -> commandSource.m_6761_(2));
        PortalCommand.registerGlobalPortalCommands((LiteralArgumentBuilder<CommandSourceStack>)global);
        builder.then((ArgumentBuilder)global);
        LiteralArgumentBuilder debugBuilder = (LiteralArgumentBuilder)Commands.m_82127_((String)"debug").requires(PortalCommand::canUsePortalCommand);
        PortalDebugCommands.registerDebugCommands((LiteralArgumentBuilder<CommandSourceStack>)debugBuilder);
        builder.then((ArgumentBuilder)debugBuilder);
        LiteralArgumentBuilder euler = Commands.m_82127_((String)"euler");
        PortalCommand.registerEulerCommands((LiteralArgumentBuilder<CommandSourceStack>)euler);
        builder.then((ArgumentBuilder)euler);
        dispatcher.register(builder);
    }

    public static boolean canUsePortalCommand(CommandSourceStack commandSource) {
        Entity entity = commandSource.m_81373_();
        if (entity instanceof ServerPlayer && IPGlobal.easeCreativePermission && ((ServerPlayer)entity).m_7500_()) {
            return true;
        }
        return commandSource.m_6761_(2);
    }

    private static void registerGlobalPortalCommands(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"create_inward_wrapping").then(Commands.m_82129_((String)"p1", (ArgumentType)ColumnPosArgument.m_118989_()).then(Commands.m_82129_((String)"p2", (ArgumentType)ColumnPosArgument.m_118989_()).executes(context -> {
            ColumnPos p1 = ColumnPosArgument.m_118992_((CommandContext)context, (String)"p1");
            ColumnPos p2 = ColumnPosArgument.m_118992_((CommandContext)context, (String)"p2");
            WorldWrappingPortal.invokeAddWrappingZone(((CommandSourceStack)context.getSource()).m_81372_(), p1.f_140723_(), p1.f_140724_(), p2.f_140723_(), p2.f_140724_(), true, text -> ((CommandSourceStack)context.getSource()).m_288197_(() -> text, false));
            return 0;
        }))));
        builder.then(Commands.m_82127_((String)"create_outward_wrapping").then(Commands.m_82129_((String)"p1", (ArgumentType)ColumnPosArgument.m_118989_()).then(Commands.m_82129_((String)"p2", (ArgumentType)ColumnPosArgument.m_118989_()).executes(context -> {
            ColumnPos p1 = ColumnPosArgument.m_118992_((CommandContext)context, (String)"p1");
            ColumnPos p2 = ColumnPosArgument.m_118992_((CommandContext)context, (String)"p2");
            WorldWrappingPortal.invokeAddWrappingZone(((CommandSourceStack)context.getSource()).m_81372_(), p1.f_140723_(), p1.f_140724_(), p2.f_140723_(), p2.f_140724_(), false, text -> ((CommandSourceStack)context.getSource()).m_288197_(() -> text, false));
            return 0;
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove_wrapping_zone").executes(context -> {
            WorldWrappingPortal.invokeRemoveWrappingZone(((CommandSourceStack)context.getSource()).m_81372_(), ((CommandSourceStack)context.getSource()).m_81371_(), text -> ((CommandSourceStack)context.getSource()).m_288197_(() -> text, false));
            return 0;
        })).then(Commands.m_82129_((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int id = IntegerArgumentType.getInteger((CommandContext)context, (String)"id");
            WorldWrappingPortal.invokeRemoveWrappingZone(((CommandSourceStack)context.getSource()).m_81372_(), id, text -> ((CommandSourceStack)context.getSource()).m_288197_(() -> text, false));
            return 0;
        })));
        builder.then(Commands.m_82127_((String)"view_wrapping_zones").executes(context -> {
            WorldWrappingPortal.invokeViewWrappingZones(((CommandSourceStack)context.getSource()).m_81372_(), text -> ((CommandSourceStack)context.getSource()).m_288197_(() -> text, false));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear_wrapping_border").executes(context -> {
            BorderBarrierFiller.onCommandExecuted(((CommandSourceStack)context.getSource()).m_81375_());
            return 0;
        })).then(Commands.m_82129_((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int id = IntegerArgumentType.getInteger((CommandContext)context, (String)"id");
            BorderBarrierFiller.onCommandExecuted(((CommandSourceStack)context.getSource()).m_81375_(), id);
            return 0;
        })));
        builder.then(Commands.m_82127_((String)"connect_floor").then(Commands.m_82129_((String)"from", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"to", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> {
            ResourceKey from = DimensionArgument.m_88808_((CommandContext)context, (String)"from").m_46472_();
            ResourceKey to = DimensionArgument.m_88808_((CommandContext)context, (String)"to").m_46472_();
            VerticalConnectingPortal.connect((ResourceKey<Level>)from, VerticalConnectingPortal.ConnectorType.floor, (ResourceKey<Level>)to);
            return 0;
        }))));
        builder.then(Commands.m_82127_((String)"connect_ceil").then(Commands.m_82129_((String)"from", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"to", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> {
            ResourceKey from = DimensionArgument.m_88808_((CommandContext)context, (String)"from").m_46472_();
            ResourceKey to = DimensionArgument.m_88808_((CommandContext)context, (String)"to").m_46472_();
            VerticalConnectingPortal.connect((ResourceKey<Level>)from, VerticalConnectingPortal.ConnectorType.ceil, (ResourceKey<Level>)to);
            return 0;
        }))));
        builder.then(Commands.m_82127_((String)"connection_floor_remove").then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> {
            ResourceKey dim = DimensionArgument.m_88808_((CommandContext)context, (String)"dim").m_46472_();
            VerticalConnectingPortal.removeConnectingPortal(VerticalConnectingPortal.ConnectorType.floor, (ResourceKey<Level>)dim);
            return 0;
        })));
        builder.then(Commands.m_82127_((String)"connection_ceil_remove").then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> {
            ResourceKey dim = DimensionArgument.m_88808_((CommandContext)context, (String)"dim").m_46472_();
            VerticalConnectingPortal.removeConnectingPortal(VerticalConnectingPortal.ConnectorType.ceil, (ResourceKey<Level>)dim);
            return 0;
        })));
        builder.then(Commands.m_82127_((String)"view_global_portals").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, Helper.myToString(GlobalPortalStorage.getGlobalPortals(player.m_9236_()).stream()));
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"convert_normal_portal_to_global_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, GlobalPortalStorage::convertNormalPortalIntoGlobalPortal)));
        builder.then(Commands.m_82127_((String)"convert_global_portal_to_normal_portal").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            Portal portal = PortalCommand.getPlayerPointingPortal(player, true);
            if (portal == null) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"You are not pointing to any portal"), false);
                return 0;
            }
            if (!portal.getIsGlobal()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"You are not pointing to a global portal"), false);
                return 0;
            }
            if (player.m_20182_().m_82554_(portal.getOriginPos()) > 64.0) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("You are too far away from the portal's center " + portal)), false);
                return 0;
            }
            GlobalPortalStorage.convertGlobalPortalIntoNormalPortal(portal);
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"delete_global_portal").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            Portal portal = PortalCommand.getPlayerPointingPortal(player, true);
            if (portal == null) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"You are not pointing to any portal"), false);
                return 0;
            }
            if (!portal.getIsGlobal()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"You are not pointing to a global portal"), false);
                return 0;
            }
            GlobalPortalStorage.get((ServerLevel)portal.m_9236_()).removePortal(portal);
            return 0;
        }));
    }

    private static void registerPortalTargetedCommands(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"view_portal_data").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.sendPortalInfo((CommandContext<CommandSourceStack>)context, portal))));
        builder.then(Commands.m_82127_((String)"set_portal_custom_name").then(Commands.m_82129_((String)"name", (ArgumentType)ComponentArgument.m_87114_()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Component name = ComponentArgument.m_87117_((CommandContext)context, (String)"name");
            portal.m_6593_(name);
        }))));
        builder.then(Commands.m_82127_((String)"delete_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "deleted " + portal);
            portal.m_142687_(Entity.RemovalReason.KILLED);
        })));
        builder.then(Commands.m_82127_((String)"set_portal_nbt").then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            CompoundTag newNbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
            PortalCommand.invokeSetPortalNbt((CommandContext<CommandSourceStack>)context, portal, newNbt);
        }))));
        builder.then(Commands.m_82127_((String)"nbt").then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            CompoundTag newNbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
            PortalCommand.invokeSetPortalNbt((CommandContext<CommandSourceStack>)context, portal, newNbt);
        }))));
        builder.then(Commands.m_82127_((String)"set_portal_destination").then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"dest", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalCommand.sendEditBiWayPortalWarning((CommandContext<CommandSourceStack>)context, portal);
            portal.dimensionTo = DimensionArgument.m_88808_((CommandContext)context, (String)"dim").m_46472_();
            portal.setDestination(Vec3Argument.m_120844_((CommandContext)context, (String)"dest"));
            PortalCommand.reloadPortal(portal);
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, portal.toString());
        })))));
        PortalCommand.registerPortalTargetedCommandWithRotationArgument(builder, "set_portal_rotation", (p, r) -> p.setRotation((DQuaternion)r));
        PortalCommand.registerPortalTargetedCommandWithRotationArgument(builder, "rotate_portal_body", (p, r) -> {
            if (r != null) {
                PortalManipulation.rotatePortalBody(p, r);
            }
        });
        PortalCommand.registerPortalTargetedCommandWithRotationArgument(builder, "rotate_portal_rotation", (portal, rot) -> {
            if (rot != null) {
                DQuaternion rotation = portal.getRotation();
                if (rotation == null) {
                    portal.setRotation((DQuaternion)rot);
                } else {
                    portal.setRotation(rotation.hamiltonProduct(rot));
                }
            }
        });
        builder.then(Commands.m_82127_((String)"complete_bi_way_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.invokeCompleteBiWayPortal((CommandContext<CommandSourceStack>)context, portal))));
        builder.then(Commands.m_82127_((String)"complete_bi_faced_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.invokeCompleteBiFacedPortal((CommandContext<CommandSourceStack>)context, portal))));
        builder.then(Commands.m_82127_((String)"complete_bi_way_bi_faced_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.invokeCompleteBiWayBiFacedPortal((CommandContext<CommandSourceStack>)context, portal))));
        builder.then(Commands.m_82127_((String)"remove_connected_portals").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalExtension.get((Portal)portal).bindCluster = false;
            PortalCommand.reloadPortal(portal);
            PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "Removed " + p));
        })));
        builder.then(Commands.m_82127_((String)"eradicate_portal_clutter").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "Removed " + p));
            portal.m_142687_(Entity.RemovalReason.KILLED);
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "Deleted " + portal);
        })));
        builder.then(Commands.m_82127_((String)"eradicate_portal_cluster").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            HashSet<Portal> removed = new HashSet<Portal>();
            PortalManipulation.removeConnectedPortals(portal, removed::add);
            portal.m_142687_(Entity.RemovalReason.KILLED);
            removed.add(portal);
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "Deleted %d portal entities".formatted(removed.size()));
        })));
        builder.then(Commands.m_82127_((String)"move_portal").then(Commands.m_82129_((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            try {
                PortalCommand.sendEditBiWayPortalWarning((CommandContext<CommandSourceStack>)context, portal);
                double distance = DoubleArgumentType.getDouble((CommandContext)context, (String)"distance");
                ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
                Vec3 viewVector = player.m_20154_();
                Direction facing = Direction.m_122366_((double)viewVector.f_82479_, (double)viewVector.f_82480_, (double)viewVector.f_82481_);
                Vec3 offset = Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(distance);
                portal.m_6034_(portal.m_20185_() + offset.f_82479_, portal.m_20186_() + offset.f_82480_, portal.m_20189_() + offset.f_82481_);
                PortalCommand.reloadPortal(portal);
            }
            catch (CommandSyntaxException e) {
                PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "This command can only be invoked by player");
            }
        }))));
        builder.then(Commands.m_82127_((String)"move_portal_destination").then(Commands.m_82129_((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            try {
                PortalCommand.sendEditBiWayPortalWarning((CommandContext<CommandSourceStack>)context, portal);
                double distance = DoubleArgumentType.getDouble((CommandContext)context, (String)"distance");
                ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
                Vec3 viewVector = player.m_20154_();
                Direction facing = Direction.m_122366_((double)viewVector.f_82479_, (double)viewVector.f_82480_, (double)viewVector.f_82481_);
                Vec3 offset = Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(distance);
                portal.setDestination(portal.getDestPos().m_82549_(portal.transformLocalVecNonScale(offset)));
                PortalCommand.reloadPortal(portal);
            }
            catch (CommandSyntaxException e) {
                PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "This command can only be invoked by player");
            }
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set_portal_specific_accessor").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.removeSpecificAccessor((CommandContext<CommandSourceStack>)context, portal)))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.setSpecificAccessor((CommandContext<CommandSourceStack>)context, portal, EntityArgument.m_91452_((CommandContext)context, (String)"player"))))));
        builder.then(Commands.m_82127_((String)"multidest").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.removeMultidestEntry((CommandContext<CommandSourceStack>)context, portal, EntityArgument.m_91474_((CommandContext)context, (String)"player"))))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"destination", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"isBiFaced", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"isBiWay", (ArgumentType)BoolArgumentType.bool()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.setMultidestEntry((CommandContext<CommandSourceStack>)context, portal, EntityArgument.m_91474_((CommandContext)context, (String)"player"), (ResourceKey<Level>)DimensionArgument.m_88808_((CommandContext)context, (String)"dimension").m_46472_(), Vec3Argument.m_120844_((CommandContext)context, (String)"destination"), BoolArgumentType.getBool((CommandContext)context, (String)"isBiFaced"), BoolArgumentType.getBool((CommandContext)context, (String)"isBiWay"))))))))));
        builder.then(Commands.m_82127_((String)"make_portal_round").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalManipulation.makePortalRound(portal, 30);
            PortalCommand.reloadPortal(portal);
        })));
        builder.then(Commands.m_82127_((String)"set_portal_scale").then(Commands.m_82129_((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            double scale;
            portal.scaling = scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(Commands.m_82127_((String)"multiply_portal_scale").then(Commands.m_82129_((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            portal.scaling *= scale;
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(Commands.m_82127_((String)"divide_portal_scale").then(Commands.m_82129_((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            portal.scaling /= scale;
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(Commands.m_82127_((String)"set_portal_destination_to").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"entity");
            portal.dimensionTo = entity.m_9236_().m_46472_();
            portal.setDestination(entity.m_20182_());
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(Commands.m_82127_((String)"set_portal_position").then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            ServerLevel targetWorld = DimensionArgument.m_88808_((CommandContext)context, (String)"dim");
            Vec3 pos = Vec3Argument.m_120844_((CommandContext)context, (String)"pos");
            if (targetWorld == portal.m_9236_()) {
                portal.setOriginPos(pos);
                PortalCommand.reloadPortal(portal);
            } else {
                ServerTeleportationManager.teleportEntityGeneral(portal, pos, targetWorld);
            }
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, portal.toString());
        })))));
        builder.then(Commands.m_82127_((String)"set_portal_position_to").then(Commands.m_82129_((String)"targetEntity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Entity targetEntity = EntityArgument.m_91452_((CommandContext)context, (String)"targetEntity");
            if (targetEntity.m_9236_() == portal.m_9236_()) {
                portal.setOriginPos(targetEntity.m_20182_());
                PortalCommand.reloadPortal(portal);
            } else {
                ServerTeleportationManager.teleportEntityGeneral(portal, targetEntity.m_20182_(), (ServerLevel)targetEntity.m_9236_());
            }
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, portal.toString());
        }))));
        builder.then(Commands.m_82127_((String)"reset_portal_orientation").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            UnilateralPortalState thisSideState = portal.getThisSideState();
            portal.setThisSideState(new UnilateralPortalState.Builder().from(thisSideState).orientation(DQuaternion.identity).build());
            PortalCommand.reloadPortal(portal);
        })));
        builder.then(Commands.m_82127_((String)"relatively_move_portal").then(Commands.m_82129_((String)"offset", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec3 offset = Vec3Argument.m_120844_((CommandContext)context, (String)"offset");
            portal.setOriginPos(portal.getOriginPos().m_82549_(portal.axisW.m_82490_(offset.f_82479_)).m_82549_(portal.axisH.m_82490_(offset.f_82480_)).m_82549_(portal.getNormal().m_82490_(offset.f_82481_)));
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(Commands.m_82127_((String)"relatively_move_portal_destination").then(Commands.m_82129_((String)"offset", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec3 offset = Vec3Argument.m_120844_((CommandContext)context, (String)"offset");
            portal.setDestination(portal.getDestPos().m_82549_(portal.transformLocalVec(portal.axisW).m_82490_(offset.f_82479_)).m_82549_(portal.transformLocalVec(portal.axisH).m_82490_(offset.f_82480_)).m_82549_(portal.transformLocalVec(portal.getNormal()).m_82490_(offset.f_82481_)));
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(Commands.m_82127_((String)"set_portal_size").then(Commands.m_82129_((String)"width", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.m_82129_((String)"height", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            portal.width = width;
            portal.height = height;
            portal.specialShape = null;
            PortalCommand.reloadPortal(portal);
        })))));
        builder.then(Commands.m_82127_((String)"adjust_portal_to_fit_square_frame").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalCommand.adjustPortalAreaToFitFrame(portal);
            PortalCommand.reloadPortal(portal);
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add_command_on_teleported").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).then(Commands.m_82129_((String)"subCommand", (ArgumentType)SubCommandArgumentType.instance).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            String subCommand = SubCommandArgumentType.get(context, "subCommand");
            if (portal.commandsOnTeleported == null) {
                portal.commandsOnTeleported = new ArrayList<String>();
            }
            portal.commandsOnTeleported.add(subCommand);
            portal.reloadAndSyncToClient();
            PortalCommand.sendPortalInfo((CommandContext<CommandSourceStack>)context, portal);
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove_command_on_teleported_at").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).then(Commands.m_82129_((String)"indexStartingFromZero", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            if (portal.commandsOnTeleported == null) {
                return;
            }
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"indexStartingFromZero");
            if (index >= portal.commandsOnTeleported.size()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Index out of range"));
                return;
            }
            portal.commandsOnTeleported.remove(index);
            portal.reloadAndSyncToClient();
            PortalCommand.sendPortalInfo((CommandContext<CommandSourceStack>)context, portal);
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set_command_on_teleported_at").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).then(Commands.m_82129_((String)"indexStartingFromZero", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).then(Commands.m_82129_((String)"subCommand", (ArgumentType)SubCommandArgumentType.instance).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            if (portal.commandsOnTeleported == null) {
                return;
            }
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"indexStartingFromZero");
            if (index >= portal.commandsOnTeleported.size()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Index out of range"));
                return;
            }
            String subCommand = SubCommandArgumentType.get(context, "subCommand");
            portal.commandsOnTeleported.set(index, subCommand);
            portal.reloadAndSyncToClient();
            PortalCommand.sendPortalInfo((CommandContext<CommandSourceStack>)context, portal);
        })))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear_commands_on_teleported").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            portal.commandsOnTeleported = null;
            portal.reloadAndSyncToClient();
            PortalCommand.sendPortalInfo((CommandContext<CommandSourceStack>)context, portal);
        })));
        builder.then(Commands.m_82127_((String)"turn_info_fake_enterable_mirror").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.invokeTurnIntoFakeEnterableMirror((CommandContext<CommandSourceStack>)context, portal))));
        LiteralArgumentBuilder shapeBuilder = Commands.m_82127_((String)"shape");
        shapeBuilder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sculpt").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.invokeSculpt((CommandContext<CommandSourceStack>)context, portal, true)))).then(Commands.m_82129_((String)"adjustPortalBounds", (ArgumentType)BoolArgumentType.bool()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            boolean adjustPortalBounds = BoolArgumentType.getBool((CommandContext)context, (String)"adjustPortalBounds");
            PortalCommand.invokeSculpt((CommandContext<CommandSourceStack>)context, portal, adjustPortalBounds);
        }))));
        shapeBuilder.then(Commands.m_82127_((String)"reset").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            portal.specialShape = null;
            PortalCommand.reloadPortal(portal);
        })));
        builder.then((ArgumentBuilder)shapeBuilder);
    }

    private static void invokeSetPortalNbt(CommandContext<CommandSourceStack> context, Portal portal, CompoundTag newNbt) {
        if (newNbt.m_128441_("commandsOnTeleported") && !((CommandSourceStack)context.getSource()).m_6761_(2)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You do not have the permission to set commandsOnTeleported"));
            return;
        }
        if (newNbt.m_128441_("dimensionTo")) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Cannot change tag dimensionTo. use command /portal set_portal_destination"));
            return;
        }
        portal.updatePortalFromNbt(newNbt);
        PortalCommand.reloadPortal(portal);
        PortalCommand.sendPortalInfo(context, portal);
    }

    private static void adjustPortalAreaToFitFrame(Portal portal) {
        BlockPos origin = BlockPos.m_274446_((Position)portal.getOriginPos());
        Direction portalNormalDirection = Direction.m_122366_((double)portal.getNormal().f_82479_, (double)portal.getNormal().f_82480_, (double)portal.getNormal().f_82481_);
        Level world = portal.m_9236_();
        IntBox boxArea = Helper.expandRectangle((BlockPos)origin, pos -> world.m_8055_(pos).m_60795_(), (Direction.Axis)portalNormalDirection.m_122434_());
        AABB portalBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (Direction direction : Direction.values()) {
            IntBox outerSurface = boxArea.getSurfaceLayer(direction).getMoved(direction.m_122436_());
            AABB collisionBox = McHelper.getWallBox(world, outerSurface);
            if (collisionBox == null) {
                collisionBox = outerSurface.toRealNumberBox();
            }
            portalBox = Helper.replaceBoxCoordinate((AABB)portalBox, (Direction)direction, (double)Helper.getBoxCoordinate((AABB)collisionBox, (Direction)direction.m_122424_()));
        }
        double portalNormalCoordinate = Helper.getCoordinate((Vec3)portal.getOriginPos(), (Direction.Axis)portalNormalDirection.m_122434_());
        portalBox = Helper.replaceBoxCoordinate((AABB)portalBox, (Direction)portalNormalDirection, (double)portalNormalCoordinate);
        portalBox = Helper.replaceBoxCoordinate((AABB)portalBox, (Direction)portalNormalDirection.m_122424_(), (double)portalNormalCoordinate);
        portal.specialShape = null;
        PortalAPI.setPortalOrthodoxShape(portal, portalNormalDirection, portalBox);
    }

    public static void reloadPortal(Portal portal) {
        portal.reloadPortal();
    }

    private static void registerPortalTargetedCommandWithRotationArgument(LiteralArgumentBuilder<CommandSourceStack> builder, String literal, BiConsumer<Portal, DQuaternion> func) {
        builder.then(Commands.m_82127_((String)literal).then(Commands.m_82129_((String)"rotatingAxis", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec3 rotatingAxis = Vec3Argument.m_120844_((CommandContext)context, (String)"rotatingAxis").m_82541_();
            PortalCommand.doInvokeRotationCommandWithAngleArgument(func, (CommandContext<CommandSourceStack>)context, portal, rotatingAxis);
        })))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)(literal + "_along")).then(Commands.m_82127_((String)"x").then(Commands.m_82129_((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.doInvokeRotationCommandWithAngleArgument(func, (CommandContext<CommandSourceStack>)context, portal, new Vec3(1.0, 0.0, 0.0))))))).then(Commands.m_82127_((String)"y").then(Commands.m_82129_((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.doInvokeRotationCommandWithAngleArgument(func, (CommandContext<CommandSourceStack>)context, portal, new Vec3(0.0, 1.0, 0.0))))))).then(Commands.m_82127_((String)"z").then(Commands.m_82129_((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.doInvokeRotationCommandWithAngleArgument(func, (CommandContext<CommandSourceStack>)context, portal, new Vec3(0.0, 0.0, 1.0)))))));
    }

    private static void doInvokeRotationCommandWithAngleArgument(BiConsumer<Portal, DQuaternion> func, CommandContext<CommandSourceStack> context, Portal portal, Vec3 rotatingAxis) {
        PortalCommand.sendEditBiWayPortalWarning(context, portal);
        double angleDegrees = DoubleArgumentType.getDouble(context, (String)"angleDegrees");
        DQuaternion rot = angleDegrees != 0.0 ? DQuaternion.rotationByDegrees((Vec3)rotatingAxis, (double)((float)angleDegrees)) : null;
        func.accept(portal, rot);
        PortalCommand.reloadPortal(portal);
    }

    private static void registerCBPortalCommands(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"cb_make_portal").then(Commands.m_82129_((String)"width", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"height", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"from", (ArgumentType)EntityArgument.m_91449_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"to", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            Entity fromEntity = EntityArgument.m_91452_((CommandContext)context, (String)"from");
            Entity toEntity = EntityArgument.m_91452_((CommandContext)context, (String)"to");
            PortalCommand.invokeCbMakePortal(width, height, fromEntity, toEntity, "");
            return 0;
        })).then(Commands.m_82129_((String)"portalName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            Entity fromEntity = EntityArgument.m_91452_((CommandContext)context, (String)"from");
            Entity toEntity = EntityArgument.m_91452_((CommandContext)context, (String)"to");
            String portalName = StringArgumentType.getString((CommandContext)context, (String)"portalName");
            PortalCommand.invokeCbMakePortal(width, height, fromEntity, toEntity, portalName);
            return 0;
        })))))));
    }

    private static void invokeCbMakePortal(double width, double height, Entity fromEntity, Entity toEntity, String portalName) {
        Portal portal = (Portal)Portal.entityType.m_20615_(fromEntity.m_9236_());
        portal.m_6034_(fromEntity.m_20185_(), fromEntity.m_20186_(), fromEntity.m_20189_());
        portal.dimensionTo = toEntity.m_9236_().m_46472_();
        portal.setDestination(toEntity.m_20182_());
        portal.width = width;
        portal.height = height;
        Vec3 normal = fromEntity.m_20252_(1.0f);
        Vec3 rightVec = PortalCommand.getRightVec(fromEntity);
        Vec3 axisH = rightVec.m_82537_(normal).m_82541_();
        portal.axisW = rightVec;
        portal.axisH = axisH;
        portal.m_6593_((Component)Component.m_237113_((String)portalName));
        McHelper.spawnServerEntity(portal);
    }

    private static void registerUtilityCommands(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpme").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"target");
            IPGlobal.serverTeleportationManager.forceTeleportPlayer(((CommandSourceStack)context.getSource()).m_81375_(), (ResourceKey<Level>)entity.m_9236_().m_46472_(), entity.m_20182_());
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"imm_ptl.command.tpme.success", (Object[])new Object[]{entity.m_5446_()}), true);
            return 1;
        }))).then(Commands.m_82129_((String)"dest", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Vec3 dest = Vec3Argument.m_120844_((CommandContext)context, (String)"dest");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            IPGlobal.serverTeleportationManager.forceTeleportPlayer(player, (ResourceKey<Level>)player.m_9236_().m_46472_(), dest);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"imm_ptl.command.tpme.success", (Object[])new Object[]{dest.toString()}), true);
            return 1;
        }))).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"dest", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            ResourceKey dim = DimensionArgument.m_88808_((CommandContext)context, (String)"dim").m_46472_();
            Vec3 dest = Vec3Argument.m_120844_((CommandContext)context, (String)"dest");
            IPGlobal.serverTeleportationManager.forceTeleportPlayer(((CommandSourceStack)context.getSource()).m_81375_(), (ResourceKey<Level>)dim, dest);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"imm_ptl.command.tpme.success", (Object[])new Object[]{McHelper.dimensionTypeId((ResourceKey<Level>)dim).toString() + dest.toString()}), true);
            return 1;
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"tp").requires(commandSource -> commandSource.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"from", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"to", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            Collection entities = EntityArgument.m_91461_((CommandContext)context, (String)"from");
            Entity target = EntityArgument.m_91452_((CommandContext)context, (String)"to");
            int numTeleported = PortalCommand.teleport(entities, (ResourceKey<Level>)target.m_9236_().m_46472_(), target.m_20182_());
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"imm_ptl.command.tp.success", (Object[])new Object[]{numTeleported, target.m_5446_()}), true);
            return numTeleported;
        }))).then(Commands.m_82129_((String)"dest", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Collection entities = EntityArgument.m_91461_((CommandContext)context, (String)"from");
            Vec3 dest = Vec3Argument.m_120844_((CommandContext)context, (String)"dest");
            int numTeleported = PortalCommand.teleport(entities, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_(), dest);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"imm_ptl.command.tp.success", (Object[])new Object[]{numTeleported, dest.toString()}), true);
            return numTeleported;
        }))).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"dest", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Collection entities = EntityArgument.m_91461_((CommandContext)context, (String)"from");
            ResourceKey dim = DimensionArgument.m_88808_((CommandContext)context, (String)"dim").m_46472_();
            Vec3 dest = Vec3Argument.m_120844_((CommandContext)context, (String)"dest");
            int numTeleported = PortalCommand.teleport(entities, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_(), dest);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"imm_ptl.command.tp.success", (Object[])new Object[]{numTeleported, McHelper.dimensionTypeId((ResourceKey<Level>)dim).toString() + dest.toString()}), true);
            return numTeleported;
        })))));
        builder.then(Commands.m_82127_((String)"make_portal").then(Commands.m_82129_((String)"width", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"height", (ArgumentType)DoubleArgumentType.doubleArg()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"to", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"dest", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(PortalCommand::placePortalAbsolute))).then(Commands.m_82127_((String)"shift").then(Commands.m_82129_((String)"dist", (ArgumentType)DoubleArgumentType.doubleArg()).executes(PortalCommand::placePortalShift)))))));
        builder.then(Commands.m_82127_((String)"goback").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            WithDim<Vec3> lastPos = IPGlobal.serverTeleportationManager.lastPosition.get(player);
            if (lastPos == null) {
                PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "You haven't teleported");
            } else {
                IPGlobal.serverTeleportationManager.forceTeleportPlayer(player, (ResourceKey<Level>)lastPos.dimension(), (Vec3)lastPos.value());
            }
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"create_small_inward_wrapping").then(Commands.m_82129_((String)"p1", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"p2", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(context -> {
            Vec3 p1 = Vec3Argument.m_120844_((CommandContext)context, (String)"p1");
            Vec3 p2 = Vec3Argument.m_120844_((CommandContext)context, (String)"p2");
            AABB box = new AABB(p1, p2);
            ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
            PortalCommand.addSmallWorldWrappingPortals(box, world, true);
            return 0;
        }))));
        builder.then(Commands.m_82127_((String)"create_small_outward_wrapping").then(Commands.m_82129_((String)"p1", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"p2", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(context -> {
            Vec3 p1 = Vec3Argument.m_120844_((CommandContext)context, (String)"p1");
            Vec3 p2 = Vec3Argument.m_120844_((CommandContext)context, (String)"p2");
            AABB box = new AABB(p1, p2);
            ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
            PortalCommand.addSmallWorldWrappingPortals(box, world, false);
            return 0;
        }))));
        builder.then(Commands.m_82127_((String)"create_scaled_box_view").then(Commands.m_82129_((String)"p1", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"p2", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"placeTargetEntity", (ArgumentType)EntityArgument.m_91449_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"biWay", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            PortalCommand.invokeCreateScaledViewCommand((CommandContext<CommandSourceStack>)context, false, false, false, false, BoolArgumentType.getBool((CommandContext)context, (String)"biWay"));
            return 0;
        })).then(Commands.m_82129_((String)"teleportChangesScale", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean teleportChangesScale = BoolArgumentType.getBool((CommandContext)context, (String)"teleportChangesScale");
            PortalCommand.invokeCreateScaledViewCommand((CommandContext<CommandSourceStack>)context, teleportChangesScale, false, false, false, BoolArgumentType.getBool((CommandContext)context, (String)"biWay"));
            return 0;
        }))))))));
        builder.then(Commands.m_82127_((String)"create_scaled_box_view_optimized").then(Commands.m_82129_((String)"p1", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"p2", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"placeTargetEntity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            PortalCommand.invokeCreateScaledViewCommand((CommandContext<CommandSourceStack>)context, false, true, true, true, true);
            return 0;
        }))))));
        builder.then(Commands.m_82127_((String)"create_connected_rooms").then(Commands.m_82127_((String)"roomSize").then(Commands.m_82129_((String)"roomSize", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82127_((String)"roomNumber").then(Commands.m_82129_((String)"roomNumber", (ArgumentType)IntegerArgumentType.integer((int)2, (int)500)).executes(context -> {
            BlockPos roomSize = BlockPosArgument.m_174395_((CommandContext)context, (String)"roomSize");
            int roomNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"roomNumber");
            PortalCommand.createConnectedRooms(((CommandSourceStack)context.getSource()).m_81372_(), BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()), roomSize, roomNumber, text -> ((CommandSourceStack)context.getSource()).m_288197_(() -> text, false));
            return 0;
        }))))));
        builder.then(Commands.m_82127_((String)"create_cube_surface_unwrapping").then(Commands.m_82129_((String)"boxL", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"boxH", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"length", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(context -> {
            BlockPos boxL = BlockPosArgument.m_174395_((CommandContext)context, (String)"boxL");
            BlockPos boxH = BlockPosArgument.m_174395_((CommandContext)context, (String)"boxH");
            IntBox box = new IntBox(boxL, boxH);
            int length = IntegerArgumentType.getInteger((CommandContext)context, (String)"length");
            BlockPos size = box.getSize();
            PortalCommand.createCubeSurfaceUnwrapping(((CommandSourceStack)context.getSource()).m_81372_(), box.toRealNumberBox(), length);
            return 0;
        })))));
        builder.then(Commands.m_82127_((String)"adjust_rotation_to_connect").then(Commands.m_82129_((String)"portal1", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"portal2", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            Entity e1 = EntityArgument.m_91452_((CommandContext)context, (String)"portal1");
            Entity e2 = EntityArgument.m_91452_((CommandContext)context, (String)"portal2");
            if (!(e1 instanceof Portal)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"portal1 is not a portal entity"));
                return 0;
            }
            if (!(e2 instanceof Portal)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"portal2 is not a portal entity"));
                return 0;
            }
            Portal portal1 = (Portal)e1;
            Portal portal2 = (Portal)e2;
            portal1.setDestination(portal2.getOriginPos());
            portal2.setDestination(portal1.getOriginPos());
            PortalManipulation.adjustRotationToConnect(portal1, portal2);
            portal1.reloadAndSyncToClient();
            portal2.reloadAndSyncToClient();
            return 0;
        }))));
        builder.then(Commands.m_82127_((String)"rotate_portals_around").then(Commands.m_82129_((String)"portals", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"origin", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82129_((String)"axis", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"angle", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            Portal portal;
            Collection portals = EntityArgument.m_91461_((CommandContext)context, (String)"portals");
            Vec3 origin = Vec3Argument.m_120844_((CommandContext)context, (String)"origin");
            Vec3 axis = Vec3Argument.m_120844_((CommandContext)context, (String)"axis").m_82541_();
            double angle = DoubleArgumentType.getDouble((CommandContext)context, (String)"angle");
            DQuaternion quaternion = DQuaternion.rotationByDegrees((Vec3)axis, (double)angle);
            for (Entity entity : portals) {
                if (entity instanceof Portal) {
                    portal = (Portal)entity;
                    Vec3 offset = portal.getOriginPos().m_82546_(origin);
                    Vec3 offsetRotated = quaternion.rotate(offset);
                    portal.setOriginPos(offsetRotated.m_82549_(origin));
                    portal.axisW = quaternion.rotate(portal.axisW);
                    portal.axisH = quaternion.rotate(portal.axisH);
                    portal.setRotationTransformationD(portal.getRotationD().hamiltonProduct(quaternion.getConjugated()));
                    continue;
                }
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"the entity is not a portal"));
            }
            for (Entity entity : portals) {
                if (!(entity instanceof Portal)) continue;
                portal = (Portal)entity;
                PortalCommand.reloadPortal(portal);
            }
            return 0;
        }))))));
        builder.then(Commands.m_82127_((String)"scale_portals_relative_to_point").then(Commands.m_82129_((String)"portals", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"origin", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82129_((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            Collection portals = EntityArgument.m_91461_((CommandContext)context, (String)"portals");
            Vec3 origin = Vec3Argument.m_120844_((CommandContext)context, (String)"origin");
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            ArrayList<Portal> portalsToReload = new ArrayList<Portal>();
            for (Entity entity : portals) {
                if (entity instanceof Portal) {
                    Portal portal = (Portal)entity;
                    Vec3 offset = portal.getOriginPos().m_82546_(origin);
                    Vec3 newOrigin = offset.m_82490_(scale).m_82549_(origin);
                    PortalExtension extension = PortalExtension.get(portal);
                    if (extension.reversePortal != null) {
                        extension.reversePortal.setDestination(newOrigin);
                        extension.reversePortal.scaling /= scale;
                        portalsToReload.add(extension.reversePortal);
                        continue;
                    }
                    portal.setOriginPos(newOrigin);
                    portal.width *= scale;
                    portal.height *= scale;
                    portalsToReload.add(portal);
                    continue;
                }
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"the entity is not a portal"));
            }
            for (Portal portal : portalsToReload) {
                PortalCommand.reloadPortal(portal);
            }
            return 0;
        })))));
        builder.then(Commands.m_82127_((String)"create_diagonal_portal").then(Commands.m_82129_((String)"fromPos", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"toPos", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"axis", (ArgumentType)AxisArgumentType.instance).executes(context -> {
            Vec3 fromPos = Vec3Argument.m_120844_((CommandContext)context, (String)"fromPos");
            Vec3 toPos = Vec3Argument.m_120844_((CommandContext)context, (String)"toPos");
            Direction.Axis axis = AxisArgumentType.getAxis((CommandContext<CommandSourceStack>)context, "axis");
            Vec3 axisVec = Vec3.m_82528_((Vec3i)Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).m_122436_());
            Vec3 delta = toPos.m_82546_(fromPos);
            Vec3 vecAlongAxis = axisVec.m_82490_(delta.m_82526_(axisVec));
            Vec3 vecNotAlongAxis = delta.m_82546_(vecAlongAxis);
            Vec3 center = fromPos.m_82549_(toPos).m_82490_(0.5);
            Portal portal = (Portal)Portal.entityType.m_20615_((Level)((CommandSourceStack)context.getSource()).m_81372_());
            assert (portal != null);
            portal.setOriginPos(center);
            portal.setOrientation(vecAlongAxis.m_82541_(), vecNotAlongAxis.m_82541_());
            portal.setWidth(vecAlongAxis.m_82553_());
            portal.setHeight(vecNotAlongAxis.m_82553_());
            portal.setDestination(center.m_82520_(0.0, 10.0, 0.0));
            portal.setDestinationDimension((ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
            if (portal.width > 64.0 || portal.height > 64.0) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"portal size is too large"));
                return 0;
            }
            McHelper.spawnServerEntity(portal);
            Portal flippedPortal = PortalManipulation.createFlippedPortal(portal, Portal.entityType);
            McHelper.spawnServerEntity(flippedPortal);
            return 0;
        })))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dimension_stack").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ArrayList<String> dimIdList = new ArrayList<String>();
            for (ServerLevel world : MiscHelper.getServer().m_129785_()) {
                dimIdList.add(world.m_46472_().m_135782_().toString());
            }
            McRemoteProcedureCall.tellClientToInvoke((ServerPlayer)player, (String)"qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement.RemoteCallables.clientOpenScreen", (Object[])new Object[]{dimIdList});
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"wiki").executes(context -> {
            ((CommandSourceStack)context.getSource()).m_81375_().m_213846_((Component)McHelper.getLinkText("https://qouteall.fun/immptl/wiki/Commands-Reference"));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"create_command_stick").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).then(Commands.m_82129_((String)"command", (ArgumentType)SubCommandArgumentType.instance).executes(context -> {
            createCommandStickCommandSignal.emit((Object)((CommandSourceStack)context.getSource()).m_81375_(), (Object)SubCommandArgumentType.get(context, "command"));
            return 0;
        })));
    }

    private static void createCubeSurfaceUnwrapping(ServerLevel world, AABB box, double length) {
        Vec3 boxSize = Helper.getBoxSize((AABB)box);
        Vec3 boxCenter = box.m_82399_();
        for (Direction face : Direction.values()) {
            Vec3 facingVec = Vec3.m_82528_((Vec3i)face.m_122436_());
            for (Direction sideDirection : Helper.getAnotherFourDirections((Direction.Axis)face.m_122434_())) {
                Vec3 sideDirectionVec = Vec3.m_82528_((Vec3i)sideDirection.m_122436_());
                Vec3 edgeCenter = facingVec.m_82490_(0.5).m_82549_(sideDirectionVec.m_82490_(0.5)).m_82559_(boxSize).m_82549_(boxCenter);
                Vec3 portalOrigin = edgeCenter.m_82549_(facingVec.m_82490_(length / 2.0));
                Vec3 portalDestination = edgeCenter.m_82549_(sideDirectionVec.m_82490_(length / 2.0));
                Vec3 portalWAxis = sideDirectionVec.m_82537_(facingVec);
                Vec3 portalHAxis = facingVec;
                double width = Math.abs(boxSize.m_82526_(portalWAxis));
                double height = length;
                DQuaternion rotationTransform = DQuaternion.getRotationBetween((Vec3)facingVec, (Vec3)sideDirectionVec);
                Portal portal = (Portal)Portal.entityType.m_20615_((Level)world);
                portal.setOriginPos(portalOrigin);
                portal.setDestination(portalDestination);
                portal.setDestinationDimension((ResourceKey<Level>)world.m_46472_());
                portal.setOrientationAndSize(portalWAxis, portalHAxis, width, height);
                portal.setRotationTransformationD(rotationTransform);
                portal.setTeleportChangesGravity(true);
                portal.portalTag = "imm_ptl:cube_surface_unwrapping";
                McHelper.spawnServerEntity(portal);
            }
        }
    }

    private static void createConnectedRooms(ServerLevel world, BlockPos startingPos, BlockPos roomSize, int roomNumber, Consumer<Component> feedbackSender) {
        BlockPos roomAreaSize = roomSize.m_7918_(2, 2, 2);
        ArrayList roomAreaList = new ArrayList();
        Helper.SimpleBox currentSearchingCenter = new Helper.SimpleBox((Object)startingPos);
        IPGlobal.serverTaskList.addTask(MyTaskList.chainTask((MyTaskList.MyTask)MyTaskList.repeat((int)roomNumber, () -> MyTaskList.withDelay((int)20, (MyTaskList.MyTask)MyTaskList.oneShotTask(() -> {
            currentSearchingCenter.obj = ((BlockPos)currentSearchingCenter.obj).m_121955_((Vec3i)PortalCommand.getRandomShift(20));
            IntBox airCube = NetherPortalMatcher.findCubeAirAreaAtAnywhere(roomAreaSize.m_7918_(6, 6, 6), (LevelAccessor)world, (BlockPos)currentSearchingCenter.obj, 128);
            if (airCube == null) {
                feedbackSender.accept((Component)Component.m_237113_((String)"Cannot find space for placing room"));
                return;
            }
            airCube = airCube.getSubBoxInCenter(roomAreaSize);
            PortalCommand.fillRoomFrame(world, airCube, PortalCommand.getRandomBlock());
            roomAreaList.add(airCube);
        }))), (MyTaskList.MyTask)MyTaskList.oneShotTask(() -> {
            Stream<IntBox> roomsStream = Stream.concat(roomAreaList.stream(), Stream.of((IntBox)roomAreaList.get(0)));
            Helper.wrapAdjacentAndMap(roomsStream, Pair::new).forEach(pair -> {
                IntBox room1Area = (IntBox)pair.getFirst();
                IntBox room2Area = (IntBox)pair.getSecond();
                IntBox room1 = room1Area.getAdjusted(1, 1, 1, -1, -1, -1);
                IntBox room2 = room2Area.getAdjusted(1, 1, 1, -1, -1, -1);
                Portal portal = (Portal)Portal.entityType.m_20615_((Level)world);
                Validate.notNull((Object)portal);
                portal.setOriginPos(room1.getCenterVec().m_82520_((double)roomSize.m_123341_() / 4.0, 0.0, 0.0));
                portal.setDestinationDimension((ResourceKey<Level>)world.m_46472_());
                portal.setDestination(room2.getCenterVec().m_82520_((double)roomSize.m_123341_() / 4.0, 0.0, 0.0));
                portal.setOrientationAndSize(new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), (double)roomSize.m_123341_() / 2.0, roomSize.m_123342_());
                portal.portalTag = "imm_ptl:room_connection";
                McHelper.spawnServerEntity(portal);
                Portal reversePortal = PortalAPI.createReversePortal(portal);
                McHelper.spawnServerEntity(reversePortal);
            });
            feedbackSender.accept((Component)Component.m_237113_((String)"finished"));
        })));
    }

    private static BlockState getRandomBlock() {
        Block block;
        BlockState state;
        while (!(state = (block = (Block)((Holder.Reference)BuiltInRegistries.f_256975_.m_213642_(RandomSource.m_216327_()).get()).m_203334_()).m_49966_()).m_280296_()) {
        }
        return state;
    }

    private static void fillRoomFrame(ServerLevel world, IntBox roomArea, BlockState blockState) {
        for (Direction direction : Direction.values()) {
            IntBox surface = roomArea.getSurfaceLayer(direction);
            surface.fastStream().forEach(blockPos -> world.m_46597_(blockPos, blockState));
        }
    }

    private static void invokeCreateScaledViewCommand(CommandContext<CommandSourceStack> context, boolean teleportChangesScale, boolean outerFuseView, boolean outerRenderingMergable, boolean innerRenderingMergable, boolean isBiWay) throws CommandSyntaxException {
        BlockPos bp1 = BlockPosArgument.m_174395_(context, (String)"p1");
        BlockPos bp2 = BlockPosArgument.m_174395_(context, (String)"p2");
        IntBox intBox = new IntBox(bp1, bp2);
        Entity placeTargetEntity = EntityArgument.m_91452_(context, (String)"placeTargetEntity");
        ServerLevel boxWorld = (ServerLevel)placeTargetEntity.m_9236_();
        Vec3 boxBottomCenter = placeTargetEntity.m_20182_();
        AABB area = intBox.toRealNumberBox();
        ServerLevel areaWorld = ((CommandSourceStack)context.getSource()).m_81372_();
        double scale = DoubleArgumentType.getDouble(context, (String)"scale");
        PortalManipulation.createScaledBoxView(areaWorld, area, boxWorld, boxBottomCenter, scale, isBiWay, teleportChangesScale, outerFuseView, outerRenderingMergable, innerRenderingMergable, false);
    }

    private static void addSmallWorldWrappingPortals(AABB box, ServerLevel world, boolean isInward) {
        for (Direction direction : Direction.values()) {
            Portal portal = (Portal)Portal.entityType.m_20615_((Level)world);
            WorldWrappingPortal.initWrappingPortal(world, box, direction, isInward, portal);
            McHelper.spawnServerEntity(portal);
        }
    }

    private static int processPortalArgumentedCBCommand(CommandContext<CommandSourceStack> context, PortalConsumerThrowsCommandSyntaxException invoker) throws CommandSyntaxException {
        Collection entities = EntityArgument.m_91461_(context, (String)"portal");
        for (Entity portalEntity : entities) {
            if (portalEntity instanceof Portal) {
                Portal portal = (Portal)portalEntity;
                invoker.accept(portal);
                continue;
            }
            PortalCommand.sendMessage(context, "The target should be portal");
        }
        return 0;
    }

    private static void sendEditBiWayPortalWarning(CommandContext<CommandSourceStack> context, Portal portal) {
        if (!PortalExtension.get((Portal)portal).bindCluster && PortalManipulation.findReversePortal(portal) != null) {
            PortalCommand.sendMessage(context, "You are editing a bi-way portal. It's recommended to enable bindCluster or you will get unlinked portal entities. Use command /portal set_portal_nbt {bindCluster:true}");
        }
        if (portal instanceof BreakablePortalEntity) {
            BreakablePortalEntity breakablePortalEntity = (BreakablePortalEntity)portal;
            if (!breakablePortalEntity.unbreakable) {
                PortalCommand.sendMessage(context, "You are editing a breakable portal. It may break if its state is abnormal. It's recommended to make it unbreakable by /portal set_portal_nbt {unbreakable:true}");
            }
        }
    }

    private static void invokeCompleteBiWayBiFacedPortal(CommandContext<CommandSourceStack> context, Portal portal) {
        PortalExtension.get((Portal)portal).bindCluster = true;
        PortalCommand.reloadPortal(portal);
        PortalManipulation.completeBiWayBiFacedPortal(portal, p -> PortalCommand.sendMessage(context, "Removed " + p), p -> PortalCommand.sendMessage(context, "Added " + p), Portal.entityType);
    }

    private static void invokeCompleteBiFacedPortal(CommandContext<CommandSourceStack> context, Portal portal) {
        PortalManipulation.removeOverlappedPortals((Level)((ServerLevel)portal.m_9236_()), portal.getOriginPos(), portal.getNormal().m_82490_(-1.0), p -> Objects.equals(portal.specificPlayerId, p.specificPlayerId), p -> PortalCommand.sendMessage(context, "Removed " + p));
        PortalExtension.get((Portal)portal).bindCluster = true;
        PortalCommand.reloadPortal(portal);
        Portal result = PortalManipulation.completeBiFacedPortal(portal, Portal.entityType);
        PortalCommand.sendMessage(context, "Added " + result);
    }

    private static void invokeCompleteBiWayPortal(CommandContext<CommandSourceStack> context, Portal portal) {
        PortalManipulation.removeOverlappedPortals((Level)MiscHelper.getServer().m_129880_(portal.dimensionTo), portal.getDestPos(), portal.transformLocalVecNonScale(portal.getNormal().m_82490_(-1.0)), p -> Objects.equals(portal.specificPlayerId, p.specificPlayerId), p -> PortalCommand.sendMessage(context, "Removed " + p));
        PortalExtension.get((Portal)portal).bindCluster = true;
        PortalCommand.reloadPortal(portal);
        Portal result = PortalManipulation.completeBiWayPortal(portal, Portal.entityType);
        PortalCommand.sendMessage(context, "Added " + result);
    }

    private static void removeSpecificAccessor(CommandContext<CommandSourceStack> context, Portal portal) {
        portal.specificPlayerId = null;
        PortalCommand.sendMessage(context, "This portal can be accessed by all players now");
        PortalCommand.sendMessage(context, portal.toString());
    }

    private static void setSpecificAccessor(CommandContext<CommandSourceStack> context, Portal portal, Entity player) {
        portal.specificPlayerId = player.m_20148_();
        PortalCommand.sendMessage(context, "This portal can only be accessed by " + player.m_7755_().m_214077_() + " now");
        PortalCommand.sendMessage(context, portal.toString());
    }

    private static void removeMultidestEntry(CommandContext<CommandSourceStack> context, Portal pointedPortal, ServerPlayer player) {
        PortalManipulation.getPortalCluster(pointedPortal.m_9236_(), pointedPortal.getOriginPos(), pointedPortal.getNormal(), p -> true).stream().filter(portal -> player.m_20148_().equals(portal.specificPlayerId) || portal.specificPlayerId == null).forEach(portal -> {
            PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage(context, "removed " + p.toString()));
            PortalCommand.sendMessage(context, "removed " + portal.toString());
            portal.m_142687_(Entity.RemovalReason.KILLED);
        });
    }

    private static void setMultidestEntry(CommandContext<CommandSourceStack> context, Portal pointedPortal, ServerPlayer player, ResourceKey<Level> dimension, Vec3 destination, boolean biFaced, boolean biWay) {
        Portal newPortal = PortalManipulation.copyPortal(pointedPortal, Portal.entityType);
        PortalCommand.removeMultidestEntry(context, pointedPortal, player);
        newPortal.dimensionTo = dimension;
        newPortal.setDestination(destination);
        newPortal.specificPlayerId = player.m_20148_();
        McHelper.spawnServerEntity(newPortal);
        PortalCommand.configureBiWayBiFaced(newPortal, biWay, biFaced);
    }

    private static void configureBiWayBiFaced(Portal newPortal, boolean biWay, boolean biFaced) {
        if (biFaced && biWay) {
            PortalManipulation.completeBiWayBiFacedPortal(newPortal, p -> {}, p -> {}, Portal.entityType);
        } else if (biFaced) {
            PortalManipulation.completeBiFacedPortal(newPortal, Portal.entityType);
        } else if (biWay) {
            PortalManipulation.completeBiWayPortal(newPortal, Portal.entityType);
        }
    }

    public static void sendPortalInfo(CommandContext<CommandSourceStack> context, Portal portal) {
        PortalCommand.sendPortalInfo((Component c) -> {
            PortalCommand.sendMessage(context, c);
            Helper.log((Object)c.getString());
        }, portal);
    }

    public static void sendPortalInfo(Consumer<Component> func, Portal portal) {
        func.accept(McHelper.compoundTagToTextSorted(portal.m_20240_(new CompoundTag()), " ", 0));
        func.accept((Component)Component.m_237113_((String)portal.toString()));
        func.accept((Component)Component.m_237113_((String)String.format("Orientation: %s", PortalAPI.getPortalOrientationQuaternion(portal))));
        if (portal.getRotation() != null) {
            func.accept((Component)Component.m_237113_((String)String.format("Rotating Transformation: %s", portal.getRotation())));
        }
    }

    public static void sendMessage(CommandContext<CommandSourceStack> context, Component component) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> component, false);
    }

    public static void sendMessage(CommandContext<CommandSourceStack> context, String message) {
        PortalCommand.sendMessage(context, (Component)Component.m_237113_((String)message));
    }

    private static Component getMakePortalSuccess(Portal portal) {
        return Component.m_237110_((String)"imm_ptl.command.make_portal.success", (Object[])new Object[]{Double.toString(portal.width), Double.toString(portal.height), McHelper.dimensionTypeId((ResourceKey<Level>)portal.m_9236_().m_46472_()).toString(), portal.getOriginPos().toString(), McHelper.dimensionTypeId(portal.dimensionTo).toString(), portal.getDestPos().toString()});
    }

    private static int placePortalAbsolute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        double width = DoubleArgumentType.getDouble(context, (String)"width");
        double height = DoubleArgumentType.getDouble(context, (String)"height");
        ResourceKey to = DimensionArgument.m_88808_(context, (String)"to").m_46472_();
        Vec3 dest = Vec3Argument.m_120844_(context, (String)"dest");
        Portal portal = PortalManipulation.placePortal(width, height, (Entity)((CommandSourceStack)context.getSource()).m_81375_());
        if (portal == null) {
            return 0;
        }
        portal.dimensionTo = to;
        portal.setDestination(dest);
        McHelper.spawnServerEntity(portal);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalCommand.getMakePortalSuccess(portal), true);
        return 1;
    }

    private static int placePortalShift(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        double width = DoubleArgumentType.getDouble(context, (String)"width");
        double height = DoubleArgumentType.getDouble(context, (String)"height");
        ResourceKey to = DimensionArgument.m_88808_(context, (String)"to").m_46472_();
        double dist = DoubleArgumentType.getDouble(context, (String)"dist");
        Portal portal = PortalManipulation.placePortal(width, height, (Entity)((CommandSourceStack)context.getSource()).m_81375_());
        if (portal == null) {
            return 0;
        }
        portal.dimensionTo = to;
        portal.setDestination(portal.getOriginPos().m_82549_(portal.axisW.m_82537_(portal.axisH).m_82490_(-dist)));
        McHelper.spawnServerEntity(portal);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalCommand.getMakePortalSuccess(portal), true);
        return 1;
    }

    public static int teleport(Collection<? extends Entity> entities, ResourceKey<Level> targetDim, Vec3 targetPos) {
        ServerLevel targetWorld = MiscHelper.getServer().m_129880_(targetDim);
        int numTeleported = 0;
        for (Entity entity : entities) {
            ServerTeleportationManager.teleportEntityGeneral(entity, targetPos, targetWorld);
            ++numTeleported;
        }
        return numTeleported;
    }

    public static BlockPos getRandomShift(int len) {
        Random rand = new Random();
        return BlockPos.m_274561_((double)((rand.nextDouble() * 2.0 - 1.0) * (double)len), (double)((rand.nextDouble() * 2.0 - 1.0) * (double)len), (double)((rand.nextDouble() * 2.0 - 1.0) * (double)len));
    }

    public static int processPortalTargetedCommand(CommandContext<CommandSourceStack> context, PortalConsumerThrowsCommandSyntaxException processCommand) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Portal portal = PortalCommand.getPlayerPointingPortal(player, false);
            if (portal == null) {
                source.m_288197_(() -> Component.m_237113_((String)"You are not pointing to any non-global portal. (This command cannot process global portals)"), false);
                return 0;
            }
            processCommand.accept(portal);
        } else if (entity instanceof Portal) {
            processCommand.accept((Portal)entity);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"The command executor should be either a player or a portal entity"), false);
        }
        return 0;
    }

    @Deprecated
    public static Portal getPlayerPointingPortal(ServerPlayer player, boolean includeGlobalPortal) {
        return PortalCommand.getPlayerPointingPortalRaw((Player)player, 1.0f, 100.0, includeGlobalPortal).map(Pair::getFirst).orElse(null);
    }

    @Deprecated
    public static Optional<Pair<Portal, Vec3>> getPlayerPointingPortalRaw(Player player, float tickDelta, double maxDistance, boolean includeGlobalPortal) {
        return PortalUtils.raytracePortalFromEntityView((Entity)player, tickDelta, maxDistance, includeGlobalPortal, p -> true);
    }

    public static Optional<Pair<Portal, Vec3>> raytracePortals(Level world, Vec3 from, Vec3 to, boolean includeGlobalPortal) {
        return PortalUtils.raytracePortals(world, from, to, includeGlobalPortal, p -> true);
    }

    private static Vec3 getRightVec(Entity entity) {
        float yaw = entity.m_146908_() + 90.0f;
        float radians = -yaw * ((float)Math.PI / 180);
        return new Vec3(Math.sin(radians), 0.0, Math.cos(radians));
    }

    private static void updateEntityFullNbt(Entity entity, CompoundTag nbt) {
        nbt.m_128473_("id");
        nbt.m_128473_("UUID");
        CompoundTag result = entity.m_20240_(new CompoundTag());
        result.m_128391_(nbt);
        entity.m_20258_(result);
    }

    private static void registerEulerCommands(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"make_portal").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"origin", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"rotation", (ArgumentType)RotationArgument.m_120479_()).then(Commands.m_82129_((String)"width", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.m_82129_((String)"height", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.m_82129_((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
            Vec3 origin = Vec3Argument.m_120844_((CommandContext)context, (String)"origin");
            Vec2 rotation = RotationArgument.m_120482_((CommandContext)context, (String)"rotation").m_6970_((CommandSourceStack)context.getSource());
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
            ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
            Portal portal = (Portal)Portal.entityType.m_20615_((Level)world);
            Validate.notNull((Object)portal);
            portal.setOriginPos(origin);
            portal.setDestination(origin.m_82520_(0.0, 10.0, 0.0));
            portal.setDestinationDimension((ResourceKey<Level>)world.m_46472_());
            DQuaternion orientationRotation = DQuaternion.fromEulerAngle((Vec3)new Vec3((double)rotation.f_82470_, (double)rotation.f_82471_, 0.0));
            portal.setOrientationRotation(orientationRotation);
            portal.setWidth(width);
            portal.setHeight(height);
            portal.setScaleTransformation(scale);
            PortalCommand.updateEntityFullNbt(portal, nbt);
            McHelper.spawnServerEntity(portal);
            return 0;
        }))))))));
        builder.then(Commands.m_82127_((String)"set_orientation").then(Commands.m_82129_((String)"rotation", (ArgumentType)RotationArgument.m_120479_()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec2 rotation = RotationArgument.m_120482_((CommandContext)context, (String)"rotation").m_6970_((CommandSourceStack)context.getSource());
            DQuaternion orientationRotation = DQuaternion.fromEulerAngle((Vec3)new Vec3((double)rotation.f_82470_, (double)rotation.f_82471_, 0.0));
            portal.setOrientationRotation(orientationRotation);
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set_this_side").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"origin", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"rotation", (ArgumentType)RotationArgument.m_120479_()).then(Commands.m_82129_((String)"width", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.m_82129_((String)"height", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec3 origin = Vec3Argument.m_120844_((CommandContext)context, (String)"origin");
            Vec2 rotation = RotationArgument.m_120482_((CommandContext)context, (String)"rotation").m_6970_((CommandSourceStack)context.getSource());
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
            portal.setOriginPos(origin);
            DQuaternion orientationRotation = DQuaternion.fromEulerAngle((Vec3)new Vec3((double)rotation.f_82470_, (double)rotation.f_82471_, 0.0));
            portal.setOrientationRotation(orientationRotation);
            portal.setWidth(width);
            portal.setHeight(height);
            PortalCommand.updateEntityFullNbt(portal, nbt);
            PortalCommand.reloadPortal(portal);
        }))))))));
        builder.then(Commands.m_82127_((String)"set_other_side").then(Commands.m_82129_((String)"destination", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"rotation", (ArgumentType)RotationArgument.m_120479_()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec3 destination = Vec3Argument.m_120844_((CommandContext)context, (String)"destination");
            Vec2 rotation = RotationArgument.m_120482_((CommandContext)context, (String)"rotation").m_6970_((CommandSourceStack)context.getSource());
            portal.setDestination(destination);
            portal.setDestinationDimension((ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
            DQuaternion otherSideRotation = DQuaternion.fromEulerAngle((Vec3)new Vec3((double)rotation.f_82470_, (double)rotation.f_82471_, 0.0));
            PortalState portalState = portal.getPortalState();
            UnilateralPortalState thisSide = UnilateralPortalState.extractThisSide(portalState);
            UnilateralPortalState otherSide = UnilateralPortalState.extractOtherSide(portalState);
            UnilateralPortalState newOtherSide = new UnilateralPortalState.Builder().from(otherSide).orientation(otherSideRotation).build();
            PortalState newPortalState = UnilateralPortalState.combine(thisSide, newOtherSide);
            portal.setPortalState(newPortalState);
            PortalCommand.reloadPortal(portal);
        })))));
    }

    private static void invokeTurnIntoFakeEnterableMirror(CommandContext<CommandSourceStack> context, Portal portal) {
        if (portal instanceof Mirror) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"This command targets non-mirror portals"));
            return;
        }
        PortalState portalState = portal.getPortalState();
        assert (portalState != null);
        UnilateralPortalState thisSideState = UnilateralPortalState.extractThisSide(portalState);
        UnilateralPortalState otherSideState = UnilateralPortalState.extractOtherSide(portalState);
        Level fromWorld = portal.m_9236_();
        Level toWorld = portal.getDestinationWorld();
        @Nullable GeometryPortalShape specialShape = portal.specialShape;
        DQuaternion spacialRotation = portal.getRotationD();
        PortalManipulation.removeConnectedPortals(portal, p -> {});
        portal.m_142687_(Entity.RemovalReason.KILLED);
        Mirror thisSideMirror = (Mirror)Mirror.entityType.m_20615_(fromWorld);
        assert (thisSideMirror != null);
        thisSideMirror.dimensionTo = thisSideMirror.m_9236_().m_46472_();
        thisSideMirror.setOriginPos(thisSideState.position());
        thisSideMirror.setOrientationRotation(thisSideState.orientation());
        thisSideMirror.setDestination(thisSideState.position());
        thisSideMirror.width = thisSideState.width();
        thisSideMirror.height = thisSideState.height();
        thisSideMirror.specialShape = specialShape;
        thisSideMirror.setRotationTransformationForMirror(spacialRotation);
        Mirror otherSideMirror = (Mirror)Mirror.entityType.m_20615_(toWorld);
        assert (otherSideMirror != null);
        otherSideMirror.dimensionTo = otherSideMirror.m_9236_().m_46472_();
        otherSideMirror.setOriginPos(otherSideState.position());
        otherSideMirror.setOrientationRotation(otherSideState.orientation());
        otherSideMirror.setDestination(otherSideState.position());
        otherSideMirror.width = otherSideState.width();
        otherSideMirror.height = otherSideState.height();
        otherSideMirror.specialShape = specialShape != null ? specialShape.getFlippedWithScaling(1.0) : null;
        otherSideMirror.setRotationTransformationForMirror(spacialRotation.getConjugated());
        McHelper.spawnServerEntity(thisSideMirror);
        McHelper.spawnServerEntity(otherSideMirror);
        Portal invisiblePortal = (Portal)Portal.entityType.m_20615_(fromWorld);
        assert (invisiblePortal != null);
        invisiblePortal.dimensionTo = toWorld.m_46472_();
        invisiblePortal.setPortalState(UnilateralPortalState.combine(thisSideState, otherSideState));
        invisiblePortal.specialShape = specialShape;
        invisiblePortal.setIsVisible(false);
        invisiblePortal.setOriginPos(invisiblePortal.getOriginPos().m_82549_(portal.getNormal().m_82490_(0.001)));
        invisiblePortal.setDestination(invisiblePortal.getDestPos().m_82549_(portal.getContentDirection().m_82490_(0.001)));
        Portal reverseInvisiblePortal = PortalManipulation.createReversePortal(invisiblePortal, Portal.entityType);
        McHelper.spawnServerEntity(invisiblePortal);
        McHelper.spawnServerEntity(reverseInvisiblePortal);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"The portal has been turned into a fake enterable mirror. You need to manually make the two sides symmetric. Two invisible portal entities are generated. If you want to remove that, don't forget to remove the invisible portals."), false);
    }

    private static void invokeSculpt(CommandContext<CommandSourceStack> context, Portal portal, boolean adjustPortalBounds) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        @Nullable ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        ObjectArrayList<AABB> boxes = PortalCommand.gatherCollisionBoxesTouching(portal);
        if (boxes.size() > 40000) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Too many collision boxes to sculpt"));
            return;
        }
        if (portal.specialShape == null) {
            portal.specialShape = GeometryPortalShape.createDefault();
        }
        double halfWidth = portal.width / 2.0;
        double halfHeight = portal.height / 2.0;
        Vec3 axisW = portal.axisW;
        Vec3 axisH = portal.axisH;
        Plane plane = new Plane(portal.getOriginPos(), portal.getNormal());
        Mesh2D mesh2D = portal.specialShape.toMesh();
        double areaBefore = mesh2D.getArea() * halfWidth * halfHeight;
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            int count = 0;
            for (AABB box : boxes) {
                ObjectArrayList polygonVertexes = GeometryUtil.getSlicePolygonOfCube((AABB)box, (Plane)plane, (Vec3)axisW, (Vec3)axisH, (double)halfWidth, (double)halfHeight);
                mesh2D.subtractPolygon(polygonVertexes);
                if (++count % 10000 != 0) continue;
                mesh2D.compact();
            }
            mesh2D.simplify();
        }, Util.m_183991_());
        future.thenRun(() -> server.execute(() -> {
            if (portal.m_213877_()) {
                return;
            }
            double meshArea = mesh2D.getArea();
            double areaAfter = meshArea * halfWidth * halfHeight;
            if (Math.abs(4.0 - meshArea) < 1.0E-5) {
                portal.specialShape = null;
                if (player != null) {
                    player.m_213846_((Component)Component.m_237113_((String)"Portal shape is still rectangular now."));
                }
                return;
            }
            if (Math.abs(meshArea) < 1.0E-5) {
                if (player != null) {
                    player.m_213846_((Component)Component.m_237113_((String)"Sculpt failed because the blocks fully cover the portal."));
                }
                return;
            }
            PortalCommand.setPortalShapeByMesh(portal, mesh2D, adjustPortalBounds);
            portal.getDefaultAnimation().setDisableUntil(portal.m_9236_().m_46467_() + 5L);
            PortalCommand.reloadPortal(portal);
            if (player != null) {
                player.m_213846_((Component)Component.m_237110_((String)"imm_ptl.sculpted", (Object[])new Object[]{String.format("%.4f", areaBefore - areaAfter), String.format("%.4f", areaBefore), String.format("%.4f", areaAfter)}));
            }
        }));
        future.exceptionally(throwable -> {
            LOGGER.error("Error when sculpting portal {}", (Object)portal, throwable);
            if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)"Failed to sculpt the portal. See the server log for detail."));
            }
            return null;
        });
        IPGlobal.serverTaskList.addTask(MyTaskList.withDelay((int)5, (MyTaskList.MyTask)MyTaskList.oneShotTask(() -> {
            if (!future.isDone() && player != null) {
                player.m_213846_((Component)Component.m_237115_((String)"imm_ptl.sculpting_in_progress"));
            }
        })));
    }

    private static void setPortalShapeByMesh(Portal portal, Mesh2D mesh2D, boolean adjustPortalBounds) {
        if (adjustPortalBounds) {
            Mesh2D.Rect boundingBox = mesh2D.getBoundingBox();
            double centerLX = (boundingBox.minX() + boundingBox.maxX()) / 2.0;
            double centerLY = (boundingBox.minY() + boundingBox.maxY()) / 2.0;
            double lWidth = boundingBox.maxX() - boundingBox.minX();
            double lHeight = boundingBox.maxY() - boundingBox.minY();
            mesh2D.transformPoints(input -> new Vec2d((input.x() - centerLX) / (lWidth / 2.0), (input.y() - centerLY) / (lHeight / 2.0)));
            double oldHalfWidth = portal.width / 2.0;
            double oldHalfHeight = portal.height / 2.0;
            double newPortalWidth = oldHalfWidth * lWidth;
            double newPortalHeight = oldHalfHeight * lHeight;
            Vec3 centerOffset = portal.axisW.m_82490_(centerLX * oldHalfWidth).m_82549_(portal.axisH.m_82490_(centerLY * oldHalfHeight));
            Vec3 otherSideCenterOffset = portal.transformLocalVec(centerOffset);
            portal.setOriginPos(portal.getOriginPos().m_82549_(centerOffset));
            portal.setDestination(portal.getDestPos().m_82549_(otherSideCenterOffset));
            portal.setWidth(newPortalWidth);
            portal.setHeight(newPortalHeight);
        }
        portal.specialShape = GeometryPortalShape.fromMesh(mesh2D);
    }

    @NotNull
    private static ObjectArrayList<AABB> gatherCollisionBoxesTouching(Portal portal) {
        AABB areaBox = portal.m_20191_();
        ObjectArrayList boxes = new ObjectArrayList();
        for (VoxelShape blockCollision : portal.m_9236_().m_186434_((Entity)portal, areaBox)) {
            if (blockCollision.m_83281_()) continue;
            boxes.addAll((Collection)blockCollision.m_83299_());
        }
        return boxes;
    }

    public static interface PortalConsumerThrowsCommandSyntaxException {
        public void accept(Portal var1) throws CommandSyntaxException;
    }

    public static class RemoteCallables {
    }
}

