/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityAccess;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEEntityTracker;
import qouteall.imm_ptl.core.ducks.IEThreadedAnvilChunkStorage;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DynamicDimensionsImpl;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class EntitySync {
    private static final LimitedLogger limitedLogger = new LimitedLogger(100);

    public static void init() {
        IPGlobal.postServerTickSignal.connect(EntitySync::tick);
        DynamicDimensionsImpl.beforeRemovingDimensionSignal.connect(EntitySync::forceRemoveDimension);
    }

    private static void tick() {
        MinecraftServer server = MiscHelper.getServer();
        server.m_129905_().m_6180_("ip_entity_tracking");
        List<ServerPlayer> playerList = McHelper.getRawPlayerList();
        ArrayList<ServerPlayer> dirtyPlayers = new ArrayList<ServerPlayer>();
        for (ServerPlayer player : playerList) {
            ChunkMap storage = ((ServerLevel)player.m_9236_()).m_7726_().f_8325_;
            Int2ObjectMap<ChunkMap.TrackedEntity> entityTrackerMap = ((IEThreadedAnvilChunkStorage)storage).ip_getEntityTrackerMap();
            ChunkMap.TrackedEntity playerItselfTracker = (ChunkMap.TrackedEntity)entityTrackerMap.get(player.m_19879_());
            if (playerItselfTracker == null || !EntitySync.isDirty(playerItselfTracker)) continue;
            dirtyPlayers.add(player);
        }
        server.m_129785_().forEach(world -> {
            ChunkMap storage = world.m_7726_().f_8325_;
            Int2ObjectMap<ChunkMap.TrackedEntity> entityTrackerMap = ((IEThreadedAnvilChunkStorage)storage).ip_getEntityTrackerMap();
            PacketRedirection.withForceRedirect(world, () -> {
                for (ChunkMap.TrackedEntity tracker : entityTrackerMap.values()) {
                    ((IEEntityTracker)tracker).tickEntry();
                    boolean dirty = EntitySync.isDirty(tracker);
                    List updatedPlayerList = dirty ? playerList : dirtyPlayers;
                    for (ServerPlayer player : updatedPlayerList) {
                        ((IEEntityTracker)tracker).updateEntityTrackingStatus(player);
                    }
                    if (!dirty) continue;
                    EntitySync.markUnDirty(tracker);
                }
            });
        });
        server.m_129905_().m_7238_();
    }

    private static boolean isDirty(ChunkMap.TrackedEntity tracker) {
        SectionPos newPos = SectionPos.m_235861_((EntityAccess)((IEEntityTracker)tracker).getEntity_());
        return !((IEEntityTracker)tracker).getLastCameraPosition().equals((Object)newPos);
    }

    private static void markUnDirty(ChunkMap.TrackedEntity tracker) {
        SectionPos currPos = SectionPos.m_235861_((EntityAccess)((IEEntityTracker)tracker).getEntity_());
        ((IEEntityTracker)tracker).setLastCameraPosition(currPos);
    }

    private static void forceRemoveDimension(ResourceKey<Level> dimension) {
    }
}

