/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.chunk_loading.NewChunkTrackingGraph;
import qouteall.imm_ptl.core.ducks.IEThreadedAnvilChunkStorage;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DynamicDimensionsImpl;

public class ChunkDataSyncManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int unloadWaitingTickTime = 200;
    private static final boolean debugLightStatus = true;

    public ChunkDataSyncManager() {
        NewChunkTrackingGraph.beginWatchChunkSignal.connectWithWeakRef((Object)this, ChunkDataSyncManager::onBeginWatch);
        NewChunkTrackingGraph.endWatchChunkSignal.connectWithWeakRef((Object)this, ChunkDataSyncManager::onEndWatch);
        DynamicDimensionsImpl.beforeRemovingDimensionSignal.connectWithWeakRef((Object)this, ChunkDataSyncManager::onDimensionRemove);
    }

    private void onBeginWatch(ServerPlayer player, DimensionalChunkPos chunkPos) {
        MiscHelper.getServer().m_129905_().m_6180_("begin_watch");
        IEThreadedAnvilChunkStorage ieStorage = McHelper.getIEStorage(chunkPos.dimension);
        this.sendChunkDataPacketNow(player, chunkPos, ieStorage);
        MiscHelper.getServer().m_129905_().m_7238_();
    }

    private void sendChunkDataPacketNow(ServerPlayer player, DimensionalChunkPos chunkPos, IEThreadedAnvilChunkStorage ieStorage) {
        LevelChunk chunk;
        ChunkHolder chunkHolder = ieStorage.ip_getChunkHolder(chunkPos.getChunkPos().m_45588_());
        ThreadedLevelLightEngine lightingProvider = ieStorage.ip_getLightingProvider();
        if (chunkHolder != null && (chunk = chunkHolder.m_140085_()) != null) {
            MiscHelper.getServer().m_129905_().m_6180_("ptl_create_chunk_packet");
            PacketRedirection.sendRedirectedMessage(player, chunkPos.dimension, (Packet)new ClientboundLevelChunkWithLightPacket(chunk, (LevelLightEngine)lightingProvider, null, null));
            ieStorage.ip_updateEntityTrackersAfterSendingChunkPacket(chunk, player);
            MiscHelper.getServer().m_129905_().m_7238_();
            return;
        }
    }

    public void onChunkProvidedDeferred(LevelChunk chunk) {
        ResourceKey dimension = chunk.m_62953_().m_46472_();
        IEThreadedAnvilChunkStorage ieStorage = McHelper.getIEStorage((ResourceKey<Level>)dimension);
        ThreadedLevelLightEngine lightingProvider = ieStorage.ip_getLightingProvider();
        MiscHelper.getServer().m_129905_().m_6180_("ptl_create_chunk_packet");
        Supplier chunkDataPacketRedirected = Helper.cached(() -> PacketRedirection.createRedirectedMessage((ResourceKey<Level>)dimension, (Packet<ClientGamePacketListener>)new ClientboundLevelChunkWithLightPacket(chunk, (LevelLightEngine)lightingProvider, null, null)));
        NewChunkTrackingGraph.getPlayersViewingChunk((ResourceKey<Level>)dimension, chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_).forEach(arg_0 -> ChunkDataSyncManager.lambda$onChunkProvidedDeferred$1((Supplier)chunkDataPacketRedirected, ieStorage, chunk, arg_0));
        MiscHelper.getServer().m_129905_().m_7238_();
    }

    private void onEndWatch(ServerPlayer player, DimensionalChunkPos chunkPos) {
        player.f_8906_.m_9829_(PacketRedirection.createRedirectedMessage(chunkPos.dimension, (Packet<ClientGamePacketListener>)new ClientboundForgetLevelChunkPacket(chunkPos.x, chunkPos.z)));
    }

    public void removePlayerFromChunkTrackersAndEntityTrackers(ServerPlayer oldPlayer) {
        for (ServerLevel world : MiscHelper.getServer().m_129785_()) {
            ServerChunkCache chunkManager = world.m_7726_();
            IEThreadedAnvilChunkStorage storage = (IEThreadedAnvilChunkStorage)chunkManager.f_8325_;
            storage.ip_onPlayerUnload(oldPlayer);
        }
        NewChunkTrackingGraph.forceRemovePlayer(oldPlayer);
    }

    @Deprecated
    public void removePlayerFromEntityTrackersWithoutSendingPacket(ServerPlayer player) {
        for (ServerLevel world : MiscHelper.getServer().m_129785_()) {
            ServerChunkCache chunkManager = world.m_7726_();
            IEThreadedAnvilChunkStorage storage = (IEThreadedAnvilChunkStorage)chunkManager.f_8325_;
            storage.ip_onPlayerDisconnected(player);
        }
    }

    public void onDimensionRemove(ResourceKey<Level> dimension) {
        ServerLevel world = McHelper.getServerWorld(dimension);
        ServerChunkCache chunkManager = world.m_7726_();
        IEThreadedAnvilChunkStorage storage = (IEThreadedAnvilChunkStorage)chunkManager.f_8325_;
        storage.ip_onDimensionRemove();
        NewChunkTrackingGraph.forceRemoveDimension(dimension);
    }

    private static /* synthetic */ void lambda$onChunkProvidedDeferred$1(Supplier chunkDataPacketRedirected, IEThreadedAnvilChunkStorage ieStorage, LevelChunk chunk, ServerPlayer player) {
        player.f_8906_.m_9829_((Packet)chunkDataPacketRedirected.get());
        ieStorage.ip_updateEntityTrackersAfterSendingChunkPacket(chunk, player);
    }
}

