/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.block_manipulation;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.q_misc_util.MiscHelper;

public class BlockManipulationServer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ThreadLocal<ServerLevel> SERVER_PLAYER_INTERACTION_REDIRECT = ThreadLocal.withInitial(() -> null);
    public static final Event<Predicate<Player>> canDoCrossPortalInteractionEvent = EventFactory.createArrayBacked(Predicate.class, handlers -> player -> {
        for (Predicate handler : handlers) {
            if (handler.test(player)) continue;
            return false;
        }
        return true;
    });

    private static boolean canPlayerReach(ResourceKey<Level> dimension, ServerPlayer player, BlockPos requestPos) {
        if (!((Predicate)canDoCrossPortalInteractionEvent.invoker()).test(player)) {
            return false;
        }
        Float playerScale = Float.valueOf(PehkuiInterface.invoker.computeBlockReachScale((Entity)player));
        Vec3 pos = Vec3.m_82512_((Vec3i)requestPos);
        Vec3 playerPos = player.m_20182_();
        double distanceSquare = 576.0f * playerScale.floatValue() * playerScale.floatValue();
        if (player.m_9236_().m_46472_() == dimension && playerPos.m_82557_(pos) < distanceSquare) {
            return true;
        }
        return IPMcHelper.getNearbyPortals((Entity)player, IPGlobal.maxNormalPortalRadius).anyMatch(portal -> portal.dimensionTo == dimension && portal.isInteractableBy((Player)player) && portal.transformPoint(playerPos).m_82557_(pos) < distanceSquare * portal.getScale() * portal.getScale());
    }

    public static Tuple<BlockHitResult, ResourceKey<Level>> getHitResultForPlacing(Level world, BlockHitResult blockHitResult) {
        Direction side = blockHitResult.m_82434_();
        Vec3 sideVec = Vec3.m_82528_((Vec3i)side.m_122436_());
        Vec3 hitCenter = Vec3.m_82512_((Vec3i)blockHitResult.m_82425_());
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        Portal portal = globalPortals.stream().filter(p -> p.getNormal().m_82526_(sideVec) < -0.9 && p.isPointInPortalProjection(hitCenter) && p.getDistanceToPlane(hitCenter) < 0.6).findFirst().orElse(null);
        if (portal == null) {
            return new Tuple((Object)blockHitResult, (Object)world.m_46472_());
        }
        Vec3 newCenter = portal.transformPoint(hitCenter.m_82549_(sideVec.m_82490_(0.501)));
        BlockPos placingBlockPos = BlockPos.m_274446_((Position)newCenter);
        BlockHitResult newHitResult = new BlockHitResult(Vec3.f_82478_, side.m_122424_(), placingBlockPos, blockHitResult.m_82436_());
        return new Tuple((Object)newHitResult, portal.dimensionTo);
    }

    public static void init() {
    }

    private static void withRedirect(ServerLevel world, Runnable runnable) {
        ServerLevel original = SERVER_PLAYER_INTERACTION_REDIRECT.get();
        SERVER_PLAYER_INTERACTION_REDIRECT.set(world);
        try {
            PacketRedirection.withForceRedirect(world, runnable);
        }
        finally {
            SERVER_PLAYER_INTERACTION_REDIRECT.set(original);
        }
    }

    @IPVanillaCopy
    private static void doProcessPlayerAction(ServerLevel world, ServerPlayer player, ServerboundPlayerActionPacket packet) {
        player.m_9243_();
        BlockPos blockPos = packet.m_134281_();
        ServerboundPlayerActionPacket.Action action = packet.m_134285_();
        if (!BlockManipulationServer.canPlayerReach((ResourceKey<Level>)world.m_46472_(), player, blockPos)) {
            LOGGER.error("Reject cross-portal action {} {} {}", new Object[]{player, world, blockPos});
            return;
        }
        if (BlockManipulationServer.isAttackingAction(action)) {
            player.f_8941_.m_214168_(blockPos, action, packet.m_134284_(), world.m_151558_(), packet.m_237987_());
            player.f_8906_.m_215201_(packet.m_237987_());
        }
    }

    public static boolean isAttackingAction(ServerboundPlayerActionPacket.Action action) {
        return action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK || action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK || action == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK;
    }

    @IPVanillaCopy
    private static void doProcessUseItemOn(ServerLevel world, ServerPlayer player, ServerboundUseItemOnPacket packet) {
        player.f_8906_.m_215201_(packet.m_238008_());
        InteractionHand hand = packet.m_134703_();
        BlockHitResult blockHitResult = packet.m_134706_();
        ResourceKey dimension = world.m_46472_();
        ItemStack itemStack = player.m_21120_(hand);
        if (!itemStack.m_246617_(world.m_246046_())) {
            return;
        }
        BlockPos blockPos = blockHitResult.m_82425_();
        Direction direction = blockHitResult.m_82434_();
        player.m_9243_();
        if (world.m_7966_((Player)player, blockPos)) {
            if (!BlockManipulationServer.canPlayerReach((ResourceKey<Level>)dimension, player, blockPos)) {
                LOGGER.error("Reject cross-portal action {} {} {}", new Object[]{player, world, blockPos});
                return;
            }
            InteractionResult actionResult = player.f_8941_.m_7179_(player, (Level)world, itemStack, hand, blockHitResult);
            if (actionResult.m_19080_()) {
                player.m_21011_(hand, true);
            }
        }
        PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)dimension, (Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, blockPos));
        BlockPos offseted = blockPos.m_121945_(direction);
        if (offseted.m_123342_() >= world.m_141937_() && offseted.m_123342_() < world.m_151558_()) {
            PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)dimension, (Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, offseted));
        }
    }

    public static class RemoteCallables {
        public static void processPlayerActionPacket(ServerPlayer player, ResourceKey<Level> dimension, byte[] packetBytes) {
            FriendlyByteBuf buf = IPMcHelper.bytesToBuf(packetBytes);
            ServerboundPlayerActionPacket packet = new ServerboundPlayerActionPacket(buf);
            ServerLevel world = MiscHelper.getServer().m_129880_(dimension);
            Validate.notNull((Object)world);
            BlockManipulationServer.withRedirect(world, () -> BlockManipulationServer.doProcessPlayerAction(world, player, packet));
        }

        public static void processUseItemOnPacket(ServerPlayer player, ResourceKey<Level> dimension, byte[] packetBytes) {
            FriendlyByteBuf buf = IPMcHelper.bytesToBuf(packetBytes);
            ServerboundUseItemOnPacket packet = new ServerboundUseItemOnPacket(buf);
            ServerLevel world = MiscHelper.getServer().m_129880_(dimension);
            Validate.notNull((Object)world);
            BlockManipulationServer.withRedirect(world, () -> BlockManipulationServer.doProcessUseItemOn(world, player, packet));
        }
    }
}

