/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.q_misc_util.Helper;

public class TeleportationUtil {
    public static PortalPointVelocity getPortalPointVelocity(PortalState lastTickState, PortalState thisTickState, double localX, double localY) {
        class_243 lastThisSidePos = lastTickState.getPointOnSurface(localX, localY);
        class_243 currentThisSidePos = thisTickState.getPointOnSurface(localX, localY);
        class_243 thisSideVelocity = currentThisSidePos.method_1020(lastThisSidePos);
        class_243 lastOtherSidePos = lastTickState.transformPoint(lastThisSidePos);
        class_243 currentOtherSidePos = thisTickState.transformPoint(currentThisSidePos);
        class_243 otherSideVelocity = currentOtherSidePos.method_1020(lastOtherSidePos);
        return new PortalPointVelocity(thisSideVelocity, otherSideVelocity);
    }

    public static void transformEntityVelocity(Portal portal, class_1297 entity, PortalPointVelocity portalPointVelocity) {
        class_243 oldVelocityRelativeToPortal = McHelper.getWorldVelocity(entity).method_1020(portalPointVelocity.thisSidePointVelocity());
        class_243 transformedVelocityRelativeToPortal = portal.transformVelocityRelativeToPortal(oldVelocityRelativeToPortal, entity);
        class_243 newVelocity = transformedVelocityRelativeToPortal.method_1019(portalPointVelocity.otherSidePointVelocity());
        McHelper.setWorldVelocity(entity, newVelocity);
    }

    @Nullable
    public static Teleportation checkStaticTeleportation(Portal portal, class_243 lastPos, class_243 currentPos, class_243 lastTickEyePos, class_243 thisTickEyePos) {
        class_243 currentLocalPos;
        class_243 lastLocalPos = portal.transformFromWorldToPortalLocal(lastPos);
        CollisionInfo collisionInfo = TeleportationUtil.checkTeleportationByPortalLocalPos(portal, lastLocalPos, currentLocalPos = portal.transformFromWorldToPortalLocal(currentPos));
        if (collisionInfo == null) {
            return null;
        }
        class_243 newLastTickEyePos = portal.transformPoint(lastTickEyePos);
        class_243 newThisTickEyePos = portal.transformPoint(thisTickEyePos);
        PortalState portalState = portal.getPortalState();
        return new Teleportation(false, portal, lastPos, currentPos, collisionInfo.portalLocalX, collisionInfo.portalLocalY, collisionInfo.tOfCollision, collisionInfo.collisionPos, portalState, portalState, portalState, portalState, portalState, PortalPointVelocity.zero, portal.transformPoint(collisionInfo.collisionPos), newLastTickEyePos, newThisTickEyePos);
    }

    @Nullable
    public static Teleportation checkDynamicTeleportation(Portal portal, PortalState lastFrameState, PortalState currentFrameState, class_243 lastFrameEyePos, class_243 currentFrameEyePos, PortalState lastTickState, PortalState thisTickState, class_243 lastTickEyePos, class_243 thisTickEyePos, float partialTicks) {
        class_243 offset1;
        class_243 currentLocalPos;
        class_243 lastLocalPos = lastFrameState.worldPosToPortalLocalPos(lastFrameEyePos);
        CollisionInfo collisionInfo = TeleportationUtil.checkTeleportationByPortalLocalPos(portal, lastLocalPos, currentLocalPos = currentFrameState.worldPosToPortalLocalPos(currentFrameEyePos));
        if (collisionInfo == null) {
            return null;
        }
        double collisionLocalX = collisionInfo.portalLocalX;
        double collisionLocalY = collisionInfo.portalLocalY;
        PortalPointVelocity portalPointVelocity = TeleportationUtil.getPortalPointVelocity(lastTickState, thisTickState, collisionLocalX, collisionLocalY);
        PortalState collisionPortalState = PortalState.interpolate(lastFrameState, currentFrameState, collisionInfo.tOfCollision, false);
        class_243 collisionPointMappedToThisFrame = thisTickState.getLocalPosTransformed(collisionLocalX, collisionLocalY);
        class_243 collisionPointMappedToLastFrame = lastFrameState.getLocalPosTransformed(collisionLocalX, collisionLocalY);
        class_243 newOtherSideLastTickPos = lastTickState.transformPoint(lastTickEyePos);
        class_243 newOtherSideThisTickPos = thisTickState.transformPoint(thisTickEyePos);
        class_243 newImmediateCameraPos = newOtherSideLastTickPos.method_35590(newOtherSideThisTickPos, (double)partialTicks);
        class_243 correctImmediateCameraPos = collisionPortalState.transformPoint(currentFrameEyePos);
        class_243 deltaVelocity = portalPointVelocity.otherSidePointVelocity().method_1020(collisionPortalState.transformVec(portalPointVelocity.thisSidePointVelocity()));
        class_243 offset = correctImmediateCameraPos.method_1020(newImmediateCameraPos);
        newOtherSideLastTickPos = newOtherSideLastTickPos.method_1019(offset);
        double dot = (newOtherSideThisTickPos = newOtherSideThisTickPos.method_1019(offset)).method_1020(thisTickState.toPos).method_1026(thisTickState.getContentDirection());
        if (dot < 1.0E-5) {
            Helper.log((Object)"Teleported to behind the end-tick portal destination. Corrected.");
            offset1 = thisTickState.getContentDirection().method_1021(Math.max(-dot, 0.0) + 1.0E-5);
            newOtherSideThisTickPos = newOtherSideThisTickPos.method_1019(offset1);
            newOtherSideLastTickPos = newOtherSideLastTickPos.method_1019(offset1);
        }
        if ((dot = (newImmediateCameraPos = newOtherSideLastTickPos.method_35590(newOtherSideThisTickPos, (double)partialTicks)).method_1020(currentFrameState.toPos).method_1026(currentFrameState.getContentDirection())) < 1.0E-5) {
            Helper.log((Object)"Teleported to behind the end-frame portal destination. Corrected.");
            offset1 = currentFrameState.getContentDirection().method_1021(Math.max(-dot, 0.0) + 1.0E-5);
            newOtherSideThisTickPos = newOtherSideThisTickPos.method_1019(offset1);
            newOtherSideLastTickPos = newOtherSideLastTickPos.method_1019(offset1);
        }
        if ((dot = (newImmediateCameraPos = newOtherSideLastTickPos.method_35590(newOtherSideThisTickPos, (double)partialTicks)).method_1020(lastFrameState.toPos).method_1026(lastFrameState.getContentDirection())) < 1.0E-5) {
            Helper.log((Object)"Teleported to behind the last-frame portal destination. Corrected.");
            offset1 = lastFrameState.getContentDirection().method_1021(Math.max(-dot, 0.0) + 0.001);
            newOtherSideThisTickPos = newOtherSideThisTickPos.method_1019(offset1);
            newOtherSideLastTickPos = newOtherSideLastTickPos.method_1019(offset1);
        }
        class_243 teleportationCheckpoint = newOtherSideLastTickPos.method_35590(newOtherSideThisTickPos, (double)partialTicks);
        return new Teleportation(true, portal, lastFrameEyePos, currentFrameEyePos, collisionLocalX, collisionLocalY, collisionInfo.tOfCollision, collisionInfo.collisionPos, collisionPortalState, lastFrameState, currentFrameState, lastTickState, thisTickState, portalPointVelocity, teleportationCheckpoint, newOtherSideLastTickPos, newOtherSideThisTickPos);
    }

    @Nullable
    private static CollisionInfo checkTeleportationByPortalLocalPos(Portal portal, class_243 lastLocalPos, class_243 currentLocalPos) {
        boolean movedThrough;
        boolean bl = movedThrough = lastLocalPos.field_1350 > 0.0 && currentLocalPos.field_1350 < 0.0;
        if (!movedThrough) {
            return null;
        }
        class_243 lineOrigin = lastLocalPos;
        class_243 lineDirection = currentLocalPos.method_1020(lastLocalPos);
        double t = Helper.getCollidingT((class_243)class_243.field_1353, (class_243)new class_243(0.0, 0.0, 1.0), (class_243)lineOrigin, (class_243)lineDirection);
        Validate.isTrue((t < 1.00001 && t > -1.0E-5 ? 1 : 0) != 0);
        class_243 collidingPoint = lineOrigin.method_1019(lineDirection.method_1021(t));
        boolean inProjection = portal.isLocalXYOnPortal(collidingPoint.field_1352, collidingPoint.field_1351);
        if (inProjection) {
            return new CollisionInfo(collidingPoint.field_1352, collidingPoint.field_1351, t, portal.transformFromPortalLocalToWorld(collidingPoint));
        }
        return null;
    }

    @Deprecated
    private static PortalPointVelocity getConservativePortalPointVelocity(PortalState lastTickState, PortalState thisTickState, class_243 lastTickPos, class_243 thisTickPos) {
        List<class_243> localPoses = List.of(lastTickState.worldPosToPortalLocalPos(lastTickPos), lastTickState.worldPosToPortalLocalPos(thisTickPos), thisTickState.worldPosToPortalLocalPos(lastTickPos), thisTickState.worldPosToPortalLocalPos(thisTickPos));
        List<PortalPointVelocity> portalPointVelocities = localPoses.stream().map(localPos -> TeleportationUtil.getPortalPointVelocity(lastTickState, thisTickState, localPos.field_1352, localPos.field_1351)).toList();
        return new PortalPointVelocity(portalPointVelocities.stream().map(v -> v.thisSidePointVelocity).max(Comparator.comparingDouble(p -> p.method_1026(lastTickState.getNormal()))).orElseThrow(), portalPointVelocities.stream().map(v -> v.otherSidePointVelocity).max(Comparator.comparingDouble(p -> p.method_1026(thisTickState.getContentDirection()))).orElseThrow());
    }

    public record PortalPointVelocity(class_243 thisSidePointVelocity, class_243 otherSidePointVelocity) {
        public static final PortalPointVelocity zero = new PortalPointVelocity(class_243.field_1353, class_243.field_1353);
    }

    private record CollisionInfo(double portalLocalX, double portalLocalY, double tOfCollision, class_243 collisionPos) {
    }

    public record Teleportation(boolean isDynamic, Portal portal, class_243 lastFrameEyePos, class_243 thisFrameEyePos, double collidingPosPortalLocalX, double collidingPosPortalLocalY, double tOfCollision, class_243 collidingPos, PortalState collidingPortalState, PortalState lastFrameState, PortalState thisFrameState, PortalState lastTickState, PortalState thisTickState, PortalPointVelocity portalPointVelocity, class_243 teleportationCheckpoint, class_243 newLastTickEyePos, class_243 newThisTickEyePos) {
    }

    public record PortalPointOffset(class_243 thisSideOffset, class_243 otherSideOffse) {
    }
}

