/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.NewChunkTrackingGraph;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEServerPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEServerPlayerEntity;
import qouteall.imm_ptl.core.network.IPNetworking;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.teleportation.TeleportationUtil;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.dimension.DynamicDimensionsImpl;
import qouteall.q_misc_util.my_util.LimitedLogger;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.WithDim;

public class ServerTeleportationManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private Set<class_1297> teleportingEntities = new HashSet<class_1297>();
    private WeakHashMap<class_1297, Long> lastTeleportGameTime = new WeakHashMap();
    public boolean isFiringMyChangeDimensionEvent = false;
    public final WeakHashMap<class_3222, WithDim<class_243>> lastPosition = new WeakHashMap();
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);

    public ServerTeleportationManager() {
        IPGlobal.postServerTickSignal.connectWithWeakRef((Object)this, ServerTeleportationManager::tick);
        Portal.serverPortalTickSignal.connectWithWeakRef((Object)this, (this_, portal) -> ServerTeleportationManager.getEntitiesToTeleport(portal).forEach(entity -> this_.startTeleportingRegularEntity((Portal)portal, (class_1297)entity)));
        DynamicDimensionsImpl.beforeRemovingDimensionSignal.connect(this::evacuatePlayersFromDimension);
    }

    private void tick() {
        this.teleportingEntities.clear();
        long tickTimeNow = McHelper.getServerGameTime();
        if (tickTimeNow % 30L == 7L) {
            for (class_3222 player : McHelper.getRawPlayerList()) {
                this.updateForPlayer(tickTimeNow, player);
            }
        }
        this.manageGlobalPortalTeleportation();
    }

    public static boolean shouldEntityTeleport(Portal portal, class_1297 entity) {
        if (entity.method_37908() != portal.method_37908()) {
            return false;
        }
        if (!portal.canTeleportEntity(entity)) {
            return false;
        }
        class_243 lastEyePos = entity.method_5836(0.0f);
        class_243 nextEyePos = entity.method_5836(1.0f);
        if (entity instanceof class_1676) {
            nextEyePos = nextEyePos.method_1019(McHelper.getWorldVelocity(entity));
        }
        boolean movedThroughPortal = portal.isMovedThroughPortal(lastEyePos, nextEyePos);
        return movedThroughPortal;
    }

    public void startTeleportingRegularEntity(Portal portal, class_1297 entity) {
        if (entity instanceof class_3222) {
            return;
        }
        if (entity instanceof Portal) {
            return;
        }
        if (entity.method_5854() != null || this.doesEntityClusterContainPlayer(entity)) {
            return;
        }
        if (entity.method_31481()) {
            return;
        }
        if (!entity.method_5822()) {
            return;
        }
        if (this.isJustTeleported(entity, 1L)) {
            return;
        }
        if (entity.field_6014 == 0.0 && entity.field_6036 == 0.0 && entity.field_5969 == 0.0) {
            LOGGER.warn("Trying to teleport a fresh new entity {}", (Object)entity);
            return;
        }
        double motion = McHelper.lastTickPosOf(entity).method_1025(entity.method_19538());
        if (motion > 20.0) {
            return;
        }
        IPGlobal.serverTaskList.addTask(() -> {
            try {
                this.teleportRegularEntity(entity, portal);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return true;
        });
    }

    private static Stream<class_1297> getEntitiesToTeleport(Portal portal) {
        return portal.method_37908().method_8390(class_1297.class, portal.method_5829().method_1014(2.0), e -> true).stream().filter(e -> !(e instanceof Portal)).filter(entity -> ServerTeleportationManager.shouldEntityTeleport(portal, entity));
    }

    public void onPlayerTeleportedInClient(class_3222 player, class_5321<class_1937> dimensionBefore, class_243 oldEyePos, UUID portalId) {
        if (player.method_35049() != null) {
            Helper.err((Object)("Trying to teleport a removed player " + player));
            return;
        }
        Portal portal = this.findPortal(dimensionBefore, portalId);
        this.lastTeleportGameTime.put((class_1297)player, McHelper.getServerGameTime());
        class_243 oldFeetPos = oldEyePos.method_1020(McHelper.getEyeOffset((class_1297)player));
        if (this.canPlayerTeleport(player, dimensionBefore, oldFeetPos, portal)) {
            if (this.isTeleporting((class_1297)player)) {
                Helper.log((Object)(player.toString() + "is teleporting frequently"));
            }
            ServerTeleportationManager.notifyChasersForPlayer(player, portal);
            class_5321<class_1937> dimensionTo = portal.dimensionTo;
            class_243 newEyePos = portal.transformPoint(oldEyePos);
            this.recordLastPosition(player, dimensionBefore, oldFeetPos);
            this.teleportPlayer(player, dimensionTo, newEyePos);
            portal.onEntityTeleportedOnServer((class_1297)player);
            PehkuiInterface.invoker.onServerEntityTeleported((class_1297)player, portal);
            if (portal.getTeleportChangesGravity()) {
                class_2350 oldGravityDir = GravityChangerInterface.invoker.getGravityDirection((class_1297)player);
                GravityChangerInterface.invoker.setBaseGravityDirectionServer((class_1297)player, portal.getTransformedGravityDirection(oldGravityDir));
            }
        } else {
            Helper.err((Object)String.format("Player cannot teleport through portal %s %s %s %s", player.method_5477().method_10851(), player.method_37908().method_27983(), player.method_19538(), portal));
            ServerTeleportationManager.teleportEntityGeneral((class_1297)player, player.method_19538(), (class_3218)player.method_37908());
            PehkuiInterface.invoker.setBaseScale((class_1297)player, PehkuiInterface.invoker.getBaseScale((class_1297)player));
            GravityChangerInterface.invoker.setBaseGravityDirectionServer((class_1297)player, GravityChangerInterface.invoker.getGravityDirection((class_1297)player));
        }
    }

    private Portal findPortal(class_5321<class_1937> dimensionBefore, UUID portalId) {
        class_3218 originalWorld = MiscHelper.getServer().method_3847(dimensionBefore);
        class_1297 portalEntity = originalWorld.method_14190(portalId);
        if (portalEntity == null) {
            portalEntity = GlobalPortalStorage.get((class_3218)originalWorld).data.stream().filter(p -> p.method_5667().equals(portalId)).findFirst().orElse(null);
        }
        if (portalEntity == null) {
            return null;
        }
        if (portalEntity instanceof Portal) {
            return (Portal)portalEntity;
        }
        return null;
    }

    public void recordLastPosition(class_3222 player, class_5321<class_1937> dim, class_243 pos) {
        this.lastPosition.put(player, (WithDim<class_243>)new WithDim(dim, (Object)pos));
    }

    private boolean canPlayerTeleport(class_3222 player, class_5321<class_1937> dimensionBefore, class_243 posBefore, class_1297 portalEntity) {
        if (player.method_5854() != null) {
            return true;
        }
        if (!(portalEntity instanceof Portal)) {
            return false;
        }
        Portal portal = (Portal)portalEntity;
        return portal.canTeleportEntity((class_1297)player) && player.method_37908().method_27983() == dimensionBefore && player.method_19538().method_1025(posBefore) < 256.0 && portal.getDistanceToPlane(posBefore) < 20.0;
    }

    public static boolean canPlayerReachPos(class_3222 player, class_5321<class_1937> dimension, class_243 pos) {
        class_243 playerPos = player.method_19538();
        if (player.method_37908().method_27983() == dimension && playerPos.method_1025(pos) < 256.0) {
            return true;
        }
        return IPMcHelper.getNearbyPortals((class_1297)player, 20.0).filter(portal -> portal.dimensionTo == dimension).filter(portal -> portal.canTeleportEntity((class_1297)player)).map(portal -> portal.transformPoint(playerPos)).anyMatch(mappedPos -> mappedPos.method_1025(pos) < 256.0);
    }

    public static boolean canPlayerReachBlockEntity(class_3222 player, class_2586 blockEntity) {
        return ServerTeleportationManager.canPlayerReachPos(player, (class_5321<class_1937>)blockEntity.method_10997().method_27983(), class_243.method_24953((class_2382)blockEntity.method_11016()));
    }

    public void teleportPlayer(class_3222 player, class_5321<class_1937> dimensionTo, class_243 newEyePos) {
        MiscHelper.getServer().method_16044().method_15396("portal_teleport");
        class_3218 fromWorld = (class_3218)player.method_37908();
        class_3218 toWorld = MiscHelper.getServer().method_3847(dimensionTo);
        if (player.method_37908().method_27983() == dimensionTo) {
            McHelper.setEyePos((class_1297)player, newEyePos, newEyePos);
            McHelper.updateBoundingBox((class_1297)player);
        } else {
            this.changePlayerDimension(player, fromWorld, toWorld, newEyePos);
            ((IEServerPlayNetworkHandler)player.field_13987).cancelTeleportRequest();
        }
        McHelper.adjustVehicle((class_1297)player);
        player.field_13987.method_14372();
        MiscHelper.getServer().method_16044().method_15407();
    }

    public void forceTeleportPlayer(class_3222 player, class_5321<class_1937> dimensionTo, class_243 newPos) {
        class_3218 fromWorld = (class_3218)player.method_37908();
        class_3218 toWorld = MiscHelper.getServer().method_3847(dimensionTo);
        if (player.method_37908().method_27983() == dimensionTo) {
            player.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
        } else {
            this.changePlayerDimension(player, fromWorld, toWorld, newPos.method_1019(McHelper.getEyeOffset((class_1297)player)));
            ServerTeleportationManager.sendPositionConfirmMessage(player);
        }
        player.field_13987.method_14363(newPos.field_1352, newPos.field_1351, newPos.field_1350, player.method_36454(), player.method_36455());
        player.field_13987.method_14372();
        ((IEServerPlayNetworkHandler)player.field_13987).cancelTeleportRequest();
        NewChunkTrackingGraph.updateForPlayer(player);
    }

    private void changePlayerDimension(class_3222 player, class_3218 fromWorld, class_3218 toWorld, class_243 newEyePos) {
        this.teleportingEntities.add((class_1297)player);
        class_1297 vehicle = player.method_5854();
        if (vehicle != null) {
            ((IEServerPlayerEntity)player).stopRidingWithoutTeleportRequest();
        }
        class_243 oldPos = player.method_19538();
        fromWorld.method_18770(player, class_1297.class_5529.field_27002);
        ((IEEntity)player).ip_unsetRemoved();
        McHelper.setEyePos((class_1297)player, newEyePos, newEyePos);
        McHelper.updateBoundingBox((class_1297)player);
        player.method_51468(toWorld);
        toWorld.method_18211(player);
        if (vehicle != null) {
            class_243 offset = McHelper.getVehicleOffsetFromPassenger(vehicle, (class_1297)player);
            class_243 vehiclePos = player.method_19538().method_1019(offset);
            vehicle = this.teleportVehicleAcrossDimensions(vehicle, (class_5321<class_1937>)toWorld.method_27983(), vehiclePos.method_1019(McHelper.getEyeOffset(vehicle)));
            McHelper.setPosAndLastTickPos(vehicle, player.method_19538().method_1019(offset), McHelper.lastTickPosOf((class_1297)player).method_1019(offset));
            ((IEServerPlayerEntity)player).startRidingWithoutTeleportRequest(vehicle);
            McHelper.adjustVehicle((class_1297)player);
        }
        Helper.dbg((Object)String.format("%s :: (%s %s %s %s)->(%s %s %s %s)", player.method_5477().method_10851(), fromWorld.method_27983().method_29177(), oldPos.method_10216(), oldPos.method_10214(), oldPos.method_10215(), toWorld.method_27983().method_29177(), (int)player.method_23317(), (int)player.method_23318(), (int)player.method_23321()));
        O_O.onPlayerTravelOnServer(player, (class_5321<class_1937>)fromWorld.method_27983(), (class_5321<class_1937>)toWorld.method_27983());
        ((IEServerPlayerEntity)player).portal_worldChanged(fromWorld, oldPos);
    }

    public static void sendPositionConfirmMessage(class_3222 player) {
        class_2596 packet = IPNetworking.createStcDimensionConfirm((class_5321<class_1937>)player.method_37908().method_27983(), player.method_19538());
        player.field_13987.method_14364(packet);
    }

    private void manageGlobalPortalTeleportation() {
        for (class_3218 world : MiscHelper.getServer().method_3738()) {
            for (class_1297 entity : world.method_27909()) {
                Portal collidingPortal;
                if (entity instanceof class_3222 || (collidingPortal = ((IEEntity)entity).ip_getCollidingPortal()) == null || !collidingPortal.getIsGlobal() || !ServerTeleportationManager.shouldEntityTeleport(collidingPortal, entity)) continue;
                this.startTeleportingRegularEntity(collidingPortal, entity);
            }
        }
    }

    private void updateForPlayer(long tickTimeNow, class_3222 player) {
        if (player.field_13989 || player.method_14208()) {
            this.lastTeleportGameTime.put((class_1297)player, tickTimeNow);
            return;
        }
        Long lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(player, 0L);
        if (tickTimeNow - lastTeleportGameTime > 60L) {
            ServerTeleportationManager.sendPositionConfirmMessage(player);
            player.method_14240();
        } else {
            ((IEServerPlayNetworkHandler)player.field_13987).cancelTeleportRequest();
        }
    }

    public boolean isTeleporting(class_1297 entity) {
        return this.teleportingEntities.contains(entity);
    }

    private void teleportRegularEntity(class_1297 entity, Portal portal) {
        Long lastTeleportGameTime;
        Validate.isTrue((!(entity instanceof class_3222) ? 1 : 0) != 0);
        if (entity.method_35049() != null) {
            Helper.err((Object)String.format("Trying to teleport an entity that is already removed %s %s", entity, portal));
            return;
        }
        if (entity.method_37908() != portal.method_37908()) {
            Helper.err((Object)String.format("Cannot teleport %s from %s through %s", entity, entity.method_37908().method_27983(), portal));
            return;
        }
        if (portal.getDistanceToNearestPointInPortal(entity.method_33571()) > 5.0) {
            Helper.err((Object)("Entity is too far to teleport " + entity + portal));
            return;
        }
        long currGameTime = McHelper.getServerGameTime();
        if (currGameTime - (lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(entity, 0L)) <= 0L) {
            return;
        }
        this.lastTeleportGameTime.put(entity, currGameTime);
        if (entity.method_5765() || this.doesEntityClusterContainPlayer(entity)) {
            return;
        }
        class_243 velocity = entity.method_18798();
        List passengerList = entity.method_5685();
        class_243 newEyePos = ServerTeleportationManager.getRegularEntityTeleportedEyePos(entity, portal);
        TeleportationUtil.transformEntityVelocity(portal, entity, TeleportationUtil.PortalPointVelocity.zero);
        if (portal.dimensionTo != entity.method_37908().method_27983()) {
            class_1297 newEntity = entity = this.changeEntityDimension(entity, portal.dimensionTo, newEyePos, true);
            passengerList.stream().map(e -> this.changeEntityDimension((class_1297)e, portal.dimensionTo, newEyePos, true)).collect(Collectors.toList()).forEach(e -> e.method_5873(newEntity, true));
        }
        McHelper.setEyePos(entity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(entity);
        McHelper.sendToTrackers(entity, McRemoteProcedureCall.createPacketToSendToClient((String)"qouteall.imm_ptl.core.teleportation.ClientTeleportationManager.RemoteCallables.updateEntityPos", (Object[])new Object[]{entity.method_37908().method_27983(), entity.method_5628(), entity.method_19538()}));
        portal.onEntityTeleportedOnServer(entity);
        PehkuiInterface.invoker.onServerEntityTeleported(entity, portal);
        this.lastTeleportGameTime.put(entity, currGameTime);
    }

    private static class_243 getRegularEntityTeleportedEyePos(class_1297 entity, Portal portal) {
        class_243 eyePosLastTick;
        class_243 deltaMovement;
        class_243 deltaMovementDirection;
        class_243 eyePosThisTick = McHelper.getEyePos(entity);
        class_243 collidingPoint = portal.rayTrace(eyePosThisTick.method_1020((deltaMovementDirection = (deltaMovement = eyePosThisTick.method_1020(eyePosLastTick = McHelper.getLastTickEyePos(entity))).method_1029()).method_1021(5.0)), eyePosThisTick.method_1019(deltaMovementDirection));
        if (collidingPoint == null) {
            collidingPoint = portal.getPointProjectedToPlane(eyePosThisTick);
        }
        class_243 result = portal.transformPoint(collidingPoint).method_1019(portal.getContentDirection().method_1021(0.05));
        return result;
    }

    public class_1297 changeEntityDimension(class_1297 entity, class_5321<class_1937> toDimension, class_243 newEyePos, boolean recreateEntity) {
        if (entity.method_35049() != null) {
            Helper.err((Object)("Trying to teleport a removed entity " + entity));
            new Throwable().printStackTrace();
            return entity;
        }
        class_3218 fromWorld = (class_3218)entity.method_37908();
        class_3218 toWorld = MiscHelper.getServer().method_3847(toDimension);
        entity.method_18375();
        if (recreateEntity) {
            class_1297 oldEntity = entity;
            class_1297 newEntity = entity.method_5864().method_5883((class_1937)toWorld);
            if (newEntity == null) {
                return oldEntity;
            }
            newEntity.method_5878(oldEntity);
            newEntity.method_5838(oldEntity.method_5628());
            McHelper.setEyePos(newEntity, newEyePos, newEyePos);
            McHelper.updateBoundingBox(newEntity);
            newEntity.method_5847(oldEntity.method_5791());
            oldEntity.method_5650(class_1297.class_5529.field_27002);
            ((IEEntity)oldEntity).ip_unsetRemoved();
            toWorld.method_18769(newEntity);
            return newEntity;
        }
        entity.method_5650(class_1297.class_5529.field_27002);
        ((IEEntity)entity).ip_unsetRemoved();
        McHelper.setEyePos(entity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(entity);
        ((IEEntity)entity).ip_setWorld((class_1937)toWorld);
        toWorld.method_18769(entity);
        Validate.isTrue((!entity.method_31481() ? 1 : 0) != 0);
        return entity;
    }

    public class_1297 teleportVehicleAcrossDimensions(class_1297 entity, class_5321<class_1937> toDimension, class_243 newEyePos) {
        this.teleportingEntities.add(entity);
        class_3218 fromWorld = (class_3218)entity.method_37908();
        class_3218 toWorld = MiscHelper.getServer().method_3847(toDimension);
        class_1297 oldEntity = entity;
        class_1297 newEntity = entity.method_5864().method_5883((class_1937)toWorld);
        Validate.isTrue((newEntity != null ? 1 : 0) != 0);
        newEntity.method_5878(oldEntity);
        newEntity.method_5838(oldEntity.method_5628());
        McHelper.setEyePos(newEntity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(newEntity);
        newEntity.method_5847(oldEntity.method_5791());
        oldEntity.method_5650(class_1297.class_5529.field_27002);
        ((IEEntity)oldEntity).ip_unsetRemoved();
        toWorld.method_18769(newEntity);
        return newEntity;
    }

    private boolean doesEntityClusterContainPlayer(class_1297 entity) {
        if (entity instanceof class_1657) {
            return true;
        }
        List passengerList = entity.method_5685();
        if (passengerList.isEmpty()) {
            return false;
        }
        return passengerList.stream().anyMatch(this::doesEntityClusterContainPlayer);
    }

    public boolean isJustTeleported(class_1297 entity, long valveTickTime) {
        Long lastTeleportGameTime;
        long currGameTime = McHelper.getServerGameTime();
        return currGameTime - (lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(entity, -100000L)) < valveTickTime;
    }

    @Deprecated
    public void acceptDubiousMovePacket(class_3222 player, class_2828 packet, class_5321<class_1937> dimension) {
        double z;
        double y;
        if (player.method_37908().method_27983() == dimension) {
            return;
        }
        if (player.method_35049() != null) {
            return;
        }
        double x = packet.method_12269(player.method_23317());
        class_243 newPos = new class_243(x, y = packet.method_12268(player.method_23318()), z = packet.method_12274(player.method_23321()));
        if (ServerTeleportationManager.canPlayerReachPos(player, dimension, newPos)) {
            this.forceTeleportPlayer(player, dimension, newPos);
            limitedLogger.lInfo(LOGGER, "accepted dubious move packet {} {} {} {} {} {} {}", new Object[]{player.method_37908().method_27983().method_29177(), x, y, z, player.method_23317(), player.method_23318(), player.method_23321()});
        } else {
            limitedLogger.lInfo(LOGGER, "ignored dubious move packet {} {} {} {} {} {} {}", new Object[]{player.method_37908().method_27983().method_29177(), x, y, z, player.method_23317(), player.method_23318(), player.method_23321()});
        }
    }

    public static void teleportEntityGeneral(class_1297 entity, class_243 targetPos, class_3218 targetWorld) {
        if (entity instanceof class_3222) {
            IPGlobal.serverTeleportationManager.forceTeleportPlayer((class_3222)entity, (class_5321<class_1937>)targetWorld.method_27983(), targetPos);
        } else {
            ServerTeleportationManager.teleportRegularEntityTo(entity, (class_5321<class_1937>)targetWorld.method_27983(), targetPos);
        }
    }

    public static <E extends class_1297> E teleportRegularEntityTo(E entity, class_5321<class_1937> targetDim, class_243 targetPos) {
        if (entity.method_37908().method_27983() == targetDim) {
            entity.method_5808(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, entity.method_36454(), entity.method_36455());
            entity.method_5847(entity.method_36454());
            return entity;
        }
        return (E)IPGlobal.serverTeleportationManager.changeEntityDimension(entity, targetDim, targetPos.method_1019(McHelper.getEyeOffset(entity)), true);
    }

    private static void notifyChasersForPlayer(class_3222 player, Portal portal) {
        List<class_1308> chasers = McHelper.findEntitiesRough(class_1308.class, player.method_37908(), player.method_19538(), 1, e -> e.method_5968() == player);
        for (class_1308 chaser : chasers) {
            chaser.method_5980(null);
            ServerTeleportationManager.notifyChaser(player, portal, chaser);
        }
    }

    private static void notifyChaser(class_3222 player, Portal portal, class_1308 chaser) {
        class_243 targetPos = player.method_19538().method_1019(portal.getNormal().method_1021(-0.1));
        UUID chaserId = chaser.method_5667();
        class_3218 destWorld = (class_3218)portal.getDestinationWorld();
        IPGlobal.serverTaskList.addTask(MyTaskList.withRetryNumberLimit((int)140, () -> {
            if (chaser.method_31481()) {
                class_1297 newChaser = destWorld.method_14190(chaserId);
                if (newChaser instanceof class_1308) {
                    ((class_1308)newChaser).method_5980((class_1309)player);
                    return true;
                }
                return false;
            }
            if (chaser.method_19538().method_1022(targetPos) < 2.0) {
                chaser.method_5962().method_6239(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 1.0);
            } else {
                @Nullable class_11 path = chaser.method_5942().method_6348(class_2338.method_49638((class_2374)targetPos), 0);
                chaser.method_5942().method_6334(path, 1.0);
            }
            return false;
        }, () -> {}));
    }

    private void evacuatePlayersFromDimension(class_5321<class_1937> dim) {
        class_3324 playerList = MiscHelper.getServer().method_3760();
        for (class_3222 player : playerList.method_14571()) {
            if (player.method_37908().method_27983() != dim) continue;
            class_3218 overWorld = McHelper.getOverWorldOnServer();
            class_2338 spawnPos = overWorld.method_43126();
            this.forceTeleportPlayer(player, (class_5321<class_1937>)class_1937.field_25179, class_243.method_24953((class_2382)spawnPos));
            player.method_43496((class_2561)class_2561.method_43470((String)"Teleported to spawn pos because dimension %s had been removed".formatted(dim.method_29177())));
        }
    }
}

