/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.collision.CollisionHelper;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.ducks.IEAbstractClientPlayer;
import qouteall.imm_ptl.core.ducks.IEClientPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.ducks.IEParticleManager;
import qouteall.imm_ptl.core.network.IPNetworkingClient;
import qouteall.imm_ptl.core.network.PacketRedirectionClient;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.FogRendererContext;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.imm_ptl.core.teleportation.TeleportationUtil;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.Vec2d;

@Environment(value=EnvType.CLIENT)
public class ClientTeleportationManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_310 client = class_310.method_1551();
    public static long tickTimeForTeleportation = 0L;
    private static long lastTeleportGameTime = 0L;
    private static long teleportTickTimeLimit = 0L;
    private static class_243 lastPlayerEyePos = null;
    private static long lastRecordStableTickTime = 0L;
    private static float lastRecordStablePartialTicks = 0.0f;
    public static boolean isTeleportingTick = false;
    public static boolean isTeleportingFrame = false;
    public static boolean isTicking = false;
    private static final int teleportLimitPerFrame = 2;
    private static long teleportationCounter = 0L;

    public static void init() {
        IPGlobal.postClientTickSignal.connect(ClientTeleportationManager::tick);
        IPGlobal.clientCleanupSignal.connect(() -> {
            lastPlayerEyePos = null;
        });
    }

    private static void tick() {
        ++tickTimeForTeleportation;
        ClientTeleportationManager.changePlayerMotionIfCollidingWithPortal();
        isTeleportingTick = false;
    }

    public static void acceptSynchronizationDataFromServer(class_5321<class_1937> dimension, class_243 pos, boolean forceAccept) {
        if (!forceAccept) {
            if (ClientTeleportationManager.isTeleportingFrequently()) {
                return;
            }
            if (ClientTeleportationManager.client.field_1724.field_6012 < 200) {
                return;
            }
        }
        if (ClientTeleportationManager.client.field_1724.method_37908().method_27983() != dimension) {
            ClientTeleportationManager.forceTeleportPlayer(dimension, pos);
        }
    }

    public static void manageTeleportation(boolean isTicking_) {
        if (IPGlobal.disableTeleportation) {
            return;
        }
        isTicking = isTicking_;
        ++teleportationCounter;
        isTeleportingFrame = false;
        if (ClientTeleportationManager.client.field_1687 == null || ClientTeleportationManager.client.field_1724 == null) {
            lastPlayerEyePos = null;
            return;
        }
        if (ClientTeleportationManager.client.field_1724.field_6014 == 0.0 && ClientTeleportationManager.client.field_1724.field_6036 == 0.0 && ClientTeleportationManager.client.field_1724.field_5969 == 0.0) {
            return;
        }
        client.method_16011().method_15396("ip_teleport");
        ClientPortalAnimationManagement.foreachCustomAnimatedPortals(portal -> PortalExtension.forClusterPortals(portal, p -> p.animation.updateClientState((Portal)p, teleportationCounter)));
        float realPartialTicks = RenderStates.getPartialTick();
        TeleportationUtil.Teleportation lastTeleportation = null;
        if (lastPlayerEyePos != null) {
            TeleportationUtil.Teleportation teleportation;
            for (int i = 0; i < 2 && (teleportation = ClientTeleportationManager.tryTeleport(realPartialTicks)) != null; ++i) {
                lastTeleportation = teleportation;
                if (i == 0) continue;
                Helper.log((Object)"The client player made a combo-teleport");
            }
        }
        if (lastTeleportation != null && PortalExtension.get((Portal)lastTeleportation.portal()).adjustPositionAfterTeleport) {
            ClientTeleportationManager.adjustPlayerPosition(ClientTeleportationManager.client.field_1724);
        }
        lastPlayerEyePos = ClientTeleportationManager.getPlayerEyePos(realPartialTicks);
        lastRecordStableTickTime = StableClientTimer.getStableTickTime();
        lastRecordStablePartialTicks = StableClientTimer.getStablePartialTicks();
        client.method_16011().method_15407();
    }

    @Nullable
    private static TeleportationUtil.Teleportation tryTeleport(float partialTicks) {
        class_746 player = ClientTeleportationManager.client.field_1724;
        assert (player != null);
        class_243 thisFrameEyePos = ClientTeleportationManager.getPlayerEyePos(partialTicks);
        if (lastPlayerEyePos.method_1025(thisFrameEyePos) > 1600.0) {
            return null;
        }
        assert (ClientTeleportationManager.client.field_1687 != null);
        long currentGameTime = ClientTeleportationManager.client.field_1687.method_8510();
        class_243 lastTickEyePos = McHelper.getLastTickEyePos((class_1297)player);
        class_243 thisTickEyePos = McHelper.getEyePos((class_1297)player);
        ArrayList teleportationCandidates = new ArrayList();
        IPMcHelper.traverseNearbyPortals(player.method_37908(), thisFrameEyePos, IPGlobal.maxNormalPortalRadius, portal -> {
            if (!portal.canTeleportEntity((class_1297)player)) {
                return;
            }
            if (portal.animation.clientLastFramePortalStateCounter == teleportationCounter - 1L && portal.animation.clientLastFramePortalState != null && portal.animation.lastTickAnimatedState != null && portal.animation.thisTickAnimatedState != null) {
                assert (portal.animation.clientCurrentFramePortalState != null);
                TeleportationUtil.Teleportation teleportation = TeleportationUtil.checkDynamicTeleportation(portal, portal.animation.clientLastFramePortalState, portal.animation.clientCurrentFramePortalState, lastPlayerEyePos, thisFrameEyePos, portal.animation.lastTickAnimatedState, portal.animation.thisTickAnimatedState, lastTickEyePos, thisTickEyePos, partialTicks);
                if (teleportation != null) {
                    teleportationCandidates.add(teleportation);
                }
            } else {
                TeleportationUtil.Teleportation teleportation = TeleportationUtil.checkStaticTeleportation(portal, lastPlayerEyePos, thisFrameEyePos, lastTickEyePos, thisTickEyePos);
                if (teleportation != null) {
                    teleportationCandidates.add(teleportation);
                }
            }
        });
        TeleportationUtil.Teleportation teleportation = teleportationCandidates.stream().min(Comparator.comparingDouble(p -> p.collidingPos().method_1025(lastPlayerEyePos))).orElse(null);
        if (teleportation != null) {
            Portal portal2 = teleportation.portal();
            class_243 collidingPos = teleportation.collidingPos();
            client.method_16011().method_15396("portal_teleport");
            ClientTeleportationManager.teleportPlayer(teleportation, partialTicks);
            client.method_16011().method_15407();
            boolean allowOverlappedTeleport = portal2.respectParallelOrientedPortal();
            double adjustment = allowOverlappedTeleport ? -0.001 : 0.001;
            lastPlayerEyePos = teleportation.teleportationCheckpoint().method_1019(portal2.getContentDirection().method_1021(adjustment));
            return teleportation;
        }
        return null;
    }

    public static class_243 getPlayerEyePos(float partialTick) {
        return ClientTeleportationManager.client.field_1724.method_5836(partialTick);
    }

    private static void teleportPlayer(TeleportationUtil.Teleportation teleportation, float partialTicks) {
        Portal portal = teleportation.portal();
        if (tickTimeForTeleportation <= teleportTickTimeLimit) {
            Helper.log((Object)"Client player teleportation rejected");
            return;
        }
        lastTeleportGameTime = tickTimeForTeleportation;
        class_746 player = ClientTeleportationManager.client.field_1724;
        Validate.isTrue((player != null ? 1 : 0) != 0);
        class_5321<class_1937> toDimension = portal.dimensionTo;
        float tickDelta = RenderStates.getPartialTick();
        class_243 thisTickEyePos = McHelper.getEyePos((class_1297)player);
        class_243 lastTickEyePos = McHelper.getLastTickEyePos((class_1297)player);
        class_243 newThisTickEyePos = teleportation.newThisTickEyePos();
        class_243 newLastTickEyePos = teleportation.newLastTickEyePos();
        class_638 fromWorld = ClientTeleportationManager.client.field_1687;
        class_5321 fromDimension = fromWorld.method_27983();
        if (fromDimension != toDimension) {
            class_638 toWorld = ClientWorldLoader.getWorld(toDimension);
            ClientTeleportationManager.changePlayerDimension(player, fromWorld, toWorld, newThisTickEyePos);
        }
        class_243 oldRealVelocity = McHelper.getWorldVelocity((class_1297)player);
        TransformationManager.managePlayerRotationAndChangeGravity(portal);
        McHelper.setWorldVelocity((class_1297)player, oldRealVelocity);
        TeleportationUtil.PortalPointVelocity portalPointVelocity = teleportation.portalPointVelocity();
        TeleportationUtil.transformEntityVelocity(portal, (class_1297)player, portalPointVelocity);
        if (player.method_5854() != null) {
            TeleportationUtil.transformEntityVelocity(portal, player.method_5854(), portalPointVelocity);
        }
        McHelper.setEyePos((class_1297)player, newThisTickEyePos, newLastTickEyePos);
        McHelper.updateBoundingBox((class_1297)player);
        PehkuiInterface.invoker.onClientPlayerTeleported(portal);
        player.field_3944.method_2883(IPNetworkingClient.createCtsTeleport((class_5321<class_1937>)fromDimension, lastTickEyePos, portal.method_5667()));
        PortalCollisionHandler.updateCollidingPortalAfterTeleportation((class_1297)player, newThisTickEyePos, newLastTickEyePos, RenderStates.getPartialTick());
        McHelper.adjustVehicle((class_1297)player);
        RenderStates.updatePreRenderInfo(tickDelta);
        if (teleportation.isDynamic()) {
            LOGGER.info("Client Teleported Dynamically\nportal: {}\ntickTime: {}\nduring ticking: {}\ncounter: {}\neye pos (by frame): {} -> {}\npartial ticks: {}\nnew immediate eye pos: {}\nportal origin/normal: {} {}\nportal dest/content dir: {} {}", new Object[]{portal, tickTimeForTeleportation, isTicking, teleportationCounter, teleportation.lastFrameEyePos(), teleportation.thisFrameEyePos(), Float.valueOf(partialTicks), teleportation.newLastTickEyePos().method_35590(teleportation.newThisTickEyePos(), (double)tickDelta), portal.getOriginPos(), portal.getNormal(), portal.getDestPos(), portal.getContentDirection()});
        } else {
            LOGGER.info("Client Teleported Statically\nportal: {}\neye pos: {} -> {}", new Object[]{portal, teleportation.lastFrameEyePos(), teleportation.thisFrameEyePos()});
        }
        isTeleportingTick = true;
        isTeleportingFrame = true;
        MyGameRenderer.vanillaTerrainSetupOverride = 1;
    }

    public static boolean isTeleportingFrequently() {
        return tickTimeForTeleportation - lastTeleportGameTime <= 100L || tickTimeForTeleportation <= teleportTickTimeLimit;
    }

    public static void forceTeleportPlayer(class_5321<class_1937> toDimension, class_243 destination) {
        LOGGER.info("client player force teleported {} {}", toDimension, (Object)destination);
        class_638 fromWorld = ClientTeleportationManager.client.field_1687;
        class_5321 fromDimension = fromWorld.method_27983();
        class_746 player = ClientTeleportationManager.client.field_1724;
        assert (player != null);
        if (fromDimension != toDimension) {
            class_638 toWorld = ClientWorldLoader.getWorld(toDimension);
            class_243 eyeOffset = McHelper.getEyeOffset((class_1297)player);
            ClientTeleportationManager.changePlayerDimension(player, fromWorld, toWorld, destination.method_1019(eyeOffset));
        }
        player.method_5814(destination.field_1352, destination.field_1351, destination.field_1350);
        McHelper.adjustVehicle((class_1297)player);
        lastPlayerEyePos = null;
        RenderStates.updatePreRenderInfo(RenderStates.getPartialTick());
        MyGameRenderer.vanillaTerrainSetupOverride = 1;
    }

    public static void changePlayerDimension(class_746 player, class_638 fromWorld, class_638 toWorld, class_243 newEyePos) {
        Validate.isTrue((!WorldRenderInfo.isRendering() ? 1 : 0) != 0);
        Validate.isTrue((!FrontClipping.isClippingEnabled ? 1 : 0) != 0);
        Validate.isTrue((!PacketRedirectionClient.getIsProcessingRedirectedMessage() ? 1 : 0) != 0);
        class_1297 vehicle = player.method_5854();
        player.method_18375();
        class_5321 toDimension = toWorld.method_27983();
        class_5321 fromDimension = fromWorld.method_27983();
        ((IEClientPlayNetworkHandler)client.method_1562()).ip_setWorld(toWorld);
        fromWorld.method_2945(player.method_5628(), class_1297.class_5529.field_27002);
        ((IEEntity)player).ip_setWorld((class_1937)toWorld);
        McHelper.setEyePos((class_1297)player, newEyePos, newEyePos);
        McHelper.updateBoundingBox((class_1297)player);
        ((IEEntity)player).ip_unsetRemoved();
        toWorld.method_18107(player.method_5628(), (class_742)player);
        ((IEAbstractClientPlayer)player).ip_setClientLevel(toWorld);
        IEGameRenderer gameRenderer = (IEGameRenderer)class_310.method_1551().field_1773;
        gameRenderer.setLightmapTextureManager(ClientWorldLoader.getDimensionRenderHelper((class_5321<class_1937>)toDimension).lightmapTexture);
        ClientTeleportationManager.client.field_1687 = toWorld;
        ((IEMinecraftClient)client).setWorldRenderer(ClientWorldLoader.getWorldRenderer((class_5321<class_1937>)toDimension));
        toWorld.method_2944(fromWorld.method_8428());
        if (ClientTeleportationManager.client.field_1713 != null) {
            ((IEParticleManager)ClientTeleportationManager.client.field_1713).ip_setWorld(toWorld);
        }
        client.method_31975().method_3551((class_1937)toWorld);
        if (vehicle != null) {
            class_243 offset = McHelper.getVehicleOffsetFromPassenger(vehicle, (class_1297)player);
            class_243 vehiclePos = player.method_19538().method_1019(offset);
            ClientTeleportationManager.moveClientEntityAcrossDimension(vehicle, toWorld, vehiclePos);
            McHelper.setPosAndLastTickPos(vehicle, player.method_19538().method_1019(offset), McHelper.lastTickPosOf((class_1297)player).method_1019(offset));
            player.method_5873(vehicle, true);
        }
        Helper.log((Object)String.format("Client Changed Dimension from %s to %s time: %s age: %s", fromDimension.method_29177(), toDimension.method_29177(), tickTimeForTeleportation, player.field_6012));
        FogRendererContext.onPlayerTeleport((class_5321<class_1937>)fromDimension, (class_5321<class_1937>)toDimension);
        O_O.onPlayerChangeDimensionClient((class_5321<class_1937>)fromDimension, (class_5321<class_1937>)toDimension);
    }

    private static void changePlayerMotionIfCollidingWithPortal() {
        class_746 player = ClientTeleportationManager.client.field_1724;
        Portal portal = ((IEEntity)player).ip_getCollidingPortal();
        if (portal != null) {
            if (PortalExtension.get((Portal)portal).motionAffinity > 0.0) {
                ClientTeleportationManager.changeMotion((class_1297)player, portal);
            } else if (PortalExtension.get((Portal)portal).motionAffinity < 0.0 && player.method_18798().method_1033() > 0.7) {
                ClientTeleportationManager.changeMotion((class_1297)player, portal);
            }
        }
    }

    private static void changeMotion(class_1297 player, Portal portal) {
        class_243 velocity = player.method_18798();
        player.method_18799(velocity.method_1021(1.0 + PortalExtension.get((Portal)portal).motionAffinity));
    }

    public static void moveClientEntityAcrossDimension(class_1297 entity, class_638 newWorld, class_243 newPos) {
        class_638 oldWorld = (class_638)entity.method_37908();
        oldWorld.method_2945(entity.method_5628(), class_1297.class_5529.field_27002);
        ((IEEntity)entity).ip_setWorld((class_1937)newWorld);
        entity.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
        ((IEEntity)entity).ip_unsetRemoved();
        newWorld.method_2942(entity.method_5628(), entity);
        Validate.isTrue((!entity.method_31481() ? 1 : 0) != 0);
    }

    public static void disableTeleportFor(int ticks) {
        teleportTickTimeLimit = tickTimeForTeleportation + (long)ticks;
    }

    private static void adjustPlayerPosition(class_746 player) {
        Function<class_265, class_265> shapeFilter;
        if (player.method_7325()) {
            return;
        }
        if (player.method_5854() != null) {
            return;
        }
        class_238 playerBoundingBox = player.method_5829();
        PortalCollisionHandler portalCollisionHandler = ((IEEntity)player).ip_getPortalCollisionHandler();
        List<Object> collidingPortals = portalCollisionHandler == null ? Collections.emptyList() : portalCollisionHandler.getCollidingPortals();
        class_2350 gravityDir = GravityChangerInterface.invoker.getGravityDirection((class_1297)player);
        class_2350 levitationDir = gravityDir.method_10153();
        class_243 eyeOffset = GravityChangerInterface.invoker.getEyeOffset((class_1297)player);
        class_238 bottomHalfBox = playerBoundingBox.method_1002(eyeOffset.field_1352 / 2.0, eyeOffset.field_1351 / 2.0, eyeOffset.field_1350 / 2.0);
        class_238 collisionUnion = CollisionHelper.getTotalBlockCollisionBox((class_1297)player, bottomHalfBox, shapeFilter = c -> {
            class_265 curr = c;
            for (Portal collidingPortal : collidingPortals) {
                if ((curr = CollisionHelper.clipVoxelShape(curr, collidingPortal.getOriginPos(), collidingPortal.getNormal())) != null) continue;
                return null;
            }
            return curr;
        });
        if (collisionUnion == null) {
            return;
        }
        class_243 anchor = player.method_19538();
        class_238 collisionUnionLocal = Helper.transformBox((class_238)collisionUnion, v -> GravityChangerInterface.invoker.transformWorldToPlayer(gravityDir, v.method_1020(anchor)));
        class_238 playerBoxLocal = Helper.transformBox((class_238)playerBoundingBox, v -> GravityChangerInterface.invoker.transformWorldToPlayer(gravityDir, v.method_1020(anchor)));
        double targetLocalY = collisionUnionLocal.field_1325 + 0.01;
        double originalLocalY = playerBoxLocal.field_1322;
        double delta = targetLocalY - originalLocalY;
        if (delta <= 0.0) {
            return;
        }
        class_243 levitationVec = class_243.method_24954((class_2382)levitationDir.method_10163());
        class_243 offset = levitationVec.method_1021(delta);
        int ticks = 5;
        Helper.log((Object)"Adjusting Client Player Position");
        int[] counter = new int[]{0};
        IPGlobal.clientTaskList.addTask(() -> {
            class_243 newEyePos;
            class_243 eyePos;
            if (player.method_31481()) {
                return true;
            }
            if (GravityChangerInterface.invoker.getGravityDirection((class_1297)player) != gravityDir) {
                return true;
            }
            if (counter[0] >= 5) {
                return true;
            }
            counter[0] = counter[0] + 1;
            double len = player.method_19538().method_1020(anchor).method_1026(levitationVec);
            if (len < -1.0 || len > 2.0) {
                return true;
            }
            double progress = (double)counter[0] / 5.0;
            progress = TransformationManager.mapProgress(progress);
            class_243 expectedPos = anchor.method_1019(offset.method_1021(progress));
            class_243 newPos = Helper.putCoordinate((class_243)player.method_19538(), (class_2350.class_2351)levitationDir.method_10166(), (double)Helper.getCoordinate((class_243)expectedPos, (class_2350.class_2351)levitationDir.method_10166()));
            Portal currentCollidingPortal = ((IEEntity)player).ip_getCollidingPortal();
            if (currentCollidingPortal != null && currentCollidingPortal.rayTrace(eyePos = McHelper.getEyePos((class_1297)player), newEyePos = newPos.method_1019(McHelper.getEyeOffset((class_1297)player))) != null) {
                return true;
            }
            player.method_23327(newPos.field_1352, newPos.field_1351, newPos.field_1350);
            McHelper.updateBoundingBox((class_1297)player);
            return false;
        });
    }

    public static class RemoteCallables {
        public static void updateEntityPos(class_5321<class_1937> dim, int entityId, class_243 pos) {
            class_638 world = ClientWorldLoader.getWorld(dim);
            class_1297 entity = world.method_8469(entityId);
            if (entity == null) {
                Helper.err((Object)"cannot find entity to update position");
                return;
            }
            entity.method_5759(pos.field_1352, pos.field_1351, pos.field_1350, entity.method_36454(), entity.method_36455(), 0, false);
            entity.method_33574(pos);
        }
    }

    private record TeleportationRec(Portal portal, Vec2d portalLocalXY, class_243 collisionPos) {
    }
}

