/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.optimization;

import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_750;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.q_misc_util.Helper;

public class SharedBlockMeshBuffers {
    public static final ThreadLocal<Object> bufferTemp = ThreadLocal.withInitial(() -> null);
    public static final ThreadLocal<Object> taskTemp = ThreadLocal.withInitial(() -> null);
    public static ConcurrentLinkedQueue<class_750> threadBuffers;

    public static void init() {
        IPGlobal.clientCleanupSignal.connect(SharedBlockMeshBuffers::cleanup);
    }

    public static boolean isEnabled() {
        if (SodiumInterface.invoker.isSodiumPresent()) {
            return false;
        }
        return IPGlobal.enableSharedBlockMeshBuffers;
    }

    public static ConcurrentLinkedQueue<class_750> acquireThreadBuffers() {
        if (threadBuffers == null) {
            SharedBlockMeshBuffers.createThreadBuffers();
        }
        return threadBuffers;
    }

    private static void createThreadBuffers() {
        Validate.isTrue((boolean)SharedBlockMeshBuffers.isEnabled());
        int totalExpectedBufferSize = class_1921.method_22720().stream().mapToInt(class_1921::method_22722).sum();
        int bufferCountEstimation = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / (totalExpectedBufferSize * 4) - 1);
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        boolean is64Bits = class_310.method_1551().method_1540();
        int effectiveProcessors = is64Bits ? availableProcessors : Math.min(availableProcessors, 4);
        int bufferCount = Math.max(1, Math.min(effectiveProcessors, bufferCountEstimation));
        ArrayList<class_750> list = new ArrayList<class_750>();
        try {
            for (int m = 0; m < bufferCount; ++m) {
                list.add(new class_750());
            }
        }
        catch (OutOfMemoryError error) {
            error.printStackTrace();
            String errorMessage = String.format("[Immersive Portals] Allocated only %s/%s block mesh buffers. Memory seems not enough.", list.size(), bufferCount);
            Helper.err((Object)errorMessage);
            CHelper.printChat(errorMessage);
            int n = Math.min(list.size() * 2 / 3, list.size() - 1);
            for (int i = 0; i < n; ++i) {
                list.remove(list.size() - 1);
            }
            System.gc();
        }
        threadBuffers = Queues.newConcurrentLinkedQueue(list);
    }

    private static void cleanup() {
        if (threadBuffers != null) {
            threadBuffers = null;
        }
    }

    @Nullable
    public static String getDebugString() {
        if (SharedBlockMeshBuffers.isEnabled() && threadBuffers != null) {
            return "SharedBlockMeshBuffers " + Integer.toString(threadBuffers.size());
        }
        return null;
    }
}

