/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.PortalRenderable;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

public class ViewAreaRenderer {
    public static void renderPortalArea(PortalRenderable portalRenderable, class_243 fogColor, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, boolean doFaceCulling, boolean doModifyColor, boolean doModifyDepth, boolean doClip) {
        PortalLike portalLike = portalRenderable.getPortalLike();
        if (doFaceCulling) {
            GlStateManager._enableCull();
        } else {
            GlStateManager._disableCull();
        }
        if (portalLike.isFuseView() && IPGlobal.maxPortalLayer != 0) {
            GlStateManager._colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        } else if (!doModifyColor) {
            GlStateManager._colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        } else {
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        if (doModifyDepth) {
            if (portalLike.isFuseView()) {
                GlStateManager._depthMask((boolean)false);
            } else {
                GlStateManager._depthMask((boolean)true);
            }
        } else {
            GlStateManager._depthMask((boolean)false);
        }
        boolean shouldReverseCull = PortalRendering.isRenderingOddNumberOfMirrors();
        if (shouldReverseCull) {
            MyRenderHelper.applyMirrorFaceCulling();
        }
        if (doClip) {
            if (PortalRendering.isRendering()) {
                FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), modelViewMatrix, 0.0);
            }
        } else {
            FrontClipping.disableClipping();
        }
        GlStateManager._enableDepthTest();
        CHelper.enableDepthClamp();
        class_5944 shader = MyRenderHelper.portalAreaShader;
        RenderSystem.setShader(() -> shader);
        shader.field_29470.method_1250(modelViewMatrix);
        shader.field_29471.method_1250(projectionMatrix);
        FrontClipping.updateClippingEquationUniformForCurrentShader(false);
        shader.method_34586();
        ViewAreaRenderer.buildPortalViewAreaTrianglesBuffer(fogColor, portalRenderable, CHelper.getCurrentCameraPos(), RenderStates.getPartialTick());
        shader.method_34585();
        GlStateManager._enableCull();
        CHelper.disableDepthClamp();
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._depthMask((boolean)true);
        if (shouldReverseCull) {
            MyRenderHelper.recoverFaceCulling();
        }
        if (PortalRendering.isRendering()) {
            FrontClipping.disableClipping();
        }
        CHelper.checkGlError();
    }

    public static void buildPortalViewAreaTrianglesBuffer(class_243 fogColor, PortalRenderable portalRenderable, class_243 cameraPos, float tickDelta) {
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        class_243 originRelativeToCamera = portalRenderable.getPortalLike().getOriginPos().method_1020(cameraPos);
        Consumer<class_243> vertexOutput = p -> ViewAreaRenderer.putIntoVertex(bufferBuilder, p, fogColor);
        if (portalRenderable instanceof Portal) {
            Portal portal = (Portal)portalRenderable;
            portal.renderViewAreaMesh(originRelativeToCamera, vertexOutput);
        } else if (portalRenderable instanceof PortalRenderer.PortalGroupToRender) {
            PortalRenderer.PortalGroupToRender portalGroupToRender = (PortalRenderer.PortalGroupToRender)portalRenderable;
            PortalLike portalLike = portalGroupToRender.getPortalLike();
            for (Portal portal : portalGroupToRender.portals()) {
                class_243 relativeToGroup = portal.getOriginPos().method_1020(portalLike.getOriginPos());
                portal.renderViewAreaMesh(originRelativeToCamera.method_1019(relativeToGroup), vertexOutput);
            }
        }
        class_286.method_43437((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static void generateViewAreaTriangles(Portal portal, class_243 posInPlayerCoordinate, Consumer<class_243> vertexOutput) {
        if (portal.specialShape == null) {
            if (portal.getIsGlobal()) {
                ViewAreaRenderer.generateTriangleForGlobalPortal(vertexOutput, portal, posInPlayerCoordinate);
            } else {
                ViewAreaRenderer.generateTriangleForNormalShape(vertexOutput, portal, posInPlayerCoordinate);
            }
        } else {
            ViewAreaRenderer.generateTriangleForSpecialShape(vertexOutput, portal, posInPlayerCoordinate);
        }
    }

    public static void generateTriangleForSpecialShape(Consumer<class_243> vertexOutput, Portal portal, class_243 posInPlayerCoordinate) {
        ViewAreaRenderer.generateTriangleSpecial(vertexOutput, portal, posInPlayerCoordinate);
    }

    public static void generateTriangleSpecial(Consumer<class_243> vertexOutput, Portal portal, class_243 posInPlayerCoordinate) {
        GeometryPortalShape specialShape = portal.specialShape;
        assert (specialShape != null);
        specialShape.normalize(portal.width, portal.height);
        double halfWidth = portal.width / 2.0;
        double halfHeight = portal.height / 2.0;
        for (GeometryPortalShape.TriangleInPlane triangle : specialShape.triangles) {
            class_243 a = posInPlayerCoordinate.method_1019(portal.axisW.method_1021(triangle.x1 * halfWidth)).method_1019(portal.axisH.method_1021(triangle.y1 * halfHeight));
            class_243 b = posInPlayerCoordinate.method_1019(portal.axisW.method_1021(triangle.x3 * halfWidth)).method_1019(portal.axisH.method_1021(triangle.y3 * halfHeight));
            class_243 c = posInPlayerCoordinate.method_1019(portal.axisW.method_1021(triangle.x2 * halfWidth)).method_1019(portal.axisH.method_1021(triangle.y2 * halfHeight));
            vertexOutput.accept(a);
            vertexOutput.accept(b);
            vertexOutput.accept(c);
        }
    }

    private static void putIntoLocalVertex(Consumer<class_243> vertexOutput, Portal portal, class_243 offset, class_243 posInPlayerCoordinate, double localX, double localY) {
        vertexOutput.accept(posInPlayerCoordinate.method_1019(portal.axisW.method_1021(localX)).method_1019(portal.axisH.method_1021(localY)).method_1019(offset));
    }

    private static void generateTriangleForNormalShape(Consumer<class_243> vertexOutput, Portal portal, class_243 posInPlayerCoordinate) {
        double w = Math.min(portal.width, 23333.0);
        double h = Math.min(portal.height, 23333.0);
        class_243 v0 = portal.getPointInPlaneLocal(w / 2.0 - 0.0, -h / 2.0 + 0.0);
        class_243 v1 = portal.getPointInPlaneLocal(-w / 2.0 + 0.0, -h / 2.0 + 0.0);
        class_243 v2 = portal.getPointInPlaneLocal(w / 2.0 - 0.0, h / 2.0 - 0.0);
        class_243 v3 = portal.getPointInPlaneLocal(-w / 2.0 + 0.0, h / 2.0 - 0.0);
        ViewAreaRenderer.putIntoQuad(vertexOutput, v0.method_1019(posInPlayerCoordinate), v2.method_1019(posInPlayerCoordinate), v3.method_1019(posInPlayerCoordinate), v1.method_1019(posInPlayerCoordinate));
    }

    private static void generateTriangleForGlobalPortal(Consumer<class_243> vertexOutput, Portal portal, class_243 posInPlayerCoordinate) {
        double distance;
        class_243 cameraPosLocal = posInPlayerCoordinate.method_1021(-1.0);
        double cameraLocalX = cameraPosLocal.method_1026(portal.axisW);
        double cameraLocalY = cameraPosLocal.method_1026(portal.axisH);
        double r = class_310.method_1551().field_1690.method_38521() * 16 - 16;
        if (TransformationManager.isIsometricView) {
            r *= 2.0;
        }
        if ((distance = Math.abs(cameraPosLocal.method_1026(portal.getNormal()))) > 200.0) {
            r = r * 200.0 / distance;
        }
        class_243 v0 = portal.getPointInPlaneLocalClamped(r + cameraLocalX, -r + cameraLocalY);
        class_243 v1 = portal.getPointInPlaneLocalClamped(-r + cameraLocalX, -r + cameraLocalY);
        class_243 v2 = portal.getPointInPlaneLocalClamped(r + cameraLocalX, r + cameraLocalY);
        class_243 v3 = portal.getPointInPlaneLocalClamped(-r + cameraLocalX, r + cameraLocalY);
        ViewAreaRenderer.putIntoQuad(vertexOutput, v0.method_1019(posInPlayerCoordinate), v2.method_1019(posInPlayerCoordinate), v3.method_1019(posInPlayerCoordinate), v1.method_1019(posInPlayerCoordinate));
    }

    private static void putIntoVertex(class_287 bufferBuilder, class_243 pos, class_243 fogColor) {
        bufferBuilder.method_22912(pos.field_1352, pos.field_1351, pos.field_1350).method_22915((float)fogColor.field_1352, (float)fogColor.field_1351, (float)fogColor.field_1350, 1.0f).method_1344();
    }

    private static void putIntoQuad(Consumer<class_243> vertexOutput, class_243 a, class_243 b, class_243 c, class_243 d) {
        vertexOutput.accept(b);
        vertexOutput.accept(c);
        vertexOutput.accept(d);
        vertexOutput.accept(d);
        vertexOutput.accept(a);
        vertexOutput.accept(b);
    }
}

