/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_5365;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.compat.IPModInfoChecking;
import qouteall.imm_ptl.core.compat.iris_compatibility.ExperimentalIrisPortalRenderer;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisCompatibilityPortalRenderer;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisPortalRenderer;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.PortalGroup;
import qouteall.imm_ptl.core.render.PortalRenderable;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

public abstract class PortalRenderer {
    public static final Event<Predicate<Portal>> PORTAL_RENDERING_PREDICATE = EventFactory.createArrayBacked(Predicate.class, listeners -> portal -> {
        for (Predicate listener : listeners) {
            if (listener.test(portal)) continue;
            return false;
        }
        return true;
    });
    public static final class_310 client = class_310.method_1551();
    private static boolean fabulousWarned = false;

    public abstract void onBeforeTranslucentRendering(class_4587 var1);

    public abstract void onAfterTranslucentRendering(class_4587 var1);

    public abstract void onHandRenderingEnded(class_4587 var1);

    public void onBeforeHandRendering(class_4587 matrixStack) {
    }

    public abstract void prepareRendering();

    public abstract void finishRendering();

    public abstract void renderPortalInEntityRenderer(Portal var1);

    public abstract boolean replaceFrameBufferClearing();

    protected List<PortalRenderable> getPortalsToRender(class_4587 matrixStack) {
        Supplier frustumSupplier = Helper.cached(() -> {
            class_4604 frustum = new class_4604(matrixStack.method_23760().method_23761(), RenderSystem.getProjectionMatrix());
            class_243 cameraPos = PortalRenderer.client.field_1773.method_19418().method_19326();
            frustum.method_23088(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350);
            return frustum;
        });
        ObjectArrayList renderables = new ObjectArrayList();
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals((class_1937)PortalRenderer.client.field_1687);
        for (Portal globalPortal : globalPortals) {
            if (PortalRenderer.shouldSkipRenderingPortal(globalPortal, frustumSupplier)) continue;
            renderables.add((Object)globalPortal);
        }
        Object2ObjectOpenHashMap groupToRenderable = new Object2ObjectOpenHashMap();
        PortalRenderer.client.field_1687.method_18112().forEach(arg_0 -> PortalRenderer.lambda$getPortalsToRender$3((Supplier)frustumSupplier, groupToRenderable, renderables, arg_0));
        class_243 cameraPos = CHelper.getCurrentCameraPos();
        renderables.sort(Comparator.comparingDouble(e -> e.getPortalLike().getDistanceToNearestPointInPortal(cameraPos)));
        return renderables;
    }

    private static boolean shouldSkipRenderingPortal(Portal portal, Supplier<class_4604> frustumSupplier) {
        class_4604 frustum;
        PortalLike outerPortal;
        if (!portal.isPortalValid()) {
            return true;
        }
        if (!portal.isVisible() && IPGlobal.maxPortalLayer != 0) {
            return true;
        }
        if (RenderStates.getRenderedPortalNum() >= IPGlobal.portalRenderLimit) {
            return true;
        }
        class_243 cameraPos = TransformationManager.getIsometricAdjustedCameraPos();
        if (!portal.isRoughlyVisibleTo(cameraPos)) {
            return true;
        }
        if (PortalRendering.isRendering() && (outerPortal = PortalRendering.getRenderingPortal()).cannotRenderInMe(portal)) {
            return true;
        }
        double distance = portal.getDistanceToNearestPointInPortal(cameraPos);
        if (distance > PortalRenderer.getRenderRange()) {
            return true;
        }
        if (IPCGlobal.earlyFrustumCullingPortal && distance > 0.03 && !(frustum = frustumSupplier.get()).method_23093(portal.getExactAreaBox())) {
            return true;
        }
        boolean predicateTest = ((Predicate)PORTAL_RENDERING_PREDICATE.invoker()).test(portal);
        return !predicateTest;
    }

    public static double getRenderRange() {
        double outerPortalScale;
        double range = PortalRenderer.client.field_1690.method_38521() * 16;
        if (RenderStates.isLaggy || IPGlobal.reducedPortalRendering) {
            range = 16.0;
        }
        if (PortalRendering.getPortalLayer() > 1) {
            range /= (double)PortalRendering.getPortalLayer();
        }
        if (PortalRendering.getPortalLayer() >= 1 && (outerPortalScale = PortalRendering.getRenderingPortal().getScale()) > 2.0) {
            range *= outerPortalScale;
            range = Math.min(range, 512.0);
        }
        return range;
    }

    protected final void renderPortalContent(PortalRenderable portalRenderable) {
        PortalLike portalLike = portalRenderable.getPortalLike();
        if (PortalRendering.getPortalLayer() > PortalRendering.getMaxPortalLayer()) {
            return;
        }
        class_638 newWorld = ClientWorldLoader.getWorld(portalLike.getDestDim());
        PortalRendering.onBeginPortalWorldRendering();
        int renderDistance = PortalRenderer.getPortalRenderDistance(portalLike);
        this.invokeWorldRendering(new WorldRenderInfo.Builder().setWorld(newWorld).setCameraPos(PortalRendering.getRenderingCameraPos()).setCameraTransformation(portalLike.getAdditionalCameraTransformation()).setOverwriteCameraTransformation(false).setDescription(portalLike.getDiscriminator()).setRenderDistance(renderDistance).setDoRenderHand(false).setEnableViewBobbing(true).setDoRenderSky(!portalLike.isFuseView()).build());
        PortalRendering.onEndPortalWorldRendering();
        GlStateManager._enableDepthTest();
        MyRenderHelper.restoreViewPort();
    }

    private static int getPortalRenderDistance(PortalLike portal) {
        int mcRenderDistance = PortalRenderer.client.field_1690.method_38521();
        if (portal.getScale() > 2.0) {
            double radiusBlocks = portal.getDestAreaRadiusEstimation() * 1.4;
            radiusBlocks = Math.min(radiusBlocks, 512.0);
            return Math.max((int)(radiusBlocks / 16.0), mcRenderDistance);
        }
        if (IPGlobal.reducedPortalRendering) {
            return mcRenderDistance / 3;
        }
        return mcRenderDistance;
    }

    public void invokeWorldRendering(WorldRenderInfo worldRenderInfo) {
        MyGameRenderer.renderWorldNew(worldRenderInfo, Runnable::run);
    }

    @Nullable
    public static Matrix4f getPortalTransformation(Portal portal) {
        Matrix4f rot = PortalRenderer.getPortalRotationMatrix(portal);
        Matrix4f mirror = portal instanceof Mirror ? TransformationManager.getMirrorTransformation(portal.getNormal()) : null;
        Matrix4f scale = PortalRenderer.getPortalScaleMatrix(portal);
        return PortalRenderer.combineNullable(rot, PortalRenderer.combineNullable(mirror, scale));
    }

    @Nullable
    public static Matrix4f getPortalRotationMatrix(Portal portal) {
        if (portal.getRotation() == null) {
            return null;
        }
        Quaternionf rot = portal.getRotation().toMcQuaternion();
        rot.conjugate();
        return rot.get(new Matrix4f());
    }

    @Nullable
    public static Matrix4f combineNullable(@Nullable Matrix4f a, @Nullable Matrix4f b) {
        return (Matrix4f)Helper.combineNullable((Object)a, (Object)b, (m1, m2) -> {
            m1.mul((Matrix4fc)m2);
            return m1;
        });
    }

    @Nullable
    public static Matrix4f getPortalScaleMatrix(Portal portal) {
        if (PortalRenderer.shouldApplyScaleToModelView(portal)) {
            float v = (float)(1.0 / portal.getScale());
            return new Matrix4f().scale(v, v, v);
        }
        return null;
    }

    public static boolean shouldApplyScaleToModelView(PortalLike portal) {
        return portal.hasScaling() && portal.isFuseView();
    }

    public void onBeginIrisTranslucentRendering(class_4587 matrixStack) {
    }

    public static void switchToCorrectRenderer() {
        if (PortalRendering.isRendering()) {
            return;
        }
        if (class_310.method_1551().field_1690.method_42534().method_41753() == class_5365.field_25429 && !fabulousWarned) {
            fabulousWarned = true;
            CHelper.printChat((class_2561)class_2561.method_43471((String)"imm_ptl.fabulous_warning"));
        }
        IPModInfoChecking.checkShaderpack();
        if (IrisInterface.invoker.isIrisPresent() && IrisInterface.invoker.isShaders()) {
            if (IPCGlobal.experimentalIrisPortalRenderer) {
                PortalRenderer.switchRenderer(ExperimentalIrisPortalRenderer.instance);
                return;
            }
            switch (IPGlobal.renderMode) {
                case normal: {
                    PortalRenderer.switchRenderer(IrisPortalRenderer.instance);
                    break;
                }
                case compatibility: {
                    PortalRenderer.switchRenderer(IrisCompatibilityPortalRenderer.instance);
                    break;
                }
                case debug: {
                    PortalRenderer.switchRenderer(IrisCompatibilityPortalRenderer.debugModeInstance);
                    break;
                }
                case none: {
                    PortalRenderer.switchRenderer(IPCGlobal.rendererDummy);
                }
            }
            return;
        }
        switch (IPGlobal.renderMode) {
            case normal: {
                PortalRenderer.switchRenderer(IPCGlobal.rendererUsingStencil);
                break;
            }
            case compatibility: {
                PortalRenderer.switchRenderer(IPCGlobal.rendererUsingFrameBuffer);
                break;
            }
            case debug: {
                PortalRenderer.switchRenderer(IPCGlobal.rendererDebug);
                break;
            }
            case none: {
                PortalRenderer.switchRenderer(IPCGlobal.rendererDummy);
            }
        }
    }

    private static void switchRenderer(PortalRenderer renderer) {
        if (IPCGlobal.renderer != renderer) {
            Helper.log((Object)("switched to renderer " + renderer.getClass()));
            IPCGlobal.renderer = renderer;
            if (IrisInterface.invoker.isShaders()) {
                IrisInterface.invoker.reloadPipelines();
            }
        }
    }

    private static /* synthetic */ void lambda$getPortalsToRender$3(Supplier frustumSupplier, Object2ObjectOpenHashMap groupToRenderable, ObjectArrayList renderables, class_1297 e) {
        Portal portal;
        if (e instanceof Portal && !PortalRenderer.shouldSkipRenderingPortal(portal = (Portal)e, frustumSupplier)) {
            PortalLike renderingDelegate = portal.getRenderingDelegate();
            if (renderingDelegate instanceof PortalGroup) {
                PortalGroup portalGroup = (PortalGroup)renderingDelegate;
                if (groupToRenderable.containsKey((Object)portalGroup)) {
                    ((PortalGroupToRender)groupToRenderable.get((Object)portalGroup)).portals.add(portal);
                } else {
                    PortalGroupToRender renderable = new PortalGroupToRender(portalGroup, Lists.newArrayList((Object[])new Portal[]{portal}));
                    groupToRenderable.put((Object)portalGroup, (Object)renderable);
                    renderables.add((Object)renderable);
                }
            } else {
                renderables.add((Object)portal);
            }
        }
    }

    public record PortalGroupToRender(PortalGroup group, List<Portal> portals) implements PortalRenderable
    {
        @Override
        public PortalLike getPortalLike() {
            return this.group;
        }
    }
}

