/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.BoxPredicate;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.LimitedLogger;
import qouteall.q_misc_util.my_util.Plane;

@Environment(value=EnvType.CLIENT)
public class PortalGroup
implements PortalLike {
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);
    public final Portal.TransformationDesc transformationDesc;
    public final List<Portal> portals = new ArrayList<Portal>();
    private class_238 exactBoundingBox;
    private class_243 origin;
    private class_243 dest;
    @Nullable
    private class_238 destAreaBoxCache = null;
    @Nullable
    private Boolean isEnclosedCache = null;
    private final UUID uuid = class_3532.method_15394();

    public PortalGroup(Portal.TransformationDesc transformationDesc) {
        this.transformationDesc = transformationDesc;
    }

    public void addPortal(Portal portal) {
        Validate.isTrue((boolean)portal.method_37908().method_8608());
        Validate.isTrue((!portal.getIsGlobal() ? 1 : 0) != 0);
        if (this.portals.contains(portal)) {
            limitedLogger.err("Adding duplicate portal into group " + portal);
            return;
        }
        this.portals.add(portal);
        this.updateCache();
    }

    public void removePortal(Portal portal) {
        this.portals.remove(portal);
        this.updateCache();
    }

    public void updateCache() {
        this.exactBoundingBox = null;
        this.origin = null;
        this.dest = null;
        this.destAreaBoxCache = null;
        this.isEnclosedCache = null;
    }

    public class_238 getDestAreaBox() {
        if (this.destAreaBoxCache == null) {
            this.destAreaBoxCache = Helper.transformBox((class_238)this.getExactAreaBox(), pos -> this.getFirstPortal().transformPoint((class_243)pos));
        }
        return this.destAreaBoxCache;
    }

    @Override
    public boolean isConventionalPortal() {
        return false;
    }

    @Override
    public class_238 getExactAreaBox() {
        if (this.exactBoundingBox == null) {
            this.exactBoundingBox = this.portals.stream().map(Portal::getExactBoundingBox).reduce(class_238::method_991).get();
        }
        return this.exactBoundingBox;
    }

    @Override
    public class_243 transformPoint(class_243 pos) {
        return this.getFirstPortal().transformPoint(pos);
    }

    @Override
    public class_243 transformLocalVec(class_243 localVec) {
        return this.getFirstPortal().transformLocalVec(localVec);
    }

    @Override
    public class_243 transformLocalVecNonScale(class_243 localVec) {
        return this.getFirstPortal().transformLocalVecNonScale(localVec);
    }

    @Override
    public class_243 inverseTransformLocalVec(class_243 localVec) {
        return this.getFirstPortal().inverseTransformLocalVec(localVec);
    }

    @Override
    public class_243 inverseTransformPoint(class_243 point) {
        return this.getFirstPortal().inverseTransformPoint(point);
    }

    @Override
    public double getDistanceToNearestPointInPortal(class_243 point) {
        return Helper.getDistanceToBox((class_238)this.getExactAreaBox(), (class_243)point);
    }

    @Override
    public double getDestAreaRadiusEstimation() {
        double maxDimension = this.getSizeEstimation();
        return maxDimension * this.transformationDesc.scaling();
    }

    @Override
    public class_243 getOriginPos() {
        if (this.origin == null) {
            this.origin = this.getExactAreaBox().method_1005();
        }
        return this.origin;
    }

    @Override
    public class_243 getDestPos() {
        if (this.dest == null) {
            this.dest = this.transformPoint(this.getOriginPos());
        }
        return this.dest;
    }

    @Override
    public class_1937 getOriginWorld() {
        return this.getFirstPortal().method_37908();
    }

    @Override
    public class_1937 getDestWorld() {
        return this.getFirstPortal().getDestWorld();
    }

    @Override
    public class_5321<class_1937> getDestDim() {
        return this.getFirstPortal().getDestDim();
    }

    @Override
    public boolean isRoughlyVisibleTo(class_243 cameraPos) {
        return true;
    }

    @Override
    @Nullable
    public Plane getInnerClipping() {
        return null;
    }

    @Override
    public boolean isOnDestinationSide(class_243 entityPos, double valve) {
        if (this.isEnclosed()) {
            return this.getDestAreaBox().method_1006(entityPos);
        }
        return true;
    }

    @Override
    @Nullable
    public DQuaternion getRotation() {
        return this.transformationDesc.rotation();
    }

    @Override
    public double getScale() {
        return this.transformationDesc.scaling();
    }

    @Override
    public boolean getIsGlobal() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    @Nullable
    public class_243[] getOuterFrustumCullingVertices() {
        return null;
    }

    @Override
    @Deprecated
    @Environment(value=EnvType.CLIENT)
    public void renderViewAreaMesh(class_243 portalPosRelativeToCamera, Consumer<class_243> vertexOutput) {
        for (Portal portal : this.portals) {
            class_243 relativeToGroup = portal.getOriginPos().method_1020(this.getOriginPos());
            portal.renderViewAreaMesh(portalPosRelativeToCamera.method_1019(relativeToGroup), vertexOutput);
        }
    }

    @Override
    @Nullable
    public Matrix4f getAdditionalCameraTransformation() {
        return this.getFirstPortal().getAdditionalCameraTransformation();
    }

    @Override
    @Nullable
    public UUID getDiscriminator() {
        return this.uuid;
    }

    public void purge() {
        this.portals.removeIf(portal -> portal.method_31481());
    }

    @Override
    public boolean cannotRenderInMe(Portal portal) {
        if (this.isEnclosed() && !this.getDestAreaBox().method_994(portal.getExactAreaBox())) {
            return true;
        }
        return this.portals.stream().anyMatch(p -> p.cannotRenderInMe(portal));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BoxPredicate getInnerFrustumCullingFunc(double innerCameraX, double innerCameraY, double innerCameraZ) {
        class_243 innerCameraPos = new class_243(innerCameraX, innerCameraY, innerCameraZ);
        class_243 outerCameraPos = this.getFirstPortal().inverseTransformPoint(innerCameraPos);
        List funcs = this.portals.stream().filter(portal1 -> portal1.isInFrontOfPortal(outerCameraPos)).map(portal -> portal.getInnerFrustumCullingFunc(innerCameraX, innerCameraY, innerCameraZ)).collect(Collectors.toList());
        return (minX, minY, minZ, maxX, maxY, maxZ) -> {
            for (BoxPredicate func : funcs) {
                if (func.test(minX, minY, minZ, maxX, maxY, maxZ)) continue;
                return false;
            }
            return true;
        };
    }

    @Override
    public boolean isFuseView() {
        return this.getFirstPortal().isFuseView();
    }

    @Override
    public boolean getDoRenderPlayer() {
        return this.getFirstPortal().getDoRenderPlayer();
    }

    @Override
    public boolean getHasCrossPortalCollision() {
        return this.getFirstPortal().getHasCrossPortalCollision();
    }

    public String toString() {
        return String.format("PortalRenderingGroup(%s)(first:%s)", this.portals.size(), this.getFirstPortal());
    }

    public boolean isEnclosed() {
        if (this.isEnclosedCache == null) {
            this.isEnclosedCache = this.portals.stream().allMatch(p -> p.getOriginPos().method_1020(this.getOriginPos()).method_1026(p.getNormal()) > 0.3);
        }
        return this.isEnclosedCache;
    }

    public Portal getFirstPortal() {
        return this.portals.get(0);
    }

    public static PortalLike getPortalUnit(Portal portal) {
        PortalGroup group = PortalRenderInfo.getGroupOf(portal);
        if (group != null) {
            return group;
        }
        return portal;
    }
}

