/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IECamera;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

@Environment(value=EnvType.CLIENT)
public class GuiPortalRendering {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static class_276 renderingFrameBuffer = null;
    private static final HashMap<class_276, WorldRenderInfo> renderingTasks = new HashMap();

    @Nullable
    public static class_276 getRenderingFrameBuffer() {
        return renderingFrameBuffer;
    }

    public static boolean isRendering() {
        return GuiPortalRendering.getRenderingFrameBuffer() != null;
    }

    private static void renderWorldIntoFrameBuffer(WorldRenderInfo worldRenderInfo, class_276 framebuffer) {
        RenderStates.basicProjectionMatrix = null;
        CHelper.checkGlError();
        ((IECamera)RenderStates.originalCamera).resetState(worldRenderInfo.cameraPos, worldRenderInfo.world);
        Validate.isTrue((renderingFrameBuffer == null ? 1 : 0) != 0);
        renderingFrameBuffer = framebuffer;
        MyRenderHelper.restoreViewPort();
        class_276 mcFb = MyGameRenderer.client.method_1522();
        Validate.isTrue((mcFb != framebuffer ? 1 : 0) != 0);
        ((IEMinecraftClient)MyGameRenderer.client).setFrameBuffer(framebuffer);
        if (!worldRenderInfo.doRenderSky) {
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
            framebuffer.method_1230(true);
        }
        framebuffer.method_1235(true);
        IPCGlobal.renderer.prepareRendering();
        IPCGlobal.renderer.invokeWorldRendering(worldRenderInfo);
        IPCGlobal.renderer.finishRendering();
        ((IEMinecraftClient)MyGameRenderer.client).setFrameBuffer(mcFb);
        mcFb.method_1235(true);
        renderingFrameBuffer = null;
        MyRenderHelper.restoreViewPort();
        CHelper.checkGlError();
        RenderStates.basicProjectionMatrix = null;
    }

    public static void submitNextFrameRendering(WorldRenderInfo worldRenderInfo, class_276 renderTarget) {
        if (!ClientWorldLoader.getIsInitialized()) {
            LOGGER.error("Trying to submit world rendering task before client world is initialized", new Throwable());
            return;
        }
        Validate.isTrue((!renderingTasks.containsKey(renderTarget) ? 1 : 0) != 0);
        class_276 mcFB = class_310.method_1551().method_1522();
        if (renderTarget.field_1482 != mcFB.field_1482 || renderTarget.field_1481 != mcFB.field_1481) {
            renderTarget.method_1234(mcFB.field_1482, mcFB.field_1481, true);
            Helper.log((Object)"Resized Framebuffer for GUI Portal Rendering");
        }
        renderingTasks.put(renderTarget, worldRenderInfo);
    }

    public static void _onGameRenderEnd() {
        renderingTasks.forEach((frameBuffer, worldRendering) -> GuiPortalRendering.renderWorldIntoFrameBuffer(worldRendering, frameBuffer));
        renderingTasks.clear();
    }

    public static void _init() {
        IPGlobal.clientCleanupSignal.connect(renderingTasks::clear);
    }
}

