/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import java.util.Comparator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.q_misc_util.my_util.BoxPredicate;

@Environment(value=EnvType.CLIENT)
public class FrustumCuller {
    private BoxPredicate canDetermineInvisibleFunc;
    private double camX;
    private double camY;
    private double camZ;

    public void update(double cameraX, double cameraY, double cameraZ) {
        this.canDetermineInvisibleFunc = this.getCanDetermineInvisibleFunc(cameraX, cameraY, cameraZ);
        this.camX = cameraX;
        this.camY = cameraY;
        this.camZ = cameraZ;
    }

    public boolean canDetermineInvisibleWithCameraCoord(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.canDetermineInvisibleFunc.test(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean canDetermineInvisibleWithWorldCoord(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.canDetermineInvisibleWithCameraCoord(minX - this.camX, minY - this.camY, minZ - this.camZ, maxX - this.camX, maxY - this.camY, maxZ - this.camZ);
    }

    private BoxPredicate getCanDetermineInvisibleFunc(double cameraX, double cameraY, double cameraZ) {
        if (!IPCGlobal.doUseAdvancedFrustumCulling) {
            return BoxPredicate.nonePredicate;
        }
        if (IrisInterface.invoker.isRenderingShadowMap()) {
            return BoxPredicate.nonePredicate;
        }
        if (PortalRendering.isRendering()) {
            return PortalRendering.getRenderingPortal().getInnerFrustumCullingFunc(cameraX, cameraY, cameraZ);
        }
        if (!IPCGlobal.useSuperAdvancedFrustumCulling) {
            return BoxPredicate.nonePredicate;
        }
        Portal portal = FrustumCuller.getCurrentNearestVisibleCullablePortal();
        if (portal != null) {
            class_243 portalOrigin = portal.getOriginPos();
            class_243 portalOriginInLocalCoordinate = portalOrigin.method_1031(-cameraX, -cameraY, -cameraZ);
            class_243[] outerFrustumCullingVertices = portal.getOuterFrustumCullingVertices();
            if (outerFrustumCullingVertices == null) {
                return BoxPredicate.nonePredicate;
            }
            class_243[] downLeftUpRightPlaneNormals = FrustumCuller.getDownLeftUpRightPlaneNormals(portalOriginInLocalCoordinate, outerFrustumCullingVertices);
            class_243 downPlane = downLeftUpRightPlaneNormals[0];
            class_243 leftPlane = downLeftUpRightPlaneNormals[1];
            class_243 upPlane = downLeftUpRightPlaneNormals[2];
            class_243 rightPlane = downLeftUpRightPlaneNormals[3];
            class_243 nearPlanePosInLocalCoordinate = portalOriginInLocalCoordinate;
            class_243 nearPlaneNormal = portal.getNormal().method_1021(-1.0);
            return (minX, minY, minZ, maxX, maxY, maxZ) -> {
                boolean isBehindNearPlane;
                boolean bl = isBehindNearPlane = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, nearPlaneNormal.field_1352, nearPlaneNormal.field_1351, nearPlaneNormal.field_1350, nearPlanePosInLocalCoordinate.field_1352, nearPlanePosInLocalCoordinate.field_1351, nearPlanePosInLocalCoordinate.field_1350) == BatchTestResult.all_true;
                if (!isBehindNearPlane) {
                    return false;
                }
                boolean fullyInFrustum = FrustumCuller.isFullyInFrustum(minX, minY, minZ, maxX, maxY, maxZ, leftPlane, rightPlane, upPlane, downPlane);
                return fullyInFrustum;
            };
        }
        return BoxPredicate.nonePredicate;
    }

    public static class_243[] getDownLeftUpRightPlaneNormals(class_243 portalOriginInLocalCoordinate, class_243[] fourVertices) {
        class_243[] relativeVertices = new class_243[]{fourVertices[0].method_1019(portalOriginInLocalCoordinate), fourVertices[1].method_1019(portalOriginInLocalCoordinate), fourVertices[2].method_1019(portalOriginInLocalCoordinate), fourVertices[3].method_1019(portalOriginInLocalCoordinate)};
        return new class_243[]{relativeVertices[0].method_1036(relativeVertices[1]), relativeVertices[1].method_1036(relativeVertices[3]), relativeVertices[3].method_1036(relativeVertices[2]), relativeVertices[2].method_1036(relativeVertices[0])};
    }

    public static BatchTestResult testBoxTwoVertices(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double planeNormalX, double planeNormalY, double planeNormalZ, double planePosX, double planePosY, double planePosZ) {
        double p2z;
        double p1z;
        double p2y;
        double p1y;
        double p2x;
        double p1x;
        if (planeNormalX > 0.0) {
            p1x = minX;
            p2x = maxX;
        } else {
            p1x = maxX;
            p2x = minX;
        }
        if (planeNormalY > 0.0) {
            p1y = minY;
            p2y = maxY;
        } else {
            p1y = maxY;
            p2y = minY;
        }
        if (planeNormalZ > 0.0) {
            p1z = minZ;
            p2z = maxZ;
        } else {
            p1z = maxZ;
            p2z = minZ;
        }
        boolean r1 = FrustumCuller.isInFrontOf(p1x - planePosX, p1y - planePosY, p1z - planePosZ, planeNormalX, planeNormalY, planeNormalZ);
        boolean r2 = FrustumCuller.isInFrontOf(p2x - planePosX, p2y - planePosY, p2z - planePosZ, planeNormalX, planeNormalY, planeNormalZ);
        if (r1 && r2) {
            return BatchTestResult.all_true;
        }
        if (!r1 && !r2) {
            return BatchTestResult.all_false;
        }
        return BatchTestResult.both;
    }

    public static BatchTestResult testBoxTwoVertices(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, class_243 planeNormal) {
        return FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, planeNormal.field_1352, planeNormal.field_1351, planeNormal.field_1350, 0.0, 0.0, 0.0);
    }

    private static boolean isInFrontOf(double x, double y, double z, class_243 planeNormal) {
        return x * planeNormal.field_1352 + y * planeNormal.field_1351 + z * planeNormal.field_1350 >= 0.0;
    }

    private static boolean isInFrontOf(double x, double y, double z, double planeNormalX, double planeNormalY, double planeNormalZ) {
        return x * planeNormalX + y * planeNormalY + z * planeNormalZ >= 0.0;
    }

    public static boolean isFullyOutsideFrustum(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, class_243 leftPlane, class_243 rightPlane, class_243 upPlane, class_243 downPlane) {
        BatchTestResult left = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, leftPlane);
        BatchTestResult right = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, rightPlane);
        if (left == BatchTestResult.all_false && right == BatchTestResult.all_true) {
            return true;
        }
        if (left == BatchTestResult.all_true && right == BatchTestResult.all_false) {
            return true;
        }
        BatchTestResult up = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, upPlane);
        BatchTestResult down = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, downPlane);
        if (up == BatchTestResult.all_false && down == BatchTestResult.all_true) {
            return true;
        }
        return up == BatchTestResult.all_true && down == BatchTestResult.all_false;
    }

    private static boolean isFullyInFrustum(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, class_243 leftPlane, class_243 rightPlane, class_243 upPlane, class_243 downPlane) {
        return FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, leftPlane) == BatchTestResult.all_true && FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, rightPlane) == BatchTestResult.all_true && FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, upPlane) == BatchTestResult.all_true && FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, downPlane) == BatchTestResult.all_true;
    }

    @Nullable
    private static Portal getCurrentNearestVisibleCullablePortal() {
        if (TransformationManager.isIsometricView) {
            return null;
        }
        class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
        return CHelper.getClientNearbyPortals(16.0).filter(portal -> portal.isInFrontOfPortal(cameraPos)).filter(Portal::canDoOuterFrustumCulling).min(Comparator.comparingDouble(portal -> portal.getDistanceToNearestPointInPortal(cameraPos))).orElse(null);
    }

    public static boolean isTouchingInsideContentArea(Portal renderingPortal, class_238 boundingBox) {
        class_243 planeNormal = renderingPortal.getContentDirection();
        class_243 planePos = renderingPortal.getDestPos();
        BatchTestResult batchTestResult = FrustumCuller.testBoxTwoVertices(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1321, boundingBox.field_1320, boundingBox.field_1325, boundingBox.field_1324, planeNormal.field_1352, planeNormal.field_1351, planeNormal.field_1350, planePos.field_1352, planePos.field_1351, planePos.field_1350);
        return batchTestResult != BatchTestResult.all_false;
    }

    public static enum BatchTestResult {
        all_true,
        all_false,
        both;

    }
}

