/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_243;
import net.minecraft.class_284;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEShader;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.q_misc_util.my_util.Plane;

public class FrontClipping {
    private static final class_310 client = class_310.method_1551();
    private static double[] activeClipPlaneEquationBeforeModelView;
    private static double[] activeClipPlaneAfterModelView;
    public static boolean isClippingEnabled;
    public static final double ADJUSTMENT = 0.01;

    public static void disableClipping() {
        if (IPGlobal.enableClippingMechanism && isClippingEnabled) {
            GL11.glDisable((int)12288);
            isClippingEnabled = false;
        }
    }

    private static void enableClipping() {
        if (IPGlobal.enableClippingMechanism && !isClippingEnabled) {
            GL11.glEnable((int)12288);
            isClippingEnabled = true;
        }
    }

    public static void updateInnerClipping(class_4587 matrixStack) {
        if (PortalRendering.isRendering()) {
            FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), matrixStack.method_23760().method_23761(), 0.0);
        } else {
            FrontClipping.disableClipping();
        }
    }

    public static void setupInnerClipping(Plane clipping, Matrix4f modelView, double adjustment) {
        if (!IPCGlobal.useFrontClipping) {
            return;
        }
        if (clipping != null) {
            activeClipPlaneEquationBeforeModelView = FrontClipping.getClipEquationInner(clipping.pos(), clipping.normal(), adjustment);
            activeClipPlaneAfterModelView = FrontClipping.transformClipEquation(activeClipPlaneEquationBeforeModelView, modelView);
            FrontClipping.enableClipping();
        } else {
            activeClipPlaneEquationBeforeModelView = null;
            FrontClipping.disableClipping();
        }
    }

    private static double[] transformClipEquation(double[] equation, Matrix4f modelView) {
        Vector4f eq = new Vector4f((float)equation[0], (float)equation[1], (float)equation[2], (float)equation[3]);
        Matrix4f m = new Matrix4f((Matrix4fc)modelView);
        m.invert();
        m.transpose();
        m.transform(eq);
        return new double[]{eq.x(), eq.y(), eq.z(), eq.w()};
    }

    private static double[] getClipEquationInner(class_243 clippingPoint, class_243 clippingDirection, double correction) {
        class_243 cameraPos = CHelper.getCurrentCameraPos();
        class_243 planeNormal = clippingDirection;
        class_243 portalPos = clippingPoint.method_1019(planeNormal.method_1021(correction)).method_1020(cameraPos);
        double c = planeNormal.method_1021(-1.0).method_1026(portalPos);
        return new double[]{planeNormal.field_1352, planeNormal.field_1351, planeNormal.field_1350, c};
    }

    public static void setupOuterClipping(class_4587 matrixStack, PortalLike portalLike) {
        if (!IPCGlobal.useFrontClipping) {
            return;
        }
        if (portalLike instanceof Portal) {
            activeClipPlaneEquationBeforeModelView = FrontClipping.getClipEquationOuter((Portal)portalLike);
            activeClipPlaneAfterModelView = FrontClipping.transformClipEquation(activeClipPlaneEquationBeforeModelView, matrixStack.method_23760().method_23761());
            FrontClipping.enableClipping();
        } else {
            activeClipPlaneEquationBeforeModelView = null;
            FrontClipping.disableClipping();
        }
    }

    private static double[] getClipEquationOuter(Portal portal) {
        class_243 planeNormal = portal.getNormal();
        class_243 portalPos = portal.getOriginPos().method_1020(FrontClipping.client.field_1773.method_19418().method_19326());
        double c = planeNormal.method_1021(-1.0).method_1026(portalPos);
        return new double[]{planeNormal.field_1352, planeNormal.field_1351, planeNormal.field_1350, c};
    }

    public static double[] getActiveClipPlaneEquationBeforeModelView() {
        return activeClipPlaneEquationBeforeModelView;
    }

    public static double[] getActiveClipPlaneEquationAfterModelView() {
        return activeClipPlaneAfterModelView;
    }

    public static void updateClippingEquationUniformForCurrentShader(boolean isRenderingEntities) {
        if (!IPGlobal.enableClippingMechanism) {
            return;
        }
        class_5944 shader = RenderSystem.getShader();
        if (shader == null) {
            return;
        }
        class_284 clippingEquationUniform = ((IEShader)shader).ip_getClippingEquationUniform();
        if (clippingEquationUniform != null) {
            if (isClippingEnabled) {
                double[] equation = isRenderingEntities ? activeClipPlaneAfterModelView : activeClipPlaneEquationBeforeModelView;
                clippingEquationUniform.method_1254((float)equation[0], (float)equation[1], (float)equation[2], (float)equation[3]);
            } else {
                clippingEquationUniform.method_1254(0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    public static void unsetClippingUniform() {
        if (!IPGlobal.enableClippingMechanism) {
            return;
        }
        class_5944 shader = RenderSystem.getShader();
        if (shader == null) {
            return;
        }
        class_284 clippingEquationUniform = ((IEShader)shader).ip_getClippingEquationUniform();
        if (clippingEquationUniform != null) {
            clippingEquationUniform.method_1254(0.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    static {
        isClippingEnabled = false;
    }
}

