/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.collision.PortalCollisionEntry;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

@Environment(value=EnvType.CLIENT)
public class CrossPortalEntityRenderer {
    private static final class_310 client = class_310.method_1551();
    private static final WeakHashMap<class_1297, Object> collidedEntities = new WeakHashMap();
    public static boolean isRenderingEntityNormally = false;
    public static boolean isRenderingEntityProjection = false;

    public static void init() {
        IPGlobal.postClientTickSignal.connect(CrossPortalEntityRenderer::onClientTick);
        IPGlobal.clientCleanupSignal.connect(CrossPortalEntityRenderer::cleanUp);
        ClientWorldLoader.clientDimensionDynamicRemoveSignal.connect(dim -> CrossPortalEntityRenderer.cleanUp());
    }

    private static void cleanUp() {
        collidedEntities.clear();
    }

    private static void onClientTick() {
        collidedEntities.entrySet().removeIf(entry -> {
            class_1297 entity = (class_1297)entry.getKey();
            return entity.method_31481() || !((IEEntity)entity).ip_isCollidingWithPortal();
        });
    }

    public static void onEntityTickClient(class_1297 entity) {
        if (entity instanceof Portal) {
            return;
        }
        if (((IEEntity)entity).ip_isCollidingWithPortal()) {
            collidedEntities.put(entity, null);
        }
    }

    public static void onBeginRenderingEntities(class_4587 matrixStack) {
        isRenderingEntityNormally = true;
        if (PortalRendering.isRendering()) {
            FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), matrixStack.method_23760().method_23761(), 0.0);
        }
    }

    private static boolean isCrossPortalRenderingEnabled() {
        if (IrisInterface.invoker.isIrisPresent()) {
            return false;
        }
        return IPGlobal.correctCrossPortalEntityRendering;
    }

    public static void onEndRenderingEntities(class_4587 matrixStack) {
        isRenderingEntityNormally = false;
        FrontClipping.disableClipping();
        if (!CrossPortalEntityRenderer.isCrossPortalRenderingEnabled()) {
            return;
        }
        CrossPortalEntityRenderer.renderEntityProjections(matrixStack);
    }

    public static void beforeRenderingEntity(class_1297 entity, class_4587 matrixStack) {
        PortalCollisionHandler collisionHandler;
        if (!CrossPortalEntityRenderer.isCrossPortalRenderingEnabled()) {
            return;
        }
        if (!PortalRendering.isRendering() && collidedEntities.containsKey(entity) && (collisionHandler = ((IEEntity)entity).ip_getPortalCollisionHandler()) != null) {
            for (PortalCollisionEntry e : collisionHandler.portalCollisions) {
                Portal collidingPortal = e.portal;
                client.method_22940().method_23000().method_22993();
                FrontClipping.setupOuterClipping(matrixStack, collidingPortal);
            }
        }
    }

    public static void afterRenderingEntity(class_1297 entity) {
        if (!CrossPortalEntityRenderer.isCrossPortalRenderingEnabled()) {
            return;
        }
        if (!PortalRendering.isRendering() && collidedEntities.containsKey(entity)) {
            client.method_22940().method_23000().method_22993();
            FrontClipping.disableClipping();
        }
    }

    private static void renderEntityProjections(class_4587 matrixStack) {
        if (!CrossPortalEntityRenderer.isCrossPortalRenderingEnabled()) {
            return;
        }
        class_5321 clientDim = CrossPortalEntityRenderer.client.field_1687.method_27983();
        for (class_1297 entity : collidedEntities.keySet()) {
            PortalCollisionHandler collisionHandler = ((IEEntity)entity).ip_getPortalCollisionHandler();
            if (collisionHandler == null) continue;
            for (PortalCollisionEntry e : collisionHandler.portalCollisions) {
                class_5321<class_1937> projectionDimension;
                Portal collidingPortal = e.portal;
                if (collidingPortal instanceof Mirror || clientDim != (projectionDimension = collidingPortal.dimensionTo)) continue;
                CrossPortalEntityRenderer.renderProjectedEntity(entity, collidingPortal, matrixStack);
            }
        }
    }

    public static boolean hasIntersection(class_243 outerPlanePos, class_243 outerPlaneNormal, class_243 entityPos, class_243 collidingPortalNormal) {
        return entityPos.method_1020(outerPlanePos).method_1026(outerPlaneNormal) > 0.01 && outerPlanePos.method_1020(entityPos).method_1026(collidingPortalNormal) > 0.01;
    }

    private static void renderProjectedEntity(class_1297 entity, Portal collidingPortal, class_4587 matrixStack) {
        if (PortalRendering.isRendering()) {
            PortalLike renderingPortal = PortalRendering.getRenderingPortal();
            if (renderingPortal instanceof Portal && !Portal.isFlippedPortal((Portal)renderingPortal, collidingPortal) && !Portal.isReversePortal((Portal)renderingPortal, collidingPortal)) {
                boolean isHidden;
                class_243 cameraPos = CrossPortalEntityRenderer.client.field_1773.method_19418().method_19326();
                boolean bl = isHidden = cameraPos.method_1020(collidingPortal.getDestPos()).method_1026(collidingPortal.getContentDirection()) < 0.0;
                if (renderingPortal == collidingPortal || !isHidden) {
                    CrossPortalEntityRenderer.renderEntity(entity, collidingPortal, matrixStack);
                }
            }
        } else {
            FrontClipping.disableClipping();
            client.method_22940().method_23000().method_22993();
            FrontClipping.setupInnerClipping(collidingPortal.getInnerClipping(), matrixStack.method_23760().method_23761(), 0.0);
            CrossPortalEntityRenderer.renderEntity(entity, collidingPortal, matrixStack);
            FrontClipping.disableClipping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderEntity(class_1297 entity, Portal transformingPortal, class_4587 matrixStack) {
        class_243 cameraPos = CrossPortalEntityRenderer.client.field_1773.method_19418().method_19326();
        class_638 newWorld = ClientWorldLoader.getWorld(transformingPortal.dimensionTo);
        class_243 entityPos = entity.method_19538();
        class_243 entityEyePos = McHelper.getEyePos(entity);
        class_243 entityLastTickPos = McHelper.lastTickPosOf(entity);
        class_243 entityLastTickEyePos = McHelper.getLastTickEyePos(entity);
        class_1937 oldWorld = entity.method_37908();
        class_243 newEyePos = transformingPortal.transformPoint(entityEyePos);
        if (PortalRendering.isRendering()) {
            PortalLike renderingPortal = PortalRendering.getRenderingPortal();
            class_243 transformedEntityPos = newEyePos.method_1020(McHelper.getEyeOffset(entity));
            class_238 transformedBoundingBox = McHelper.getBoundingBoxWithMovedPosition(entity, transformedEntityPos);
            boolean intersects = PortalManipulation.isOtherSideBoxInside(transformedBoundingBox, renderingPortal);
            if (!intersects) {
                return;
            }
        }
        if (entity instanceof class_746) {
            if (!IPGlobal.renderYourselfInPortal) {
                return;
            }
            if (!transformingPortal.getDoRenderPlayer()) {
                return;
            }
            if (CrossPortalEntityRenderer.client.field_1690.method_31044().method_31034()) {
                double dis = newEyePos.method_1022(cameraPos);
                double valve = 0.5 + entityLastTickPos.method_1022(entityPos);
                if (transformingPortal.scaling > 1.0) {
                    valve *= transformingPortal.scaling;
                }
                if (dis < valve) {
                    return;
                }
                class_238 transformedBoundingBox = Helper.transformBox((class_238)RenderStates.originalPlayerBoundingBox, transformingPortal::transformPoint);
                if (transformedBoundingBox.method_1006(CHelper.getCurrentCameraPos())) {
                    return;
                }
            }
        }
        isRenderingEntityProjection = true;
        matrixStack.method_22903();
        try {
            class_243 entityInstantPos = entityLastTickPos.method_35590(entityPos, (double)RenderStates.getPartialTick());
            class_243 newEntityInstantPos = transformingPortal.transformPoint(entityInstantPos);
            class_243 newCameraPos = entityInstantPos.method_1020(newEntityInstantPos).method_1019(cameraPos);
            CrossPortalEntityRenderer.setupEntityProjectionRenderingTransformation(transformingPortal, matrixStack, entityPos, entityLastTickPos, newCameraPos);
            class_4597.class_4598 consumers = client.method_22940().method_23000();
            ((IEWorldRenderer)CrossPortalEntityRenderer.client.field_1769).ip_myRenderEntity(entity, newCameraPos.field_1352, newCameraPos.field_1351, newCameraPos.field_1350, RenderStates.getPartialTick(), matrixStack, (class_4597)consumers);
            consumers.method_22993();
        }
        finally {
            matrixStack.method_22909();
            isRenderingEntityProjection = false;
        }
    }

    private static void setupEntityProjectionRenderingTransformation(Portal portal, class_4587 matrixStack, class_243 entityPos, class_243 entityLastTickPos, class_243 cameraPos) {
        if (portal.scaling == 1.0 && portal.getRotation() == null) {
            return;
        }
        class_243 anchor = entityLastTickPos.method_35590(entityPos, (double)RenderStates.getPartialTick()).method_1020(cameraPos);
        matrixStack.method_22904(anchor.field_1352, anchor.field_1351, anchor.field_1350);
        float scaling = (float)portal.scaling;
        matrixStack.method_22905(scaling, scaling, scaling);
        if (portal.getRotation() != null) {
            matrixStack.method_22907(portal.getRotation().toMcQuaternion());
        }
        matrixStack.method_22904(-anchor.field_1352, -anchor.field_1351, -anchor.field_1350);
    }

    public static boolean shouldRenderPlayerDefault() {
        PortalLike renderingPortal;
        if (!IPGlobal.renderYourselfInPortal) {
            return false;
        }
        if (!WorldRenderInfo.isRendering()) {
            return false;
        }
        class_746 player = CrossPortalEntityRenderer.client.field_1724;
        assert (player != null);
        if (PortalRendering.isRendering() && (renderingPortal = PortalRendering.getRenderingPortal()) instanceof Mirror) {
            float width = player.method_17681();
            if (renderingPortal.getDistanceToNearestPointInPortal(player.method_33571()) < (double)width * 0.8) {
                return false;
            }
        }
        return CrossPortalEntityRenderer.client.field_1687 == player.method_37908();
    }

    public static boolean shouldRenderEntityNow(class_1297 entity) {
        Validate.notNull((Object)entity);
        if (IrisInterface.invoker.isRenderingShadowMap()) {
            return true;
        }
        if (PortalRendering.isRendering()) {
            PortalLike renderingPortal = PortalRendering.getRenderingPortal();
            Portal collidingPortal = ((IEEntity)entity).ip_getCollidingPortal();
            if (entity instanceof class_1657 && !renderingPortal.getDoRenderPlayer()) {
                return false;
            }
            if (collidingPortal != null && !(entity instanceof class_746) && renderingPortal instanceof Portal && !Portal.isReversePortal(collidingPortal, (Portal)renderingPortal)) {
                boolean isHidden;
                class_243 cameraPos = PortalRenderer.client.field_1773.method_19418().method_19326();
                boolean bl = isHidden = cameraPos.method_1020(collidingPortal.getOriginPos()).method_1026(collidingPortal.getNormal()) < 0.0;
                if (isHidden) {
                    return false;
                }
            }
            return renderingPortal.isOnDestinationSide(CrossPortalEntityRenderer.getRenderingCameraPos(entity), -0.01);
        }
        return true;
    }

    public static boolean shouldRenderPlayerNormally(class_1297 entity) {
        if (!CrossPortalEntityRenderer.client.field_1690.method_31044().method_31034()) {
            return true;
        }
        if (RenderStates.originalPlayerBoundingBox.method_1006(CHelper.getCurrentCameraPos())) {
            return false;
        }
        double distanceToCamera = CrossPortalEntityRenderer.getRenderingCameraPos(entity).method_1022(CrossPortalEntityRenderer.client.field_1773.method_19418().method_19326());
        return distanceToCamera > 1.0 || PortalRendering.isRenderingOddNumberOfMirrors();
    }

    public static class_243 getRenderingCameraPos(class_1297 entity) {
        if (entity instanceof class_746) {
            return RenderStates.originalPlayerPos.method_1019(McHelper.getEyeOffset(entity));
        }
        return entity.method_5836(RenderStates.getPartialTick());
    }
}

