/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_3233;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.q_misc_util.MiscHelper;

public class FrameSearching {
    public static <T> void startSearchingPortalFrameAsync(class_3233 region, int regionRadius, class_2338 centerPoint, Predicate<class_2680> framePredicate, Function<class_2338.class_2339, T> matchShape, Consumer<T> onFound, Runnable onNotFound) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                Object result = FrameSearching.searchPortalFrame(region, regionRadius, centerPoint, framePredicate, matchShape);
                MiscHelper.getServer().execute(() -> {
                    if (result != null) {
                        onFound.accept(result);
                    } else {
                        onNotFound.run();
                    }
                });
            }
            catch (Throwable oops) {
                oops.printStackTrace();
                onNotFound.run();
            }
        }, class_156.method_18349());
    }

    @Nullable
    public static <T> T searchPortalFrame(class_3233 region, int regionRadius, class_2338 centerPoint, Predicate<class_2680> framePredicate, Function<class_2338.class_2339, T> matchShape) {
        ArrayList<class_2791> chunks = FrameSearching.getChunksFromNearToFar(region, centerPoint, regionRadius);
        int minSectionY = McHelper.getMinSectionY((class_1936)region);
        int maxSectionYExclusive = McHelper.getMaxSectionYExclusive((class_1936)region);
        return FrameSearching.searchPortalFrameWithYRange(framePredicate, matchShape, chunks, minSectionY, McHelper.getMinY((class_1936)region), McHelper.getMaxYExclusive((class_1936)region));
    }

    @Nullable
    private static <T> T searchPortalFrameWithYRange(Predicate<class_2680> framePredicate, Function<class_2338.class_2339, T> matchShape, ArrayList<class_2791> chunks, int minSectionY, int yRangeStart, int yRangeEnd) {
        class_2338.class_2339 temp = new class_2338.class_2339();
        for (int chunkIndex = 0; chunkIndex < chunks.size(); ++chunkIndex) {
            class_2791 chunk = chunks.get(chunkIndex);
            class_2826[] sectionArray = chunk.method_12006();
            for (int ySectionIndex = 0; ySectionIndex < sectionArray.length; ++ySectionIndex) {
                int sectionY = ySectionIndex + minSectionY;
                class_2826 chunkSection = sectionArray[ySectionIndex];
                if (chunkSection == null || chunkSection.method_38292()) continue;
                int localYStart = Math.max(0, yRangeStart - sectionY * 16);
                int localYEnd = Math.min(16, yRangeEnd - sectionY * 16);
                for (int localY = localYStart; localY < localYEnd; ++localY) {
                    for (int localZ = 0; localZ < 16; ++localZ) {
                        for (int localX = 0; localX < 16; ++localX) {
                            class_2680 blockState = chunkSection.method_12254(localX, localY, localZ);
                            if (!framePredicate.test(blockState)) continue;
                            int worldX = localX + chunk.method_12004().method_8326();
                            int worldY = localY + sectionY * 16;
                            int worldZ = localZ + chunk.method_12004().method_8328();
                            temp.method_10103(worldX, worldY, worldZ);
                            T result = matchShape.apply(temp);
                            if (result == null) continue;
                            return result;
                        }
                    }
                }
            }
        }
        return null;
    }

    private static ArrayList<class_2791> getChunksFromNearToFar(class_3233 region, class_2338 centerPoint, int regionRadius) {
        ArrayList<class_2791> chunks = new ArrayList<class_2791>();
        int searchedRadius = regionRadius - 1;
        int centerX = region.method_33561().field_9181;
        int centerZ = region.method_33561().field_9180;
        for (int x = centerX - searchedRadius; x <= centerX + searchedRadius; ++x) {
            for (int z = centerZ - searchedRadius; z <= centerZ + searchedRadius; ++z) {
                chunks.add(region.method_8392(x, z));
            }
        }
        chunks.sort(Comparator.comparingDouble(chunk -> chunk.method_12004().method_8323().method_10262((class_2382)centerPoint)));
        return chunks;
    }
}

