/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3545;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class BlockPortalShape {
    public static int defaultLengthLimit = 64;
    public class_2338 anchor;
    public Set<class_2338> area;
    public IntBox innerAreaBox;
    public IntBox totalAreaBox;
    public class_2350.class_2351 axis;
    public Set<class_2338> frameAreaWithoutCorner;
    public Set<class_2338> frameAreaWithCorner;
    public class_2338 firstFramePos;

    public BlockPortalShape(Set<class_2338> area, class_2350.class_2351 axis) {
        this.area = area;
        this.axis = axis;
        this.calcAnchor();
        this.calcFrameArea();
        this.calcAreaBox();
    }

    public BlockPortalShape(class_2487 tag) {
        this(BlockPortalShape.readArea(tag.method_10554("poses", 3)), class_2350.class_2351.values()[tag.method_10550("axis")]);
    }

    private static Set<class_2338> readArea(class_2499 list) {
        int size = list.size();
        Validate.isTrue((size % 3 == 0 ? 1 : 0) != 0);
        HashSet<class_2338> result = new HashSet<class_2338>();
        for (int i = 0; i < size / 3; ++i) {
            result.add(new class_2338(list.method_10600(i * 3 + 0), list.method_10600(i * 3 + 1), list.method_10600(i * 3 + 2)));
        }
        return result;
    }

    public static BlockPortalShape fromTag(class_2487 tag) {
        return new BlockPortalShape(tag);
    }

    public class_2487 toTag() {
        class_2487 data = new class_2487();
        class_2499 list = new class_2499();
        this.area.forEach(blockPos -> {
            list.method_10531(list.size(), (class_2520)class_2497.method_23247((int)blockPos.method_10263()));
            list.method_10531(list.size(), (class_2520)class_2497.method_23247((int)blockPos.method_10264()));
            list.method_10531(list.size(), (class_2520)class_2497.method_23247((int)blockPos.method_10260()));
        });
        data.method_10566("poses", (class_2520)list);
        data.method_10569("axis", this.axis.ordinal());
        return data;
    }

    public void calcAnchor() {
        this.anchor = this.area.stream().min(Comparator.comparingInt(class_2382::method_10263).thenComparingInt(class_2382::method_10264).thenComparingInt(class_2382::method_10260)).get();
        Validate.notNull((Object)this.anchor);
    }

    public void calcAreaBox() {
        this.innerAreaBox = (IntBox)Helper.reduce((Object)new IntBox(this.anchor, this.anchor), this.area.stream(), IntBox::getExpanded);
        this.totalAreaBox = (IntBox)Helper.reduce((Object)new IntBox(this.anchor, this.anchor), this.frameAreaWithoutCorner.stream(), IntBox::getExpanded);
    }

    public void calcFrameArea() {
        class_2350[] directions = Helper.getAnotherFourDirections((class_2350.class_2351)this.axis);
        this.frameAreaWithoutCorner = this.area.stream().flatMap(blockPos -> Stream.of(blockPos.method_10081(directions[0].method_10163()), blockPos.method_10081(directions[1].method_10163()), blockPos.method_10081(directions[2].method_10163()), blockPos.method_10081(directions[3].method_10163()))).filter(blockPos -> !this.area.contains(blockPos)).collect(Collectors.toSet());
        class_2338[] cornerOffsets = new class_2338[]{new class_2338(directions[0].method_10163()).method_10081(directions[1].method_10163()), new class_2338(directions[1].method_10163()).method_10081(directions[2].method_10163()), new class_2338(directions[2].method_10163()).method_10081(directions[3].method_10163()), new class_2338(directions[3].method_10163()).method_10081(directions[0].method_10163())};
        this.frameAreaWithCorner = this.area.stream().flatMap(blockPos -> Stream.of(blockPos.method_10081((class_2382)cornerOffsets[0]), blockPos.method_10081((class_2382)cornerOffsets[1]), blockPos.method_10081((class_2382)cornerOffsets[2]), blockPos.method_10081((class_2382)cornerOffsets[3]))).filter(blockPos -> !this.area.contains(blockPos)).collect(Collectors.toSet());
        this.frameAreaWithCorner.addAll(this.frameAreaWithoutCorner);
        this.firstFramePos = this.frameAreaWithoutCorner.iterator().next();
    }

    @Nullable
    public static BlockPortalShape findArea(class_2338 startingPos, class_2350.class_2351 axis, Predicate<class_2338> isAir, Predicate<class_2338> isObsidian) {
        return BlockPortalShape.findArea(startingPos, axis, isAir, isObsidian, defaultLengthLimit);
    }

    @Nullable
    public static BlockPortalShape findArea(class_2338 startingPos, class_2350.class_2351 axis, Predicate<class_2338> isAir, Predicate<class_2338> isObsidian, int lengthLimit) {
        if (!isAir.test(startingPos)) {
            return null;
        }
        return BlockPortalShape.findShapeWithoutRegardingStartingPos(startingPos, axis, isAir, isObsidian, lengthLimit);
    }

    @Nullable
    public static BlockPortalShape findShapeWithoutRegardingStartingPos(class_2338 startingPos, class_2350.class_2351 axis, Predicate<class_2338> isAir, Predicate<class_2338> isObsidian) {
        return BlockPortalShape.findShapeWithoutRegardingStartingPos(startingPos, axis, isAir, isObsidian, defaultLengthLimit);
    }

    @Nullable
    private static BlockPortalShape findShapeWithoutRegardingStartingPos(class_2338 startingPos, class_2350.class_2351 axis, Predicate<class_2338> isAir, Predicate<class_2338> isObsidian, int lengthLimit) {
        startingPos = startingPos.method_10062();
        HashSet<class_2338> area = new HashSet<class_2338>();
        area.add(startingPos);
        class_2350[] directions = Helper.getAnotherFourDirections((class_2350.class_2351)axis);
        boolean isNormalFrame = BlockPortalShape.findAreaBreadthFirst(startingPos, isAir, isObsidian, directions, area, startingPos, lengthLimit);
        if (!isNormalFrame) {
            return null;
        }
        BlockPortalShape result = new BlockPortalShape(area, axis);
        class_2338 innerSize = result.innerAreaBox.getSize();
        if (innerSize.method_10263() > lengthLimit || innerSize.method_10264() > lengthLimit || innerSize.method_10260() > lengthLimit) {
            return null;
        }
        return result;
    }

    private static boolean findAreaBreadthFirst(class_2338 startingPos, Predicate<class_2338> isAir, Predicate<class_2338> isObsidian, class_2350[] directions, Set<class_2338> foundArea, class_2338 initialPos, int lengthLimit) {
        ArrayDeque<class_2338> newlyAdded = new ArrayDeque<class_2338>();
        newlyAdded.addLast(startingPos);
        while (!newlyAdded.isEmpty()) {
            if (foundArea.size() > lengthLimit * lengthLimit) {
                return false;
            }
            class_2338 last = (class_2338)newlyAdded.pollFirst();
            for (class_2350 direction : directions) {
                class_2338 curr = last.method_10093(direction).method_10062();
                if (foundArea.contains(curr)) continue;
                if (isAir.test(curr)) {
                    newlyAdded.addLast(curr);
                    foundArea.add(curr);
                    continue;
                }
                if (isObsidian.test(curr)) continue;
                return false;
            }
            class_2338 delta = initialPos.method_10059((class_2382)startingPos);
            if (Math.abs(delta.method_10263()) <= lengthLimit && Math.abs(delta.method_10264()) <= lengthLimit && Math.abs(delta.method_10260()) <= lengthLimit) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BlockPortalShape matchShape(Predicate<class_2338> isAir, Predicate<class_2338> isObsidian, class_2338 newAnchor, class_2338.class_2339 temp) {
        if (!isAir.test(newAnchor)) {
            return null;
        }
        boolean testFrame = this.testFrameWithoutCorner(isObsidian, newAnchor, temp);
        if (!testFrame) {
            return null;
        }
        boolean testAir = this.area.stream().map(blockPos -> temp.method_10103(blockPos.method_10263() - this.anchor.method_10263() + newAnchor.method_10263(), blockPos.method_10264() - this.anchor.method_10264() + newAnchor.method_10264(), blockPos.method_10260() - this.anchor.method_10260() + newAnchor.method_10260())).allMatch(isAir);
        if (!testAir) {
            return null;
        }
        return this.getShapeWithMovedAnchor(newAnchor);
    }

    private boolean testFrameWithoutCorner(Predicate<class_2338> isObsidian, class_2338 newAnchor, class_2338.class_2339 temp) {
        Function<class_2338, class_2338.class_2339> mapper = blockPos -> temp.method_10103(blockPos.method_10263() - this.anchor.method_10263() + newAnchor.method_10263(), blockPos.method_10264() - this.anchor.method_10264() + newAnchor.method_10264(), blockPos.method_10260() - this.anchor.method_10260() + newAnchor.method_10260());
        if (!isObsidian.test((class_2338)mapper.apply(this.firstFramePos))) {
            return false;
        }
        return this.frameAreaWithoutCorner.stream().map(mapper).allMatch(isObsidian);
    }

    public BlockPortalShape getShapeWithMovedAnchor(class_2338 newAnchor) {
        class_2338 offset = newAnchor.method_10059((class_2382)this.anchor);
        return new BlockPortalShape(this.area.stream().map(blockPos -> blockPos.method_10081((class_2382)offset)).collect(Collectors.toSet()), this.axis);
    }

    public boolean isFrameIntact(Predicate<class_2338> isObsidian) {
        return this.frameAreaWithoutCorner.stream().allMatch(isObsidian);
    }

    public boolean isPortalIntact(Predicate<class_2338> isPortalBlock, Predicate<class_2338> isObsidian) {
        return this.isFrameIntact(isObsidian) && this.area.stream().allMatch(isPortalBlock);
    }

    public void initPortalPosAxisShape(Portal portal, class_2350.class_2352 axisDirection) {
        class_243 center = this.innerAreaBox.getCenterVec();
        portal.method_5814(center.field_1352, center.field_1351, center.field_1350);
        this.initPortalAxisShape(portal, center, class_2350.method_10169((class_2350.class_2351)this.axis, (class_2350.class_2352)axisDirection));
    }

    public void initPortalAxisShape(Portal portal, class_243 center, class_2350 facing) {
        Validate.isTrue((facing.method_10166() == this.axis ? 1 : 0) != 0);
        class_3545 perpendicularDirections = Helper.getPerpendicularDirections((class_2350)facing);
        class_2350 wDirection = (class_2350)perpendicularDirections.method_15442();
        class_2350 hDirection = (class_2350)perpendicularDirections.method_15441();
        portal.axisW = class_243.method_24954((class_2382)wDirection.method_10163());
        portal.axisH = class_243.method_24954((class_2382)hDirection.method_10163());
        portal.width = Helper.getCoordinate((class_2382)this.innerAreaBox.getSize(), (class_2350.class_2351)wDirection.method_10166());
        portal.height = Helper.getCoordinate((class_2382)this.innerAreaBox.getSize(), (class_2350.class_2351)hDirection.method_10166());
        class_243 offset = class_243.method_24954((class_2382)class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)this.axis).method_10163()).method_1021(0.5);
        if (this.isRectangle()) {
            portal.specialShape = null;
        } else {
            GeometryPortalShape simplified;
            GeometryPortalShape shape = new GeometryPortalShape();
            this.area.forEach(part -> {
                class_243 p1 = class_243.method_24954((class_2382)part).method_1019(offset);
                class_243 p2 = class_243.method_24954((class_2382)part).method_1031(1.0, 1.0, 1.0).method_1019(offset);
                double p1LocalX = p1.method_1020(center).method_1026(portal.axisW);
                double p1LocalY = p1.method_1020(center).method_1026(portal.axisH);
                double p2LocalX = p2.method_1020(center).method_1026(portal.axisW);
                double p2LocalY = p2.method_1020(center).method_1026(portal.axisH);
                shape.addTriangleForRectangle(p1LocalX, p1LocalY, p2LocalX, p2LocalY);
            });
            shape.normalize(portal.width, portal.height);
            portal.specialShape = simplified = shape.simplified();
        }
    }

    public BlockPortalShape matchShapeWithMovedFirstFramePos(Predicate<class_2338> isAir, Predicate<class_2338> isObsidian, class_2338 newFirstObsidianPos, class_2338.class_2339 temp) {
        boolean testFrame = this.frameAreaWithoutCorner.stream().map(blockPos1 -> temp.method_10103(blockPos1.method_10263() - this.firstFramePos.method_10263() + newFirstObsidianPos.method_10263(), blockPos1.method_10264() - this.firstFramePos.method_10264() + newFirstObsidianPos.method_10264(), blockPos1.method_10260() - this.firstFramePos.method_10260() + newFirstObsidianPos.method_10260())).allMatch(isObsidian);
        if (!testFrame) {
            return null;
        }
        boolean testAir = this.area.stream().map(blockPos -> temp.method_10103(blockPos.method_10263() - this.firstFramePos.method_10263() + newFirstObsidianPos.method_10263(), blockPos.method_10264() - this.firstFramePos.method_10264() + newFirstObsidianPos.method_10264(), blockPos.method_10260() - this.firstFramePos.method_10260() + newFirstObsidianPos.method_10260())).allMatch(isAir);
        if (!testAir) {
            return null;
        }
        class_2338 offset = newFirstObsidianPos.method_10059((class_2382)this.firstFramePos);
        return new BlockPortalShape(this.area.stream().map(blockPos -> blockPos.method_10081((class_2382)offset)).collect(Collectors.toSet()), this.axis);
    }

    public static boolean isSquareShape(BlockPortalShape shape, int length) {
        class_3545 xs;
        class_2338 areaSize = shape.innerAreaBox.getSize();
        return Helper.getCoordinate((class_2382)areaSize, (class_2350.class_2351)((class_2350.class_2351)(xs = Helper.getAnotherTwoAxis((class_2350.class_2351)shape.axis)).method_15442())) == length && Helper.getCoordinate((class_2382)areaSize, (class_2350.class_2351)((class_2350.class_2351)xs.method_15441())) == length && shape.area.size() == length * length;
    }

    public static BlockPortalShape getSquareShapeTemplate(class_2350.class_2351 axis, int length) {
        class_3545 perpendicularDirections = Helper.getPerpendicularDirections((class_2350)class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056));
        HashSet<class_2338> area = new HashSet<class_2338>();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < length; ++j) {
                area.add(class_2338.field_10980.method_10079((class_2350)perpendicularDirections.method_15442(), i).method_10079((class_2350)perpendicularDirections.method_15441(), j));
            }
        }
        return new BlockPortalShape(area, axis);
    }

    public BlockPortalShape getShapeWithMovedTotalAreaBox(IntBox newTotalAreaBox) {
        Validate.isTrue((boolean)this.totalAreaBox.getSize().equals((Object)newTotalAreaBox.getSize()));
        return this.getShapeWithMovedAnchor(newTotalAreaBox.l.method_10059((class_2382)this.totalAreaBox.l).method_10081((class_2382)this.anchor));
    }

    public int getShapeInnerLength() {
        class_2338 size = this.innerAreaBox.getSize();
        return Math.max(size.method_10263(), Math.max(size.method_10264(), size.method_10260()));
    }

    public boolean isRectangle() {
        class_2338 size = this.innerAreaBox.getSize();
        return size.method_10263() * size.method_10264() * size.method_10260() == this.area.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockPortalShape that = (BlockPortalShape)o;
        return this.area.equals(that.area) && this.axis == that.axis;
    }

    public int hashCode() {
        return Objects.hash(this.area, this.axis);
    }
}

