/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.global_portals;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.GlobalTrackedPortal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class WorldWrappingPortal
extends GlobalTrackedPortal {
    public static final class_1299<WorldWrappingPortal> entityType = Portal.createPortalEntityType(WorldWrappingPortal::new);
    public boolean isInward = true;
    public int zoneId = -1;

    public WorldWrappingPortal(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_10545("isInward")) {
            this.isInward = compoundTag.method_10577("isInward");
        }
        if (compoundTag.method_10545("zoneId")) {
            this.zoneId = compoundTag.method_10550("zoneId");
        }
    }

    @Override
    protected void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556("isInward", this.isInward);
        compoundTag.method_10569("zoneId", this.zoneId);
    }

    private static WorldWrappingPortal createWrappingPortal(class_3218 serverWorld, class_238 area, class_2350 direction, int zoneId, boolean isInward) {
        WorldWrappingPortal portal = (WorldWrappingPortal)entityType.method_5883((class_1937)serverWorld);
        portal.isInward = isInward;
        portal.zoneId = zoneId;
        WorldWrappingPortal.initWrappingPortal(serverWorld, area, direction, isInward, portal);
        return portal;
    }

    public static void initWrappingPortal(class_3218 serverWorld, class_238 area, class_2350 direction, boolean isInward, Portal portal) {
        class_243 areaSize = Helper.getBoxSize((class_238)area);
        class_3545 axises = Helper.getPerpendicularDirections((class_2350)(isInward ? direction : direction.method_10153()));
        class_238 boxSurface = Helper.getBoxSurfaceInversed((class_238)area, (class_2350)direction);
        class_243 center = boxSurface.method_1005();
        class_238 oppositeSurface = Helper.getBoxSurfaceInversed((class_238)area, (class_2350)direction.method_10153());
        class_243 destination = oppositeSurface.method_1005();
        portal.method_5814(center.field_1352, center.field_1351, center.field_1350);
        portal.setDestination(destination);
        portal.axisW = class_243.method_24954((class_2382)((class_2350)axises.method_15442()).method_10163());
        portal.axisH = class_243.method_24954((class_2382)((class_2350)axises.method_15441()).method_10163());
        portal.width = Helper.getCoordinate((class_243)areaSize, (class_2350.class_2351)((class_2350)axises.method_15442()).method_10166());
        portal.height = Helper.getCoordinate((class_243)areaSize, (class_2350.class_2351)((class_2350)axises.method_15441()).method_10166());
        portal.dimensionTo = serverWorld.method_27983();
    }

    public static List<WrappingZone> getWrappingZones(class_3218 world) {
        GlobalPortalStorage gps = GlobalPortalStorage.get(world);
        ArrayList<WrappingZone> result = new ArrayList<WrappingZone>();
        gps.data.stream().filter(portal -> portal instanceof WorldWrappingPortal).map(portal -> (WorldWrappingPortal)portal).collect(Collectors.groupingBy(portal -> portal.zoneId)).forEach((zoneId, portals) -> result.add(new WrappingZone(world, ((WorldWrappingPortal)portals.get((int)0)).isInward, (int)zoneId, (List<WorldWrappingPortal>)portals)));
        return result;
    }

    public static int getAvailableId(List<WrappingZone> zones) {
        return zones.stream().max(Comparator.comparingInt(z -> z.id)).map(z -> z.id + 1).orElse(1);
    }

    public static void invokeAddWrappingZone(class_3218 world, int x1, int z1, int x2, int z2, boolean isInward, Consumer<class_2561> feedbackSender) {
        List<WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        for (WrappingZone zone : wrappingZones) {
            if (zone.isValid()) continue;
            feedbackSender.accept((class_2561)class_2561.method_43469((String)"imm_ptl.removed_invalid_wrapping_portals", (Object[])new Object[]{Helper.myToString(zone.portals.stream())}));
            zone.removeFromWorld();
        }
        int availableId = WorldWrappingPortal.getAvailableId(wrappingZones);
        class_238 box = new IntBox(new class_2338(x1, McHelper.getMinY((class_1936)world), z1), new class_2338(x2, McHelper.getMaxYExclusive((class_1936)world) - 1, z2)).toRealNumberBox();
        WorldWrappingPortal p1 = WorldWrappingPortal.createWrappingPortal(world, box, class_2350.field_11043, availableId, isInward);
        WorldWrappingPortal p2 = WorldWrappingPortal.createWrappingPortal(world, box, class_2350.field_11035, availableId, isInward);
        WorldWrappingPortal p3 = WorldWrappingPortal.createWrappingPortal(world, box, class_2350.field_11039, availableId, isInward);
        WorldWrappingPortal p4 = WorldWrappingPortal.createWrappingPortal(world, box, class_2350.field_11034, availableId, isInward);
        GlobalPortalStorage gps = GlobalPortalStorage.get(world);
        gps.addPortal(p1);
        gps.addPortal(p2);
        gps.addPortal(p3);
        gps.addPortal(p4);
    }

    public static void invokeViewWrappingZones(class_3218 world, Consumer<class_2561> feedbackSender) {
        List<WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        wrappingZones.forEach(wrappingZone -> feedbackSender.accept((class_2561)class_2561.method_43470((String)wrappingZone.toString())));
    }

    public static void invokeRemoveWrappingZone(class_3218 world, class_243 playerPos, Consumer<class_2561> feedbackSender) {
        List<WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        WrappingZone zone = wrappingZones.stream().filter(z -> z.getArea().method_1006(playerPos)).findFirst().orElse(null);
        if (zone != null) {
            zone.removeFromWorld();
            feedbackSender.accept((class_2561)class_2561.method_43469((String)"imm_ptl.removed_portal", (Object[])new Object[]{zone.toString()}));
        } else {
            feedbackSender.accept((class_2561)class_2561.method_43471((String)"imm_ptl.not_in_wrapping_zone"));
        }
    }

    public static void invokeRemoveWrappingZone(class_3218 world, int zoneId, Consumer<class_2561> feedbackSender) {
        List<WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        WrappingZone zone = wrappingZones.stream().filter(wrappingZone -> wrappingZone.id == zoneId).findFirst().orElse(null);
        if (zone != null) {
            zone.removeFromWorld();
            feedbackSender.accept((class_2561)class_2561.method_43469((String)"imm_ptl.removed_portal", (Object[])new Object[]{zone.toString()}));
        } else {
            feedbackSender.accept((class_2561)class_2561.method_43471((String)"imm_ptl.cannot_find_zone"));
        }
    }

    public static class WrappingZone {
        public class_3218 world;
        public boolean isInwardZone;
        public int id;
        public List<WorldWrappingPortal> portals;

        public WrappingZone(class_3218 world, boolean isInwardZone, int id, List<WorldWrappingPortal> portals) {
            this.world = world;
            this.isInwardZone = isInwardZone;
            this.id = id;
            this.portals = portals;
        }

        public boolean isValid() {
            return this.portals.size() == 4 && this.portals.get((int)0).isInward == this.isInwardZone && this.portals.get((int)1).isInward == this.isInwardZone && this.portals.get((int)2).isInward == this.isInwardZone && this.portals.get((int)3).isInward == this.isInwardZone;
        }

        public void removeFromWorld() {
            GlobalPortalStorage gps = GlobalPortalStorage.get(this.world);
            this.portals.forEach(worldWrappingPortal -> gps.removePortal((Portal)worldWrappingPortal));
        }

        public class_238 getArea() {
            return this.portals.stream().map(Portal::getThinAreaBox).reduce(class_238::method_991).orElse(null);
        }

        public IntBox getIntArea() {
            class_238 floatBox = this.getArea();
            return new IntBox(new class_2338((int)Math.round(floatBox.field_1323), McHelper.getMinY((class_1936)this.world), (int)Math.round(floatBox.field_1321)), new class_2338((int)Math.round(floatBox.field_1320) - 1, McHelper.getMaxYExclusive((class_1936)this.world), (int)Math.round(floatBox.field_1324) - 1));
        }

        public IntBox getBorderBox() {
            if (!this.isInwardZone) {
                return this.getIntArea();
            }
            class_238 floatBox = this.getArea();
            return new IntBox(new class_2338((int)Math.round(floatBox.field_1323) - 1, McHelper.getMinY((class_1936)this.world), (int)Math.round(floatBox.field_1321) - 1), new class_2338((int)Math.round(floatBox.field_1320), McHelper.getMaxYExclusive((class_1936)this.world), (int)Math.round(floatBox.field_1324)));
        }

        public String toString() {
            class_238 area = this.getArea();
            return String.format("[%d] %s %s %s ~ %s %s\n", this.id, this.isInwardZone ? "inward" : "outward", area.field_1323, area.field_1321, area.field_1320, area.field_1324);
        }
    }
}

