/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.global_portals;

import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.GlobalTrackedPortal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.DQuaternion;

public class VerticalConnectingPortal
extends GlobalTrackedPortal {
    public static final class_1299<VerticalConnectingPortal> entityType = Portal.createPortalEntityType(VerticalConnectingPortal::new);

    private static Predicate<Portal> getPredicate(ConnectorType connectorType) {
        switch (connectorType) {
            case floor: {
                return portal -> portal instanceof VerticalConnectingPortal && portal.getNormal().field_1351 > 0.0;
            }
        }
        return portal -> portal instanceof VerticalConnectingPortal && portal.getNormal().field_1351 < 0.0;
    }

    public VerticalConnectingPortal(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static void connect(class_5321<class_1937> from, ConnectorType connectorType, class_5321<class_1937> to) {
        VerticalConnectingPortal.connect(from, connectorType, to, false);
    }

    public static void connect(class_5321<class_1937> from, ConnectorType connectorType, class_5321<class_1937> to, boolean respectSpaceRatio) {
        VerticalConnectingPortal.removeConnectingPortal(connectorType, from);
        class_3218 fromWorld = MiscHelper.getServer().method_3847(from);
        class_3218 toWorld = MiscHelper.getServer().method_3847(to);
        VerticalConnectingPortal connectingPortal = VerticalConnectingPortal.createConnectingPortal(fromWorld, connectorType, toWorld, respectSpaceRatio ? fromWorld.method_8597().comp_646() / toWorld.method_8597().comp_646() : 1.0, false, 0.0, McHelper.getMinY((class_1936)fromWorld), McHelper.getMaxContentYExclusive((class_1936)fromWorld), McHelper.getMinY((class_1936)toWorld), McHelper.getMaxContentYExclusive((class_1936)toWorld));
        GlobalPortalStorage storage = GlobalPortalStorage.get(fromWorld);
        storage.addPortal(connectingPortal);
    }

    public static void connectMutually(class_5321<class_1937> up, class_5321<class_1937> down, boolean respectSpaceRatio) {
        VerticalConnectingPortal.connect(up, ConnectorType.floor, down, respectSpaceRatio);
        VerticalConnectingPortal.connect(down, ConnectorType.ceil, up, respectSpaceRatio);
    }

    public static VerticalConnectingPortal createConnectingPortal(class_3218 fromWorld, ConnectorType connectorType, class_3218 toWorld, double scaling, boolean inverted, double rotationAlongYDegrees, int fromWorldMinY, int fromWorldMaxY, int toWorldMinY, int toWorldMaxY) {
        DQuaternion rotation;
        VerticalConnectingPortal verticalConnectingPortal = new VerticalConnectingPortal(entityType, (class_1937)fromWorld);
        verticalConnectingPortal.dimensionTo = toWorld.method_27983();
        verticalConnectingPortal.width = 2.3333333333E10;
        verticalConnectingPortal.height = 2.3333333333E10;
        switch (connectorType) {
            case floor: {
                verticalConnectingPortal.method_5814(0.0, fromWorldMinY, 0.0);
                verticalConnectingPortal.axisW = new class_243(0.0, 0.0, 1.0);
                verticalConnectingPortal.axisH = new class_243(1.0, 0.0, 0.0);
                break;
            }
            case ceil: {
                verticalConnectingPortal.method_5814(0.0, fromWorldMaxY, 0.0);
                verticalConnectingPortal.axisW = new class_243(1.0, 0.0, 0.0);
                verticalConnectingPortal.axisH = new class_243(0.0, 0.0, 1.0);
            }
        }
        if (!inverted) {
            switch (connectorType) {
                case floor: {
                    verticalConnectingPortal.setDestination(new class_243(0.0, (double)toWorldMaxY, 0.0));
                    break;
                }
                case ceil: {
                    verticalConnectingPortal.setDestination(new class_243(0.0, (double)toWorldMinY, 0.0));
                }
            }
        } else {
            switch (connectorType) {
                case floor: {
                    verticalConnectingPortal.setDestination(new class_243(0.0, (double)toWorldMinY, 0.0));
                    break;
                }
                case ceil: {
                    verticalConnectingPortal.setDestination(new class_243(0.0, (double)toWorldMaxY, 0.0));
                }
            }
        }
        DQuaternion inversionRotation = inverted ? DQuaternion.rotationByDegrees((class_243)new class_243(1.0, 0.0, 0.0), (double)180.0) : null;
        DQuaternion additionalRotation = rotationAlongYDegrees != 0.0 ? DQuaternion.rotationByDegrees((class_243)new class_243(0.0, 1.0, 0.0), (double)rotationAlongYDegrees) : null;
        verticalConnectingPortal.rotation = rotation = (DQuaternion)Helper.combineNullable((Object)inversionRotation, additionalRotation, DQuaternion::hamiltonProduct);
        if (scaling != 1.0) {
            verticalConnectingPortal.scaling = scaling;
            verticalConnectingPortal.teleportChangesScale = false;
            PortalExtension.get((Portal)verticalConnectingPortal).adjustPositionAfterTeleport = false;
        }
        return verticalConnectingPortal;
    }

    public static void removeConnectingPortal(ConnectorType connectorType, class_5321<class_1937> dimension) {
        VerticalConnectingPortal.removeConnectingPortal(VerticalConnectingPortal.getPredicate(connectorType), dimension);
    }

    private static void removeConnectingPortal(Predicate<Portal> predicate, class_5321<class_1937> dimension) {
        class_3218 endWorld = MiscHelper.getServer().method_3847(dimension);
        GlobalPortalStorage storage = GlobalPortalStorage.get(endWorld);
        storage.removePortals(portal -> portal instanceof VerticalConnectingPortal && predicate.test((Portal)portal));
    }

    public static VerticalConnectingPortal getConnectingPortal(class_1937 world, ConnectorType type) {
        return GlobalPortalStorage.getGlobalPortals(world).stream().filter(VerticalConnectingPortal.getPredicate(type)).findFirst().orElse(null);
    }

    public static enum ConnectorType {
        ceil,
        floor;

    }
}

