/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.global_portals;

import com.google.common.base.Supplier;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3227;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.global_portals.WorldWrappingPortal;
import qouteall.q_misc_util.my_util.IntBox;

public class BorderBarrierFiller {
    private static final WeakHashMap<class_3222, Object> warnedPlayers = new WeakHashMap();

    public static void onCommandExecuted(class_3222 player) {
        class_3218 world = (class_3218)player.method_37908();
        class_243 playerPos = player.method_19538();
        List<WorldWrappingPortal.WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        WorldWrappingPortal.WrappingZone zone = wrappingZones.stream().filter(wrappingZone -> wrappingZone.getArea().method_1006(playerPos)).findFirst().orElse(null);
        if (zone == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"imm_ptl.cannot_find_zone"), false);
            return;
        }
        BorderBarrierFiller.doInvoke(player, world, zone);
    }

    public static void onCommandExecuted(class_3222 player, int zoneId) {
        class_3218 world = (class_3218)player.method_37908();
        List<WorldWrappingPortal.WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        WorldWrappingPortal.WrappingZone zone = wrappingZones.stream().filter(wrappingZone -> wrappingZone.id == zoneId).findFirst().orElse(null);
        if (zone == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"imm_ptl.cannot_find_zone"), false);
            return;
        }
        BorderBarrierFiller.doInvoke(player, world, zone);
    }

    private static void doInvoke(class_3222 player, class_3218 world, WorldWrappingPortal.WrappingZone zone) {
        IntBox borderBox = zone.getBorderBox();
        boolean warned = warnedPlayers.containsKey(player);
        if (!warned) {
            warnedPlayers.put(player, null);
            class_2338 size = borderBox.getSize();
            int totalColumns = size.method_10263() * 2 + size.method_10260() * 2;
            double sizeEstimationGB = (double)totalColumns / 80000.0 * 0.5;
            player.method_7353((class_2561)class_2561.method_43469((String)"imm_ptl.clear_border_warning", (Object[])new Object[]{sizeEstimationGB < 0.01 ? 0.0 : sizeEstimationGB}), false);
        } else {
            warnedPlayers.remove(player);
            player.method_7353((class_2561)class_2561.method_43471((String)"imm_ptl.start_clearing_border"), false);
            BorderBarrierFiller.startFillingBorder(world, borderBox, l -> player.method_7353(l, false));
        }
    }

    private static void startFillingBorder(class_3218 world, IntBox borderBox, Consumer<class_2561> informer) {
        Supplier xStream = () -> IntStream.range(borderBox.l.method_10263(), borderBox.h.method_10263() + 1);
        Supplier zStream = () -> IntStream.range(borderBox.l.method_10260(), borderBox.h.method_10260() + 1);
        class_2338.class_2339 temp = new class_2338.class_2339();
        class_2338.class_2339 temp1 = new class_2338.class_2339();
        Stream stream = Streams.concat((Stream[])new Stream[]{((IntStream)xStream.get()).mapToObj(x -> temp.method_10103(x, 0, borderBox.l.method_10260())), ((IntStream)xStream.get()).mapToObj(x -> temp.method_10103(x, 0, borderBox.h.method_10260())), ((IntStream)zStream.get()).mapToObj(z -> temp.method_10103(borderBox.l.method_10263(), 0, z)), ((IntStream)zStream.get()).mapToObj(z -> temp.method_10103(borderBox.h.method_10263(), 0, z))});
        class_2338 size = borderBox.getSize();
        int totalColumns = size.method_10263() * 2 + size.method_10260() * 2;
        int minY = McHelper.getMinY((class_1936)world);
        int maxYEx = McHelper.getMaxYExclusive((class_1936)world);
        class_3227 lightingProvider = world.method_14178().method_17293();
        McHelper.performMultiThreadedFindingTaskOnServer(stream, columnPos -> {
            class_2791 chunk = world.method_22350((class_2338)columnPos);
            for (int y = minY; y < maxYEx; ++y) {
                temp1.method_10103(columnPos.method_10263(), y, columnPos.method_10260());
                chunk.method_12010((class_2338)temp1, class_2246.field_10124.method_9564(), false);
                lightingProvider.method_15513((class_2338)temp1);
            }
            return false;
        }, columns -> {
            if (McHelper.getServerGameTime() % 20L == 0L) {
                informer.accept((class_2561)class_2561.method_43470((String)String.format("Progress: %d / %d", columns, totalColumns)));
            }
            return true;
        }, e -> {}, () -> informer.accept((class_2561)class_2561.method_43471((String)"imm_ptl.finished_clearing_border")), () -> {});
    }
}

