/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.SimpleBlockPredicate;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.DiligentMatcher;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.FlippingFloorSquareForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.BlockTraverse;
import qouteall.imm_ptl.core.portal.nether_portal.GeneralBreakablePortal;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class ConvertConventionalPortalForm
extends PortalGenForm {
    public static final Codec<ConvertConventionalPortalForm> codec = RecordCodecBuilder.create(instance -> instance.group((App)SimpleBlockPredicate.codec.fieldOf("portal_block").forGetter(o -> o.portalBlock)).apply((Applicative)instance, instance.stable(ConvertConventionalPortalForm::new)));
    public final SimpleBlockPredicate portalBlock;

    public ConvertConventionalPortalForm(SimpleBlockPredicate portalBlock) {
        this.portalBlock = portalBlock;
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        return codec;
    }

    @Override
    public PortalGenForm getReverse() {
        return this;
    }

    @Override
    public boolean perform(CustomPortalGeneration cpg, class_3218 fromWorld, class_2338 startingPos, class_3218 toWorld, @Nullable class_1297 triggeringEntity) {
        if (triggeringEntity == null) {
            Helper.err((Object)"Null triggering entity for portal conversion");
            return false;
        }
        if (!(triggeringEntity instanceof class_3222)) {
            Helper.err((Object)"Non player entity triggers portal conversion");
            return false;
        }
        class_3222 player = (class_3222)triggeringEntity;
        if (player.method_37908() != toWorld) {
            Helper.err((Object)("The player is not in the correct world " + player.method_37908().method_27983().method_29177()));
            return false;
        }
        class_2338 playerCurrentPos = player.method_24515().method_10062();
        class_2338 startFramePos = ConvertConventionalPortalForm.findBlockAround((class_1937)fromWorld, startingPos, this.portalBlock);
        if (startFramePos == null) {
            return false;
        }
        class_2338 toFramePos = ConvertConventionalPortalForm.findBlockAround((class_1937)toWorld, playerCurrentPos, this.portalBlock);
        if (toFramePos == null) {
            return false;
        }
        Helper.log((Object)String.format("Trying to convert conventional portal %s -> %s by %s (%d %d %d)", fromWorld.method_27983().method_29177(), toWorld.method_27983().method_29177(), player.method_5477().method_10851(), (int)player.method_23317(), (int)player.method_23318(), (int)player.method_23321()));
        BlockPortalShape fromShape = NetherPortalGeneration.findFrameShape(fromWorld, startFramePos, this.portalBlock, s -> !s.method_26215());
        if (fromShape == null) {
            Helper.err((Object)"Cannot find from side shape");
            return false;
        }
        BlockPortalShape toShape = NetherPortalGeneration.findFrameShape(toWorld, toFramePos, this.portalBlock, s -> !s.method_26215());
        if (toShape == null) {
            Helper.err((Object)"Cannot fine to side shape");
            return false;
        }
        Helper.log((Object)(fromShape.innerAreaBox + " " + toShape.innerAreaBox));
        PortalGenInfo portalGenInfo = ConvertConventionalPortalForm.tryToMatch((class_5321<class_1937>)fromWorld.method_27983(), (class_5321<class_1937>)toWorld.method_27983(), fromShape, toShape);
        if (portalGenInfo == null) {
            Helper.err((Object)"Shapes are incompatible");
            player.method_7353((class_2561)class_2561.method_43471((String)"imm_ptl.incompatible_shape"), false);
            return false;
        }
        portalGenInfo.generatePlaceholderBlocks();
        if (fromShape.axis == class_2350.class_2351.field_11052 && toShape.axis == class_2350.class_2351.field_11052 && portalGenInfo.scale == 1.0 && portalGenInfo.rotation == null) {
            Portal[] portals = FlippingFloorSquareForm.createPortals(fromWorld, toWorld, portalGenInfo.fromShape, portalGenInfo.toShape);
            cpg.onPortalsGenerated(portals);
            Helper.log((Object)"Created flipping floor portal");
        } else {
            Portal[] portals = portalGenInfo.generateBiWayBiFacedPortal(GeneralBreakablePortal.entityType);
            cpg.onPortalsGenerated(portals);
            Helper.log((Object)"Created normal bi-way bi-faced portal");
        }
        return true;
    }

    @Deprecated
    @Nullable
    public static IntBox findBlockBoxArea(class_1937 world, class_2338 pos, Predicate<class_2680> predicate) {
        class_2338 startingPos = ConvertConventionalPortalForm.findBlockAround(world, pos, predicate);
        if (startingPos == null) {
            return null;
        }
        IntBox result = Helper.expandBoxArea((class_2338)startingPos, p -> predicate.test(world.method_8320(p)));
        if (result.getSize().equals((Object)new class_2338(1, 1, 1))) {
            return null;
        }
        return result;
    }

    @Nullable
    public static class_2338 findBlockAround(class_1937 world, class_2338 pos, Predicate<class_2680> predicate) {
        class_2680 blockState = world.method_8320(pos);
        if (predicate.test(blockState)) {
            return pos;
        }
        return BlockTraverse.searchInBox(new IntBox(pos.method_10069(-2, -2, -2), pos.method_10069(2, 2, 2)), p -> {
            if (predicate.test(world.method_8320(p))) {
                return p;
            }
            return null;
        });
    }

    @Deprecated
    @Nullable
    public static BlockPortalShape convertToPortalShape(IntBox box) {
        class_2338 size = box.getSize();
        class_2350.class_2351 axis = null;
        if (size.method_10263() == 1) {
            axis = class_2350.class_2351.field_11048;
        } else if (size.method_10264() == 1) {
            axis = class_2350.class_2351.field_11052;
        } else if (size.method_10260() == 1) {
            axis = class_2350.class_2351.field_11051;
        } else {
            Helper.err((Object)("The box is not flat " + box));
            return null;
        }
        return new BlockPortalShape(box.stream().collect(Collectors.toSet()), axis);
    }

    @Nullable
    public static PortalGenInfo tryToMatch(class_5321<class_1937> fromDim, class_5321<class_1937> toDim, BlockPortalShape a, BlockPortalShape b) {
        List<DiligentMatcher.TransformedShape> matchableShapeVariants = DiligentMatcher.getMatchableShapeVariants(a, BlockPortalShape.defaultLengthLimit);
        for (DiligentMatcher.TransformedShape variant : matchableShapeVariants) {
            BlockPortalShape variantMoved = variant.transformedShape.getShapeWithMovedAnchor(b.anchor);
            if (!variantMoved.equals(b)) continue;
            return new PortalGenInfo(fromDim, toDim, a, b, variant.rotation.toQuaternion(), variant.scale);
        }
        return null;
    }
}

