/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import qouteall.q_misc_util.MiscHelper;

public class SimpleBlockPredicate
implements Predicate<class_2680> {
    public static final SimpleBlockPredicate pass = new SimpleBlockPredicate();
    public final String name;
    private final class_6862<class_2248> tag;
    private final class_2248 block;
    public static final Codec<SimpleBlockPredicate> codec = Codec.STRING.comapFlatMap(SimpleBlockPredicate::deserialize, SimpleBlockPredicate::serialize);

    public SimpleBlockPredicate(String name, class_6862<class_2248> tag) {
        this.name = name;
        this.tag = tag;
        this.block = null;
    }

    public SimpleBlockPredicate(String name, class_2248 block) {
        this.name = name;
        this.block = block;
        this.tag = null;
    }

    private SimpleBlockPredicate() {
        this.tag = null;
        this.block = null;
        this.name = "imm_ptl:pass";
    }

    @Override
    public boolean test(class_2680 blockState) {
        if (this.tag != null) {
            return blockState.method_26164(this.tag);
        }
        if (this.block != null) {
            return blockState.method_26204() == this.block;
        }
        return true;
    }

    private static DataResult<SimpleBlockPredicate> deserialize(String string) {
        MinecraftServer server = MiscHelper.getServer();
        if (server == null) {
            return DataResult.error(() -> "[Immersive Portals] Simple block predicate should not be deserialized in client");
        }
        if (string.equals("minecraft:air")) {
            return DataResult.success((Object)new AirPredicate());
        }
        class_2960 id = new class_2960(string);
        class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)id);
        class_2378 blockRegistry = (class_2378)server.method_30611().method_33310(class_7924.field_41254).get();
        Optional tag1 = blockRegistry.method_40266(tagKey);
        boolean knownTagName = tag1.isPresent();
        if (knownTagName) {
            return DataResult.success((Object)new SimpleBlockPredicate(string, (class_6862<class_2248>)tagKey));
        }
        if (blockRegistry.method_10235().contains(id)) {
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(id);
            return DataResult.success((Object)new SimpleBlockPredicate(string, block), (Lifecycle)Lifecycle.stable());
        }
        return DataResult.error(() -> "Unknown block or block tag:" + string);
    }

    private static String serialize(SimpleBlockPredicate predicate) {
        MinecraftServer server = MiscHelper.getServer();
        if (server == null) {
            throw new RuntimeException("Simple block predicate should not be serialized in client");
        }
        return predicate.name;
    }

    public static class AirPredicate
    extends SimpleBlockPredicate {
        @Override
        public boolean test(class_2680 blockState) {
            return blockState.method_26215();
        }
    }
}

