/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenTrigger;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

public class CustomPortalGeneration {
    public static final class_5321<class_1937> theSameDimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("imm_ptl:the_same_dimension"));
    public static final class_5321<class_1937> anyDimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("imm_ptl:any_dimension"));
    public static final Codec<List<class_5321<class_1937>>> dimensionListCodec = new ListCodec(class_1937.field_25178);
    public static final Codec<List<String>> stringListCodec = new ListCodec((Codec)Codec.STRING);
    public static final Codec<List<List<String>>> stringListListCodec = new ListCodec(stringListCodec);
    public static class_5321<class_2378<Codec<CustomPortalGeneration>>> schemaRegistryKey = class_5321.method_29180((class_2960)new class_2960("imm_ptl:custom_portal_gen_schema"));
    public static class_5321<class_2378<CustomPortalGeneration>> registryRegistryKey = class_5321.method_29180((class_2960)new class_2960("imm_ptl:custom_portal_generation"));
    public static final Codec<CustomPortalGeneration> codecV1 = RecordCodecBuilder.create(instance -> instance.group((App)dimensionListCodec.fieldOf("from").forGetter(o -> o.fromDimensions), (App)class_1937.field_25178.fieldOf("to").forGetter(o -> o.toDimension), (App)Codec.INT.optionalFieldOf("space_ratio_from", (Object)1).forGetter(o -> o.spaceRatioFrom), (App)Codec.INT.optionalFieldOf("space_ratio_to", (Object)1).forGetter(o -> o.spaceRatioTo), (App)Codec.BOOL.optionalFieldOf("reversible", (Object)true).forGetter(o -> o.reversible), (App)PortalGenForm.codec.fieldOf("form").forGetter(o -> o.form), (App)PortalGenTrigger.triggerCodec.fieldOf("trigger").forGetter(o -> o.trigger), (App)stringListCodec.optionalFieldOf("post_invoke_commands", Collections.emptyList()).forGetter(o -> o.postInvokeCommands), (App)stringListListCodec.optionalFieldOf("commands_on_generated", Collections.emptyList()).forGetter(o -> o.commandsOnGenerated)).apply((Applicative)instance, instance.stable(CustomPortalGeneration::new)));
    public static class_2370<Codec<CustomPortalGeneration>> schemaRegistry = (class_2370)class_156.method_656(() -> {
        class_2370 registry = new class_2370(schemaRegistryKey, Lifecycle.stable());
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("imm_ptl:v1"), codecV1);
        return registry;
    });
    public static final MapCodec<CustomPortalGeneration> codec = schemaRegistry.method_39673().dispatchMap("schema_version", e -> codecV1, Function.identity());
    public final List<class_5321<class_1937>> fromDimensions;
    public final class_5321<class_1937> toDimension;
    public final int spaceRatioFrom;
    public final int spaceRatioTo;
    public final boolean reversible;
    public final PortalGenForm form;
    public final PortalGenTrigger trigger;
    public final List<String> postInvokeCommands;
    public final List<List<String>> commandsOnGenerated;
    public class_2960 identifier = null;

    public CustomPortalGeneration(List<class_5321<class_1937>> fromDimensions, class_5321<class_1937> toDimension, int spaceRatioFrom, int spaceRatioTo, boolean reversible, PortalGenForm form, PortalGenTrigger trigger, List<String> postInvokeCommands, List<List<String>> commandsOnGenerated) {
        this.fromDimensions = fromDimensions;
        this.toDimension = toDimension;
        this.spaceRatioFrom = spaceRatioFrom;
        this.spaceRatioTo = spaceRatioTo;
        this.reversible = reversible;
        this.form = form;
        this.trigger = trigger;
        this.postInvokeCommands = postInvokeCommands;
        this.commandsOnGenerated = commandsOnGenerated;
    }

    @Nullable
    public CustomPortalGeneration getReverse() {
        if (this.toDimension == theSameDimension) {
            return new CustomPortalGeneration(this.fromDimensions, theSameDimension, this.spaceRatioTo, this.spaceRatioFrom, false, this.form.getReverse(), this.trigger, this.postInvokeCommands, this.commandsOnGenerated);
        }
        if (!this.fromDimensions.isEmpty()) {
            return new CustomPortalGeneration(Lists.newArrayList((Object[])new class_5321[]{this.toDimension}), this.fromDimensions.get(0), this.spaceRatioTo, this.spaceRatioFrom, false, this.form.getReverse(), this.trigger, this.postInvokeCommands, this.commandsOnGenerated);
        }
        Helper.err((Object)"Cannot get reverse custom portal gen");
        return null;
    }

    public class_2338 mapPosition(class_2338 from, class_3218 fromWorld, class_3218 toWorld) {
        class_2338 newPosition = Helper.divide((class_2382)Helper.scale((class_2382)from, (int)this.spaceRatioTo), (int)this.spaceRatioFrom);
        boolean withinBounds = toWorld.method_8621().method_11952(newPosition);
        if (!withinBounds) {
            Helper.log((Object)"Tries to spawn a portal outside of world border");
            class_2338 clamped = toWorld.method_8621().method_39538((double)newPosition.method_10263(), (double)newPosition.method_10264(), (double)newPosition.method_10260());
            newPosition = new class_2338((int)((double)clamped.method_10263() * 0.9), clamped.method_10264(), (int)((double)clamped.method_10260() * 0.9));
        }
        return newPosition;
    }

    public boolean initAndCheck() {
        class_5321<class_1937> toDimension = this.toDimension;
        if (toDimension != theSameDimension && MiscHelper.getServer().method_3847(toDimension) == null) {
            return false;
        }
        if (!this.form.initAndCheck()) {
            return false;
        }
        return !this.fromDimensions.isEmpty();
    }

    public String toString() {
        return McHelper.serializeToJson(this, codec.codec());
    }

    public boolean perform(class_3218 world, class_2338 startPos, @Nullable class_1297 triggeringEntity) {
        class_3218 toWorld;
        if (!this.fromDimensions.contains(world.method_27983()) && this.fromDimensions.get(0) != anyDimension) {
            return false;
        }
        if (!world.method_22340(startPos)) {
            Helper.log((Object)"Skip custom portal generation because chunk not loaded");
            return false;
        }
        class_5321 destDimension = this.toDimension;
        if (destDimension == theSameDimension) {
            destDimension = world.method_27983();
        }
        if ((toWorld = MiscHelper.getServer().method_3847(destDimension)) == null) {
            Helper.err((Object)("Missing dimension " + destDimension.method_29177()));
            return false;
        }
        world.method_16107().method_15396("custom_portal_gen_perform");
        boolean result = this.form.perform(this, world, startPos, toWorld, triggeringEntity);
        world.method_16107().method_15407();
        return result;
    }

    public void onPortalsGenerated(Portal[] portals) {
        for (int i = 0; i < portals.length; ++i) {
            Portal portal = portals[i];
            if (this.identifier != null) {
                portal.portalTag = this.identifier.toString();
            }
            if (!this.postInvokeCommands.isEmpty()) {
                McHelper.invokeCommandAs(portal, this.postInvokeCommands);
            }
            if (i >= this.commandsOnGenerated.size()) continue;
            List<String> commandsForThisPortal = this.commandsOnGenerated.get(i);
            McHelper.invokeCommandAs(portal, commandsForThisPortal);
        }
    }
}

