/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2370;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.mixin.common.registry.IERegistryDataLoader;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenTrigger;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.WithDim;

public class CustomPortalGenManagement {
    private static final Multimap<class_1792, CustomPortalGeneration> useItemGen = HashMultimap.create();
    private static final Multimap<class_1792, CustomPortalGeneration> throwItemGen = HashMultimap.create();
    private static final ArrayList<CustomPortalGeneration> convGen = new ArrayList();
    private static final Map<UUID, WithDim<class_243>> playerPosBeforeTravel = new HashMap<UUID, WithDim<class_243>>();

    public static void onDatapackReload() {
        useItemGen.clear();
        throwItemGen.clear();
        convGen.clear();
        playerPosBeforeTravel.clear();
        if (!IPGlobal.enableDatapackPortalGen) {
            return;
        }
        Helper.log((Object)"Loading custom portal generation");
        class_2378<CustomPortalGeneration> result = CustomPortalGenManagement.loadCustomPortalGenerations();
        if (result == null) {
            return;
        }
        result.method_29722().forEach(entry -> {
            CustomPortalGeneration gen = (CustomPortalGeneration)entry.getValue();
            gen.identifier = ((class_5321)entry.getKey()).method_29177();
            if (!gen.initAndCheck()) {
                Helper.log((Object)("Custom Portal Gen Is Not Activated " + gen.toString()));
                return;
            }
            Helper.log((Object)("Loaded Custom Portal Gen " + ((class_5321)entry.getKey()).method_29177()));
            CustomPortalGenManagement.load(gen);
            if (gen.reversible) {
                CustomPortalGeneration reverse = gen.getReverse();
                if (reverse != null) {
                    reverse.identifier = ((class_5321)entry.getKey()).method_29177();
                    if (gen.initAndCheck()) {
                        CustomPortalGenManagement.load(reverse);
                    }
                } else {
                    McHelper.sendMessageToFirstLoggedPlayer((class_2561)class_2561.method_43470((String)("Cannot create reverse generation of " + gen)));
                }
            }
        });
    }

    private static class_2378<CustomPortalGeneration> loadCustomPortalGenerations() {
        MinecraftServer server = MiscHelper.getServer();
        class_5455.class_6890 registryTracker = server.method_30611();
        class_3300 resourceManager = server.method_34864();
        class_6903 registryOps = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryTracker);
        class_2370 registry = new class_2370(CustomPortalGeneration.registryRegistryKey, Lifecycle.stable());
        class_6903.class_7863 context = IERegistryDataLoader.ip_createContext((class_5455)registryTracker, List.of());
        HashMap errorMap = new HashMap();
        IERegistryDataLoader.ip_loadRegistryContents(context, resourceManager, CustomPortalGeneration.registryRegistryKey, registry, CustomPortalGeneration.codec.codec(), errorMap);
        errorMap.forEach((key, exception) -> {
            exception.printStackTrace();
            McHelper.sendMessageToFirstLoggedPlayer((class_2561)class_2561.method_43470((String)"Error loading custom portal generation %s".formatted(key.method_29177())));
        });
        return registry;
    }

    private static void load(CustomPortalGeneration gen) {
        PortalGenTrigger trigger = gen.trigger;
        if (trigger instanceof PortalGenTrigger.UseItemTrigger) {
            useItemGen.put((Object)((PortalGenTrigger.UseItemTrigger)trigger).item, (Object)gen);
        } else if (trigger instanceof PortalGenTrigger.ThrowItemTrigger) {
            throwItemGen.put((Object)((PortalGenTrigger.ThrowItemTrigger)trigger).item, (Object)gen);
        } else if (trigger instanceof PortalGenTrigger.ConventionalDimensionChangeTrigger) {
            convGen.add(gen);
        }
    }

    public static void onItemUse(class_1838 context, class_1269 actionResult) {
        if (context.method_8045().method_8608()) {
            return;
        }
        class_1792 item = context.method_8041().method_7909();
        if (useItemGen.containsKey((Object)item)) {
            IPGlobal.serverTaskList.addTask(() -> {
                for (CustomPortalGeneration gen : useItemGen.get((Object)item)) {
                    PortalGenTrigger.UseItemTrigger trigger;
                    boolean result = gen.perform((class_3218)context.method_8045(), context.method_8037().method_10093(context.method_8038()), (class_1297)context.method_8036());
                    if (!result) continue;
                    if (!(gen.trigger instanceof PortalGenTrigger.UseItemTrigger) || !(trigger = (PortalGenTrigger.UseItemTrigger)gen.trigger).shouldConsume(context)) break;
                    context.method_8041().method_7934(1);
                    break;
                }
                return true;
            });
        }
    }

    public static void onItemTick(class_1542 entity) {
        class_1792 item;
        Validate.isTrue((!entity.method_37908().method_8608() ? 1 : 0) != 0);
        if (entity.method_6977() && throwItemGen.containsKey((Object)(item = entity.method_6983().method_7909()))) {
            IPGlobal.serverTaskList.addTask(() -> {
                for (CustomPortalGeneration gen : throwItemGen.get((Object)item)) {
                    boolean result = gen.perform((class_3218)entity.method_37908(), entity.method_24515(), (class_1297)entity);
                    if (!result) continue;
                    entity.method_6983().method_7934(1);
                    break;
                }
                return true;
            });
        }
    }

    public static void onBeforeConventionalDimensionChange(class_3222 player) {
        playerPosBeforeTravel.put(player.method_5667(), (WithDim<class_243>)new WithDim(player.method_37908().method_27983(), (Object)player.method_19538()));
    }

    public static void onAfterConventionalDimensionChange(class_3222 player) {
        UUID uuid = player.method_5667();
        if (playerPosBeforeTravel.containsKey(uuid)) {
            WithDim<class_243> startCoord = playerPosBeforeTravel.get(uuid);
            class_3218 startWorld = McHelper.getServerWorld((class_5321<class_1937>)startCoord.dimension());
            class_2338 startPos = class_2338.method_49638((class_2374)((class_2374)startCoord.value()));
            for (CustomPortalGeneration gen : convGen) {
                boolean succeeded = gen.perform(startWorld, startPos, (class_1297)player);
                if (!succeeded) continue;
                playerPosBeforeTravel.remove(uuid);
                return;
            }
        }
        playerPosBeforeTravel.remove(uuid);
    }
}

