/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Vec2d;
import qouteall.q_misc_util.my_util.animation.Animated;

public record UnilateralPortalState(class_5321<class_1937> dimension, class_243 position, DQuaternion orientation, double width, double height) {
    public static final Animated.TypeInfo<UnilateralPortalState> ANIMATION_TYPE_INFO = new Animated.TypeInfo<UnilateralPortalState>(){

        public UnilateralPortalState interpolate(UnilateralPortalState start, UnilateralPortalState end, double progress) {
            if (start.dimension() != end.dimension()) {
                return end;
            }
            Pair<RectInvariant, UnilateralPortalState> p = start.turnToClosestTo(end.orientation());
            start = (UnilateralPortalState)p.getSecond();
            return new UnilateralPortalState(start.dimension(), start.position().method_35590(end.position(), progress), DQuaternion.interpolate((DQuaternion)start.orientation(), (DQuaternion)end.orientation(), (double)progress), class_3532.method_16436((double)progress, (double)start.width(), (double)end.width()), class_3532.method_16436((double)progress, (double)start.height(), (double)end.height()));
        }

        public boolean isClose(UnilateralPortalState a, UnilateralPortalState b) {
            return a.dimension() == b.dimension() && a.position().method_1025(b.position()) < 0.01 && DQuaternion.isClose((DQuaternion)a.orientation(), (DQuaternion)b.orientation(), (double)0.01) && Math.abs(a.width() - b.width()) < 0.01 && Math.abs(a.height() - b.height()) < 0.01;
        }
    };

    public static UnilateralPortalState extractThisSide(PortalState portalState) {
        return new UnilateralPortalState(portalState.fromWorld, portalState.fromPos, portalState.orientation, portalState.width, portalState.height);
    }

    public static UnilateralPortalState extractOtherSide(PortalState portalState) {
        DQuaternion otherSideOrientation = portalState.rotation.hamiltonProduct(portalState.orientation).hamiltonProduct(PortalManipulation.flipAxisW);
        return new UnilateralPortalState(portalState.toWorld, portalState.toPos, otherSideOrientation, portalState.width * portalState.scaling, portalState.height * portalState.scaling);
    }

    public static PortalState combine(UnilateralPortalState thisSide, UnilateralPortalState otherSide) {
        DQuaternion otherSideOrientation = otherSide.orientation;
        DQuaternion thisSideOrientation = thisSide.orientation;
        DQuaternion rotation = PortalManipulation.computeDeltaTransformation(thisSideOrientation, otherSideOrientation);
        double scale = otherSide.width / thisSide.width;
        PortalState result = new PortalState(thisSide.dimension, thisSide.position, otherSide.dimension, otherSide.position, scale, rotation, thisSide.orientation, thisSide.width, thisSide.height);
        return result;
    }

    public static UnilateralPortalState interpolate(UnilateralPortalState from, UnilateralPortalState to, double progress) {
        return new UnilateralPortalState(from.dimension, Helper.interpolatePos((class_243)from.position, (class_243)to.position, (double)progress), DQuaternion.interpolate((DQuaternion)from.orientation, (DQuaternion)to.orientation, (double)progress), class_3532.method_16436((double)progress, (double)from.width, (double)to.width), class_3532.method_16436((double)progress, (double)from.height, (double)to.height));
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("dimension", this.dimension.method_29177().toString());
        Helper.putVec3d((class_2487)tag, (String)"position", (class_243)this.position);
        tag.method_10566("orientation", this.orientation.toTag());
        tag.method_10549("width", this.width);
        tag.method_10549("height", this.height);
        return tag;
    }

    public static UnilateralPortalState fromTag(class_2487 tag) {
        class_5321 dimension = DimId.idToKey((String)tag.method_10558("dimension"));
        class_243 point = Helper.getVec3d((class_2487)tag, (String)"position");
        DQuaternion orientation = DQuaternion.fromTag((class_2520)tag.method_10562("orientation"));
        double width = tag.method_10574("width");
        double height = tag.method_10574("height");
        return new UnilateralPortalState((class_5321<class_1937>)dimension, point, orientation, width, height);
    }

    public DeltaUnilateralPortalState subtract(UnilateralPortalState other) {
        class_243 offset = this.position.method_1020(other.position);
        DQuaternion rotation = this.orientation.hamiltonProduct(other.orientation.getConjugated());
        double widthScale = this.width / other.width;
        double heightScale = this.height / other.height;
        return new DeltaUnilateralPortalState(offset, rotation, new Vec2d(widthScale, heightScale)).purgeFPError();
    }

    public UnilateralPortalState apply(DeltaUnilateralPortalState thisSideDelta) {
        return new Builder().from(this).apply(thisSideDelta).build();
    }

    public class_243 getAxisW() {
        return this.orientation.getAxisW();
    }

    public class_243 getAxisH() {
        return this.orientation.getAxisH();
    }

    public class_243 getNormal() {
        return this.orientation.getNormal();
    }

    public Pair<RectInvariant, UnilateralPortalState> turnToClosestTo(DQuaternion targetOrientation) {
        return Arrays.stream(RectInvariant.values()).map(inv -> Pair.of((Object)inv, (Object)inv.getVariantOf(this))).min(Comparator.comparingDouble(p -> DQuaternion.distance((DQuaternion)((UnilateralPortalState)p.getSecond()).orientation(), (DQuaternion)targetOrientation))).orElseThrow();
    }

    public static class Builder {
        public class_5321<class_1937> dimension;
        public class_243 position;
        public DQuaternion orientation;
        public double width;
        public double height;

        public UnilateralPortalState build() {
            return new UnilateralPortalState(this.dimension, this.position, this.orientation, this.width, this.height);
        }

        public Builder dimension(class_5321<class_1937> dimension) {
            this.dimension = dimension;
            return this;
        }

        public Builder position(class_243 point) {
            this.position = point;
            return this;
        }

        public Builder orientation(DQuaternion orientation) {
            this.orientation = orientation;
            return this;
        }

        public Builder width(double width) {
            this.width = width;
            return this;
        }

        public Builder height(double height) {
            this.height = height;
            return this;
        }

        @NotNull
        public Builder from(UnilateralPortalState other) {
            this.dimension = other.dimension;
            this.position = other.position;
            this.orientation = other.orientation;
            this.width = other.width;
            this.height = other.height;
            return this;
        }

        public Builder offset(class_243 offset) {
            this.position = this.position.method_1019(offset);
            return this;
        }

        public Builder rotate(DQuaternion rotation) {
            this.orientation = rotation.hamiltonProduct(this.orientation);
            return this;
        }

        public Builder scaleWidth(double scale) {
            this.width *= scale;
            return this;
        }

        public Builder scaleHeight(double scale) {
            this.height *= scale;
            return this;
        }

        public Builder apply(DeltaUnilateralPortalState delta) {
            if (delta.offset() != null) {
                this.position = this.position.method_1019(delta.offset());
            }
            if (delta.rotation() != null) {
                this.orientation = delta.rotation().hamiltonProduct(this.orientation);
            }
            if (delta.sizeScaling() != null) {
                this.width *= delta.sizeScaling().x();
                this.height *= delta.sizeScaling().y();
            }
            return this;
        }

        @Deprecated
        @NotNull
        public Builder correctFrom(UnilateralPortalState other) {
            this.dimension = other.dimension;
            if (this.position.method_1025(other.position) > 1.0E-4) {
                this.position = other.position;
            }
            if (!DQuaternion.isClose((DQuaternion)this.orientation, (DQuaternion)other.orientation, (double)0.001)) {
                this.orientation = other.orientation;
            }
            if (Math.abs(this.width - other.width) > 1.0E-4) {
                this.width = other.width;
            }
            if (Math.abs(this.height - other.height) > 1.0E-4) {
                this.height = other.height;
            }
            return this;
        }
    }

    public static enum RectInvariant {
        IDENTITY,
        ROTATE_90,
        ROTATE_180,
        ROTATE_270,
        FLIP_X,
        FLIP_X_ROTATE_90,
        FLIP_X_ROTATE_180,
        FLIP_X_ROTATE_270;


        public UnilateralPortalState getVariantOf(UnilateralPortalState state) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY -> state;
                case ROTATE_90 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((class_243)new class_243(0.0, 0.0, 1.0), (double)90.0)), state.height, state.width);
                case ROTATE_180 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((class_243)new class_243(0.0, 0.0, 1.0), (double)180.0)), state.width, state.height);
                case ROTATE_270 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((class_243)new class_243(0.0, 0.0, 1.0), (double)270.0)), state.height, state.width);
                case FLIP_X -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((class_243)new class_243(1.0, 0.0, 0.0), (double)180.0)), state.width, state.height);
                case FLIP_X_ROTATE_90 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((class_243)new class_243(0.0, 0.0, 1.0), (double)90.0)).hamiltonProduct(DQuaternion.rotationByDegrees((class_243)new class_243(1.0, 0.0, 0.0), (double)180.0)), state.height, state.width);
                case FLIP_X_ROTATE_180 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((class_243)new class_243(0.0, 0.0, 1.0), (double)180.0)).hamiltonProduct(DQuaternion.rotationByDegrees((class_243)new class_243(1.0, 0.0, 0.0), (double)180.0)), state.width, state.height);
                case FLIP_X_ROTATE_270 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees((class_243)new class_243(0.0, 0.0, 1.0), (double)270.0)).hamiltonProduct(DQuaternion.rotationByDegrees((class_243)new class_243(1.0, 0.0, 0.0), (double)180.0)), state.height, state.width);
            };
        }

        public boolean switchesWidthAndHeight() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY, ROTATE_180, FLIP_X, FLIP_X_ROTATE_180 -> false;
                case ROTATE_90, ROTATE_270, FLIP_X_ROTATE_90, FLIP_X_ROTATE_270 -> true;
            };
        }
    }
}

