/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.animation.AnimationContext;
import qouteall.imm_ptl.core.portal.animation.AnimationResult;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;

public class RotationAnimation
implements PortalAnimationDriver {
    public final class_243 initialOffset;
    public final class_243 rotationAxis;
    public final double degreesPerTick;
    public final long startGameTime;
    public final long endGameTime;
    @Nullable
    public final TimingFunction timingFunction;

    public static void init() {
        PortalAnimationDriver.registerDeserializer(new class_2960("imm_ptl:rotation"), RotationAnimation::deserialize);
    }

    public RotationAnimation(class_243 initialOffset, class_243 rotationAxis, double degreesPerTick, long startGameTime, long endGameTime, @Nullable TimingFunction timingFunction) {
        this.initialOffset = initialOffset;
        this.rotationAxis = rotationAxis;
        this.degreesPerTick = degreesPerTick;
        this.startGameTime = startGameTime;
        this.endGameTime = endGameTime;
        this.timingFunction = timingFunction;
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("type", "imm_ptl:rotation");
        Helper.putVec3d((class_2487)tag, (String)"initialOffset", (class_243)this.initialOffset);
        Helper.putVec3d((class_2487)tag, (String)"rotationAxis", (class_243)this.rotationAxis);
        tag.method_10549("degreesPerTick", this.degreesPerTick);
        tag.method_10544("startGameTime", this.startGameTime);
        tag.method_10544("endGameTime", this.endGameTime);
        if (this.timingFunction != null) {
            tag.method_10582("timingFunction", this.timingFunction.toString());
        }
        return tag;
    }

    private static RotationAnimation deserialize(class_2487 tag) {
        class_243 initialOffset = Helper.getVec3d((class_2487)tag, (String)"initialOffset");
        class_243 rotationAxis = Helper.getVec3d((class_2487)tag, (String)"rotationAxis");
        double degreesPerTick = tag.method_10574("degreesPerTick");
        long startGameTime = tag.method_10537("startGameTime");
        long endGameTime = tag.method_10537("endGameTime");
        TimingFunction timingFunction = tag.method_10545("timingFunction") ? TimingFunction.fromString(tag.method_10558("timingFunction")) : null;
        return new RotationAnimation(initialOffset, rotationAxis, degreesPerTick, startGameTime, endGameTime, timingFunction);
    }

    @Override
    public AnimationResult getAnimationResult(long tickTime, float partialTicks, AnimationContext context) {
        double passedTicks = (double)(tickTime - 1L - this.startGameTime) + (double)partialTicks;
        boolean ended = false;
        long durationTicks = this.endGameTime - this.startGameTime;
        if (passedTicks >= (double)durationTicks) {
            ended = true;
            passedTicks = durationTicks;
        }
        if (this.timingFunction != null) {
            passedTicks = this.timingFunction.mapProgress(passedTicks / (double)durationTicks) * (double)durationTicks;
        }
        double angle = this.degreesPerTick * passedTicks;
        DQuaternion rotation = DQuaternion.rotationByDegrees((class_243)this.rotationAxis, (double)angle);
        class_243 vec = this.initialOffset;
        class_243 rotatedVec = rotation.rotate(vec);
        class_243 offset = rotatedVec.method_1020(vec);
        return new AnimationResult(new DeltaUnilateralPortalState(offset, rotation, null), ended);
    }

    @Override
    @Nullable
    public DeltaUnilateralPortalState getEndingResult(long tickTime, AnimationContext context) {
        if (this.endGameTime == Long.MAX_VALUE) {
            return null;
        }
        return this.getAnimationResult(this.endGameTime, 0.0f, context).delta();
    }

    @Override
    public PortalAnimationDriver getFlippedVersion() {
        return new RotationAnimation(this.initialOffset, this.rotationAxis, this.degreesPerTick, this.startGameTime, this.endGameTime, this.timingFunction);
    }

    @Override
    public class_2561 getInfo() {
        return class_2561.method_43470((String)"Rotation[offset=(%.3f %.3f %.3f),axis=(%.3f %.3f %.3f),angVelo=%.3f]".formatted(this.initialOffset.field_1352, this.initialOffset.field_1351, this.initialOffset.field_1350, this.rotationAxis.field_1352, this.rotationAxis.field_1351, this.rotationAxis.field_1350, this.degreesPerTick));
    }

    public static class Builder {
        private class_243 initialOffset;
        public class_243 rotationAxis;
        public double degreesPerTick;
        public long startGameTime;
        public long endGameTime;
        public TimingFunction timingFunction;

        public RotationAnimation build() {
            return new RotationAnimation(this.initialOffset, this.rotationAxis, this.degreesPerTick, this.startGameTime, this.endGameTime, this.timingFunction);
        }

        public Builder setInitialOffset(class_243 initialOffset) {
            this.initialOffset = initialOffset;
            return this;
        }

        public Builder setRotationAxis(class_243 rotationAxis) {
            this.rotationAxis = rotationAxis;
            return this;
        }

        public Builder setDegreesPerTick(double degreesPerTick) {
            this.degreesPerTick = degreesPerTick;
            return this;
        }

        public Builder setStartGameTime(long startGameTime) {
            this.startGameTime = startGameTime;
            return this;
        }

        public Builder setEndGameTime(long endGameTime) {
            this.endGameTime = endGameTime;
            return this;
        }

        public Builder setTimingFunction(TimingFunction timingFunction) {
            this.timingFunction = timingFunction;
            return this;
        }
    }
}

