/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.AnimationContext;
import qouteall.imm_ptl.core.portal.animation.AnimationResult;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.Vec2d;

public class NormalAnimation
implements PortalAnimationDriver {
    public static final int INFINITE_THRESHOLD = 100000;
    public final List<Phase> phases;
    public final long startingGameTime;
    public final int loopCount;
    public final boolean isBuilding;
    private final long ticksPerRound;

    public static void init() {
        PortalAnimationDriver.registerDeserializer(new class_2960("imm_ptl:normal"), NormalAnimation::deserialize);
    }

    public NormalAnimation(List<Phase> phases, long startingGameTime, int loopCount, boolean isBuilding) {
        this.phases = phases;
        this.startingGameTime = startingGameTime;
        this.loopCount = loopCount;
        this.isBuilding = isBuilding;
        long totalTicks = 0L;
        for (Phase phase : phases) {
            totalTicks += phase.durationTicks;
        }
        this.ticksPerRound = totalTicks;
    }

    private static NormalAnimation deserialize(class_2487 compoundTag) {
        UnilateralPortalState initialState = UnilateralPortalState.fromTag(compoundTag.method_10562("initialState"));
        ArrayList phases = Helper.listTagToList((class_2499)Helper.getCompoundList((class_2487)compoundTag, (String)"phases"), Phase::fromTag);
        long startingGameTime = compoundTag.method_10537("startingGameTime");
        int loopCount = compoundTag.method_10550("loopCount");
        boolean isBuilding = compoundTag.method_10577("isBuilding");
        if (!isBuilding && (phases.isEmpty() || loopCount < 0)) {
            throw new RuntimeException("invalid NormalAnimation");
        }
        return new NormalAnimation(phases, startingGameTime, loopCount, isBuilding);
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("type", "imm_ptl:normal");
        tag.method_10566("phases", (class_2520)Helper.listToListTag(this.phases, Phase::toTag));
        tag.method_10544("startingGameTime", this.startingGameTime);
        tag.method_10569("loopCount", this.loopCount);
        tag.method_10556("isBuilding", this.isBuilding);
        return tag;
    }

    private long getTotalDuration() {
        if (this.loopCount >= 100000) {
            return Long.MAX_VALUE;
        }
        return this.ticksPerRound * (long)this.loopCount;
    }

    @Override
    @NotNull
    public AnimationResult getAnimationResult(long tickTime, float partialTicks, AnimationContext context) {
        if (this.isBuilding) {
            return new AnimationResult(null, false);
        }
        if (this.ticksPerRound == 0L || this.phases.isEmpty()) {
            Helper.err((Object)"No phase");
            return new AnimationResult(null, true);
        }
        double passedTicks = (double)(tickTime - 1L - this.startingGameTime) + (double)partialTicks;
        long totalDuration = this.getTotalDuration();
        boolean ends = false;
        if (passedTicks >= (double)totalDuration) {
            passedTicks = totalDuration;
            ends = true;
        }
        if (passedTicks < -1.0) {
            if (context.isClientSide()) {
                return new AnimationResult(null, false);
            }
            Helper.err((Object)"NormalAnimation starts in the future");
            return new AnimationResult(null, true);
        }
        double passedTicksInThisRound = ends ? (double)this.ticksPerRound : passedTicks % (double)this.ticksPerRound;
        long roundIndex = Math.floorDiv((long)passedTicks, this.ticksPerRound);
        long traversedTicks = 0L;
        DeltaUnilateralPortalState lastDelta = DeltaUnilateralPortalState.identity;
        for (Phase phase : this.phases) {
            if (phase.durationTicks != 0L && passedTicksInThisRound < (double)(traversedTicks + phase.durationTicks)) {
                double phaseProgress = (passedTicksInThisRound - (double)traversedTicks) / (double)phase.durationTicks;
                phaseProgress = phase.timingFunction.mapProgress(phaseProgress);
                DeltaUnilateralPortalState interpolated = DeltaUnilateralPortalState.interpolate(lastDelta, phase.delta, phaseProgress);
                return new AnimationResult(interpolated, ends);
            }
            lastDelta = phase.delta();
            traversedTicks += phase.durationTicks;
        }
        return new AnimationResult(lastDelta, ends);
    }

    @Override
    @Nullable
    public DeltaUnilateralPortalState getEndingResult(long tickTime, AnimationContext context) {
        if (this.phases.isEmpty()) {
            return null;
        }
        return this.phases.get(this.phases.size() - 1).delta();
    }

    @Override
    public PortalAnimationDriver getFlippedVersion() {
        return new NormalAnimation(this.phases.stream().map(phase -> phase.getFlippedVersion()).collect(Collectors.toList()), this.startingGameTime, this.loopCount, this.isBuilding);
    }

    public static NormalAnimation createSizeAnimation(Portal portal, Vec2d startSizeScale, Vec2d toSizeScale, long startingGameTime, long durationTicks, TimingFunction timingFunction) {
        Phase initialPhase = new Phase.Builder().durationTicks(0L).timingFunction(timingFunction).delta(new DeltaUnilateralPortalState.Builder().scaleSize(startSizeScale).build()).build();
        Phase endingPhase = new Phase.Builder().durationTicks(durationTicks).timingFunction(timingFunction).delta(new DeltaUnilateralPortalState.Builder().scaleSize(toSizeScale).build()).build();
        return new Builder().phases(List.of(initialPhase, endingPhase)).startingGameTime(startingGameTime).loopCount(1).build();
    }

    @Override
    public class_2561 getInfo() {
        class_5250 component = class_2561.method_43470((String)"Normal[\n");
        for (Phase phase : this.phases) {
            component.method_27693(" ");
            component.method_10852(phase.getInfo());
            component.method_27693("\n");
        }
        component.method_27693("] %s times".formatted(this.loopCount >= 100000 ? "\u221e" : Integer.valueOf(this.loopCount)));
        return component;
    }

    public record Phase(long durationTicks, DeltaUnilateralPortalState delta, TimingFunction timingFunction) {
        public static Phase fromTag(class_2487 tag) {
            long durationTicks = tag.method_10537("durationTicks");
            DeltaUnilateralPortalState delta = DeltaUnilateralPortalState.fromTag(tag.method_10562("delta"));
            TimingFunction timingFunction = TimingFunction.fromString(tag.method_10558("timingFunction"));
            return new Phase(durationTicks, delta, timingFunction);
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10544("durationTicks", this.durationTicks);
            tag.method_10566("delta", (class_2520)this.delta.toTag());
            tag.method_10582("timingFunction", this.timingFunction.name());
            return tag;
        }

        public Phase getFlippedVersion() {
            return new Phase(this.durationTicks, this.delta.getFlipped(), this.timingFunction);
        }

        public class_2561 getInfo() {
            return class_2561.method_43470((String)"Phase(%d,".formatted(this.durationTicks)).method_27693(this.delta.toString()).method_27693(")");
        }

        public static class Builder {
            private long durationTicks = 0L;
            private DeltaUnilateralPortalState delta = DeltaUnilateralPortalState.identity;
            private TimingFunction timingFunction = TimingFunction.linear;

            public Builder durationTicks(long durationTicks) {
                this.durationTicks = durationTicks;
                return this;
            }

            public Builder delta(DeltaUnilateralPortalState delta) {
                this.delta = delta;
                return this;
            }

            public Builder timingFunction(TimingFunction timingFunction) {
                this.timingFunction = timingFunction;
                return this;
            }

            public Phase build() {
                return new Phase(this.durationTicks, this.delta, this.timingFunction);
            }
        }
    }

    public static class Builder {
        private List<Phase> phases = new ArrayList<Phase>();
        private long startingGameTime;
        private int loopCount;
        private boolean isBuilding = false;

        public Builder from(NormalAnimation animation) {
            this.phases = animation.phases;
            this.startingGameTime = animation.startingGameTime;
            this.loopCount = animation.loopCount;
            return this;
        }

        public Builder phases(List<Phase> phases) {
            this.phases = phases;
            return this;
        }

        public Builder startingGameTime(long startingGameTime) {
            this.startingGameTime = startingGameTime;
            return this;
        }

        public Builder loopCount(int loopCount) {
            this.loopCount = loopCount;
            return this;
        }

        public Builder isBuilding(boolean isBuilding) {
            this.isBuilding = isBuilding;
            return this;
        }

        public NormalAnimation build() {
            return new NormalAnimation(this.phases, this.startingGameTime, this.loopCount, this.isBuilding);
        }
    }
}

