/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Vec2d;

public record DeltaUnilateralPortalState(@Nullable class_243 offset, @Nullable DQuaternion rotation, @Nullable Vec2d sizeScaling) {
    public static final DeltaUnilateralPortalState identity = new DeltaUnilateralPortalState(null, null, null);

    public DeltaUnilateralPortalState getInverse() {
        return new DeltaUnilateralPortalState(this.offset == null ? null : this.offset.method_1021(-1.0), this.rotation == null ? null : this.rotation.getConjugated(), this.sizeScaling == null ? null : new Vec2d(1.0 / this.sizeScaling.x(), 1.0 / this.sizeScaling.y()));
    }

    public DeltaUnilateralPortalState combine(DeltaUnilateralPortalState then) {
        return new DeltaUnilateralPortalState((class_243)Helper.combineNullable((Object)this.offset, (Object)then.offset, class_243::method_1019), (DQuaternion)Helper.combineNullable((Object)this.rotation, (Object)then.rotation, DQuaternion::hamiltonProduct), (Vec2d)Helper.combineNullable((Object)this.sizeScaling, (Object)then.sizeScaling, (a, b) -> new Vec2d(a.x() * b.x(), a.y() * b.y())));
    }

    public static DeltaUnilateralPortalState fromTag(class_2487 tag) {
        return new DeltaUnilateralPortalState(Helper.getVec3dOptional((class_2487)tag, (String)"offset"), tag.method_10545("rotation") ? DQuaternion.fromTag((class_2520)tag.method_10562("rotation")) : null, tag.method_10545("sizeScalingX") ? new Vec2d(tag.method_10574("sizeScalingX"), tag.method_10574("sizeScalingY")) : null);
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        if (this.offset != null) {
            Helper.putVec3d((class_2487)tag, (String)"offset", (class_243)this.offset);
        }
        if (this.rotation != null) {
            tag.method_10566("rotation", this.rotation.toTag());
        }
        if (this.sizeScaling != null) {
            tag.method_10549("sizeScalingX", this.sizeScaling.x());
            tag.method_10549("sizeScalingY", this.sizeScaling.y());
        }
        return tag;
    }

    public DeltaUnilateralPortalState getPartial(double progress) {
        return new DeltaUnilateralPortalState(this.offset == null ? null : this.offset.method_1021(progress), this.rotation == null ? null : DQuaternion.interpolate((DQuaternion)DQuaternion.identity, (DQuaternion)this.rotation, (double)progress), this.sizeScaling == null ? null : new Vec2d(class_3532.method_16436((double)progress, (double)1.0, (double)this.sizeScaling.x()), class_3532.method_16436((double)progress, (double)1.0, (double)this.sizeScaling.y())));
    }

    public static DeltaUnilateralPortalState interpolate(DeltaUnilateralPortalState a, DeltaUnilateralPortalState b, double progress) {
        return a.getPartial(1.0 - progress).combine(b.getPartial(progress));
    }

    public DeltaUnilateralPortalState getFlipped() {
        return new DeltaUnilateralPortalState(this.offset, this.rotation == null ? null : this.rotation.hamiltonProduct(PortalManipulation.flipAxisW), this.sizeScaling);
    }

    public void apply(UnilateralPortalState.Builder builder) {
        if (this.offset != null) {
            builder.offset(this.offset);
        }
        if (this.rotation != null) {
            builder.rotate(this.rotation);
        }
        if (this.sizeScaling != null) {
            builder.scaleWidth(this.sizeScaling.x());
            builder.scaleHeight(this.sizeScaling.y());
        }
    }

    public DeltaUnilateralPortalState purgeFPError() {
        Vec2d sizeScaling;
        DQuaternion rotation;
        class_243 offset = this.offset;
        if (offset != null && offset.method_1027() < 1.0E-4) {
            offset = null;
        }
        if ((rotation = this.rotation) != null && DQuaternion.isClose((DQuaternion)rotation, (DQuaternion)DQuaternion.identity, (double)1.0E-4)) {
            rotation = null;
        }
        if ((sizeScaling = this.sizeScaling) != null && Math.abs(sizeScaling.x() - 1.0) < 1.0E-5 && Math.abs(sizeScaling.y() - 1.0) < 1.0E-5) {
            sizeScaling = null;
        }
        return new DeltaUnilateralPortalState(offset, rotation, sizeScaling);
    }

    public boolean isIdentity() {
        return this.offset == null && this.rotation == null && this.sizeScaling == null;
    }

    @Override
    public String toString() {
        String str = Stream.of(this.offset == null ? null : "offset=(%.3f,%.3f,%.3f)".formatted(this.offset.method_10216(), this.offset.method_10214(), this.offset.method_10215()), this.rotation == null ? null : "rotation=(%.3f,%.3f,%.3f,%.3f)".formatted(this.rotation.x, this.rotation.y, this.rotation.z, this.rotation.w), this.sizeScaling == null ? null : "sizeScaling=(%.3f,%.3f)".formatted(this.sizeScaling.x(), this.sizeScaling.y())).filter(Objects::nonNull).reduce((a, b) -> a + ", " + b).orElse("");
        return "Delta(" + str + ")";
    }

    public static DeltaUnilateralPortalState fromDiff(UnilateralPortalState before, UnilateralPortalState after) {
        return new DeltaUnilateralPortalState(after.position().method_1020(before.position()), after.orientation().hamiltonProduct(before.orientation().getConjugated()), new Vec2d(before.width() == 0.0 ? 1.0 : after.width() / before.width(), before.height() == 0.0 ? 1.0 : after.height() / before.height()));
    }

    public static class Builder {
        @Nullable
        private class_243 offset;
        @Nullable
        private DQuaternion rotation;
        @Nullable
        private Vec2d sizeScaling;

        public Builder offset(class_243 offset) {
            this.offset = offset;
            return this;
        }

        public Builder rotate(DQuaternion rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder scaleSize(double scale) {
            this.sizeScaling = new Vec2d(scale, scale);
            return this;
        }

        public Builder scaleSize(Vec2d scale) {
            this.sizeScaling = scale;
            return this;
        }

        public DeltaUnilateralPortalState build() {
            return new DeltaUnilateralPortalState(this.offset, this.rotation, this.sizeScaling);
        }
    }
}

