/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.q_misc_util.Helper;

public class DefaultPortalAnimation {
    public TimingFunction timingFunction;
    public int durationTicks;
    public boolean inverseScale;
    public long disableUntil = 0L;

    public DefaultPortalAnimation(TimingFunction timingFunction, int durationTicks, boolean inverseScale, long disableUntil) {
        this.timingFunction = timingFunction;
        this.durationTicks = durationTicks;
        this.inverseScale = inverseScale;
        this.disableUntil = disableUntil;
    }

    public DefaultPortalAnimation(TimingFunction timingFunction, int durationTicks, boolean inverseScale) {
        this(timingFunction, durationTicks, inverseScale, 0L);
    }

    public static DefaultPortalAnimation createDefault() {
        return new DefaultPortalAnimation(TimingFunction.sine, 10, false);
    }

    public static DefaultPortalAnimation fromNbt(class_2487 nbt) {
        String c = nbt.method_10558("curve");
        TimingFunction timingFunction = TimingFunction.fromString(c);
        int durationTicks = nbt.method_10550("durationTicks");
        boolean inverseScale = nbt.method_10577("inverseScale");
        long disableUntil = nbt.method_10537("disableUntil");
        return new DefaultPortalAnimation(timingFunction, durationTicks, inverseScale, disableUntil);
    }

    public void setDisableUntil(long disableUntil) {
        this.disableUntil = disableUntil;
    }

    @Environment(value=EnvType.CLIENT)
    public void startClientDefaultAnimation(Portal portal, PortalState animationStartState) {
        PortalState newState = portal.getPortalState();
        if (newState == null) {
            Helper.err((Object)"portal animation state abnormal");
            return;
        }
        if (newState.fromWorld != animationStartState.fromWorld || newState.toWorld != animationStartState.toWorld) {
            return;
        }
        if (this.disableUntil >= portal.method_37908().method_8510()) {
            return;
        }
        ClientPortalAnimationManagement.addDefaultAnimation(portal, animationStartState, newState, this);
        portal.setPortalState(animationStartState);
    }

    public class_2487 toNbt() {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10582("curve", this.timingFunction.toString());
        nbtCompound.method_10569("durationTicks", this.durationTicks);
        nbtCompound.method_10556("inverseScale", this.inverseScale);
        nbtCompound.method_10544("disableUntil", this.disableUntil);
        return nbtCompound;
    }

    public DefaultPortalAnimation copy() {
        return new DefaultPortalAnimation(this.timingFunction, this.durationTicks, this.inverseScale);
    }
}

