/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.DQuaternion;

public class PortalManipulation {
    public static final DQuaternion flipAxisW = DQuaternion.rotationByDegrees((class_243)new class_243(0.0, 1.0, 0.0), (double)180.0).fixFloatingPointErrorAccumulation();

    public static void setPortalTransformation(Portal portal, class_5321<class_1937> destDim, class_243 destPos, @Nullable DQuaternion rotation, double scale) {
        portal.dimensionTo = destDim;
        portal.setDestination(destPos);
        portal.rotation = rotation;
        portal.scaling = scale;
        portal.updateCache();
    }

    public static void removeConnectedPortals(Portal portal, Consumer<Portal> removalInformer) {
        PortalManipulation.removeOverlappedPortals(portal.method_37908(), portal.getOriginPos(), portal.getNormal().method_1021(-1.0), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        class_3218 toWorld = MiscHelper.getServer().method_3847(portal.dimensionTo);
        PortalManipulation.removeOverlappedPortals((class_1937)toWorld, portal.getDestPos(), portal.transformLocalVecNonScale(portal.getNormal().method_1021(-1.0)), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        PortalManipulation.removeOverlappedPortals((class_1937)toWorld, portal.getDestPos(), portal.transformLocalVecNonScale(portal.getNormal()), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
    }

    public static Portal completeBiWayPortal(Portal portal, class_1299<? extends Portal> entityType) {
        Portal newPortal = PortalManipulation.createReversePortal(portal, entityType);
        McHelper.spawnServerEntity(newPortal);
        return newPortal;
    }

    public static <T extends Portal> T createReversePortal(Portal portal, class_1299<T> entityType) {
        class_1937 world = portal.getDestinationWorld();
        Portal newPortal = (Portal)entityType.method_5883(world);
        newPortal.dimensionTo = portal.method_37908().method_27983();
        newPortal.method_5814(portal.getDestPos().field_1352, portal.getDestPos().field_1351, portal.getDestPos().field_1350);
        newPortal.setDestination(portal.getOriginPos());
        newPortal.specificPlayerId = portal.specificPlayerId;
        newPortal.width = portal.width * portal.scaling;
        newPortal.height = portal.height * portal.scaling;
        newPortal.axisW = portal.axisW.method_1021(-1.0);
        newPortal.axisH = portal.axisH;
        if (portal.specialShape != null) {
            portal.specialShape.normalize(newPortal.width, newPortal.height);
            newPortal.specialShape = portal.specialShape.getFlippedWithScaling(1.0);
        }
        newPortal.initCullableRange(-portal.cullableXStart * portal.scaling, -portal.cullableXEnd * portal.scaling, portal.cullableYStart * portal.scaling, portal.cullableYEnd * portal.scaling);
        if (portal.rotation != null) {
            PortalManipulation.rotatePortalBody(newPortal, portal.rotation);
            newPortal.rotation = portal.rotation.getConjugated();
        }
        newPortal.scaling = 1.0 / portal.scaling;
        PortalManipulation.copyAdditionalProperties(newPortal, portal);
        return (T)newPortal;
    }

    public static void rotatePortalBody(Portal portal, DQuaternion rotation) {
        portal.axisW = rotation.rotate(portal.axisW);
        portal.axisH = rotation.rotate(portal.axisH);
    }

    public static Portal completeBiFacedPortal(Portal portal, class_1299<Portal> entityType) {
        Portal newPortal = PortalManipulation.createFlippedPortal(portal, entityType);
        McHelper.spawnServerEntity(newPortal);
        return newPortal;
    }

    public static <T extends Portal> T createFlippedPortal(Portal portal, class_1299<T> entityType) {
        class_1937 world = portal.method_37908();
        Portal newPortal = (Portal)entityType.method_5883(world);
        newPortal.dimensionTo = portal.dimensionTo;
        newPortal.method_5814(portal.method_23317(), portal.method_23318(), portal.method_23321());
        newPortal.setDestination(portal.getDestPos());
        newPortal.specificPlayerId = portal.specificPlayerId;
        newPortal.width = portal.width;
        newPortal.height = portal.height;
        newPortal.axisW = portal.axisW.method_1021(-1.0);
        newPortal.axisH = portal.axisH;
        if (portal.specialShape != null) {
            newPortal.specialShape = portal.specialShape.getFlippedWithScaling(1.0);
        }
        newPortal.initCullableRange(-portal.cullableXStart, -portal.cullableXEnd, portal.cullableYStart, portal.cullableYEnd);
        newPortal.rotation = portal.rotation;
        newPortal.scaling = portal.scaling;
        PortalManipulation.copyAdditionalProperties(newPortal, portal);
        return (T)newPortal;
    }

    public static Portal copyPortal(Portal portal, class_1299<Portal> entityType) {
        class_1937 world = portal.method_37908();
        Portal newPortal = (Portal)entityType.method_5883(world);
        newPortal.dimensionTo = portal.dimensionTo;
        newPortal.method_5814(portal.method_23317(), portal.method_23318(), portal.method_23321());
        newPortal.setDestination(portal.getDestPos());
        newPortal.specificPlayerId = portal.specificPlayerId;
        newPortal.width = portal.width;
        newPortal.height = portal.height;
        newPortal.axisW = portal.axisW;
        newPortal.axisH = portal.axisH;
        newPortal.specialShape = portal.specialShape;
        newPortal.initCullableRange(portal.cullableXStart, portal.cullableXEnd, portal.cullableYStart, portal.cullableYEnd);
        newPortal.rotation = portal.rotation;
        newPortal.scaling = portal.scaling;
        PortalManipulation.copyAdditionalProperties(newPortal, portal);
        return newPortal;
    }

    public static void completeBiWayBiFacedPortal(Portal portal, Consumer<Portal> removalInformer, Consumer<Portal> addingInformer, class_1299<Portal> entityType) {
        PortalManipulation.removeOverlappedPortals((class_1937)((class_3218)portal.method_37908()), portal.getOriginPos(), portal.getNormal().method_1021(-1.0), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        Portal oppositeFacedPortal = PortalManipulation.completeBiFacedPortal(portal, entityType);
        PortalManipulation.removeOverlappedPortals((class_1937)MiscHelper.getServer().method_3847(portal.dimensionTo), portal.getDestPos(), portal.transformLocalVecNonScale(portal.getNormal().method_1021(-1.0)), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        Portal r1 = PortalManipulation.completeBiWayPortal(portal, entityType);
        PortalManipulation.removeOverlappedPortals((class_1937)MiscHelper.getServer().method_3847(oppositeFacedPortal.dimensionTo), oppositeFacedPortal.getDestPos(), oppositeFacedPortal.transformLocalVecNonScale(oppositeFacedPortal.getNormal().method_1021(-1.0)), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        Portal r2 = PortalManipulation.completeBiWayPortal(oppositeFacedPortal, entityType);
        addingInformer.accept(oppositeFacedPortal);
        addingInformer.accept(r1);
        addingInformer.accept(r2);
    }

    public static void removeOverlappedPortals(class_1937 world, class_243 pos, class_243 normal, Predicate<Portal> predicate, Consumer<Portal> informer) {
        PortalManipulation.getPortalCluster(world, pos, normal, predicate).forEach(e -> {
            e.method_5650(class_1297.class_5529.field_26998);
            informer.accept((Portal)e);
        });
    }

    public static List<Portal> getPortalCluster(class_1937 world, class_243 pos, class_243 normal, Predicate<Portal> predicate) {
        return McHelper.findEntitiesByBox(Portal.class, world, new class_238(pos.method_1031(0.1, 0.1, 0.1), pos.method_1023(0.1, 0.1, 0.1)), IPGlobal.maxNormalPortalRadius, p -> p.getNormal().method_1026(normal) > 0.5 && predicate.test((Portal)p));
    }

    public static <T extends Portal> T createOrthodoxPortal(class_1299<T> entityType, class_3218 fromWorld, class_3218 toWorld, class_2350 facing, class_238 portalArea, class_243 destination) {
        Portal portal = (Portal)entityType.method_5883((class_1937)fromWorld);
        PortalAPI.setPortalOrthodoxShape(portal, facing, portalArea);
        portal.setDestination(destination);
        portal.dimensionTo = toWorld.method_27983();
        return (T)portal;
    }

    public static void copyAdditionalProperties(Portal to, Portal from) {
        PortalManipulation.copyAdditionalProperties(to, from, true);
    }

    public static void copyAdditionalProperties(Portal to, Portal from, boolean includeSpecialProperties) {
        to.teleportable = from.teleportable;
        to.teleportChangesScale = from.teleportChangesScale;
        to.teleportChangesGravity = from.teleportChangesGravity;
        to.specificPlayerId = from.specificPlayerId;
        PortalExtension.get((Portal)to).motionAffinity = PortalExtension.get((Portal)from).motionAffinity;
        PortalExtension.get((Portal)to).adjustPositionAfterTeleport = PortalExtension.get((Portal)from).adjustPositionAfterTeleport;
        to.hasCrossPortalCollision = from.hasCrossPortalCollision;
        PortalExtension.get((Portal)to).bindCluster = PortalExtension.get((Portal)from).bindCluster;
        to.animation.defaultAnimation = from.animation.defaultAnimation.copy();
        to.setIsVisible(from.isVisible());
        if (includeSpecialProperties) {
            to.portalTag = from.portalTag;
            to.commandsOnTeleported = from.commandsOnTeleported;
        }
    }

    public static void createScaledBoxView(class_3218 areaWorld, class_238 area, class_3218 boxWorld, class_243 boxBottomCenter, double scale, boolean biWay, boolean teleportChangesScale, boolean outerFuseView, boolean outerRenderingMergable, boolean innerRenderingMergable, boolean hasCrossPortalCollision) {
        class_243 viewBoxSize = Helper.getBoxSize((class_238)area).method_1021(1.0 / scale);
        class_238 viewBox = Helper.getBoxByBottomPosAndSize((class_243)boxBottomCenter, (class_243)viewBoxSize);
        for (class_2350 direction : class_2350.values()) {
            Portal portal = PortalManipulation.createOrthodoxPortal(Portal.entityType, boxWorld, areaWorld, direction, Helper.getBoxSurface((class_238)viewBox, (class_2350)direction), Helper.getBoxSurface((class_238)area, (class_2350)direction).method_1005());
            portal.scaling = scale;
            portal.teleportChangesScale = teleportChangesScale;
            portal.fuseView = outerFuseView;
            portal.renderingMergable = outerRenderingMergable;
            portal.hasCrossPortalCollision = hasCrossPortalCollision;
            portal.portalTag = "imm_ptl:scale_box";
            McHelper.spawnServerEntity(portal);
            if (!biWay) continue;
            Portal reversePortal = PortalManipulation.createReversePortal(portal, Portal.entityType);
            reversePortal.renderingMergable = innerRenderingMergable;
            McHelper.spawnServerEntity(reversePortal);
        }
    }

    public static Portal placePortal(double width, double height, class_1297 entity) {
        class_243 playerLook = entity.method_5720();
        class_3545<class_3965, List<Portal>> rayTrace = IPMcHelper.rayTrace(entity.method_37908(), new class_3959(entity.method_5836(1.0f), entity.method_5836(1.0f).method_1019(playerLook.method_1021(100.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, entity), true);
        class_3965 hitResult = (class_3965)rayTrace.method_15442();
        List hitPortals = (List)rayTrace.method_15441();
        if (IPMcHelper.hitResultIsMissedOrNull((class_239)hitResult)) {
            return null;
        }
        for (Portal hitPortal : hitPortals) {
            playerLook = hitPortal.transformLocalVecNonScale(playerLook);
        }
        class_2350 lookingDirection = Helper.getFacingExcludingAxis((class_243)playerLook, (class_2350.class_2351)hitResult.method_17780().method_10166());
        if (lookingDirection == null) {
            return null;
        }
        class_243 axisH = class_243.method_24954((class_2382)hitResult.method_17780().method_10163());
        class_243 axisW = axisH.method_1036(class_243.method_24954((class_2382)lookingDirection.method_10153().method_10163()));
        class_243 pos = class_243.method_24953((class_2382)hitResult.method_17777()).method_1019(axisH.method_1021(0.5 + height / 2.0));
        class_1937 world = hitPortals.isEmpty() ? entity.method_37908() : ((Portal)hitPortals.get(hitPortals.size() - 1)).getDestinationWorld();
        Portal portal = new Portal(Portal.entityType, world);
        portal.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
        portal.axisW = axisW;
        portal.axisH = axisH;
        portal.width = width;
        portal.height = height;
        return portal;
    }

    public static DQuaternion getPortalOrientationQuaternion(class_243 axisW, class_243 axisH) {
        class_243 normal = axisW.method_1036(axisH);
        return DQuaternion.matrixToQuaternion((class_243)axisW, (class_243)axisH, (class_243)normal);
    }

    public static void setPortalOrientationQuaternion(Portal portal, DQuaternion quaternion) {
        portal.setOrientationRotation(quaternion);
    }

    public static void adjustRotationToConnect(Portal portalA, Portal portalB) {
        DQuaternion a = PortalAPI.getPortalOrientationQuaternion(portalA);
        DQuaternion b = PortalAPI.getPortalOrientationQuaternion(portalB);
        DQuaternion delta = b.hamiltonProduct(a.getConjugated());
        DQuaternion flip = DQuaternion.rotationByDegrees((class_243)portalB.axisH, (double)180.0);
        DQuaternion aRot = flip.hamiltonProduct(delta);
        portalA.setRotation(aRot);
        portalB.setRotation(aRot.getConjugated());
    }

    public static boolean isOtherSideBoxInside(class_238 transformedBoundingBox, PortalLike renderingPortal) {
        boolean intersects = Arrays.stream(Helper.eightVerticesOf((class_238)transformedBoundingBox)).anyMatch(p -> renderingPortal.isOnDestinationSide((class_243)p, 0.0));
        return intersects;
    }

    @Nullable
    public static Portal findParallelPortal(Portal portal) {
        return (Portal)Helper.getFirstNullable(McHelper.findEntitiesRough(Portal.class, portal.getDestinationWorld(), portal.getDestPos(), 0, p1 -> p1.getOriginPos().method_1020(portal.getDestPos()).method_1027() < 0.01 && p1.getDestPos().method_1020(portal.getOriginPos()).method_1027() < 0.01 && p1.getNormal().method_1026(portal.getContentDirection()) < -0.9 && p1.getContentDirection().method_1026(portal.getNormal()) < -0.9 && !(p1 instanceof Mirror) && p1 != portal));
    }

    @Nullable
    public static Portal findReversePortal(Portal portal) {
        return (Portal)Helper.getFirstNullable(McHelper.findEntitiesRough(Portal.class, portal.getDestinationWorld(), portal.getDestPos(), 0, p1 -> Portal.isReversePortal(portal, p1)));
    }

    @Nullable
    public static Portal findFlippedPortal(Portal portal) {
        return (Portal)Helper.getFirstNullable(McHelper.findEntitiesRough(Portal.class, portal.getOriginWorld(), portal.getOriginPos(), 0, p1 -> p1.getOriginPos().method_1020(portal.getOriginPos()).method_1027() < 0.01 && p1.getNormal().method_1026(portal.getNormal()) < -0.9 && p1.getDestPos().method_1025(portal.getDestPos()) < 0.01 && !(p1 instanceof Mirror) && p1 != portal));
    }

    @Deprecated
    public static Optional<Pair<Portal, class_243>> raytracePortals(class_1937 world, class_243 from, class_243 to, boolean includeGlobalPortal) {
        return PortalCommand.raytracePortals(world, from, to, includeGlobalPortal);
    }

    public static DQuaternion computeDeltaTransformation(DQuaternion thisSideOrientation, DQuaternion otherSideOrientation) {
        return otherSideOrientation.hamiltonProduct(flipAxisW).hamiltonProduct(thisSideOrientation.getConjugated());
    }

    public static void makePortalRound(Portal portal, int triangleNum) {
        GeometryPortalShape shape = new GeometryPortalShape();
        double twoPi = Math.PI * 2;
        shape.triangles = IntStream.range(0, triangleNum).mapToObj(i -> new GeometryPortalShape.TriangleInPlane(0.0, 0.0, portal.width * 0.5 * Math.cos(twoPi * (double)i / (double)triangleNum), portal.height * 0.5 * Math.sin(twoPi * (double)i / (double)triangleNum), portal.width * 0.5 * Math.cos(twoPi * ((double)i + 1.0) / (double)triangleNum), portal.height * 0.5 * Math.sin(twoPi * ((double)i + 1.0) / (double)triangleNum))).collect(Collectors.toList());
        portal.specialShape = shape;
    }
}

